/*************************************************************************************************/
/*!
   	@file		PinConnectLine.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
void GetPinConnectLine
		(
		float			v[13] , 
		const fvector2&	tp ,		//!< [in] start pos is fvector2(0.0f,0.0f)
		float			r ,			//!< [in] line round radius , 
		float			j ,			//!< [in] target line height min( > 0.0f )
		float			svx , 
		float			tvx
		)
{
	v[12]	= 0.0f;
	svx	= svx < 0.0f ? -1.0f : 1.0f;
	tvx	= tvx < 0.0f ? -1.0f : 1.0f;
	
	// same direction
	if( svx * tvx > 0.0f )
	{
		if( svx * tp.x >= 2.0f * r )
		{
			v[0]	= tp.x - 2.0f * r * svx;
			v[1]	= r * svx;
			v[4]	= 0.0f;
			v[5]	= 0.0f;
			v[6]	= 0.0f;
			v[7]	= 0.0f;
			v[8]	= 0.0f;
			v[9]	= 0.0f;
			v[11]	= r * svx;
			r		= tp.y < 0.0f ? -r : r;
			v[3]	= tp.y - 2.0f * r;
			v[3]	= v[3] * tp.y <= 0.0f ? 0.0f : v[3];
			v[2]	= ( tp.y - v[3] ) / 2.0f;
			v[10]	= v[2];
		}
		else
		{
			j	= tp.y < 0.0f ? -j : j;
			v[1]	= r * svx;
			v[11]	= r * svx;
			v[5]	= -r * svx;
			v[7]	= -r * svx;
			v[6]	= tp.x;
			v[6]	= v[6]*svx > 0.0f ? 0.0f : v[6];
			v[0]	= tp.x - v[6];
			r		= tp.y < 0.0f ? -r : r;
			v[3]	= tp.y - j - 4.0f * r;
			v[3]	= v[3] * tp.y <= 0.0f ? 0.0f : v[3];
			v[9]	= tp.y - v[3] - 4.0f * r;
			v[9]	= v[9]*tp.y <= 0.0f ? 0.0f : v[9];
			v[2]	= ( tp.y - v[3] - v[9] ) / 4.0f;
			v[4]	= v[2];
			v[8]	= v[2];
			v[10]	= v[2];
		}
	}
	// diffrent direction
	else
	{
		v[1]	= r * svx;
		v[5]	= -r * svx;
		v[6]	= tp.x;
		v[6]	= v[6] * svx >= 0.0f ? 0.0f : v[6];
		v[0]	= tp.x - v[6];
		r		= tp.y < 0.0f ? -r : r;
		v[3]	= tp.y - 2.0f * r;
		v[3]	= v[3] * tp.y <= 0.0f ? 0.0f : v[3];
		v[2]	= ( tp.y - v[3] ) / 2.0f;
		v[4]	= v[2];
		v[7]	= 0.0f;
		v[8]	= 0.0f;
		v[9]	= 0.0f;
		v[10]	= 0.0f;
		v[11]	= 0.0f;
	}
}
//=================================================================================================
cb_inline
void GetPinConnectLine
		(
		int				v[13] , 
		const ivector2&	tp ,		//!< [in] start pos is fvector2(0.0f,0.0f)
		int				r ,			//!< [in] line round radius , 
		int				j ,			//!< [in] target line height min( > 0.0f )
		int				svx , 
		int				tvx
		)
{
	v[12]	= 0;
	svx	= svx < 0 ? -1 : 1;
	tvx	= tvx < 0 ? -1 : 1;
	
	// same direction
	if( tp.y == 0 )
	{
		v[0]	= tp.x;
		v[1]	= 0;
		v[2]	= 0;
		v[3]	= 0;
		v[4]	= 0;
		v[5]	= 0;
		v[6]	= 0;
		v[7]	= 0;
		v[8]	= 0;
		v[9]	= 0;
		v[10]	= 0;
		v[11]	= 0;
		v[12]	= 0;
	}
	else if( svx * tvx > 0 )
	{
		if( svx * tp.x >= 2 * r )
		{
			v[0]	= tp.x - 2 * r * svx;
			v[1]	= r * svx;
			v[4]	= 0;
			v[5]	= 0;
			v[6]	= 0;
			v[7]	= 0;
			v[8]	= 0;
			v[9]	= 0;
			v[11]	= r * svx;
			r		= tp.y < 0 ? -r : r;
			v[3]	= tp.y - 2 * r;
			v[3]	= v[3] * tp.y <= 0 ? 0 : v[3];
			int		result = tp.y - v[3];
			v[2]	= result / 2;
			result -= v[2];
			v[10]	= result;
		}
		else
		{
			j	= tp.y < 0 ? -j : j;
			v[1]	= r * svx;
			v[11]	= r * svx;
			v[5]	= -r * svx;
			v[7]	= -r * svx;
			v[6]	= tp.x;
			v[6]	= v[6]*svx > 0 ? 0 : v[6];
			v[0]	= tp.x - v[6];
			r		= tp.y < 0 ? -r : r;
			v[3]	= tp.y - j - 4 * r;
			v[3]	= v[3] * tp.y <= 0 ? 0 : v[3];
			v[9]	= tp.y - v[3] - 4 * r;
			v[9]	= v[9]*tp.y <= 0 ? 0 : v[9];
			int		result = tp.y - v[3] - v[9];
			v[2]	= result / 4;
			result	-=v[2];
			v[4]	= result / 3;
			result	-=v[4];
			v[8]	= result / 2;
			result	-=v[8];
			v[10]	= result;
		}
	}
	// diffrent direction
	else
	{
		v[1]	= r * svx;
		v[5]	= -r * svx;
		v[6]	= tp.x;
		v[6]	= v[6] * svx >= 0 ? 0 : v[6];
		v[0]	= tp.x - v[6];
		r		= tp.y < 0 ? -r : r;
		v[3]	= tp.y - 2 * r;
		v[3]	= v[3] * tp.y <= 0 ? 0 : v[3];
		int		result = tp.y - v[3];
		v[2]	= result / 2;
		result	-= v[2];
		v[4]	= result;
		v[7]	= 0;
		v[8]	= 0;
		v[9]	= 0;
		v[10]	= 0;
		v[11]	= 0;
	}
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
