/*************************************************************************************************/
/*!
   	@file		XmlParserProcess.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"ParserProcess.h"

#include	<string>
#include	<boost/regex.hpp>
#include	<xercesc/parsers/XercesDOMParser.hpp>
#include	<xercesc/dom/DOM.hpp>
#include	<xercesc/dom/DOMNode.hpp>
#include	<xercesc/util/XMLString.hpp>
#include	<xercesc/util/PlatformUtils.hpp>
#include	<xercesc/util/BinInputStream.hpp>
#include	<xercesc/sax/HandlerBase.hpp>
#include	<xercesc/sax/InputSource.hpp>
#include	<xercesc/framework/LocalFileFormatTarget.hpp>

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace parserprocess;
using namespace std;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
/**************************************************************************************************
 "IXmlParserProcessGen" interface 
***************************************************************************************************/
cb_guid_define( IXmlParserProcessGen_IID , 0x29E0CB44 , 0xFFE74e01 , 0xB9CC66CD , 0x1898B772 );
class IXmlParserProcessGen;
typedef icubic::iface_object< IXmlParserProcessGen , IXmlParserProcessGen_IID >		iXmlParserProcessGen;
typedef icubic::iface_reference< IXmlParserProcessGen , IXmlParserProcessGen_IID >	rXmlParserProcessGen;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IXmlParserProcessGen
{
public:
//=================================================================================================
virtual
bool cb_call GenXml
		(
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMElement**	elem
		) = 0;
};

/**************************************************************************************************
"RegularParserCond" class 
**************************************************************************************************/
cb_guid_define( RegularParserCondId , 0x52A91FAD , 0x82EE4b06 , 0xAA6EA54E , 0xEDCE61B3 );
class RegularParserCond : 
	virtual public object_base , 
	public IParserCond
{
	query_begin();
	iface_hook( IParserCond , IParserCond_IID )
	query_end( object_base );

public:
	enum SeqType
	{
		SeekSeq , 
		AddBuf , 
		NoSeq , 
	};
	
// variable member
public:
	wstring		m_regular;
	SeqType		m_seqtype;

//=================================================================================================
RegularParserCond() : m_seqtype( SeekSeq )
{
}
// "IParserCond" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return RegularParserCondId();
}
//=================================================================================================
bool cb_call Execute
		(
		IParserSurvice*		survice , 
		const wstring&		source , 
		int*				pos
		)
{
	if( true == m_regular.empty() )
		return true;
	
	boost::match_results<const wchar_t*> results;
	try
	{
		boost::wregex	reg( m_regular );
		if( false == boost::regex_search( ( const wchar_t* )source.c_str() + ( *pos ) , results , reg , boost::regex_constants::match_continuous ) )
			return false;
	}
	catch( ... )
	{
		return false;
	}
	if( m_seqtype == SeekSeq )
	{
		*pos	+= results.str( 0 ).length();
	}
	else if( m_seqtype == AddBuf )
	{
		*pos	+= results.str( 0 ).length();
		survice->AddTextBuffer( results.str( 0 ) );
	}
	return true;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	if( false == stream->Write( &m_seqtype , sizeof( m_seqtype ) , 1 , Little_EndianType ) )
		return false;
	return SaveString( stream , m_regular );
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	if( 1 != stream->Read( &m_seqtype , sizeof( m_seqtype ) , 1 , Little_EndianType ) )
		return false;
	return LoadString( stream , &m_regular );
}
};
/**************************************************************************************************
"ClearTextParserCmd" class 
**************************************************************************************************/
cb_guid_define( ClearTextParserCmdId , 0x67589E83 , 0xDCDC43d8 , 0x8A36241E , 0x95F289C6 );
class ClearTextParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return ClearTextParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	survice->ClearTextBuffer();
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return true;
}
};
/**************************************************************************************************
"PushTagParserCmd" class 
**************************************************************************************************/
cb_guid_define( PushTagParserCmdId , 0x6CA3FF36 , 0x6D0C4369 , 0xB346D393 , 0x6707D558 );
class PushTagParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );

	class Gen : 
		virtual public object_base , 
		public IXmlParserProcessGen
	{
		query_begin();
		iface_hook( IXmlParserProcessGen , IXmlParserProcessGen_IID )
		query_end( object_base );
		
	// variable member
	public:
		wstring		m_tag;
		
	// "IXmlParserProcessGen" interface functions
	public:
		bool cb_call GenXml
				(
				XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
				XERCES_CPP_NAMESPACE::DOMElement**	elem
				)
		{
			if( *elem == 0 )
				return false;
			if( m_tag == L"" )
				return true;
			try
			{
				DOMElement*  new_elem = doc->createElement( m_tag.c_str() );
				if( new_elem == 0 )
					return false;
				(*elem)->appendChild( new_elem );
				*elem	= new_elem;
			}
			catch( ... )
			{
				return false;
			}
			return true;
		}
	};
// variable member
public:
	wstring		m_tag;
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return PushTagParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	instance<Gen>	gen;
	gen->m_tag	= m_tag;
	*r	= (object)gen;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return SaveString( stream , m_tag );
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return LoadString( stream , &m_tag );
}
};
/**************************************************************************************************
"PopTagParserCmd" class 
**************************************************************************************************/
cb_guid_define( PopTagParserCmdId , 0xD6E7C098 , 0x54A14723 , 0x9C96C7F1 , 0x0650D5DD );
class PopTagParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );

	class Gen : 
		virtual public object_base , 
		public IXmlParserProcessGen
	{
		query_begin();
		iface_hook( IXmlParserProcessGen , IXmlParserProcessGen_IID )
		query_end( object_base );
		
	// "IXmlParserProcessGen" interface functions
	public:
		bool cb_call GenXml
				(
				XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
				XERCES_CPP_NAMESPACE::DOMElement**	elem
				)
		{
			if( *elem == 0 )
				return false;
			XERCES_CPP_NAMESPACE::DOMElement*	parent = (XERCES_CPP_NAMESPACE::DOMElement*)( (*elem)->getParentNode() );
			if( parent == 0 )
				return false;
			*elem	= parent;
			return true;
		}
	};
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return PopTagParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	*r	= (object)instance<Gen>();
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return true;
}
};
/**************************************************************************************************
"SetAttrParserCmd" class 
**************************************************************************************************/
cb_guid_define( SetAttrParserCmdId , 0xE1DA0A91 , 0xC85449c4 , 0x823A482E , 0xCE036ADD );
class SetAttrParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );
	
	class Gen : 
		virtual public object_base , 
		public IXmlParserProcessGen
	{
		query_begin();
		iface_hook( IXmlParserProcessGen , IXmlParserProcessGen_IID )
		query_end( object_base );
	
	public:
		wstring		m_name;
		wstring		m_value;
		
	// "IXmlParserProcessGen" interface functions
	public:
		bool cb_call GenXml
				(
				XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
				XERCES_CPP_NAMESPACE::DOMElement**	elem
				)
		{
			if( *elem == 0 )
				return false;
			if( m_name == L"" || m_value == L"" )
				return true;
			(*elem)->setAttribute( m_name.c_str() , m_value.c_str() );
			return true;
		}
	};

// variable member
public:
	wstring		m_name;
	wstring		m_value;
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return SetAttrParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	instance<Gen>	gen;
	gen->m_name		= m_name;
	gen->m_value	= m_value;
	*r	= (object)gen;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	if( false == SaveString( stream , m_name ) )
		return false;
	if( false == SaveString( stream , m_value ) )
		return false;
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	if( false == LoadString( stream , &m_name ) )
		return false;
	if( false == LoadString( stream , &m_value ) )
		return false;
	return true;
}
};
/**************************************************************************************************
"SetAttrTextParserCmd" class 
**************************************************************************************************/
cb_guid_define( SetAttrTextParserCmdId , 0xAA31CAD0 , 0x96F04b5a , 0x8AE09576 , 0x083A73B8 );
class SetAttrTextParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );
	
	class Gen : 
		virtual public object_base , 
		public IXmlParserProcessGen
	{
		query_begin();
		iface_hook( IXmlParserProcessGen , IXmlParserProcessGen_IID )
		query_end( object_base );
	
	public:
		wstring		m_name;
		wstring		m_value;
		
	// "IXmlParserProcessGen" interface functions
	public:
		bool cb_call GenXml
				(
				XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
				XERCES_CPP_NAMESPACE::DOMElement**	elem
				)
		{
			if( *elem == 0 )
				return false;
			if( m_name == L"" || m_value == L"" )
				return true;
			(*elem)->setAttribute( m_name.c_str() , m_value.c_str() );
			return true;
		}
	};

// variable member
public:
	wstring		m_name;
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return SetAttrTextParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	instance<Gen>	gen;
	gen->m_name		= m_name;
	gen->m_value	= survice->GetTextBuffer();
	*r	= (object)gen;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	if( false == SaveString( stream , m_name ) )
		return false;
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	if( false == LoadString( stream , &m_name ) )
		return false;
	return true;
}
};
/**************************************************************************************************
"SetTextParserCmd" class 
**************************************************************************************************/
cb_guid_define( SetTextParserCmdId , 0x813C722E , 0x6D19471e , 0xB254FA1B , 0x62333D69 );
class SetTextParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );

	class Gen : 
		virtual public object_base , 
		public IXmlParserProcessGen
	{
		query_begin();
		iface_hook( IXmlParserProcessGen , IXmlParserProcessGen_IID )
		query_end( object_base );
	
	public:
		wstring		m_text;
		
	// "IXmlParserProcessGen" interface functions
	public:
		bool cb_call GenXml
				(
				XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
				XERCES_CPP_NAMESPACE::DOMElement**	elem
				)
		{
			if( *elem == 0 )
				return false;
			if( m_text == L"" )
				return true;
			DOMText*    text = doc->createTextNode( m_text.c_str() );
			if( text == 0 )
				return false;
			(*elem)->appendChild( text );
			return true;
		}
	};
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return SetTextParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	instance<Gen>	gen;
	gen->m_text	= survice->GetTextBuffer();
	*r	= (object)gen;
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return true;
}
};
/**************************************************************************************************
"PushTextParserCmd" class 
**************************************************************************************************/
cb_guid_define( PushTextParserCmdId , 0x685DDFF8 , 0x51C04cbc , 0x9D003EEC , 0x62BCFBC4 );
class PushTextParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );

	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return PushTextParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	survice->PushTextBuffer();
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return true;
}
};
/**************************************************************************************************
"PopTextParserCmd" class 
**************************************************************************************************/
cb_guid_define( PopTextParserCmdId , 0x0BC87DE7 , 0x98C54a0d , 0xA32FA619 , 0x82AB1D70 );
class PopTextParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );

	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return PopTextParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
	survice->PopTextBuffer();
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	return true;
}
};
/**************************************************************************************************
"DescParserCmd" class 
**************************************************************************************************/
cb_guid_define( DescParserCmdId , 0xAEB0C430 , 0x7B834372 , 0xB0C5FD8E , 0xAA58540B );
class DescParserCmd : 
	virtual public object_base , 
	public IParserCmd
{
	query_begin();
	iface_hook( IParserCmd , IParserCmd_IID )
	query_end( object_base );
	
public:
	wstring		m_desc;
	
// "IParserCmd" interface functions
public:
//=================================================================================================
guid cb_call GetId()
{
	return DescParserCmdId();
}
//=================================================================================================
void cb_call Execute
		(
		IParserSurvice*	survice , 
		object*			r
		)
{
}
//=================================================================================================
bool cb_call Save
		(
		IStreamWrite*	stream
		)
{
	if( false == SaveString( stream , m_desc ) )
		return false;
	return true;
}
//=================================================================================================
bool cb_call Load
		(
		IStreamRead*	stream
		)
{
	if( false == LoadString( stream , &m_desc ) )
		return false;
	return true;
}
};
/**************************************************************************************************
 "IXmlParserProcess" interface 
***************************************************************************************************/
cb_guid_define( IXmlParserProcess_IID , 0xAF631FC4 , 0x25E74806 , 0x857C53AD , 0x329C358B );
class IXmlParserProcess;
typedef icubic::iface_object< IXmlParserProcess , IXmlParserProcess_IID >		iXmlParserProcess;
typedef icubic::iface_reference< IXmlParserProcess , IXmlParserProcess_IID >	rXmlParserProcess;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IXmlParserProcess
{
public:
//=================================================================================================
virtual
bool cb_call GenXml
		(
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMElement*	elem
		) = 0;
};
/**************************************************************************************************
"XmlParserProcess" class 
**************************************************************************************************/
class XmlParserProcess : 
	public ParserProcess , 
	public IXmlParserProcess , 
	public IParserObjectFactory
{
	query_begin();
	iface_hook( IXmlParserProcess , IXmlParserProcess_IID )
	iface_hook( IParserObjectFactory , IParserObjectFactory_IID )
	query_end( ParserProcess );
	
// variable member
private:

// private functions
private:

// "IParserObjectFactory" interface functions
public:
//=================================================================================================
object cb_call CreateCmd
		(
		const guid&		id
		)
{
	if( id == ClearTextParserCmdId() )
		return (object)instance<ClearTextParserCmd>();
	else if( id == PushTagParserCmdId() )
		return (object)instance<PushTagParserCmd>();
	else if( id == PopTagParserCmdId() )
		return (object)instance<PopTagParserCmd>();
	else if( id == SetAttrParserCmdId() )
		return (object)instance<SetAttrParserCmd>();
	else if( id == SetAttrTextParserCmdId() )
		return (object)instance<SetAttrTextParserCmd>();
	else if( id == SetTextParserCmdId() )
		return (object)instance<SetTextParserCmd>();
	else if( id == PushTextParserCmdId() )
		return (object)instance<PushTextParserCmd>();
	else if( id == PopTextParserCmdId() )
		return (object)instance<PopTextParserCmd>();
	else if( id == DescParserCmdId() )
		return (object)instance<DescParserCmd>();
	return object();
}
//=================================================================================================
object cb_call CreateCond
		(
		const guid&		id
		)
{
	if( id == RegularParserCondId() )
		return (object)instance<RegularParserCond>();
		
	return object();
}
// "IXmlParserProcess" interface functions
public:
//=================================================================================================
bool cb_call GenXml
		(
		XERCES_CPP_NAMESPACE::DOMDocument*	doc ,
		XERCES_CPP_NAMESPACE::DOMElement*	elem
		)
{
	void*	p = GetFirst();
	while( p != 0 )
	{
		iXmlParserProcessGen	gen = (iXmlParserProcessGen)GetData( p );
		if( gen == true )
		{
			if( false == gen->GenXml( doc , &elem ) )
				return false;
		}
		p = GetNext( p );
	}
	return true;
}

// public functions
public:
//=================================================================================================
XmlParserProcess()
{
	ParserProcess::SetFactory( (rParserObjectFactory)(iParserObjectFactory)this_object() );
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
XERCES_CPP_NAMESPACE::DOMDocument*	CreateXmlDoc
		(
		DOMImplementation*		impl , 
		iXmlParserProcess&		pp , 
		const wstring&			document_tag , 
		const wstring&			doctype_name , 
		const wstring&			doctype_public , 
		const wstring&			doctype_system
		)
{
	XERCES_CPP_NAMESPACE::DOMDocument*	doc = 0;
	try
	{
		DOMDocumentType*	doctype = 0;
		if( doctype_name.empty() == false )
		{
			doctype = impl->createDocumentType
					( 
					doctype_name.c_str() , 
					doctype_public.c_str() , 
					doctype_system.c_str()
					);
			if( doctype == 0 )
				throw 0;
		}
		doc		= impl->createDocument( NULL , document_tag.c_str() , doctype );
		if( doc == 0 )
			throw 0;
		DOMElement*	root	= doc->getDocumentElement();
		if( root == 0 )
			throw 0;
		if( false == pp->GenXml( doc , root ) )
			throw 0;
	}
	catch( ... )
	{
		if( doc != 0 )
			doc->release();
		return 0;
	}
	return doc;
}
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
