// LinkPropertyWnd.cpp : t@C
//

#include "stdafx.h"
#include "Texml.h"
#include "LinkPropertyWnd.h"
#include "resource.h"

/**************************************************************************************************
"CLinkPropertyWnd" class 
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
IMPLEMENT_DYNAMIC(CLinkPropertyWnd, CMFCPropertyGridCtrl)

BEGIN_MESSAGE_MAP(CLinkPropertyWnd, CMFCPropertyGridCtrl)
	ON_WM_CREATE()
	ON_WM_SETTINGCHANGE()
	ON_WM_DESTROY()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CLinkPropertyWnd::Callback
		(
		ICallback::Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::SetPropertyItem )
	{
		ICallback::SetPropertyItemParam*	p = (ICallback::SetPropertyItemParam*)param;
		if( m_parser_id != p->m_tree_id
		||  m_item_id	!= p->m_item_id )
		{
			m_parser_id = p->m_tree_id;
			m_item_id	= p->m_item_id;
		}
		UpdateProperty();
		UpdatePropertyShow();
	}
	else if( /*( type == ICallback::ModifyItemProperty && obj == (object)GetNode() )*/
	      ( type == ICallback::MoveItems && obj == (object)GetParser() )
	    ||( type == ICallback::ResizeLinkbar && obj == (object)GetParser() )
	    ||( type == ICallback::ReconnectLink && obj == (object)GetParser() ) )
	{
		UpdateProperty();
		UpdatePropertyShow();
	}
	else if( type == ICallback::Undo 
	     ||  type == ICallback::Redo )
	{
		UpdateProperty();
		UpdatePropertyShow();
	} 
}
//=================================================================================================
void CLinkPropertyWnd::SetPropListFont()
{
	::DeleteObject(m_fntPropList.Detach());

	LOGFONT lf;
	afxGlobalData.fontRegular.GetLogFont(&lf);

	NONCLIENTMETRICS info;
	info.cbSize = sizeof(info);

	afxGlobalData.GetNonClientMetrics(info);

	lf.lfHeight = info.lfMenuFont.lfHeight;
	lf.lfWeight = info.lfMenuFont.lfWeight;
	lf.lfItalic = info.lfMenuFont.lfItalic;

	m_fntPropList.CreateFontIndirect(&lf);

	SetFont(&m_fntPropList);
}
//=================================================================================================
iParserDoc CLinkPropertyWnd::GetParser()
{
	return (iParserDoc)m_document->SearchTreeId( m_parser_id );
}
//=================================================================================================
iParserLink CLinkPropertyWnd::GetLink()
{
	iParserDoc	doc		= (iParserDoc)m_document->SearchTreeId( m_parser_id );
	if( doc == false )
		return iParserLink();
	return (iParserLink)doc->SearchParserItemId( m_item_id );
}
//=================================================================================================
void CLinkPropertyWnd::InitProperty()
{
	RemoveAll();
	{
		m_props[Group1]	= new CMFCPropertyGridProperty(LoadText(IDS_PROP_25));
		{
			m_props[XPos]	= new CMFCPropertyGridProperty(LoadText(IDS_PROP_26), (_variant_t)(LONG)0, LoadText(IDS_PROP_27));
			m_props[XPos]->SetData( XPos );
			m_props[XPos]->EnableSpinControl( TRUE, -10000000 , 10000000 );
			m_props[XPos]->Show( FALSE );
			m_props[Group1]->AddSubItem(m_props[XPos]);
		}
		{
			m_props[YPos] = new CMFCPropertyGridProperty(LoadText(IDS_PROP_28), (_variant_t)(LONG)0, LoadText(IDS_PROP_29));
			m_props[YPos]->SetData( YPos );
			m_props[YPos]->EnableSpinControl( TRUE , -1000000 , 1000000 );
			m_props[YPos]->Show( FALSE );
			m_props[Group1]->AddSubItem( m_props[YPos] );
		}
		{
			m_props[Priority] = new CMFCPropertyGridProperty( LoadText(IDS_PROP_30), _T("") , LoadText(IDS_PROP_31));
			m_props[Priority]->Show( FALSE );
			m_props[Priority]->SetData( Priority );
			m_props[Priority]->AllowEdit( FALSE );
			m_props[Group1]->AddSubItem( m_props[Priority] );
		}
		{
			m_props[KnotType] = new CMFCPropertyGridProperty( LoadText(IDS_PROP_32), _T("") , LoadText(IDS_PROP_33));
			int		off , num = m_knottype_list.GetDatanum();
			for( off = 0 ; off < num ; off++ )
				m_props[KnotType]->AddOption(m_knottype_list[ off ]);
			m_props[KnotType]->Show( FALSE );
			m_props[KnotType]->SetData( KnotType );
			m_props[KnotType]->AllowEdit( FALSE );
			m_props[Group1]->AddSubItem( m_props[KnotType] );
		}
		{
			m_props[BarWidth] = new CMFCPropertyGridProperty( LoadText(IDS_PROP_34), (_variant_t)(LONG)0, LoadText(IDS_PROP_35));
			m_props[BarWidth]->SetData( BarWidth );
			m_props[BarWidth]->EnableSpinControl( TRUE , 0 , 1000 );
			m_props[BarWidth]->Show( FALSE );
			m_props[Group1]->AddSubItem( m_props[BarWidth] );
		}
		{
			m_props[Align] = new CMFCPropertyGridProperty( LoadText(IDS_PROP_36), _T("") , LoadText(IDS_PROP_37));
			int		off , num = m_align_list.GetDatanum();
			for( off = 0 ; off < num ; off++ )
				m_props[Align]->AddOption(m_align_list[ off ]);
			m_props[Align]->Show( FALSE );
			m_props[Align]->SetData( Align );
			m_props[Align]->AllowEdit( FALSE );
			m_props[Group1]->AddSubItem( m_props[Align] );
		}
		AddProperty( m_props[Group1] );
	}
	{
		m_props[Group2]	= new CMFCPropertyGridProperty(LoadText(IDS_PROP_38));
		{
			m_props[CmdType] = new CMFCPropertyGridProperty
					(
					LoadText(IDS_PROP_39), 
					_T("") , 
					LoadText(IDS_PROP_40)
					);
			int		off , num = m_linktype_list.GetDatanum();
			for( off = 0 ; off < num ; off++ )
				m_props[CmdType]->AddOption(m_linktype_list[ off ]);
			m_props[CmdType]->Show( FALSE );
			m_props[CmdType]->SetData( CmdType );
			m_props[CmdType]->AllowEdit( FALSE );
			m_props[Group2]->AddSubItem( m_props[CmdType] );
		}
		{
			m_props[Regular_exp] = new CMFCPropertyGridProperty
					(
					LoadText(IDS_PROP_41), 
					_T("") , 
					LoadText(IDS_PROP_42)
					);
			m_props[Regular_exp]->Show( FALSE );
			m_props[Regular_exp]->SetData( Regular_exp );
			m_props[Regular_exp]->AllowEdit( TRUE );
			m_props[Group2]->AddSubItem( m_props[Regular_exp] );
		}
		{
			m_props[Regular_seqtype] = new CMFCPropertyGridProperty
					( 
					LoadText(IDS_PROP_46), 
					_T("") , 
					LoadText(IDS_PROP_45)
					);
			int		off , num = m_seqtype_list.GetDatanum();
			for( off = 0 ; off < num ; off++ )
				m_props[Regular_seqtype]->AddOption(m_seqtype_list[ off ]);
			m_props[Regular_seqtype]->Show( FALSE );
			m_props[Regular_seqtype]->SetData( Regular_seqtype );
			m_props[Regular_seqtype]->AllowEdit( FALSE );
			m_props[Group2]->AddSubItem( m_props[Regular_seqtype] );
		}
		{
			m_props[Function_name] = new CMFCPropertyGridProperty
					(
					LoadText(IDS_PROP_43), 
					_T("") , 
					LoadText(IDS_PROP_44)
					);
			m_props[Function_name]->Show( FALSE );
			m_props[Function_name]->SetData( Regular_exp );
			m_props[Function_name]->AllowEdit( TRUE );
			m_props[Group2]->AddSubItem( m_props[Function_name] );
		}
		AddProperty( m_props[Group2] );
	}
}
//=================================================================================================
int CLinkPropertyWnd::GetPriority
		(
		iParserLink&	link , 
		int*			pnum
		)
{
	iGraphLink	glink	= (iGraphLink)link;
	iGraphNode	gnode	= glink->GetInput();
	int		off , num	= gnode->GetOutputNum();
	int		pos			= 0;
	for( off = 0 ; off < num ; off++ )
	{
		if( gnode->GetOutput(off) == glink )
			pos = off;
	}
	store( pnum , num );
	return pos;
}
//=================================================================================================
void CLinkPropertyWnd::UpdateProperty()
{
	iParserLink	link	= GetLink();
	if( link == false )
		return;
	IParserLink::Property	prop	= link->GetProperty();
	m_props[XPos]->SetValue( (_variant_t)(LONG)prop.m_pos.x );
	m_props[YPos]->SetValue( (_variant_t)(LONG)prop.m_pos.y );
	m_props[KnotType]->SetValue( m_knottype_list[ prop.m_knottype ] );
	m_props[BarWidth]->SetValue( (_variant_t)(LONG)prop.m_bar_width );
	m_props[Align]->SetValue( m_align_list[ prop.m_align ] );
	m_props[CmdType]->SetValue( m_linktype_list[ prop.m_type ] );
	m_props[Regular_exp]->SetValue( prop.m_regular_prop.m_exp.c_str() );
	m_props[Regular_seqtype]->SetValue( m_seqtype_list[ prop.m_regular_prop.m_seqtype ] );
	m_props[Function_name]->SetValue( prop.m_function_prop.m_parser_name.c_str() );
	
	m_props[Priority]->RemoveAllOptions();
	{
		int	off , num;
		int	pos = GetPriority( link , &num );
		for( off = 0 ; off < num ; off++ )
		{
			std::wostringstream os;
			os << ( off + 1 );
			m_props[Priority]->AddOption( os.str().c_str() );
		}
		{
			std::wostringstream os;
			os << ( pos + 1 );
			m_props[Priority]->SetValue( os.str().c_str() );
		}
	}
}
//=================================================================================================
void CLinkPropertyWnd::UpdatePropertyShow()
{
	iParserLink	link	= GetLink();
	if( link == false )
	{
		m_props[Group1]->Show( FALSE );
		m_props[Group2]->Show( FALSE );
		return;
	}
	IParserLink::Property		prop	= link->GetProperty();
	
	m_props[Group1]->Show( TRUE );
	m_props[Group2]->Show( TRUE );
	m_props[XPos]->Show( TRUE );
	m_props[YPos]->Show( TRUE );
	m_props[KnotType]->Show( TRUE );
	m_props[BarWidth]->Show( TRUE );
	m_props[Align]->Show( TRUE );
	m_props[CmdType]->Show( TRUE );
	m_props[Regular_exp]->Show( prop.m_type == IParserLink::Property::RegularExp ? TRUE : FALSE );
	m_props[Regular_seqtype]->Show( prop.m_type == IParserLink::Property::RegularExp ? TRUE : FALSE );
	m_props[Function_name]->Show( prop.m_type == IParserLink::Property::Function ? TRUE : FALSE );
}
//=================================================================================================
void CLinkPropertyWnd::PropertyChanged
		(
		CMFCPropertyGridProperty* pprop 
		)
{
	iParserLink	link	= GetLink();
	if( link == false )
		return;
		
	IParserLink::Property	prop	= link->GetProperty();
	if( m_props[XPos] == pprop )
	{
		prop.m_pos.x	= (_variant_t)pprop->GetValue();
	}
	else if( m_props[YPos] == pprop )
	{
		prop.m_pos.y	= (_variant_t)pprop->GetValue();
	}
	else if( m_props[KnotType] == pprop )
	{
		CString	name = pprop->GetValue();
		int		off , num = m_knottype_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_knottype_list[off] == name )
			{
				prop.m_knottype = (IParserLink::Property::KnotType)off;
				break;
			}
		}		
	}	
	else if( m_props[BarWidth] == pprop )
	{
		prop.m_bar_width	= (_variant_t)pprop->GetValue();
	}
	else if( m_props[Align] == pprop )
	{
		CString	name = pprop->GetValue();
		int		off , num = m_align_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_align_list[off] == name )
			{
				prop.m_align = (IParserLink::Property::Align)off;
				break;
			}
		}		
	}	
	else if( m_props[CmdType] == pprop )
	{
		CString	name = pprop->GetValue();
		int		off , num = m_linktype_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_linktype_list[off] == name )
			{
				prop.m_type = (IParserLink::Property::Type)off;
				break;
			}
		}		
	}
	else if( m_props[Regular_exp] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_regular_prop.m_exp = t;
	}
	else if( m_props[Regular_seqtype] == pprop )
	{
		CString	name = pprop->GetValue();
		int		off , num = m_seqtype_list.GetDatanum();
		for( off = 0 ; off < num ; off++ )
		{
			if( m_seqtype_list[off] == name )
			{
				prop.m_regular_prop.m_seqtype = (IParserLink::Property::RegularProp::SeqType)off;
				break;
			}
		}		
	}	
	else if( m_props[Function_name] == pprop )
	{
		CString	t = pprop->GetValue();
		prop.m_function_prop.m_parser_name = t;
	}
	else if( m_props[Priority] == pprop )
	{
		CString	t	= pprop->GetValue();
		wstring	tt	= t;
		std::wistringstream is( tt.c_str() );
		int		num , prev = GetPriority( link , &num ) + 1;
		int		pri	= prev;
		is >> pri;
		pri--;
		if( pri >= prev )
			pri++;
		IUndoList*	undo	= m_document->Recode();
		iGraphLink	glink	= (iGraphLink)link;
		glink->SetInput( glink->GetInput() , pri , undo );
		m_document->Callback( ICallback::ReconnectLink , (object)GetParser() , 0 );
		UpdatePropertyShow();
		return;
	}
	else
		return;
	
	IUndoList*	undo = m_document->Recode();
	link->SetProperty( prop , undo );
	m_document->Callback( ICallback::ModifyItemProperty , (object)GetParser() , 0 );
	UpdatePropertyShow();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CLinkPropertyWnd::CLinkPropertyWnd() : 
		m_parser_id( 0 ) , 
		m_item_id( 0 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );

	int		off , num = _countof( m_props );
	for( off = 0 ; off < num ; off++ )
		m_props[off] = 0;
	{
		m_linktype_list.Resize( IParserLink::Property::Function + 1 );
		m_linktype_list[IParserLink::Property::None]		= LoadText( IDS_LINKPROP_NONE );
		m_linktype_list[IParserLink::Property::RegularExp]	= LoadText( IDS_LINKPROP_REGULAR );
		m_linktype_list[IParserLink::Property::Function]	= LoadText( IDS_LINKPROP_FUNCTION );
	}
	{
		m_knottype_list.Resize( IParserLink::Property::Twist + 1 );
		m_knottype_list[IParserLink::Property::None]		= LoadText( IDS_LINKPROP_DIRECT );
		m_knottype_list[IParserLink::Property::RegularExp]	= LoadText( IDS_LINKPROP_TWIST );
	}
	{
		m_align_list.Resize( IParserLink::Property::Right + 1 );
		m_align_list[IParserLink::Property::Left]	= LoadText( IDS_LINKPROP_ALIGN_LEFT );
		m_align_list[IParserLink::Property::Center]	= LoadText( IDS_LINKPROP_ALIGN_CENTER );
		m_align_list[IParserLink::Property::Right]	= LoadText( IDS_LINKPROP_ALIGN_RIGHT );
	}
	{
		m_seqtype_list.Resize( IParserLink::Property::RegularProp::NoSeq + 1 );
		m_seqtype_list[IParserLink::Property::RegularProp::SeekSeq]		= LoadText( IDS_LINKPROP_SEQTYPE_SEEKSEQ );
		m_seqtype_list[IParserLink::Property::RegularProp::AddBuf]		= LoadText( IDS_LINKPROP_SEQTYPE_ADDBUF );
		m_seqtype_list[IParserLink::Property::RegularProp::NoSeq]		= LoadText( IDS_LINKPROP_SEQTYPE_NOSEQ );
	}
}
//=================================================================================================
CLinkPropertyWnd::~CLinkPropertyWnd()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
void CLinkPropertyWnd::OnPropertyChanged
		(
		CMFCPropertyGridProperty* pProp 
		)const
{
	typedef void (CLinkPropertyWnd::*FuncType)(CMFCPropertyGridProperty*)const;
	FuncType	func = (FuncType)&CLinkPropertyWnd::PropertyChanged;
	(this->*func)( pProp );

	__super::OnPropertyChanged( pProp );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int CLinkPropertyWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMFCPropertyGridCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetPropListFont();
	EnableHeaderCtrl( FALSE );
	EnableDescriptionArea();
	SetVSDotNetLook();
	MarkModifiedProperties();
	InitProperty();
	UpdatePropertyShow();

	return 0;
}
void CLinkPropertyWnd::OnDestroy()
{
	m_parser_id	= 0;
	m_item_id	= 0;
//	RemoveAll();

	__super::OnDestroy();
}
//=================================================================================================
void CLinkPropertyWnd::OnSettingChange(UINT uFlags, LPCTSTR lpszSection)
{
//	__super::OnSettingChange(uFlags, lpszSection);

	SetPropListFont();
}

