
// ParseEditView.cpp : CParseEditView NX̎
//

#include "stdafx.h"
#include "Texml.h"
#include "ParseEditView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

/**************************************************************************************************
"CParseEditView" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
BEGIN_MESSAGE_MAP(CParseEditView, CParseEditCtrlView)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_EDIT_DELETE, &CParseEditView::OnEditDelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, &OnUpdateEditDelete)
	ON_COMMAND(ID_ADD_NODE_NONE, &CParseEditView::OnAddNodeNone)
	ON_COMMAND(ID_ADD_NODE_NONE_CONTEXT, &CParseEditView::OnAddNodeNoneContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_NONE, &CParseEditView::OnUpdateAddNodeNone)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_NONE_CONTEXT, &CParseEditView::OnUpdateAddNodeNone)
	ON_COMMAND(ID_ADD_NODE_CLEARTEXT, &CParseEditView::OnAddNodeCleartext)
	ON_COMMAND(ID_ADD_NODE_CLEARTEXT_CONTEXT, &CParseEditView::OnAddNodeCleartextContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_CLEARTEXT, &CParseEditView::OnUpdateAddNodeCleartext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_CLEARTEXT_CONTEXT, &CParseEditView::OnUpdateAddNodeCleartext)
	ON_COMMAND(ID_ADD_NODE_PUSHTAG, &CParseEditView::OnAddNodePushtag)
	ON_COMMAND(ID_ADD_NODE_PUSHTAG_CONTEXT, &CParseEditView::OnAddNodePushtagContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_PUSHTAG, &CParseEditView::OnUpdateAddNodePushtag)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_PUSHTAG_CONTEXT, &CParseEditView::OnUpdateAddNodePushtag)
	ON_COMMAND(ID_ADD_NODE_POPTAG, &CParseEditView::OnAddNodePoptag)
	ON_COMMAND(ID_ADD_NODE_POPTAG_CONTEXT, &CParseEditView::OnAddNodePoptagContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_POPTAG, &CParseEditView::OnUpdateAddNodePoptag)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_POPTAG_CONTEXT, &CParseEditView::OnUpdateAddNodePoptag)
	ON_COMMAND(ID_ADD_NODE_SETATTR, &CParseEditView::OnAddNodeSetattr)
	ON_COMMAND(ID_ADD_NODE_SETATTR_CONTEXT, &CParseEditView::OnAddNodeSetattrContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETATTR, &CParseEditView::OnUpdateAddNodeSetattr)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETATTR_CONTEXT, &CParseEditView::OnUpdateAddNodeSetattr)
	ON_COMMAND(ID_ADD_NODE_SETATTRTEXT, &CParseEditView::OnAddNodeSetattrtext)
	ON_COMMAND(ID_ADD_NODE_SETATTRTEXT_CONTEXT, &CParseEditView::OnAddNodeSetattrtextContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETATTRTEXT, &CParseEditView::OnUpdateAddNodeSetattrtext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETATTRTEXT_CONTEXT, &CParseEditView::OnUpdateAddNodeSetattrtext)
	ON_COMMAND(ID_ADD_NODE_SETTEXT, &CParseEditView::OnAddNodeSettext)
	ON_COMMAND(ID_ADD_NODE_SETTEXT_CONTEXT, &CParseEditView::OnAddNodeSettextContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETTEXT, &CParseEditView::OnUpdateAddNodeSettext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_SETTEXT_CONTEXT, &CParseEditView::OnUpdateAddNodeSettext)
	ON_COMMAND(ID_ADD_NODE_PUSHTEXT, &CParseEditView::OnAddNodePushtext)
	ON_COMMAND(ID_ADD_NODE_PUSHTEXT_CONTEXT, &CParseEditView::OnAddNodePushtextContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_PUSHTEXT, &CParseEditView::OnUpdateAddNodePushtext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_PUSHTEXT_CONTEXT, &CParseEditView::OnUpdateAddNodePushtext)
	ON_COMMAND(ID_ADD_NODE_POPTEXT, &CParseEditView::OnAddNodePoptext)
	ON_COMMAND(ID_ADD_NODE_POPTEXT_CONTEXT, &CParseEditView::OnAddNodePoptextContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_POPTEXT, &CParseEditView::OnUpdateAddNodePoptext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_POPTEXT_CONTEXT, &CParseEditView::OnUpdateAddNodePoptext)
	ON_COMMAND(ID_ADD_NODE_DESC, &CParseEditView::OnAddNodeDesc)
	ON_COMMAND(ID_ADD_NODE_DESC_CONTEXT, &CParseEditView::OnAddNodeDescContext)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_DESC, &CParseEditView::OnUpdateAddNodeDesc)
	ON_UPDATE_COMMAND_UI(ID_ADD_NODE_DESC_CONTEXT, &CParseEditView::OnUpdateAddNodeDesc)

	ON_COMMAND(ID_EDIT_SELECTALL, &CParseEditView::OnEditSelectall)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECTALL, &CParseEditView::OnUpdateEditSelectall)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_EDIT_CUT, &CParseEditView::OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, &CParseEditView::OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_COPY, &CParseEditView::OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, &CParseEditView::OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, &CParseEditView::OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, &CParseEditView::OnUpdateEditPaste)
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
iParserNode CParseEditView::AddNode
		(
		IParserNode::Property::Type	type , 
		const ivector2&				pos
		)
{
	iGraph	graph = (iGraph)m_document->SearchTreeId( m_item_id );
	if( graph == false )
		return iParserNode();

	IUndoList*	undo	= m_document->Recode();
	iParserNode	node	= (iParserNode)graph->AddNode( undo );
	IParserNode::Property	prop = node->GetProperty();
	prop.m_type	= type;
	prop.m_pos	= pos;
	node->SetProperty( prop , undo );
	
	return node;
}
//=================================================================================================
isize CParseEditView::GetClientSize()
{
	CRect	r;
	GetClientRect( &r );
	return isize( r.right - r.left , r.bottom - r.top );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC functions
//=================================================================================================
CParseEditView::CParseEditView() : 
		m_popup_pos( -1 , -1 )
{
}
//=================================================================================================
CParseEditView::~CParseEditView()
{
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
void CParseEditView::OnContextMenu(CWnd* pWnd , CPoint point )
{
	SetFocus();
	CMenu	menu;
	menu.LoadMenu( IDR_PARSER_EDIT_CONTEXT );
	CMenu* psubmenu = menu.GetSubMenu( 0 );

	if ( AfxGetMainWnd()->IsKindOf( RUNTIME_CLASS( CMDIFrameWndEx ) ) )
	{
		CMFCPopupMenu* popup = new CMFCPopupMenu;
		if ( TRUE == popup->Create( this , point.x, point.y, (HMENU)psubmenu->m_hMenu, FALSE, TRUE ) )
		{
			ScreenToClient( &point );
			m_popup_pos	= ivector2( point.x , point.y );
			( ( CMDIFrameWndEx* )AfxGetMainWnd() )->OnShowPopupMenu( popup );
			UpdateDialogControls( this , FALSE );
		}
	}
}
//=================================================================================================
void CParseEditView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	KeyDir		dir;
	if( nChar == VK_LEFT )
		dir	= Left;
	else if( nChar == VK_UP )
		dir	= Up;
	else if( nChar == VK_RIGHT )
		dir	= Right;
	else if( nChar == VK_DOWN )
		dir	= Down;
	else
	{
		CParseEditCtrlView::OnKeyDown(nChar, nRepCnt, nFlags);
		return;
	}
	if( ( nFlags & 0x4000 ) == 0 )
		MoveSelectItem( dir , m_grid_size );
	else
		MoveSelectItem( dir , m_grid_size * 5 );
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command handler
//=================================================================================================
void CParseEditView::OnEditDelete()
{
	if( GetFocus() != this )
		return;
	Delete();
}
//=================================================================================================
void CParseEditView::OnUpdateEditDelete(CCmdUI *pCmdUI)
{
	if( GetFocus() != this )
		pCmdUI->Enable( FALSE );
	else
		pCmdUI->Enable( CanDelete() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParseEditView::OnEditCut()
{
	if( false == Copy() )
	{
		MessageBox( LoadText( IDS_MSG_6 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return;
	}
	Delete();
}
//=================================================================================================
void CParseEditView::OnUpdateEditCut(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanCopy() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParseEditView::OnEditCopy()
{
	if( false == Copy() )
	{
		MessageBox( LoadText( IDS_MSG_6 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return;
	}
}
//=================================================================================================
void CParseEditView::OnUpdateEditCopy(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanCopy() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParseEditView::OnEditPaste()
{
	if ( false == Paste() )
	{
		MessageBox( LoadText( IDS_MSG_7 ) , LoadText( IDS_APPTITLE ) , MB_OK | MB_ICONERROR );
		return;
	}
}
//=================================================================================================
void CParseEditView::OnUpdateEditPaste(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanPaste() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParseEditView::OnEditSelectall()
{
	SelectAll();
}
//=================================================================================================
void CParseEditView::OnUpdateEditSelectall(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( CanSelectAll() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParseEditView::OnAddNodeNone()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::None , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeNoneContext()
{
	AddNode( IParserNode::Property::None , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeNone(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodeCleartext()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::ClearText , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeCleartextContext()
{
	AddNode( IParserNode::Property::ClearText , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeCleartext(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodePushtag()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::PushTag , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodePushtagContext()
{
	AddNode( IParserNode::Property::PushTag , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodePushtag(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodePoptag()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::PopTag , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );	
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodePoptagContext()
{
	AddNode( IParserNode::Property::PopTag , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodePoptag(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodeSetattr()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::SetAttr , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeSetattrContext()
{
	AddNode( IParserNode::Property::SetAttr , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeSetattr(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodeSetattrtext()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::SetAttrText , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeSetattrtextContext()
{
	AddNode( IParserNode::Property::SetAttrText , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeSetattrtext(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodeSettext()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::SetText , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeSettextContext()
{
	AddNode( IParserNode::Property::SetText , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeSettext(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodePushtext()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::PushText , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodePushtextContext()
{
	AddNode( IParserNode::Property::PushText , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodePushtext(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodePoptext()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::PopText , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodePoptextContext()
{
	AddNode( IParserNode::Property::PopText , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodePoptext(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}
//=================================================================================================
void CParseEditView::OnAddNodeDesc()
{
	isize	wndsize = GetClientSize();
	AddNode( IParserNode::Property::Desc , ClientToWorld( ivector2( wndsize.width / 2 , wndsize.height / 2 ) ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnAddNodeDescContext()
{
	AddNode( IParserNode::Property::Desc , ClientToWorld( m_popup_pos ) );
	m_document->Callback( ICallback::AddNode , (object)m_document->SearchTreeId( m_item_id ) , 0 );
}
//=================================================================================================
void CParseEditView::OnUpdateAddNodeDesc(CCmdUI *pCmdUI)
{
	pCmdUI->Enable( TRUE );
}









