
#include "stdafx.h"
#include "MainFrm.h"
#include "ParserView.h"
#include "Resource.h"
#include "Texml.h"

/**************************************************************************************************
"CParserView" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
BEGIN_MESSAGE_MAP(CParserView, CDockablePane)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_NEW_FOLDER, OnNewFolder)
	ON_COMMAND(ID_NEW_PARSER, OnNewParser)
	ON_COMMAND(ID_PARSERVIEW_RENAME, OnRename )
	ON_COMMAND(ID_PARSERVIEW_DELETE, OnDelete )
	ON_COMMAND(ID_PARSERVIEW_SETSTART, OnSetStart )
	ON_UPDATE_COMMAND_UI(ID_NEW_FOLDER , OnNewFolderUpdate )
	ON_UPDATE_COMMAND_UI(ID_NEW_PARSER , OnNewParserUpdate )
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_RENAME , OnRenameUpdate )
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_DELETE , OnDeleteUpdate )
	ON_UPDATE_COMMAND_UI(ID_PARSERVIEW_SETSTART , OnSetStartUpdate )
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void CParserView::AdjustLayout()
{
	if (GetSafeHwnd() == NULL)
		return;

	CRect rectClient;
	GetClientRect(rectClient);

	int cyTlb = m_toolbar.CalcFixedLayout(FALSE, TRUE).cy;

	m_toolbar.SetWindowPos(NULL, rectClient.left, rectClient.top, rectClient.Width(), cyTlb, SWP_NOACTIVATE | SWP_NOZORDER);
	m_treeview.SetWindowPos(NULL, rectClient.left + 1, rectClient.top + cyTlb + 1, rectClient.Width() - 2, rectClient.Height() - cyTlb - 2, SWP_NOACTIVATE | SWP_NOZORDER);
}
//=================================================================================================
void CParserView::OnChangeVisualStyle()
{
	m_toolbar.CleanUpLockedImages();
	m_toolbar.LoadBitmap( theApp.m_bHiColorIcons ? IDB_PARSER_VIEW_TOOLBAR_24 : IDR_PARSER_VIEW_TOOLBAR , 0, 0, TRUE );
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CParserView::CParserView()
{
}
//=================================================================================================
CParserView::~CParserView()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC override functions
//=================================================================================================
BOOL CParserView::PreTranslateMessage(MSG* pMsg)
{
	return CDockablePane::PreTranslateMessage(pMsg);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC event handler
//=================================================================================================
int CParserView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if ( CDockablePane::OnCreate(lpCreateStruct) == -1 )
		return -1;

	// create treeview
	CRect rect;
	rect.SetRectEmpty();
	if ( !m_treeview.Create
			( 
			WS_CHILD | WS_VISIBLE | TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS | WS_CLIPSIBLINGS | WS_CLIPCHILDREN , 
			rect , 
			this , 
			2 
			) )
	{
		TRACE0("Class view create error.\n");
		return -1;
	}

	// create toolbar
	m_toolbar.Create( this , AFX_DEFAULT_TOOLBAR_STYLE , IDR_PARSER_VIEW_TOOLBAR );
	m_toolbar.LoadToolBar( IDR_PARSER_VIEW_TOOLBAR, 0, 0, TRUE );
	OnChangeVisualStyle();
	m_toolbar.SetPaneStyle( m_toolbar.GetPaneStyle() | CBRS_TOOLTIPS | CBRS_FLYBY );
	m_toolbar.SetPaneStyle( m_toolbar.GetPaneStyle() & ~(CBRS_GRIPPER | CBRS_SIZE_DYNAMIC | CBRS_BORDER_TOP | CBRS_BORDER_BOTTOM | CBRS_BORDER_LEFT | CBRS_BORDER_RIGHT ) );
	m_toolbar.SetOwner( this );

	// ׂẴR}hAet[oRł͂Ȃ̃Rg[oRœn܂:
	m_toolbar.SetRouteCommandsViaFrame( FALSE );

	return 0;
}
//=================================================================================================
void CParserView::OnSize(UINT nType, int cx, int cy)
{
	CDockablePane::OnSize(nType, cx, cy);
	AdjustLayout();
}
//=================================================================================================
void CParserView::OnPaint()
{
	CPaintDC dc(this);

	CRect rectTree;
	m_treeview.GetWindowRect(rectTree);
	ScreenToClient(rectTree);

	rectTree.InflateRect(1, 1);
	dc.Draw3dRect(rectTree, ::GetSysColor(COLOR_3DSHADOW), ::GetSysColor(COLOR_3DSHADOW));
}
//=================================================================================================
void CParserView::OnSetFocus(CWnd* pOldWnd)
{
	CDockablePane::OnSetFocus(pOldWnd);
	m_treeview.SetFocus();
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC command handler
//=================================================================================================
void CParserView::OnNewFolder()
{
	m_treeview.NewGroup();
}
//=================================================================================================
void CParserView::OnNewFolderUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_treeview.CanNewGroup() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParserView::OnNewParser()
{
	m_treeview.NewParser();
}
//=================================================================================================
void CParserView::OnNewParserUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_treeview.CanNewParser() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParserView::OnRename()
{
	m_treeview.Rename();
}
//=================================================================================================
void CParserView::OnRenameUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_treeview.CanRename() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParserView::OnDelete()
{
	m_treeview.DeleteItem();
}
//=================================================================================================
void CParserView::OnSetStart()
{
	m_treeview.SetStart();
}
//=================================================================================================
void CParserView::OnDeleteUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_treeview.CanDeleteItem() == true ? TRUE : FALSE );
}
//=================================================================================================
void CParserView::OnSetStartUpdate(CCmdUI* pCmdUI)
{
	pCmdUI->Enable( m_treeview.CanSetStart() == true ? TRUE : FALSE );
}
