
#include "stdafx.h"

#include "PropertiesWnd.h"
#include "Resource.h"
#include "MainFrm.h"
#include "Texml.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/**************************************************************************************************
"CPropertiesWnd" class define
**************************************************************************************************/
///////////////////////////////////////////////////////////////////////////////////////////////////
// MFC message map
BEGIN_MESSAGE_MAP(CPropertiesWnd, CDockablePane)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_EXPAND_ALL, OnExpandAllProperties)
	ON_UPDATE_COMMAND_UI(ID_EXPAND_ALL, OnUpdateExpandAllProperties)
	ON_COMMAND(ID_SORTPROPERTIES, OnSortProperties)
	ON_UPDATE_COMMAND_UI(ID_SORTPROPERTIES, OnUpdateSortProperties)
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions
//=================================================================================================
void cb_call CPropertiesWnd::Callback
		(
		Type	type , 
		object&	obj , 
		void*	param
		)
{
	if( type == ICallback::SetPropertyItem )
	{
		ICallback::SetPropertyItemParam*	p = (ICallback::SetPropertyItemParam*)param;
		if( true == (iParserNode)obj )
		{
			m_item_id	= ((iParserNode)obj)->m_item_id;
			m_node_property.ShowWindow( SW_SHOW );
			m_link_property.ShowWindow( SW_HIDE );
		}
		else if( true ==(iParserLink)obj )
		{
			m_item_id	= ((iParserLink)obj)->m_item_id;
			m_node_property.ShowWindow( SW_HIDE );
			m_link_property.ShowWindow( SW_SHOW );
		}
		else
		{
			m_item_id	= 0;
		}
	}
}
//=================================================================================================
void CPropertiesWnd::AdjustLayout()
{
	if (GetSafeHwnd() == NULL)
	{
		return;
	}

	CRect rectClient,rectCombo;
	GetClientRect(rectClient);

	int cyTlb = m_wndToolBar.CalcFixedLayout(FALSE, TRUE).cy;
	m_wndToolBar.SetWindowPos
			(
			NULL, 
			rectClient.left, 
			rectClient.top, 
			rectClient.Width(), 
			cyTlb, 
			SWP_NOACTIVATE | SWP_NOZORDER
			);
	m_node_property.SetWindowPos
			(
			NULL, 
			rectClient.left, 
			rectClient.top + cyTlb, 
			rectClient.Width(), 
			rectClient.Height() - cyTlb , 
			SWP_NOACTIVATE | SWP_NOZORDER
			);
	m_link_property.SetWindowPos
			(
			NULL, 
			rectClient.left, 
			rectClient.top + cyTlb, 
			rectClient.Width(), 
			rectClient.Height() - cyTlb , 
			SWP_NOACTIVATE | SWP_NOZORDER
			);
}
//=================================================================================================
void CPropertiesWnd::SetVSDotNetLook(BOOL bSet)
{
	m_node_property.SetVSDotNetLook( bSet );
	m_node_property.SetGroupNameFullWidth( bSet );
	m_link_property.SetVSDotNetLook( bSet );
	m_link_property.SetGroupNameFullWidth( bSet );
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// private functions

///////////////////////////////////////////////////////////////////////////////////////////////////
// public functions
//=================================================================================================
CPropertiesWnd::CPropertiesWnd() : m_item_id( 0 )
{
	m_document = GetDocument();
	m_listener->SetCallback( this );
	m_document->AddCallback( (rCallback)m_listener );
}
//=================================================================================================
CPropertiesWnd::~CPropertiesWnd()
{
}


///////////////////////////////////////////////////////////////////////////////////////////////////
// CResourceViewBar bZ[W nh

//=================================================================================================
int CPropertiesWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDockablePane::OnCreate(lpCreateStruct) == -1)
		return -1;

	CRect r;
	r.SetRectEmpty();

	// create property list
	if ( !m_node_property.Create(WS_VISIBLE | WS_CHILD, r, this, 2 ) )
	{
		TRACE0("fail to create property list\n");
		return -1;
	}
	// create property list
	if ( !m_link_property.Create(WS_VISIBLE | WS_CHILD, r, this, 3 ) )
	{
		TRACE0("fail to create property list\n");
		return -1;
	}
	// create toolbar
	m_wndToolBar.Create(this, AFX_DEFAULT_TOOLBAR_STYLE, IDR_PROPERTIES);
	m_wndToolBar.LoadToolBar(IDR_PROPERTIES, 0, 0, TRUE );
	m_wndToolBar.CleanUpLockedImages();
	m_wndToolBar.LoadBitmap(theApp.m_bHiColorIcons ? IDB_PROPERTIES_HC : IDR_PROPERTIES, 0, 0, TRUE );
	m_wndToolBar.SetPaneStyle(m_wndToolBar.GetPaneStyle() | CBRS_TOOLTIPS | CBRS_FLYBY);
	m_wndToolBar.SetPaneStyle(m_wndToolBar.GetPaneStyle() & ~(CBRS_GRIPPER | CBRS_SIZE_DYNAMIC | CBRS_BORDER_TOP | CBRS_BORDER_BOTTOM | CBRS_BORDER_LEFT | CBRS_BORDER_RIGHT));
	m_wndToolBar.SetOwner(this);

	// ׂẴR}hAet[oRł͂Ȃ̃Rg[oRœn܂:
	m_wndToolBar.SetRouteCommandsViaFrame(FALSE);
	AdjustLayout();
	return 0;
}
//=================================================================================================
void CPropertiesWnd::OnSize(UINT nType, int cx, int cy)
{
	CDockablePane::OnSize(nType, cx, cy);
	AdjustLayout();
}
//=================================================================================================
void CPropertiesWnd::OnExpandAllProperties()
{
	m_node_property.ExpandAll();
	m_link_property.ExpandAll();
}
//=================================================================================================
void CPropertiesWnd::OnUpdateExpandAllProperties(CCmdUI* pCmdUI)
{
}
//=================================================================================================
void CPropertiesWnd::OnSortProperties()
{
	m_node_property.SetAlphabeticMode(!m_node_property.IsAlphabeticMode());
	m_link_property.SetAlphabeticMode(!m_link_property.IsAlphabeticMode());
}
//=================================================================================================
void CPropertiesWnd::OnUpdateSortProperties(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(TRUE);//m_node_property.IsAlphabeticMode());
}
//=================================================================================================
void CPropertiesWnd::OnSetFocus(CWnd* pOldWnd)
{
	CDockablePane::OnSetFocus(pOldWnd);
	m_node_property.SetFocus();
	m_link_property.SetFocus();
}
