#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#ifdef WIN32
#ifdef _MSC_VER
#define _CRT_SECURE_NO_DEPRECATE
#endif 
#include <windows.h>
#define strcasecmp _stricmp
#endif

#include <stdio.h>
#include <gtk/gtk.h>

#include <string.h>
#include <ctype.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "file_io.h"

#define my_iter_line_star(a)  gtk_text_iter_backward_chars((a),gtk_text_iter_get_line_offset (a))

gdouble latency= -1;
gchar out_device_c='d';
gchar output_format[256]={0};
char device_list[DEVICE_LIST_MAX][MAX_LINE];
gint deviceID = -1;
gint devID[DEVICE_LIST_MAX];
gint devIDn = 0;

void set_device_list(void);
//void cr_add_buffer(GtkTextBuffer *buffer);
void cr_rm_buffer(GtkTextBuffer *buffer);
gchar *getline_buffer(GtkTextBuffer *buffer, gint line_number);
gint search_buffer(const GtkTextBuffer *buffer, const char *key, gboolean forward);
gint case_search_buffer(const GtkTextBuffer *buffer, const char *key, gboolean forward);
void update_sf2_sel_buffer(void);
void clear_buffer(GtkTextBuffer *buffer);
void update_cfg_buffer(void);
gint saveconfig_buffer(void);
void rmstr_string(gchar *str, gchar *key);
void update_out_buttons(void);
void set_deviceID(int deviceID);
void reduce_space(char *buf);
void rm_comment(char *buf);
void parse_one_line(char *buf);
void apply_config_buffer(void);
gint readconfig_buffer(void);
void dir_add(const gchar *dir_path);
void sf2_add(const gchar *sf2_name);

void set_device_list(void){
  gint i;
  get_device_list(out_device_c, device_list);
  for ( i = 0; i < devIDn; i++ )
    gtk_combo_box_remove_text(GTK_COMBO_BOX(comboboxentry1), 0);
  for( i=0; i < DEVICE_LIST_MAX-1 && device_list[i][0] != '\0';i++){
    gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxentry1), device_list[i]);
    sscanf(device_list[i], "%d ", &(devID[i]));
  }
  gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxentry1), _("(default device)"));
  devID[i++]=-1;
  devIDn = i;
}


/*
void cr_add_buffer(GtkTextBuffer *buffer)
{
  gchar *buf;
  GtkTextIter s_iter,e_iter;

  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer),&e_iter);
  s_iter=e_iter;
  gtk_text_iter_backward_word_start(&s_iter);
 buf = gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &s_iter, &e_iter, TRUE);
 if( buf[strlen(buf)-1] != '\n'){
 	gtk_text_iter_forward_to_line_end( &s_iter);
    gtk_text_buffer_insert(GTK_TEXT_BUFFER(buffer),&s_iter,"\n",strlen("\n"));
  }
  g_free(buf);
}
*/


gchar *getline_buffer(GtkTextBuffer *buffer, gint line_number)
{  
  GtkTextIter sl_iter,el_iter;
  gchar *line, *outline;

  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer),&sl_iter,line_number);
  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer),&el_iter,line_number+1);

  line=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &sl_iter, &el_iter, FALSE);
  if (line == NULL) return NULL;
  outline=(gchar *)g_malloc((strlen(line)+2)*sizeof(gchar));
  strcpy(outline,line);
  if ( ((strlen(outline)-1)>=0) && (*(outline+strlen(outline)-1)!='\n') )strcat(outline,"\n");
  g_free(line);

  return outline;
}
gint search_buffer(const GtkTextBuffer *buffer, const char *key, gboolean forward)
{
  gint i, linen;
  GtkTextIter s_iter,e_iter;
  gchar *text, *p, *cp;
  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer),&s_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer),&e_iter);
  text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &s_iter, &e_iter, TRUE);

  if ( (text==NULL) || ((p=strstr(text,key))==NULL) ) { g_free(text); return -1;}
  if ( forward != TRUE) {
    cp = p;
    while( (cp=strstr(cp,key))!=NULL ){ p=cp; };  
  }
  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(buffer));
  for( i = -1,cp=text; (i < linen-1) && (p > cp); i++)
  	   cp=strstr(cp,"\n");
   g_free(text);
   return i;
}

gint case_search_buffer(const GtkTextBuffer *buffer, const char *key, gboolean forward)
{
  guint i,linen;
  gchar key1[256];
  GtkTextIter s_iter,e_iter;
  gchar *text, *p, *cp;
  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer),&s_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer),&e_iter);
  text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(buffer), 
        &s_iter, &e_iter, TRUE);

  for(i=0;i<strlen(text);i++) *(text+i)=toupper(*(text+i));
  strcpy(key1, key);
  for(i=0;i<strlen(key1);i++) *(key1+i)=toupper(*(key1+i));

  if ( (text==NULL) || ((p=strstr(text,key1))==NULL) ) { g_free(text); return -1;}
  if ( forward != TRUE) {
    cp = p;
    while( (cp=strstr(cp,key1))!=NULL ){ p=cp; };  
  }
  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(buffer));
  for( i = -1,cp=text; (i < linen-1) && (p > cp); i++)
  	   cp=strstr(cp,"\n");
   g_free(text);
   return i;
}
  
void update_sf2_sel_buffer(void)
{

gint linen, i;
GtkTextIter sl_iter, el_iter, sl_sf2_iter, el_sf2_iter;
gchar buf[2048],buf2[256];
gchar *line_text;
GtkTextIter iter;

//offset=gtk_text_iter_get_offset(&sf2_sel_iter);

buf[0] = '\0';

gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_sel_buffer),&sl_sf2_iter,0);
gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_sel_buffer), &el_sf2_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_sel_buffer),&sl_sf2_iter,&el_sf2_iter);

linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(dir_buffer));
for( i = 0; (i < linen); i++){
  gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(dir_buffer),&sl_iter,i);
  el_iter=sl_iter;
  gtk_text_iter_forward_line(&el_iter);
  line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(dir_buffer), 
        &sl_iter, &el_iter, TRUE);
  strcpy(buf2,line_text);
  g_free(line_text);
  if (buf2[0]=='\"') strcpy(buf2,buf2+1);
  if (( buf2[0] != '\0') && (buf2[strlen(buf2)-1]='\n')) buf2[strlen(buf2)-1]='\0' ;
  if (( buf2[0] != '\0') && (buf2[strlen(buf2)-1]='\"')) buf2[strlen(buf2)-1]='\0' ;
  convert_to_utf8(buf2,FALSE);
  dir_list(buf2,".sf2", buf+strlen(buf), 2048-strlen(buf));
  dir_list(buf2,".cfg", buf+strlen(buf), 2048-strlen(buf));
  dir_list(buf2,".SF2", buf+strlen(buf), 2048-strlen(buf));
  dir_list(buf2,".CFG", buf+strlen(buf), 2048-strlen(buf));
}
gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_sel_buffer), &iter);
gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), &iter);
if (buf[0] != '\0')
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), buf, strlen(buf));
//gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_sel_buffer), "\n", strlen("\n"));

//gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_sel_buffer), &sf2_sel_iter, offset);

}

void clear_buffer(GtkTextBuffer *buffer)
{
  GtkTextIter s_iter, e_iter, iter;

  gtk_text_buffer_get_start_iter(GTK_TEXT_BUFFER(buffer), &s_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &e_iter);
  gtk_text_buffer_delete(GTK_TEXT_BUFFER(buffer), &s_iter, &e_iter);
  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(buffer), &iter);
  gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(buffer), &iter);
}

void update_cfg_buffer(void)
{
  gint i, linen;
  gchar *buf;
  gchar buf2[128];

  clear_buffer(GTK_TEXT_BUFFER(cfg_buffer));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(dir_buffer));
  for(i=0 ; i< linen; i++){
    buf = getline_buffer(GTK_TEXT_BUFFER(dir_buffer), i);
    if( (buf[0] !='\0') && ( buf[0] !='\n')){
     sprintf(buf2, "dir %s", buf);    
     gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
    }
    g_free(buf);
  }
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), "\n", strlen("\n"));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(sf2_buffer));
  for(i=0 ; i< linen; i++){
    if( NULL != (buf = getline_buffer(GTK_TEXT_BUFFER(sf2_buffer), i)) ){
 	  if ( (NULL != strstr(buf,".cfg")) || (NULL != strstr(buf,".CFG")) ){
        sprintf(buf2, "source %s", buf);      
        gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
	  }
	  if ( (NULL != strstr(buf,".sf2")) || (NULL != strstr(buf,".SF2")) ){
        sprintf(buf2, "soundfont %s", buf);    
        gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
      }
    g_free(buf);
    }
  }

  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), "\n", strlen("\n"));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(other_syntax_buffer));
  for(i=0 ; i< linen; i++){
    buf = getline_buffer(GTK_TEXT_BUFFER(other_syntax_buffer), i);
    gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf, strlen(buf));
    g_free(buf);
  }
  	
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), "\n", strlen("\n"));

  if(latency !=-1){
  	 sprintf(buf2, "#extension opt --rtsyn-latency=%lf\n", latency);
     gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
  }
  sprintf(buf2, "#extension opt -O%c%s\n", out_device_c, output_format);
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
  if(deviceID !=-1){
  	 sprintf(buf2, "#extension opt --output-device=%d\n", deviceID);
     gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf2, strlen(buf2));
  }
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer),
      "#extension opt -U\n", strlen("#extension opt -U\n"));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(other_buffer));
  for(i=0 ; i< linen; i++){
    buf = getline_buffer(GTK_TEXT_BUFFER(other_buffer), i);
    if( NULL == strstr( buf, "#extension opt -U"))    
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(cfg_buffer), buf, strlen(buf));
    g_free(buf);
  }  	
}

gint saveconfig_buffer(void)
{
 
  gchar buf[256];
  gchar *linebuf;
  gint linen, i;
  FILE *fp;

  update_cfg_buffer();

  if(NULL == (fp = fopen(get_cfg_path(), "w"))) return -1;
  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(cfg_buffer));
  for(i=0 ; i< linen; i++){
	if( NULL != (linebuf = getline_buffer(GTK_TEXT_BUFFER(cfg_buffer),i))){
      strcpy(buf, linebuf);
      buf[256-1]='\0';
      fputs(buf,fp);
      g_free(linebuf);
	}
  }
  fclose(fp);
  return 0;
}

void rmstr_string(gchar *str, gchar *key)
{
    gchar *cp;
    cp=str;
 	while ((cp=strstr(cp, key) ) !=NULL){
	  strcpy( cp, cp+strlen(key));
	}
}

void update_out_buttons(void){

  if(out_device_c=='d')
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(out_winmm_btn),TRUE);
  if(out_device_c=='p')
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(out_pa_win_btn),TRUE);
  if(out_device_c=='P')
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(out_pa_directx_btn),TRUE);
  if(out_device_c=='o')
     gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(out_pa_asio_btn),TRUE);

};

void set_deviceID(int deviceID)
{
  int i;
  set_device_list();
  for ( i = 0; i < devIDn; i++ ){
    if (deviceID == devID[i]) break;
  }
  if(i != devIDn){
    gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxentry1),i);
  }else{
    deviceID=-1;
  }
}

void reduce_space(char *buf){
  char *p, *pp, *ppp;

  for( p = buf; p < buf+strlen(buf); p++){
	  if( *p == '\t') *p = ' ';
  }
  p=buf;
  while ( (NULL != (pp = strstr(p, " "))) && (p<buf+strlen(buf)) ){
    ppp=pp;
	while( *ppp == ' ') ppp++;
	strcpy(pp+1, ppp);
	p=pp+1;
  }
}

void rm_comment(char *buf){
  char *p;
  reduce_space(buf);
  if( NULL != (p = strstr(buf, " #"))) *p='\0';
}

void parse_one_line(char *buf)
{
  gchar *cp,buf2[256];
  gboolean parsed;

    rm_comment(buf);
    rmstr_string(buf, "\"");
    if( *(buf+strlen(buf)-1) != '\n' ) strcat(buf,"\n");
    parsed = FALSE;
	if ( strncmp(buf, "dir ", strlen("dir ")) == 0){
	  char *p, *pp;
      rmstr_string(buf, "dir ");
	  *(buf+strlen(buf)-1)='\0';
	  sprintf(buf2,"\"%s\"\n",buf);
	  p=buf2;
	  while( (p < buf2+strlen(buf2)) && (NULL != (pp = strstr(p, "/"))) ){
	    *pp = G_DIR_SEPARATOR;
		p = pp+1;
	  }       
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), buf2, strlen(buf2));
      parsed = TRUE;
	}
	if ( strncmp(buf, "source ", strlen("source ")) == 0){
      rmstr_string(buf, "source ");
	  *(buf+strlen(buf)-1)='\0';
	  sprintf(buf2,"\"%s\"\n",buf);
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf2, strlen(buf2));
      parsed = TRUE;
	}
	if ( strncmp(buf, "soundfont ", strlen("soundfont ")) == 0){
      rmstr_string(buf, "soundfont ");
      if ( ( (cp = strstr( buf, ".sf2")) != NULL ) || ( (cp = strstr( buf, ".SF2")) != NULL ) ){
	    *(buf+strlen(buf)-1)='\0';
		sprintf(buf2,"\"%s\"\n",buf);
        gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf2, strlen(buf2));
        parsed = TRUE;
      }
    }

	if ( strncmp(buf, "#extension opt ", strlen("#extension opt ")) == 0){    
	  if ((cp = strstr(buf, "--rtsyn-latency="))!=NULL){
        if( sscanf(cp+strlen("--rtsyn-latency="), "%lf", &latency) != EOF )
          parsed = TRUE;
      }
	  if ((cp = strstr(buf, "--output-mode="))!=NULL){
        if( sscanf(cp+strlen("--output-mode="), "%c", &out_device_c) != EOF )
          parsed = TRUE;
      }
	  if ((cp = strstr(buf, "-O"))!=NULL){
        if( sscanf(cp+strlen("-O"), "%c", &out_device_c) != EOF ){
          gchar *p;
          strcpy(output_format,cp+strlen("-O")+1);
          rmstr_string(output_format, "\n");
          p=strstr(output_format,"d");
          if(p != NULL) {
            if (sscanf(p+1, "%d", &deviceID) != EOF ){
              *(p)='\0';
            }
          }
        }
        parsed = TRUE;
      }
      if ((cp = strstr(buf, "--output-device="))!=NULL){
        if( sscanf(cp+strlen("--output-device="), "%d", &deviceID) != EOF ){
          parsed = TRUE;
        }
      }
      if (parsed != TRUE){
           gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(other_buffer), buf, strlen(buf));
            parsed = TRUE;
      } 
    }
    if( (parsed != TRUE) && ((buf[0] != '#') && (buf[0] != '\n')) ){
      gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(other_syntax_buffer), buf, strlen(buf));
      parsed = TRUE;
    }
}


void apply_config_buffer(void)
{
  int i, linen;
  char *buf;
  gint bufID;

  latency= -1;
  out_device_c='d';
  output_format[0]='\0';
  deviceID = -1;

  clear_buffer(GTK_TEXT_BUFFER(dir_buffer));
  clear_buffer(GTK_TEXT_BUFFER(sf2_buffer));
  clear_buffer(GTK_TEXT_BUFFER(other_buffer));

  linen = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(cfg_buffer));
  for(i=0 ; i< linen; i++){
    buf=getline_buffer(GTK_TEXT_BUFFER(cfg_buffer), i);
	if(buf != NULL){
	parse_one_line(buf);
    g_free(buf);
	}
  }
  update_sf2_sel_buffer();
  update_cfg_buffer();
  if ( latency != -1){
    sprintf(buf, "%lf",latency);
    gtk_entry_set_text(GTK_ENTRY(entry2),buf);
  }else{
    gtk_entry_set_text(GTK_ENTRY(entry2),"");
  }
  
  bufID=deviceID;
  update_out_buttons();
  deviceID=bufID;
  set_deviceID(deviceID);

}

gint readconfig_buffer(void)
{
  FILE *fp;
  gchar buf[256];
  gint bufID;

  latency= -1;
  out_device_c='d';
  output_format[0]='\0';
  deviceID = -1;

  clear_buffer(GTK_TEXT_BUFFER(dir_buffer));
  clear_buffer(GTK_TEXT_BUFFER(sf2_buffer));
  clear_buffer(GTK_TEXT_BUFFER(other_buffer));

  if((fp = fopen(get_cfg_path(), "r"))==NULL) return -1;
  while( NULL != fgets(buf,256,fp) ){
    buf[256-1]='\0';
	parse_one_line(buf);
  };
  update_sf2_sel_buffer();
  update_cfg_buffer();
  if ( latency != -1){
    sprintf(buf, "%lf",latency);
    gtk_entry_set_text(GTK_ENTRY(entry2),buf);
  }else{
    gtk_entry_set_text(GTK_ENTRY(entry2),"");
  }

  bufID=deviceID;
  update_out_buttons();
  deviceID=bufID;
  set_deviceID(deviceID);
  fclose(fp);
  return 0;
}


void dir_add(const gchar *dir_path)
{
GtkTextIter iter;
gboolean included;
gchar buf[256];

strcpy(buf,dir_path);
convert_to_utf8(buf,FALSE);
if ( FALSE == is_dir(buf) ) return;

sprintf(buf,"\"%s\"",dir_path);

included = FALSE;

if( -1 == case_search_buffer(GTK_TEXT_BUFFER(dir_buffer), dir_path, TRUE) ){
   gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(dir_buffer), &iter);
   gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(dir_buffer), &iter);
   gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), buf, strlen(buf));
   gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(dir_buffer), "\n", strlen("\n"));
}
update_sf2_sel_buffer();
update_cfg_buffer();
}

void sf2_add(const gchar *sf2_name)
{
GtkTextIter iter;
gchar buf[258];

sprintf(buf,"\"%s\"",sf2_name);
//cr_add_buffer(GTK_TEXT_BUFFER(sf2_buffer));
if ( -1 == search_buffer((const GtkTextBuffer *)sf2_buffer,(const char *)sf2_name, TRUE)){
 gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(sf2_buffer), &iter);
 gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &iter);
 gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), buf, strlen(buf));
 gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), "\n", strlen("\n"));
} 
update_cfg_buffer();
}
 
void
on_entry1_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_button1_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_show (dir_select_dlg);
}


void
on_textview4_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview4_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview4_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&dir_iter,buffer_x,buffer_y);
my_iter_line_star(&dir_iter);
gtk_text_buffer_set_modified (dir_buffer, FALSE);
  return FALSE;
}


void
on_dir_add_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{
const gchar* name;

name = gtk_entry_get_text(GTK_ENTRY(entry1));
dir_add(name);
}


void
on_dir_remove_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter sl_iter, el_iter;

if (gtk_text_buffer_get_modified (dir_buffer) == TRUE) return;

//offset=gtk_text_iter_get_offset(&dir_iter);
sl_iter=dir_iter;
el_iter=dir_iter;
gtk_text_iter_forward_line(&el_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(dir_buffer),&sl_iter,&el_iter);
update_sf2_sel_buffer();
//gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(dir_buffer), &dir_iter, offset);
update_cfg_buffer();
}


void
on_textview2_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview2_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview2_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&sf2_iter,buffer_x,buffer_y);
my_iter_line_star(&sf2_iter);
gtk_text_buffer_set_modified (sf2_buffer, FALSE);
  return FALSE;
}


void
on_sf2_add_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter sl_iter, el_iter;
gchar *line_text;

//cr_add_buffer(GTK_TEXT_BUFFER(sf2_sel_buffer));

if (gtk_text_buffer_get_modified (sf2_sel_buffer) == TRUE) return;

el_iter=sf2_sel_iter;
gtk_text_iter_forward_line(&el_iter);
sl_iter=el_iter;
gtk_text_iter_backward_line(&sl_iter);
line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_sel_buffer), 
        &sl_iter, &el_iter, TRUE);
line_text[strlen(line_text)-1]='\0';

sf2_add(line_text);
g_free(line_text);
}


void
on_sf2_remove_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter sl_iter, el_iter;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

el_iter=sf2_iter;
gtk_text_iter_forward_line(&el_iter);
sl_iter=el_iter;
gtk_text_iter_backward_line(&sl_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
update_cfg_buffer();
}


void
on_sf2_up_pressed                      (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter to_iter, sl_iter, el_iter;
gchar *line_text;
gint offset;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

sl_iter=sf2_iter;
el_iter=sf2_iter;
gtk_text_iter_forward_line(&el_iter);
if (gtk_text_iter_is_start(&sl_iter) == TRUE ) return; 
to_iter = sf2_iter;
gtk_text_iter_backward_line(&to_iter);
offset=gtk_text_iter_get_offset(&to_iter);
line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_buffer), 
        &sl_iter, &el_iter, TRUE);
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sl_iter, offset);
gtk_text_iter_forward_line(&sl_iter);
el_iter=sl_iter;
gtk_text_iter_forward_line(&el_iter);
gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &to_iter, offset);
gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &to_iter);
gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), line_text, strlen(line_text));
gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
gtk_text_buffer_set_modified (sf2_buffer, FALSE);
g_free(line_text);
update_cfg_buffer();
}


void
on_sf2_down_pressed                    (GtkButton       *button,
                                        gpointer         user_data)
{
GtkTextIter to_iter, sl_iter, el_iter;
gchar *line_text;
gint offset;

if (gtk_text_buffer_get_modified (sf2_buffer) == TRUE) return;

offset=gtk_text_iter_get_offset(&sf2_iter);

sl_iter=sf2_iter;
el_iter=sf2_iter;
if (gtk_text_iter_forward_line(&el_iter) == TRUE ){
  to_iter=el_iter;
  gtk_text_iter_forward_line(&to_iter);
  line_text=gtk_text_buffer_get_text(GTK_TEXT_BUFFER(sf2_buffer), 
        &sl_iter, &el_iter, TRUE);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &to_iter, offset);
  gtk_text_iter_forward_lines(&to_iter,2);
  gtk_text_buffer_place_cursor(GTK_TEXT_BUFFER(sf2_buffer), &to_iter);
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(sf2_buffer), line_text, strlen(line_text));
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sl_iter, offset);
  el_iter=sl_iter;  
  gtk_text_iter_forward_line(&el_iter);
  gtk_text_buffer_delete(GTK_TEXT_BUFFER(sf2_buffer),&sl_iter,&el_iter);
  g_free(line_text);
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
  gtk_text_buffer_set_modified (sf2_buffer, FALSE);
  gtk_text_iter_forward_line(&sf2_iter);
}else{
  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(sf2_buffer), &sf2_iter, offset);
  gtk_text_buffer_set_modified (sf2_buffer, FALSE);
}
update_cfg_buffer();
}


void
on_textview3_move_cursor               (GtkTextView     *textview,
                                        GtkMovementStep  step,
                                        gint             count,
                                        gboolean         extend_selection,
                                        gpointer         user_data)
{

}


gboolean
on_textview3_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_textview3_button_release_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
gint x, y, buffer_x, buffer_y;
gtk_widget_get_pointer(widget, &x, &y);
gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
        GTK_TEXT_WINDOW_WIDGET,  x, y, &buffer_x, &buffer_y);
gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget),&sf2_sel_iter,buffer_x,buffer_y);
my_iter_line_star(&sf2_sel_iter);
gtk_text_buffer_set_modified (sf2_sel_buffer, FALSE);
  return FALSE;
}


void
on_entry2_changed                      (GtkEditable     *editable,
                                        gpointer         user_data)
{
const gchar *inbuf;
inbuf=gtk_entry_get_text(GTK_ENTRY(editable));
if (0==sscanf(inbuf,"%lf",&latency) ) latency=-1.0;
update_cfg_buffer();
}


void
on_button15_pressed                    (GtkButton       *button,
                                        gpointer         user_data)
{
asioConfigDialog();

}


void
on_discard_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{
readconfig_buffer();
update_cfg_buffer();
}


void
on_cacel_quit_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_main_quit(); 
}


void
on_quit_pressed                        (GtkButton       *button,
                                        gpointer         user_data)
{
saveconfig_buffer();
gtk_main_quit(); 
}


void
on_dir_select_cancel_btn_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(dir_select_dlg);
}


void
on_dir_select_open_btn_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *dir_name;
  gtk_widget_hide(dir_select_dlg);
  dir_name = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (dir_select_dlg));
  gtk_entry_set_editable(GTK_ENTRY(entry1), TRUE);
  gtk_entry_set_text(GTK_ENTRY(entry1),(const gchar *)dir_name);
  gtk_entry_set_editable(GTK_ENTRY(entry1), FALSE);
  g_free(dir_name);
}


void
on_out_pa_win_btn_clicked              (GtkToggleButton       *button,
                                        gpointer         user_data)
{
}


void
on_out_pa_directx_btn_clicked          (GtkToggleButton      *button,
                                        gpointer         user_data)
{
}


void
on_out_pa_asio_btn_clicked             (GtkToggleButton       *button,
                                        gpointer         user_data)
{
}


void
on_cfg_window_btn_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
update_cfg_buffer();
gtk_widget_show (cfg_edit_dlg);
}


void
on_out_winmm_btn_clicked               (GtkToggleButton      *button,
                                        gpointer         user_data)
{
}


void
on_dir_select_dlg_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
gtk_widget_hide (dir_select_dlg);
}


gboolean
on_dir_select_dlg_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_hide (dir_select_dlg);
  return TRUE;
}


void
on_cfg_windows_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
apply_config_buffer();
gtk_widget_hide (cfg_edit_dlg);
}


gboolean
on_cfg_windows_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
apply_config_buffer();
gtk_widget_hide (cfg_edit_dlg);
  return TRUE;
}


void
on_comboboxentry1_changed              (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  gint n;
  n = gtk_combo_box_get_active (GTK_COMBO_BOX(combobox));
  deviceID=devID[n];
}


void
on_cancel_quit1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gtk_main_quit(); 
}


void
on_save_quit1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
saveconfig_buffer();
gtk_main_quit(); 
}


void
on_timiditycfg1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
char *locale;
locale =setlocale(LC_ALL, NULL);
if( 0 == strcmp(locale,"Japanese_Japan.932")){
  ShellExecute(NULL, NULL, 
    "http://timidity-docs.sourceforge.jp/cgi-bin/hiki/hiki.cgi?%28ja%29timidity.cfg", 
     NULL, NULL, SW_SHOWNORMAL);
}else{
  ShellExecute(NULL, NULL, 
    "http://timidity-docs.sourceforge.jp/cgi-bin/hiki/hiki.cgi?timidity.cfg.5.en", 
     NULL, NULL, SW_SHOWNORMAL);
}
}


gboolean
on_textview2_drag_motion               (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        guint            time,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_textview2_drag_data_received        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
  GdkDragAction actions;
  gchar text[MAX_LINE*40];
   actions=drag_context->actions;
  if ((actions & GDK_ACTION_COPY) && (data->length > 0) && (data->format == 8)) {
    gint n;
    gchar buf[MAX_LINE];
    gchar *p, *pp, *linep, dir_path[256], filename[256];

    if (data->length > MAX_LINE*40){
      gtk_drag_finish(drag_context, FALSE, FALSE, time);
      return;
    }

    for( n = 0; n < data->length; n++){
      text[n]=*(data->data+n);
    }
    text[n+1]='\0';

    rmstr_string(text,"file:///");

    linep=text;
    while( linep < text+strlen(text) && (EOF != (n = sscanf(linep, "%s\r\n", buf))) ){
      linep += strlen(buf)+2;      
      p=buf;
	  while ( NULL != (pp = strstr(p,"/")) && p < text+strlen(buf) ){
        *pp=G_DIR_SEPARATOR;
        p=pp+1;
	  };
      *(p-1)='\0';

	  strcpy(dir_path, buf);
      strcpy(filename, p);
      rmstr_string(filename,"\r\n");
      convert_to_urlencode(dir_path,FALSE);
      convert_to_urlencode(filename,FALSE);

      if ( (0 == strcasecmp(filename+strlen(filename)-4,".sf2"))
        || (0 == strcasecmp(filename+strlen(filename)-4,".cfg")) ){
        dir_add(dir_path);
        sf2_add(filename);
      }
    }

    gtk_drag_finish(drag_context, TRUE, FALSE, time);
  } else {
    gtk_drag_finish(drag_context, FALSE, FALSE, time);
  }

}


gboolean
on_textview3_drag_motion               (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        guint            time,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_textview3_drag_data_received        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
  GdkDragAction actions;
  gchar text[MAX_LINE*40];
   actions=drag_context->actions;
  if ((actions & GDK_ACTION_COPY) && (data->length > 0) && (data->format == 8)) {
    gint n;
    gchar buf[MAX_LINE];
    gchar *p, *pp, *linep, dir_path[256], filename[256];

    if (data->length > MAX_LINE*40){
      gtk_drag_finish(drag_context, FALSE, FALSE, time);
      return;
    }

    for( n = 0; n < data->length; n++){
      text[n]=*(data->data+n);
    }
    text[n+1]='\0';

    rmstr_string(text,"file:///");

    linep=text;
    while( EOF != (n = sscanf(linep, "%s\r\n", buf)) ){
      linep += strlen(buf)+2;      
      p=buf;
	  while ( NULL != (pp = strstr(p,"/")) && p < text+strlen(buf) ){
        *pp=G_DIR_SEPARATOR;
        p=pp+1;
	  };
      *(p-1)='\0';

	  strcpy(dir_path, buf);
      strcpy(filename, p);
      rmstr_string(filename,"\r\n");
      convert_to_urlencode(dir_path,FALSE);
      convert_to_urlencode(filename,FALSE);

      if ( (0 == strcasecmp(filename+strlen(filename)-4,".sf2"))
        || (0 == strcasecmp(filename+strlen(filename)-4,".cfg")) ){
        dir_add(dir_path);
      }
    }

    gtk_drag_finish(drag_context, TRUE, FALSE, time);
  } else {
    gtk_drag_finish(drag_context, FALSE, FALSE, time);
  }
}


gboolean
on_textview4_drag_motion               (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        guint            time,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_textview4_drag_data_received        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data)
{
  GdkDragAction actions;
  gchar text[MAX_LINE*40];
   actions=drag_context->actions;
  if ((actions & GDK_ACTION_COPY) && (data->length > 0) && (data->format == 8)) {
    gint n;
    gchar buf[MAX_LINE],buf2[MAX_LINE];
    gchar *p, *pp, *linep, dir_path[256], filename[256];

    if (data->length > MAX_LINE*40){
      gtk_drag_finish(drag_context, FALSE, FALSE, time);
      return;
    }

    for( n = 0; n < data->length; n++){
      text[n]=*(data->data+n);
    }
    text[n+1]='\0';

    rmstr_string(text,"file:///");

    linep=text;
    while( EOF != (n = sscanf(linep, "%s\r\n", buf)) ){
      linep += strlen(buf)+2;      
      p=buf;
	  while ( NULL != (pp = strstr(p,"/")) && p < text+strlen(buf) ){
        *pp=G_DIR_SEPARATOR;
        p=pp+1;
	  };
	  strcpy(buf2,buf);
      convert_to_urlencode(buf2,FALSE);
	  if (TRUE != is_dir(buf2))
        *(p-1)='\0';

	  strcpy(dir_path, buf);
      strcpy(filename, p);
      rmstr_string(filename,"\r\n");
      convert_to_urlencode(dir_path,FALSE);
      convert_to_urlencode(filename,FALSE);

      dir_add(dir_path);

	}
    gtk_drag_finish(drag_context, TRUE, FALSE, time);
  } else {
    gtk_drag_finish(drag_context, FALSE, FALSE, time);
  }
}


void
on_about_win_destroy                   (GtkObject       *object,
                                        gpointer         user_data)
{
 gtk_widget_hide(about_win_dlg);
}


gboolean
on_about_win_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
 gtk_widget_hide(about_win_dlg);
  return TRUE;
}


void
on_out_winmm_btn_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (TRUE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)) ){
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_win_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_directx_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_asio_btn), FALSE);

  out_device_c='d';
  deviceID=-1;
  set_device_list();
  set_deviceID(deviceID);
  update_cfg_buffer();
}

}

void
on_out_pa_win_btn_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (TRUE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)) ){
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_winmm_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_directx_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_asio_btn), FALSE);

out_device_c='p';
deviceID=-1;
set_device_list();
set_deviceID(deviceID);
update_cfg_buffer();
}

}


void
on_out_pa_directx_btn_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (TRUE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)) ){
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_winmm_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_win_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_asio_btn), FALSE);


out_device_c='P';
deviceID=-1;
set_device_list();
set_deviceID(deviceID);
update_cfg_buffer();
}

}


void
on_out_pa_asio_btn_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
if (TRUE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)) ){
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_winmm_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_win_btn), FALSE);
gtk_toggle_button_set_active    (GTK_TOGGLE_BUTTON(out_pa_directx_btn), FALSE);

out_device_c='o';
deviceID=-1;
set_device_list();
set_deviceID(deviceID);
update_cfg_buffer();
}

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
gtk_widget_show(about_win_dlg);
}

