﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Skype2HTML
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
            // 最大（最小）ウィンドウサイズを変更
            this.MaximumSize = new Size(420, 380);
            this.MinimumSize = new Size(420, 380);
            this.Size = new Size(420, 380);
            // これでオプション画面が閉じられているはず
        }

        // 変数
        bool IsOpenOption = false;
        string DirectoryPath;
        string Converting = "";
        string ConvertAnalyze = "";
        string ConvertAnalyze_Time = "";
        string ConvertAnalyze_User = "";
        string ConvertAnalyze_Text = "";
        string Converted = "";

        private void Button_Text_Paste_Click(object sender, EventArgs e)
        {
            if (Clipboard.ContainsText() == false)
            {
                MessageBox.Show("クリップボードの内容がテキストではありません。"
                    , "Skype2HTML"
                    , MessageBoxButtons.OK
                    , MessageBoxIcon.Error);
                return;
            }
            this.TextBox_Convert_Text.Text = Clipboard.GetText();
        }

        private void Button_Option_Click(object sender, EventArgs e)
        {
            if (IsOpenOption == true)
            {
                // IsOpenOptionはtrueだった = オプション開いてる
                // 最大（最小）ウィンドウサイズを変更
                this.MaximumSize = new Size(420, 380);
                this.MinimumSize = new Size(420, 380);
                this.Size = new Size(420, 380);
                // これでオプション画面が閉じられているはず
                // ボタンテキスト変更
                this.Button_Option.Text = ("オプション ▼");
            }
            else
            {
                // IsOpenOptionはfalseだった = オプション閉じてる
                // 最大（最小）ウィンドウサイズを変更
                this.MaximumSize = new Size(420, 560);
                this.MinimumSize = new Size(420, 560);
                this.Size = new Size(420, 560);
                // これでオプション画面が開かれているはず
                // ボタンテキスト変更
                this.Button_Option.Text = ("オプション ▲");
            }
            // IsOpenOptionを反転
            IsOpenOption = !IsOpenOption;
            
        }

        private void Button_Convert_Click(object sender, EventArgs e)
        {
            // ヘッダ出力
            Converted += ("<!doctype html>\n<html>\n<head>\n<meta charset=\"utf-8\">\n");
            Converted += ("<title>" + this.TextBox_GroupName.Text + "</title>\n");
            Converted += ("<style type=\"text/css\">\n");
            Converted += (".edited {font-style: oblique;}\n");
            Converted += (".deleted {font-style: oblique;}\n");
            Converted += ("</style>\n</head>\n");
            Converted += ("<body>\n");
            Converted += ("<h1 class=\"groupname\">" + this.TextBox_GroupName.Text + " のチャットログ" + "</h1>\n");
            Convert();
            // フッタ出力
            Converted += ("</body>\n");
            Converted += ("</html>");
            // 書き込み
            try
            {
               // System.IO.StreamWriter Write = new System.IO.StreamWriter(DirectoryPath + "\\test.html", false);
               //  Write.Write(Converted);
               // Write.Close();
               System.IO.File.WriteAllText(DirectoryPath + "\\" + this.TextBox_GroupName.Text + ".html", Converted);
            }
            catch
            {
                MessageBox.Show("「参照...」をクリックして保存先を指定してください。"
                    , "Skype2HTML"
                    , MessageBoxButtons.OK
                    , MessageBoxIcon.Error);
            }
            Converting = "";
            ConvertAnalyze = "";
            ConvertAnalyze_Time = "";
            ConvertAnalyze_User = "";
            ConvertAnalyze_Text = "";
            Converted = "";

        }

        private void Convert()
        {
            // StreamReaderで読み込ませる
            System.IO.StringReader ConvertText = new System.IO.StringReader(this.TextBox_Convert_Text.Text);
            
            // 繰り返しぃぃぃぃぃぃぃぃ！
            while ((Converting = ConvertText.ReadLine()) != null)
            {

                // 変数にぶっこむ
                // Converting = ConvertText.ReadLine();

                // 空だったら
                if (Converting == "")
                {
                    continue;
                }
                if (!Regex.IsMatch(Converting, @"(\[\d\d\d\d.\d\d.\d\d\s\d\d:\d\d:\d\d\]|\[\d\d:\d\d:\d\d\]|\[\d:\d\d:\d\d\]|\[\d\d\d\d.\d\d.\d\d\s\d:\d\d:\d\d\])\s(.*):\s(.*)"))
                {
                    if (Regex.IsMatch(Converting, @"\[(.*)\s\|\s(.*)を編集しました\]\s(.*):\s(.*)"))
                    {
                        Regex editedrg = new Regex(@"\[(.*)\s\|\s(.*)を編集しました\]\s(.*):\s(.*)");
                        string[] EditedResult = editedrg.Split(Converting);

                        Converted += ("<p class=\"chat edited\"><span class=\"user\">" + EditedResult[3] + " : <span class=\"message\">" + EditedResult[4] + "</span>" + " - <span class=\"time\">[" + EditedResult[1] + "]の発言を[" + EditedResult[2] + "]に編集しました</span></p>\n");

                        continue;
                    }
                    if (Regex.IsMatch(Converting, @"\[(.*)\s\|\s(.*)を削除しました\]\s(.*):\s(.*)"))
                    {
                        Regex Deletedrg = new Regex(@"\[(.*)\s\|\s(.*)を削除しました\]\s(.*):\s(.*)");
                        string[] DeletedResult = Deletedrg.Split(Converting);

                        Converted += ("<p class=\"chat deleted\"><span class=\"user\">" + DeletedResult[3] + " : <span class=\"message\">" + DeletedResult[4] + "</span>" + " - <span class=\"time\">[" + DeletedResult[1] + "]の発言を[" + DeletedResult[2] + "]に削除しました</span></p>\n");

                        continue;
                    }
                    Converted += ("<p class=\"message\">" + Converting + "</p>\n");
                    continue;
                }
                else
                {
                    Regex rg = new Regex(@"(\[\d\d\d\d.\d\d.\d\d\s\d\d:\d\d:\d\d\]|\[\d\d:\d\d:\d\d\]|\[\d:\d\d:\d\d\]|\[\d\d\d\d.\d\d.\d\d\s\d:\d\d:\d\d\])\s(.*):\s(.*)");
                    //Regex.Split(Converting,);
                    string[] Result = rg.Split(Converting);
                    
                    Converted += ("<p class=\"chat\"><span class=\"time\">" + Result[1] + "</span> - <span class=\"user\">" + Result[2] + "</span> : <span class=\"message\">" + Result[3] + "</span></p>\n");
                    // Console.Write("<p>" + Result[1] + " - " + Result[2] + " : " + Result[3]);
                    continue;
                }
            }

            ConvertText.Close();
        }

        private void Button_Save_Directory_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.Description = "変換されたファイルを保存するフォルダーを選択してください。";
            fbd.RootFolder = Environment.SpecialFolder.Desktop;
            fbd.ShowNewFolderButton = true;
            if (fbd.ShowDialog(this) == DialogResult.OK)
            {
                DirectoryPath = fbd.SelectedPath;
                Label_Save_Directory_Path.Text = (DirectoryPath.Substring(0, 15) + "...");
            }
        }
    }
}
