/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ant;

import com.sun.tools.ant.Source;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Get;

public class FailSafeGetTask
extends Task {
    private File dest;
    private boolean usetimestamp;
    private final List sources = new ArrayList();

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setUsetimestamp(boolean usetimestamp) {
        this.usetimestamp = usetimestamp;
    }

    public void addConfiguredSource(Source src) {
        this.sources.add(src);
    }

    public void execute() throws BuildException {
        if (this.sources.size() == 0) {
            throw new BuildException("no source is specified");
        }
        if (this.dest == null) {
            throw new BuildException("Missing @dest");
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            Source source = (Source)this.sources.get(i);
            if (!source.isActive(this.getProject())) {
                this.log("Skipping " + source.getUrl(), 3);
                continue;
            }
            this.log("Trying " + source.getUrl(), 3);
            Get gettask = (Get)this.getProject().createTask("get");
            gettask.setDest(this.dest);
            gettask.setUseTimestamp(this.usetimestamp);
            gettask.setSrc(source.getUrl());
            try {
                gettask.perform();
                return;
            }
            catch (BuildException e) {
                this.log(source.getUrl() + " failed: " + e.getMessage(), 2);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.log(sw.toString(), 3);
            }
        }
        throw new BuildException("Every attempt to download to " + this.dest + " failed.");
    }
}

