/*
 * Decompiled with CFR 0.152.
 */
package com.sun.timer;

import com.sun.timer.Timer;
import java.math.BigInteger;
import sun.misc.Perf;

public class HighResTimer
extends Timer {
    private static final Perf p;
    private static final long divider;
    private static final BigInteger bi1000_1000_1000;
    private static final BigInteger biDivider;

    public long nanoTime() {
        if (divider != -1L) {
            return p.highResCounter() / divider;
        }
        return BigInteger.valueOf(p.highResCounter()).multiply(bi1000_1000_1000).divide(biDivider).longValue();
    }

    public String name() {
        return "JDK1.4.2 sun.misc.Perf";
    }

    static {
        bi1000_1000_1000 = BigInteger.valueOf(1000000000L);
        p = Perf.getPerf();
        long d = 1000000000L / p.highResFrequency();
        if (1000000000L == d * p.highResFrequency()) {
            divider = d;
            biDivider = null;
        } else {
            divider = -1L;
            biDivider = BigInteger.valueOf(p.highResFrequency());
        }
    }
}

