/*
 * @(#)$Id: JavaPackageDatatype.java,v 1.1 2002/11/02 22:30:21 kk122374 Exp $
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.relaxng.javadt;

import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

/**
 * Java Identifier as defined in
 * http://java.sun.com/docs/books/jls/second_edition/html/lexical.doc.html#40625
 * 
 * @author
 *  Kohsuke Kawaguchi (kohsuke.kawaguchi@sun.com)
 */
public class JavaPackageDatatype extends AbstractDatatypeImpl {

    public static final Datatype theInstance = new JavaPackageDatatype();
    
    private JavaPackageDatatype() {}

    public boolean isValid(String token, ValidationContext context) {
        return Name.isJavaPackageName(token.trim());
    }
}
