/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;

public class JobQueue {
    private static final int HIGH_THRESHOLD = 100;
    private static final int MEDIUM_THRESHOLD = 10;
    private static final int LOW_THRESHOLD = 1;
    private int mediumStart = 0;
    private int lowStart = 0;
    private LinkedList<Runnable> jobList = new LinkedList();
    private Random random = new Random();
    private Object jobWorkerThreadHolder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Priority priority, Runnable job) {
        if (job != null) {
            Object object;
            if (this.jobWorkerThreadHolder == null) {
                job.run();
            } else {
                object = this.jobList;
                synchronized (object) {
                    switch (priority) {
                        case HIGH: {
                            this.jobList.add(this.mediumStart, job);
                            ++this.mediumStart;
                            ++this.lowStart;
                            break;
                        }
                        case MEDIUM: {
                            this.jobList.add(this.lowStart, job);
                            ++this.lowStart;
                            break;
                        }
                        default: {
                            this.jobList.add(job);
                        }
                    }
                }
            }
            if (this.jobWorkerThreadHolder != null) {
                object = this.jobWorkerThreadHolder;
                synchronized (object) {
                    this.jobWorkerThreadHolder.notifyAll();
                }
            }
        }
    }

    public void addJob(Runnable job) {
        this.addJob(Priority.MEDIUM, job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable getJob() {
        if (this.jobList.isEmpty()) {
            return null;
        }
        int randomInt = this.random.nextInt(100);
        try {
            LinkedList<Runnable> linkedList = this.jobList;
            synchronized (linkedList) {
                int size = this.jobList.size();
                if (randomInt < 1 && size > this.lowStart) {
                    return this.jobList.remove(this.lowStart);
                }
                if (randomInt < 10 && size > this.mediumStart) {
                    --this.lowStart;
                    if (this.lowStart < 0) {
                        this.lowStart = 0;
                    }
                    return this.jobList.remove(this.mediumStart);
                }
                --this.mediumStart;
                if (this.mediumStart < 0) {
                    this.mediumStart = 0;
                }
                --this.lowStart;
                if (this.lowStart < 0) {
                    this.lowStart = 0;
                }
                return this.jobList.removeFirst();
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<Runnable> linkedList = this.jobList;
        synchronized (linkedList) {
            return this.jobList.isEmpty();
        }
    }

    public void setJobWorkerThread(Object threadHolder) {
        this.jobWorkerThreadHolder = threadHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<Runnable> linkedList = this.jobList;
        synchronized (linkedList) {
            return this.jobList.size();
        }
    }

    public static enum Priority {
        HIGH,
        MEDIUM,
        LOW;

    }
}

