/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.JobQueue;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobWorkerThread
extends Thread {
    protected volatile boolean isCanceled = false;
    private final Object threadHolder;
    private final JobQueue jobQueue;
    private ArrayList<JobWorkerThread> childThreads;
    private final ConcurrentLinkedQueue<Runnable> serializeQueue;
    private static final AtomicInteger threadNumber = new AtomicInteger();
    private final int threadsCount;
    private final boolean isParent;
    private final JobWorkerThread parent;
    private static final Logger logger = LoggerFactory.getLogger(JobWorkerThread.class);

    public JobWorkerThread(JobQueue jobQueue, ClientConfiguration configuration) {
        this(jobQueue, null, new Object(), configuration);
    }

    private JobWorkerThread(JobQueue jobQueue, JobWorkerThread parent, Object threadHolder, ClientConfiguration configuration) {
        super("jobworker-" + threadNumber.getAndIncrement());
        this.setDaemon(true);
        this.parent = parent;
        this.threadHolder = threadHolder;
        this.jobQueue = jobQueue;
        boolean bl = this.isParent = parent == null;
        if (this.isParent) {
            ClientProperties properties = configuration.getConfigProperties();
            this.threadsCount = properties.getInteger("core.jobqueue.threads");
            this.childThreads = new ArrayList();
            this.serializeQueue = new ConcurrentLinkedQueue();
        } else {
            this.threadsCount = parent.threadsCount;
            this.serializeQueue = parent.serializeQueue;
        }
    }

    public void cleanUp() {
        this.jobQueue.setJobWorkerThread(null);
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExitChildThread(JobWorkerThread jobWorkerThread) {
        ArrayList<JobWorkerThread> arrayList = this.childThreads;
        synchronized (arrayList) {
            this.childThreads.remove(jobWorkerThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object workerThread;
        if (this.isParent) {
            this.jobQueue.setJobWorkerThread(this.threadHolder);
            for (int i = 1; i < this.threadsCount; ++i) {
                workerThread = new JobWorkerThread(this.jobQueue, this, this.threadHolder, null);
                ArrayList<JobWorkerThread> arrayList = this.childThreads;
                synchronized (arrayList) {
                    this.childThreads.add((JobWorkerThread)workerThread);
                }
                ((Thread)workerThread).start();
            }
        }
        while (!this.isCanceled) {
            Runnable job = null;
            if (this.isParent) {
                job = this.serializeQueue.poll();
            }
            if (job == null) {
                job = this.jobQueue.getJob();
            }
            if (job == null) {
                workerThread = this.threadHolder;
                synchronized (workerThread) {
                    try {
                        if (!this.isCanceled) {
                            this.threadHolder.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.isParent || job instanceof ParallelRunnable) {
                try {
                    job.run();
                }
                catch (RuntimeException e) {
                    logger.warn("uncaught runtime-exception", (Throwable)e);
                }
                continue;
            }
            this.serializeQueue.add(job);
        }
        if (this.isParent) {
            Runnable job;
            while ((job = this.jobQueue.getJob()) != null) {
                try {
                    job.run();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.parent.onExitChildThread(this);
        }
        logger.debug(this.getName() + " exiting");
    }
}

