/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import jp.syuriken.snsw.twclient.StatusPanel;

public class SortedPostListPanel
extends JPanel {
    private static final long serialVersionUID = 5744052485948702454L;
    private final int leafSize;
    private final int maxContainSize;
    private LinkedList<JPanel> branches;
    private LinkedList<StatusPanel> firstBranch;
    private JPanel firstPanel;
    private int size;

    public static int compareDate(StatusPanel a, StatusPanel b) {
        return a.compareTo(b);
    }

    public SortedPostListPanel() {
        this(3200, 50);
    }

    public SortedPostListPanel(int leafSize, int maxSize) {
        this.setLayout(new BoxLayout(this, 1));
        this.leafSize = leafSize;
        this.maxContainSize = maxSize;
        this.branches = new LinkedList();
        this.firstBranch = new LinkedList();
        this.firstPanel = new JPanel();
        this.firstPanel.setLayout(new BoxLayout(this.firstPanel, 1));
        super.add((Component)this.firstPanel, 0);
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        if (comp instanceof StatusPanel) {
            LinkedList<StatusPanel> list = new LinkedList<StatusPanel>();
            list.add((StatusPanel)comp);
            this.add(comp);
            return comp;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Deprecated
    public Component add(Component comp, int index) {
        return this.add(comp);
    }

    @Override
    @Deprecated
    public void add(Component comp, Object constraints) {
        this.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.add(comp);
    }

    public synchronized void add(LinkedList<StatusPanel> values) {
        if (values.size() == 0) {
            return;
        }
        this.invalidate();
        Collections.sort(values, ComponentComparator.SINGLETON);
        ListIterator<StatusPanel> iterator = this.firstBranch.listIterator();
        while (iterator.hasNext() && !values.isEmpty()) {
            StatusPanel branchValue;
            StatusPanel value = values.peekFirst();
            if (SortedPostListPanel.compareDate(value, branchValue = (StatusPanel)iterator.next()) < 0) continue;
            this.firstPanel.add((Component)values.peekFirst(), iterator.previousIndex());
            iterator.previous();
            iterator.add(values.pollFirst());
            ++this.size;
            this.firstPanel.invalidate();
        }
        if (this.branches.isEmpty()) {
            while (!values.isEmpty()) {
                this.firstBranch.addLast(values.peekFirst());
                this.firstPanel.add(values.pollFirst());
                ++this.size;
            }
        } else {
            ListIterator listIterator = this.branches.listIterator();
            while (listIterator.hasNext() && !values.isEmpty()) {
                JPanel branch = (JPanel)listIterator.next();
                Component lastOfBranch = branch.getComponent(branch.getComponentCount() - 1);
                while (SortedPostListPanel.compareDate(values.peekFirst(), (StatusPanel)lastOfBranch) >= 0) {
                    Component[] newBranch = Arrays.copyOf(branch.getComponents(), branch.getComponentCount() + 1);
                    newBranch[newBranch.length - 1] = values.pollFirst();
                    Arrays.sort(newBranch, ComponentComparator.SINGLETON);
                    branch.removeAll();
                    for (Component component : newBranch) {
                        branch.add(component);
                    }
                    branch.invalidate();
                    ++this.size;
                }
            }
            if (!values.isEmpty()) {
                JPanel branch = this.branches.getLast();
                Component[] newBranch = Arrays.copyOf(branch.getComponents(), branch.getComponentCount() + values.size());
                int i = 1;
                while (!values.isEmpty()) {
                    newBranch[newBranch.length - i] = values.pollFirst();
                    ++this.size;
                    ++i;
                }
                Arrays.sort(newBranch, ComponentComparator.SINGLETON);
                int branchSize = newBranch.length;
                int offset = 0;
                if (branchSize > this.leafSize * 2) {
                    int i2;
                    JPanel panel;
                    this.branches.removeLast();
                    this.remove(this.getComponentCount() - 1);
                    while (branchSize > offset + this.leafSize * 2) {
                        panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        for (i2 = 0; i2 < this.leafSize; ++i2) {
                            panel.add(newBranch[offset + i2]);
                        }
                        offset += this.leafSize;
                        this.branches.addLast(panel);
                        super.add(panel);
                    }
                    panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    for (i2 = offset; i2 < branchSize; ++i2) {
                        panel.add(newBranch[i2]);
                    }
                    this.branches.addLast(panel);
                    super.add(panel);
                } else {
                    branch.removeAll();
                    for (Component component : newBranch) {
                        branch.add(component);
                    }
                    branch.invalidate();
                }
            }
        }
        if (values.size() != 0) {
            throw new AssertionError();
        }
        this.splitFirstBranch();
        this.tryRelease();
        this.validate();
    }

    public void add(StatusPanel panel) {
        LinkedList<StatusPanel> list = new LinkedList<StatusPanel>();
        list.add(panel);
        this.add(list);
    }

    @Override
    public Component add(String name, Component comp) {
        return this.add(comp);
    }

    public synchronized Rectangle getBoundsOf(StatusPanel panel) {
        Rectangle bounds = panel.getBounds();
        if (SortedPostListPanel.compareDate(panel, this.firstBranch.peekLast()) >= 0) {
            Rectangle branchBounds = this.firstPanel.getBounds();
            bounds.y += branchBounds.y;
        } else {
            for (JPanel branch : this.branches) {
                StatusPanel lastComponent = (StatusPanel)branch.getComponent(branch.getComponentCount() - 1);
                if (SortedPostListPanel.compareDate(panel, lastComponent) < 0) continue;
                Rectangle branchBounds = branch.getBounds();
                bounds.y += branchBounds.y;
                break;
            }
        }
        return bounds;
    }

    @Override
    public StatusPanel getComponentAt(int x, int y) {
        JPanel componentAt = (JPanel)super.getComponentAt(x, y);
        Point bounds = componentAt.getLocation();
        return (StatusPanel)componentAt.getComponentAt(x - bounds.x, y - bounds.y);
    }

    public synchronized boolean remove(StatusPanel value) {
        if (SortedPostListPanel.compareDate(this.firstBranch.peekLast(), value) < 0) {
            this.firstBranch.remove(value);
            this.firstPanel.remove(value);
            this.firstPanel.invalidate();
            --this.size;
            return true;
        }
        for (JPanel container : this.branches) {
            if (SortedPostListPanel.compareDate((StatusPanel)container.getComponent(container.getComponentCount() - 1), value) >= 0) continue;
            container.remove(value);
            container.invalidate();
            --this.size;
            return true;
        }
        return false;
    }

    public synchronized boolean requestFocusFirstComponent() {
        StatusPanel panel = this.firstBranch.getFirst();
        if (panel == null) {
            panel = (StatusPanel)this.branches.getFirst().getComponent(0);
        }
        if (panel == null) {
            return false;
        }
        return panel.requestFocusInWindow();
    }

    public synchronized boolean requestFocusNextOf(StatusPanel panel) {
        int comparison = SortedPostListPanel.compareDate(panel, this.firstBranch.getLast());
        if (comparison > 0) {
            int indexOf = this.firstBranch.indexOf(panel);
            if (indexOf < 0) {
                return false;
            }
            return this.firstBranch.get(indexOf + 1).requestFocusInWindow();
        }
        ListIterator iterator = this.branches.listIterator();
        while (iterator.hasNext()) {
            JPanel next = (JPanel)iterator.next();
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)next.getComponent(0)) > 0) {
                return next.getComponent(0).requestFocusInWindow();
            }
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)next.getComponent(next.getComponentCount() - 1)) <= 0) continue;
            Component[] components = next.getComponents();
            for (int i = 0; i < components.length - 1; ++i) {
                StatusPanel statusPanel = (StatusPanel)components[i];
                if (SortedPostListPanel.compareDate(panel, statusPanel) != 0) continue;
                return components[i + 1].requestFocusInWindow();
            }
        }
        return false;
    }

    public synchronized boolean requestFocusPreviousOf(StatusPanel panel) {
        ListIterator<JPanel> iterator = this.branches.listIterator(this.branches.size());
        while (iterator.hasPrevious()) {
            JPanel previous = iterator.previous();
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)previous.getComponent(previous.getComponentCount() - 1)) < 0) {
                return previous.getComponent(previous.getComponentCount() - 1).requestFocusInWindow();
            }
            if (SortedPostListPanel.compareDate(panel, (StatusPanel)previous.getComponent(0)) >= 0) continue;
            Component[] components = previous.getComponents();
            for (int i = components.length - 1; i > 0; --i) {
                StatusPanel statusPanel = (StatusPanel)components[i];
                if (SortedPostListPanel.compareDate(panel, statusPanel) != 0) continue;
                return components[i - 1].requestFocusInWindow();
            }
        }
        if (SortedPostListPanel.compareDate(panel, this.firstBranch.peekLast()) < 0) {
            return this.firstBranch.peekLast().requestFocusInWindow();
        }
        int indexOf = this.firstBranch.indexOf(panel);
        if (indexOf <= 0) {
            return false;
        }
        return this.firstBranch.get(indexOf - 1).requestFocusInWindow();
    }

    private synchronized void splitFirstBranch() {
        while (this.firstBranch.size() > this.leafSize << 1) {
            ListIterator<StatusPanel> li = this.firstBranch.listIterator(this.firstBranch.size());
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            for (int i = this.leafSize - 1; i >= 0; --i) {
                panel.add((Component)li.previous(), 0);
                li.remove();
            }
            this.branches.addFirst(panel);
            super.add((Component)panel, 1);
        }
    }

    @Override
    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SortedPostListPanel{leaf=").append(this.leafSize).append(",max=").append(this.maxContainSize).append(",size=").append(this.size);
        stringBuilder.append("}[").append(this.firstBranch.size()).append(", ");
        for (JPanel container : this.branches) {
            stringBuilder.append(container.getComponentCount()).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private synchronized void tryRelease() {
        while (this.size > this.maxContainSize + this.leafSize) {
            this.remove(this.getComponentCount() - 1);
            this.size -= this.branches.removeLast().getComponentCount();
        }
    }

    public static final class ComponentComparator
    implements Comparator<Component>,
    Serializable {
        private static final long serialVersionUID = 5164218366463800406L;
        public static final ComponentComparator SINGLETON = new ComponentComparator();

        private ComponentComparator() {
        }

        @Override
        public int compare(Component o1, Component o2) {
            if (o1 instanceof StatusPanel && o2 instanceof StatusPanel) {
                return -SortedPostListPanel.compareDate((StatusPanel)o1, (StatusPanel)o2);
            }
            throw new IllegalArgumentException("SortedPostListPanel\u306b\u8ffd\u52a0\u3067\u304d\u308b\u30b3\u30f3\u30dd\u30fc\u30cd\u30f3\u30c8\u306fStatusPanel\u3060\u3051\u3067\u3059\u3002");
        }
    }
}

