/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Scanner;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.filter.FilterDispatcherBase;
import jp.syuriken.snsw.twclient.filter.FilterFunction;
import jp.syuriken.snsw.twclient.filter.FilterProperty;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.tokenizer.FilterParser;
import jp.syuriken.snsw.twclient.filter.tokenizer.FilterParserVisitor;
import jp.syuriken.snsw.twclient.filter.tokenizer.ParseException;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenFunction;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenProperty;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenPropertyOperator;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenPropertyValue;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenQuery;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenStart;
import jp.syuriken.snsw.twclient.filter.tokenizer.SimpleNode;
import jp.syuriken.snsw.twclient.filter.tokenizer.TokenMgrError;

public class FilterCompiler
implements FilterParserVisitor {
    protected static final HashMap<String, Constructor<? extends FilterFunction>> filterFunctionFactories = new HashMap();
    protected static final HashMap<String, Constructor<? extends FilterProperty>> filterPropertyFactories = new HashMap();
    private ClientConfiguration configuration;

    public static FilterDispatcherBase getCompiledObject(ClientConfiguration configuration, String query) throws IllegalSyntaxException {
        FilterCompiler filterCompiler = new FilterCompiler(configuration);
        try {
            return (FilterDispatcherBase)FilterCompiler.tokenize(query).jjtAccept((FilterParserVisitor)filterCompiler, null);
        }
        catch (TokenMgrError e) {
            throw new IllegalSyntaxException(e.getLocalizedMessage(), e);
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalSyntaxException) {
                throw (IllegalSyntaxException)cause;
            }
            throw e;
        }
        catch (ParseException e) {
            throw new IllegalSyntaxException(e.getLocalizedMessage(), e);
        }
    }

    public static Constructor<? extends FilterFunction> getFilterFunction(String functionName) {
        return filterFunctionFactories.get(functionName);
    }

    public static Constructor<? extends FilterProperty> getFilterProperty(String propertyName) {
        return filterPropertyFactories.get(propertyName);
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());
        System.out.print("> ");
        while (scanner.hasNextLine()) {
            String query = scanner.nextLine();
            try {
                FilterCompiler.tokenize(query).dump("");
                FilterCompiler.getCompiledObject(null, query);
            }
            catch (IllegalSyntaxException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            System.out.print("> ");
        }
    }

    public static Constructor<? extends FilterFunction> putFilterFunction(String functionName, Constructor<? extends FilterFunction> constructor) {
        return filterFunctionFactories.put(functionName, constructor);
    }

    public static Constructor<? extends FilterProperty> putFilterProperty(String propertyName, Constructor<? extends FilterProperty> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes[0] == ClientConfiguration.class && parameterTypes[1] == String.class && parameterTypes[2] == String.class && parameterTypes[3] == Object.class) {
            return filterPropertyFactories.put(propertyName, constructor);
        }
        throw new IllegalArgumentException("FilterProperty's constructor must be (ClientConfiguration, String, String, Object)");
    }

    public static QueryTokenStart tokenize(String query) throws ParseException {
        FilterParser filterParser = new FilterParser((Reader)new StringReader(query));
        return filterParser.Start();
    }

    private FilterCompiler(ClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public Object visit(QueryTokenFunction node, Object data) {
        int childrenCount = node.jjtGetNumChildren();
        String functionName = (String)node.jjtGetValue();
        Constructor<? extends FilterFunction> factory = filterFunctionFactories.get(functionName);
        if (factory == null) {
            throw new WrappedException(new IllegalSyntaxException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: function<" + functionName + ">\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093"));
        }
        FilterDispatcherBase[] args = new FilterDispatcherBase[childrenCount];
        for (int i = 0; i < childrenCount; ++i) {
            args[i] = (FilterDispatcherBase)node.jjtGetChild(i).jjtAccept((FilterParserVisitor)this, data);
        }
        try {
            return factory.newInstance(functionName, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new WrappedException(cause);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: function<" + functionName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: function<" + functionName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: function<" + functionName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
    }

    public Object visit(QueryTokenProperty node, Object data) {
        PropertyData propertyData = new PropertyData();
        String propertyName = (String)node.jjtGetValue();
        Constructor<? extends FilterProperty> factory = FilterCompiler.getFilterProperty(propertyName);
        if (factory == null) {
            throw new WrappedException(new IllegalSyntaxException("\u30d7\u30ed\u30d1\u30c6\u30a3<" + propertyName + ">\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002"));
        }
        node.childrenAccept((FilterParserVisitor)this, (Object)propertyData);
        String propertyOperator = propertyData.operator;
        Object value = propertyData.value;
        try {
            return factory.newInstance(this.configuration, propertyName, propertyOperator, value);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new WrappedException(cause);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: property<" + propertyName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: property<" + propertyName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u30d5\u30a3\u30eb\u30bf\u306e\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: property<" + propertyName + ">\u306b\u95a2\u9023\u4ed8\u3051\u3089\u308c\u305fConstructor\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093", e);
        }
    }

    public String visit(QueryTokenPropertyOperator node, Object data) {
        String operator;
        PropertyData propertyData = (PropertyData)data;
        propertyData.operator = operator = (String)node.jjtGetValue();
        return operator;
    }

    public Object visit(QueryTokenPropertyValue node, Object data) {
        Comparable<Boolean> value;
        PropertyData propertyData = (PropertyData)data;
        String valueStr = (String)node.jjtGetValue();
        if (valueStr.startsWith("\"")) {
            StringBuilder str = new StringBuilder(valueStr.substring(1, valueStr.length() - 1));
            int index = 0;
            while ((index = str.indexOf("\\", index)) != -1) {
                str.deleteCharAt(index);
                index += 2;
            }
            value = str.toString();
        } else {
            value = valueStr.equals("true") ? Boolean.TRUE : (valueStr.equals("false") ? (Comparable<Boolean>)Boolean.FALSE : (Comparable<Boolean>)Long.valueOf(valueStr));
        }
        propertyData.value = value;
        return value;
    }

    public FilterDispatcherBase visit(QueryTokenQuery node, Object data) {
        return (FilterDispatcherBase)node.jjtGetChild(0).jjtAccept((FilterParserVisitor)this, data);
    }

    public FilterDispatcherBase visit(QueryTokenStart node, Object data) {
        return (FilterDispatcherBase)node.jjtGetChild(0).jjtAccept((FilterParserVisitor)this, data);
    }

    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    public static class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable exception) {
            super(exception);
        }
    }

    protected static class PropertyData {
        protected String operator;
        protected Object value;

        protected PropertyData() {
        }
    }
}

