/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;

public enum FilterOperator {
    EQ,
    NE,
    LT,
    LTE,
    GT,
    GTE,
    IS,
    IS_NOT;


    public static FilterOperator compileOperatorBool(String operator) {
        if (operator == null) {
            return IS;
        }
        switch (operator) {
            case ":": 
            case "=": 
            case "==": {
                return EQ;
            }
            case "!=": 
            case "!:": {
                return NE;
            }
            case "?": {
                return IS;
            }
            case "!": 
            case "!?": {
                return IS_NOT;
            }
        }
        return null;
    }

    public static FilterOperator compileOperatorInt(String operator) {
        switch (operator) {
            case ":": 
            case "=": 
            case "==": {
                return EQ;
            }
            case "!": 
            case "!=": 
            case "!:": {
                return NE;
            }
            case ">": {
                return GT;
            }
            case ">=": {
                return GTE;
            }
            case "<": {
                return LT;
            }
            case "<=": {
                return LTE;
            }
        }
        return null;
    }

    public static FilterOperator compileOperatorString(String operator) {
        switch (operator) {
            case ":": 
            case "=": 
            case "==": {
                return EQ;
            }
            case "!": 
            case "!=": 
            case "!:": {
                return NE;
            }
        }
        return null;
    }

    public static Object compileValueString(String value) throws IllegalSyntaxException {
        if (value == null) {
            throw new IllegalSyntaxException("string\u6f14\u7b97\u5b50\u306b\u306f\u5024\u304c\u5fc5\u8981\u3067\u3059");
        }
        if (value.length() >= 1 && value.charAt(0) == '/') {
            return Pattern.compile(value.substring(1));
        }
        return value;
    }

    public boolean compare(boolean target, boolean value) throws RuntimeException {
        switch (this) {
            case IS: {
                return target;
            }
            case IS_NOT: {
                return !target;
            }
            case EQ: {
                return target == value;
            }
            case NE: {
                return target != value;
            }
        }
        throw new RuntimeException("bool\u3067\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u6f14\u7b97\u5b50\u3067\u3059");
    }

    public boolean compare(long a, long b) throws RuntimeException {
        switch (this) {
            case EQ: {
                return a == b;
            }
            case NE: {
                return a != b;
            }
            case LT: {
                return a < b;
            }
            case LTE: {
                return a <= b;
            }
            case GT: {
                return a > b;
            }
            case GTE: {
                return a >= b;
            }
        }
        throw new RuntimeException("long\u306e\u6bd4\u8f03\u3067\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u6f14\u7b97\u5b50\u3067\u3059");
    }

    public boolean compare(String target, Object value) throws RuntimeException {
        if (this == EQ || this == NE) {
            if (value instanceof Pattern) {
                Matcher matcher = ((Pattern)value).matcher(target);
                return matcher.find() == (this == EQ);
            }
            if (value instanceof String) {
                String str = (String)value;
                int len = str.length();
                boolean contains = len > 0 && str.charAt(0) == '*' ? (str.charAt(len - 1) == '*' ? target.contains(str.substring(1, len - 1)) : target.endsWith(str.substring(1))) : (len > 0 && str.charAt(len - 1) == '*' ? target.startsWith(str.substring(0, len - 1)) : target.equals(str));
                return contains == (this == EQ);
            }
            throw new RuntimeException("string\u306e\u88ab\u6bd4\u8f03\u5024\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093");
        }
        throw new RuntimeException("string\u306e\u6bd4\u8f03\u3067\u306f\u5bfe\u5fdc\u3057\u3066\u3044\u306a\u3044\u6f14\u7b97\u5b50\u3067\u3059");
    }

    public boolean compileValueBool(String propName, String value) throws IllegalSyntaxException {
        switch (this) {
            case IS: 
            case IS_NOT: {
                if (value == null) {
                    return false;
                }
                throw new IllegalSyntaxException("[" + propName + "] \u5024\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u305b\u3093");
            }
            case EQ: 
            case NE: {
                String lowerValue;
                switch (lowerValue = value.toLowerCase(Locale.ENGLISH)) {
                    case "false": 
                    case "no": {
                        return false;
                    }
                    case "true": 
                    case "yes": {
                        return true;
                    }
                }
                throw new IllegalSyntaxException("[" + propName + "] \u5024\u304cbool\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
        }
        throw new IllegalSyntaxException("[" + propName + "] \u6b63\u3057\u304f\u306a\u3044bool\u6f14\u7b97\u5b50\u3067\u3059");
    }
}

