/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.TabRenderer;
import jp.syuriken.snsw.twclient.filter.FilterCompiler;
import jp.syuriken.snsw.twclient.filter.FilterDispatcherBase;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.filter.NullFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;

public class TeeFilter
implements TabRenderer,
PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(TeeFilter.class);
    private final String filterPropertyName;
    private final ClientProperties configProperties;
    private FilterDispatcherBase filterQuery;
    private TabRenderer renderer;
    private ClientConfiguration configuration;

    public TeeFilter(ClientConfiguration configuration, String uniqId, TabRenderer tabRenderer) throws IllegalSyntaxException {
        this.configuration = configuration;
        this.renderer = tabRenderer;
        this.configProperties = configuration.getConfigProperties();
        this.filterPropertyName = "core.filter._tabs." + uniqId;
        this.init();
        this.configProperties.addPropertyChangedListener(this);
    }

    protected void init() throws IllegalSyntaxException {
        String filterQueryString = this.configProperties.getProperty(this.filterPropertyName);
        this.filterQuery = filterQueryString == null || filterQueryString.trim().isEmpty() ? NullFilter.getInstance() : FilterCompiler.getCompiledObject(this.configuration, filterQueryString);
    }

    public void onBlock(User source, User blockedUser) {
        this.renderer.onBlock(source, blockedUser);
    }

    @Override
    public void onChangeAccount(boolean forWrite) {
        this.renderer.onChangeAccount(forWrite);
    }

    public void onCleanUp() {
        this.renderer.onCleanUp();
    }

    @Override
    public void onClientMessage(String name, Object arg) {
        this.renderer.onClientMessage(name, arg);
    }

    public void onConnect() {
        this.renderer.onConnect();
    }

    public void onDeletionNotice(long directMessageId, long userId) {
        this.renderer.onDeletionNotice(directMessageId, userId);
    }

    public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        this.renderer.onDeletionNotice(statusDeletionNotice);
    }

    public void onDirectMessage(DirectMessage directMessage) {
        if (!this.filterQuery.filter(directMessage)) {
            this.renderer.onDirectMessage(directMessage);
        }
    }

    public void onDisconnect() {
        this.renderer.onDisconnect();
    }

    public void onException(Exception ex) {
        this.renderer.onException(ex);
    }

    public void onFavorite(User source, User target, Status favoritedStatus) {
        if (!this.filterQuery.filter(favoritedStatus)) {
            this.renderer.onFavorite(source, target, favoritedStatus);
        }
    }

    public void onFollow(User source, User followedUser) {
        this.renderer.onFollow(source, followedUser);
    }

    public void onFriendList(long[] friendIds) {
        this.renderer.onFriendList(friendIds);
    }

    public void onScrubGeo(long userId, long upToStatusId) {
        this.renderer.onScrubGeo(userId, upToStatusId);
    }

    public void onStallWarning(StallWarning warning) {
        this.renderer.onStallWarning(warning);
    }

    public void onStatus(Status status) {
        if (!this.filterQuery.filter(status)) {
            this.renderer.onStatus(status);
        }
    }

    public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
        this.renderer.onTrackLimitationNotice(numberOfLimitedStatuses);
    }

    public void onUnblock(User source, User unblockedUser) {
        this.renderer.onUnblock(source, unblockedUser);
    }

    public void onUnfavorite(User source, User target, Status unfavoritedStatus) {
        if (!this.filterQuery.filter(unfavoritedStatus)) {
            this.renderer.onUnfavorite(source, target, unfavoritedStatus);
        }
    }

    public void onUserListCreation(User listOwner, UserList list) {
        this.renderer.onUserListCreation(listOwner, list);
    }

    public void onUserListDeletion(User listOwner, UserList list) {
        this.renderer.onUserListDeletion(listOwner, list);
    }

    public void onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        this.renderer.onUserListMemberAddition(addedMember, listOwner, list);
    }

    public void onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        this.renderer.onUserListMemberDeletion(deletedMember, listOwner, list);
    }

    public void onUserListSubscription(User subscriber, User listOwner, UserList list) {
        this.renderer.onUserListSubscription(subscriber, listOwner, list);
    }

    public void onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        this.renderer.onUserListUnsubscription(subscriber, listOwner, list);
    }

    public void onUserListUpdate(User listOwner, UserList list) {
        this.renderer.onUserListUpdate(listOwner, list);
    }

    public void onUserProfileUpdate(User updatedUser) {
        this.renderer.onUserProfileUpdate(updatedUser);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals(this.filterPropertyName)) {
            try {
                this.init();
            }
            catch (IllegalSyntaxException e) {
                logger.warn("\u6b63\u3057\u304f\u306a\u3044\u6587\u6cd5\u306e\u305f\u3081\u30d5\u30a3\u30eb\u30bf\u3092\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093: " + propertyName, (Throwable)e);
            }
        }
    }
}

