/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import java.io.File;
import java.io.IOException;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.MessageNotifier;
import jp.syuriken.snsw.twclient.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifySendMessageNotifier
implements MessageNotifier {
    private static final Logger logger = LoggerFactory.getLogger(NotifySendMessageNotifier.class);

    public static boolean checkUsable(ClientConfiguration configuration) {
        if (Utility.getOstype() == Utility.OSType.OTHER) {
            try {
                if (Runtime.getRuntime().exec(new String[]{"which", "notify-send"}).waitFor() == 0) {
                    return true;
                }
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
                logger.warn("#detectNotifier: which\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557", (Throwable)e);
            }
        }
        return false;
    }

    public NotifySendMessageNotifier(ClientConfiguration configuration) {
    }

    @Override
    public void sendNotify(String summary, String text, File imageFile) throws IOException {
        if (imageFile == null) {
            Runtime.getRuntime().exec(new String[]{"notify-send", summary, text});
        } else {
            Runtime.getRuntime().exec(new String[]{"notify-send", "-i", imageFile.getPath(), summary, text});
        }
    }
}

