/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.jni;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.MessageNotifier;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.jni.JavaGnome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibnotifyMessageNotifier
implements MessageNotifier {
    private static final Logger logger = LoggerFactory.getLogger(LibnotifyMessageNotifier.class);
    private final Class<?> notificationClass;

    public static final boolean checkUsable(ClientConfiguration configuration) {
        boolean disable = Boolean.getBoolean("elnetw.java-gnome.disable");
        if (disable) {
            logger.info("Skip java-gnome notify system");
            return false;
        }
        if (Utility.getOstype() == Utility.OSType.OTHER) {
            ClassLoader extraClassLoader = configuration.getExtraClassLoader();
            JavaGnome javaGnome = JavaGnome.getInstance(configuration);
            if (!javaGnome.isFound()) {
                return false;
            }
            try {
                Class<?> notifyClass;
                Boolean isNotifyInitialized;
                logger.info("detected java-gnome. version:{}", (Object)javaGnome.getVersion());
                Class<?> gtkClass = Class.forName("org.gnome.gtk.Gtk", true, extraClassLoader);
                Boolean isGtkInitialized = (Boolean)gtkClass.getMethod("isInitialized", new Class[0]).invoke(null, new Object[0]);
                if (!isGtkInitialized.booleanValue()) {
                    gtkClass.getMethod("init", String[].class).invoke(null, new Object[]{new String[0]});
                }
                if (!(isNotifyInitialized = (Boolean)(notifyClass = Class.forName("org.gnome.notify.Notify", true, extraClassLoader)).getMethod("isInitialized", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    notifyClass.getMethod("init", String.class).invoke(null, "elnetw");
                }
                Object serverCapabilities = notifyClass.getMethod("getServerCapabilities", new Class[0]).invoke(null, new Object[0]);
                logger.info("connected notification server. caps:{}", serverCapabilities);
                return true;
            }
            catch (ClassNotFoundException e) {
                logger.trace("java-gnome is partial found...", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.warn("#checkUsable", e.getCause());
            }
            catch (NoSuchMethodException e) {
                logger.warn("#checkUsable", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("#checkUsable", (Throwable)e);
            }
        }
        return false;
    }

    public LibnotifyMessageNotifier(ClientConfiguration configuration) {
        try {
            this.notificationClass = Class.forName("org.gnome.notify.Notification", true, configuration.getExtraClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendNotify(String summary, String text, File imageFile) throws IOException {
        try {
            Constructor<?> constructor = this.notificationClass.getConstructor(String.class, String.class, String.class);
            String imageFilePath = imageFile == null ? null : imageFile.getCanonicalPath();
            Object notification = constructor.newInstance(summary, text, imageFilePath);
            this.notificationClass.getMethod("show", new Class[0]).invoke(notification, new Object[0]);
        }
        catch (InstantiationException e) {
            logger.error("#sendNotify", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("#sendNotify", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("#sendNotify", e.getCause());
        }
        catch (NoSuchMethodException e) {
            logger.error("#sendNotify", (Throwable)e);
        }
    }
}

