/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;

public class Stopwatch {
    private Date startedDate = new Date();
    private Date stopedDate = new Date();
    private final JLabel out;
    private static String FMT1 = "s\u79d2SSS\u30df\u30ea";
    private static String FMT2 = "m\u5206ss\u79d2SSS\u30df\u30ea";
    private static String FMT3 = "H\u6642\u9593mm\u5206ss\u79d2SSS\u30df\u30ea";
    private static long LONG_MINUIT = 60000L;
    private static long LONG_HOUR = 60L * LONG_MINUIT;

    public synchronized void start() {
        this.startedDate = new Date();
    }

    public synchronized void stop() {
        this.stopedDate = new Date();
    }

    public Stopwatch(JLabel out) {
        this.out = out;
    }

    public static void setup(JLabel display) {
    }

    private boolean isSetup() {
        return this.out != null;
    }

    public JLabel getSource() {
        return this.out;
    }

    public synchronized void clear() {
        if (this.isSetup()) {
            this.out.setText(" ");
        }
    }

    private long getStartTime() {
        return this.startedDate.getTime();
    }

    private long getStopTime() {
        return this.stopedDate.getTime();
    }

    private long getElapsedTime() {
        return new Date().getTime() - this.getStartTime();
    }

    private static synchronized String format(long time) {
        Date date = new Date(time);
        if (time < 0L) {
            return "";
        }
        if (time < LONG_MINUIT) {
            return new SimpleDateFormat(FMT1).format(date);
        }
        if (time < LONG_HOUR) {
            return new SimpleDateFormat(FMT2).format(date);
        }
        return new SimpleDateFormat(FMT3).format(date);
    }

    public String formatElapsedTime() {
        return Stopwatch.format(this.getElapsedTime());
    }

    public void show() {
        if (this.isSetup()) {
            this.out.setText("\u7d4c\u904e\u6642\u9593\u3000" + this.formatElapsedTime());
        }
    }

    public String formatLatency() {
        return Stopwatch.format(this.getStopTime() - this.getStartTime());
    }
}

