﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU Lesser General Public License(LGPL ver3).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace DotNetEx.CustomControls
{
    //! @addtogroup DotNetEx-CustomControls名前空間
    //! @{

    //! @brief Control.Tagプロパティのボックス化／解除ラッピングクラス
    //! @details Control.Tagプロパティの任意の型へのボックス解除に失敗、あるいはTagがnullである場合、型の既定値（値型ならゼロ、参照型ならnull）を返すようになります。
    //! InvalidCastExceptionのもみ消しと、型の明示を目的としたクラスです。
    public struct TagHandler<ValueType>
    {
        public TagHandler(System.Windows.Forms.Control ctrl) { m_ctrl = ctrl; }
        public ValueType Tag
        {
            get {
                if ((m_ctrl != null) && (m_ctrl.Tag != null))
                {
                    try { return (ValueType)m_ctrl.Tag; }
                    catch (System.InvalidCastException) { } // kill unbox error
                }
                return default(ValueType);
            }
            set { if (m_ctrl != null) m_ctrl.Tag = value; }
        }
        private readonly System.Windows.Forms.Control m_ctrl;
    }

	//! @brief System::Windows::Forms::Panelを継承してダブルバッファリングを有効にしたクラス
	public class PaintPanel : System.Windows.Forms.Panel
	{
		public PaintPanel() {
			SetStyle(System.Windows.Forms.ControlStyles.DoubleBuffer, true);
			SetStyle(System.Windows.Forms.ControlStyles.UserPaint, true);
			SetStyle(System.Windows.Forms.ControlStyles.AllPaintingInWmPaint, true);
		}
	}

    //! @brief System.Windows.Forms.Buttonを継承して、選択枠が表示されないようにしたコマンドボタンクラス
    public class StyleNonSelectableButton : System.Windows.Forms.Button
    {
        public StyleNonSelectableButton() { SetStyle(System.Windows.Forms.ControlStyles.Selectable, false);  }
    }

    //! @}
}
