/*
First author tiritomato 2013.

mqsdx is distributed under the GNU Lesser General Public License 3.0(LGPLv3).

support blog (Japanese only)
http://d.hatena.ne.jp/tiri_tomato/
*/

#include "../MQ0x.hpp"

#ifdef __cplusplus_cli
#pragma unmanaged
#endif

namespace MQ0x {

	static const long double long_double_pi = 4.0L * std::atan(1.0L);
	template <> long double Math::Pi() { return long_double_pi; }
	/*
	namespace Polygon {
		UVFaceBuffer::Face::Buffer::IndexBuffer::size_type UVFaceBuffer::Edge::OwnerRegist( const Face::Buffer::Index regist_face_index ) {
			UVFaceBuffer::Face::Buffer::IndexBuffer::size_type ret;
			if ( OwnersContains( regist_face_index, &ret ) == false ) {
				ret = m_owner_faces.size();
				m_owner_faces.push_back(regist_face_index);
			}
			return ret;
		}
	}
	*/
	/*
	uv_faces::edge::ownertriangle_indexbuffer_type::size_type uv_faces::edge::owner_regist( const triangle::buffer_type::size_type regist_index ) {
		ownertriangle_indexbuffer_type::size_type ret;
		if ( owner_contains( regist_index, &ret ) == false ) {
			ret = m_owner_triangles.size();
			m_owner_triangles.push_back(regist_index);
		}
		return ret;
	}

	bool uv_faces::uv_buffer_contains( const MQCoordinate& src, uv_buffer_type::size_type* find_index ) const {
		for ( uv_buffer_type::size_type index = 0; index < m_uv_buffer.size(); index++ ) {
			if ( (std::abs(m_uv_buffer[index].u - src.u) < epsilon()) && (std::abs(m_uv_buffer[index].v - src.v) < epsilon()) ) {
				if ( find_index != NULL ) *find_index = index; return true;
			}
		}
		return false;
	}

	uv_faces::uv_buffer_type::size_type uv_faces::uv_buffer_add( const MQCoordinate& item ) {
		uv_buffer_type::size_type ret;
		if ( uv_buffer_contains( item, &ret ) == false ) {
			ret = m_uv_buffer.size();
			m_uv_buffer.push_back( item );
		}
		return ret;
	}*/
	
	SettingProxy::SettingProxy( Handle handle ) : m_plugin( handle.plugin ), m_setting(NULL) {
		if ( m_plugin != NULL ) m_setting = m_plugin->OpenSetting();
	}
	void SettingProxy::Close() {
		if ( m_plugin != NULL && m_setting != NULL ) m_plugin->CloseSetting(m_setting);
		m_plugin = NULL;
		m_setting = NULL;
	}

	template <typename T> inline bool MQSettingLoad( MQSetting* setting, const char* name, T& value, T default_value ) {
		if ( setting == NULL ) return false;
		setting->Load( name, value, default_value );
		return true;
	}
	bool SettingProxy::Load( const char *name, bool& value, bool default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, int& value, int default_value) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, unsigned int& value, unsigned int default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, float& value, float default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}
	bool SettingProxy::Load(const char *name, std::string& value, std::string default_value ) {
		return MQSettingLoad( m_setting, name, value, default_value );
	}

	template <typename T> inline bool MQSettingSave( MQSetting* setting, const char* name, const T& value ) {
		if ( setting == NULL ) return false;
		setting->Save( name, value );
		return true;
	}
	bool SettingProxy::Save(const char *name, const bool& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const int& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const unsigned int& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const float& value) { return MQSettingSave( m_setting, name, value ); }
	bool SettingProxy::Save(const char *name, const char* value) { return MQSettingSave( m_setting, name, std::string(value) ); }
	bool SettingProxy::Save(const char *name, const std::string& value) { return MQSettingSave( m_setting, name, value ); }

}

#ifdef __cplusplus_cli
#pragma managed
#endif
