/*
 * Decompiled with CFR 0.152.
 */
package com.japaricraft.japaricraftmod.mob;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySandStarHandler
extends EntitySpellcasterIllager {
    private EntitySheep wololoTarget;
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("japaricraftmod", "entitys/sandstarhandler");

    public EntitySandStarHandler(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 12;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISummonVexSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAttackSpell());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHealingSpell());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntitySandStarHandler.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public static void registerFixesEvoker(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySandStarHandler.class);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (entityIn == this) {
            return true;
        }
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof EntityVex) {
            return this.func_184191_r((Entity)((EntityVex)entityIn).func_190645_o());
        }
        return entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.ILLAGER && this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191246_bp;
    }

    private void setWololoTarget(@Nullable EntitySheep p_190748_1_) {
        this.wololoTarget = p_190748_1_;
    }

    @Nullable
    private EntitySheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    class AIHealingSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIHealingSpell() {
            super((EntitySpellcasterIllager)EntitySandStarHandler.this);
        }

        public boolean func_75250_a() {
            if (EntitySandStarHandler.this.func_193082_dl()) {
                return false;
            }
            if (EntitySandStarHandler.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (EntitySandStarHandler.this.func_110143_aJ() < 40.0f) {
                // empty if block
            }
            return true;
        }

        protected int func_190869_f() {
            return 50;
        }

        protected int func_190872_i() {
            return 200;
        }

        protected void func_190868_j() {
            EntitySandStarHandler.this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 400, 1));
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_190021_aL;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.DISAPPEAR;
        }
    }

    class AISummonVexSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AISummonVexSpell() {
            super((EntitySpellcasterIllager)EntitySandStarHandler.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EntitySandStarHandler.this.field_70170_p.func_72872_a(EntityVex.class, EntitySandStarHandler.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntitySandStarHandler.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 90;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntitySandStarHandler.this).func_177982_a(-2 + EntitySandStarHandler.this.field_70146_Z.nextInt(5), 1, -2 + EntitySandStarHandler.this.field_70146_Z.nextInt(5));
                EntityVex entityvex = new EntityVex(EntitySandStarHandler.this.field_70170_p);
                entityvex.func_174828_a(blockpos, 0.0f, 0.0f);
                entityvex.func_180482_a(EntitySandStarHandler.this.field_70170_p.func_175649_E(blockpos), null);
                entityvex.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151041_m));
                entityvex.func_190658_a((EntityLiving)EntitySandStarHandler.this);
                entityvex.func_190651_g(blockpos);
                entityvex.func_190653_a(20 * (30 + EntitySandStarHandler.this.field_70146_Z.nextInt(90)));
                EntitySandStarHandler.this.field_70170_p.func_72838_d((Entity)entityvex);
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.SUMMON_VEX;
        }
    }

    class AICastingSpell
    extends EntitySpellcasterIllager.AICastingApell {
        private AICastingSpell() {
            super((EntitySpellcasterIllager)EntitySandStarHandler.this);
        }

        public void func_75246_d() {
            if (EntitySandStarHandler.this.func_70638_az() != null) {
                EntitySandStarHandler.this.func_70671_ap().func_75651_a((Entity)EntitySandStarHandler.this.func_70638_az(), (float)EntitySandStarHandler.this.func_184649_cE(), (float)EntitySandStarHandler.this.func_70646_bf());
            } else if (EntitySandStarHandler.this.getWololoTarget() != null) {
                EntitySandStarHandler.this.func_70671_ap().func_75651_a((Entity)EntitySandStarHandler.this.getWololoTarget(), (float)EntitySandStarHandler.this.func_184649_cE(), (float)EntitySandStarHandler.this.func_70646_bf());
            }
        }
    }

    class AIAttackSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIAttackSpell() {
            super((EntitySpellcasterIllager)EntitySandStarHandler.this);
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntitySandStarHandler.this.func_70638_az();
            assert (entitylivingbase != null);
            double d0 = Math.min(entitylivingbase.field_70163_u, EntitySandStarHandler.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntitySandStarHandler.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntitySandStarHandler.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntitySandStarHandler.this.field_70165_t));
            if (EntitySandStarHandler.this.func_70068_e((Entity)entitylivingbase) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.spawnFangs(EntitySandStarHandler.this.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 1.5, EntitySandStarHandler.this.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnFangs(EntitySandStarHandler.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.5, EntitySandStarHandler.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                int l = 0;
                while (l < 16) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = l++;
                    this.spawnFangs(EntitySandStarHandler.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntitySandStarHandler.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void spawnFangs(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntitySandStarHandler.this.field_70170_p.func_175677_d(blockpos, true) || !EntitySandStarHandler.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntitySandStarHandler.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntitySandStarHandler.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntitySandStarHandler.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntityEvokerFangs SandStarHandlerfangs = new EntityEvokerFangs(EntitySandStarHandler.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (EntityLivingBase)EntitySandStarHandler.this);
                EntitySandStarHandler.this.field_70170_p.func_72838_d((Entity)SandStarHandlerfangs);
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191247_bq;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.FANGS;
        }
    }
}

