/* Sample hack for using the slowsjctype library.
// by Joel Matthew Rees, March 2009.
// Copyright 2009, Joel Matthew Rees
//
// Derived from a test file I'd written while at Alps Giken
// building a faster table-based library, 
// in which I found a bug which never got fixed in the original source code 
// still to be found at <http://reiisi.homedns.org/~joel/sannet/sjctype/testproj.html>.
//
// License extended under the GPL v. 3, see LICENSE.TXT.
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "slowsjctype.h"

#define ALPHA_COUNT 26
char alpha_list[ ALPHA_COUNT * 2 + 1 ] 
= "abcdefghijklmnopqrstuvwxyz"; /* DO NOT change without adjusting ALPHA_COUNT! */
#define HIRAGANA_COUNT 46
char hiragana_list[ HIRAGANA_COUNT * 4 + 1 ] 
/* DO NOT change without adjusting HIRAGANA_COUNT! */
= "ĂƂȂɂʂ˂̂͂Ђӂւق܂݂ނ߂";

void prep_search_list( char list[] )
{	size_t i;
	size_t count 
	= ( list == alpha_list ) 
		? ALPHA_COUNT
		: ( list == hiragana_list ) 
			? HIRAGANA_COUNT * 2
			: 0;
	for ( i = 0; i < count; ++i )
	{	list[ i + count ] = list[ i ];
	}
	list[ 2 * count ] = '\0';
}

int search( char * target_pointer, char list[], size_t offset ) 
{	if ( offset < ALPHA_COUNT )
	{	if ( list == alpha_list ) 
		{	char target = * target_pointer;
			size_t i;
			for ( i = 0; i < ALPHA_COUNT; ++i )
			{	if ( list[ offset + i ] == target )
				{	return i;
				}
			}
		}
		else if ( list == hiragana_list )
		{	char targetHigh = target_pointer[ 0 ];
			char targetLow = target_pointer[ 1 ];
			size_t i;
			for ( i = 0; i < HIRAGANA_COUNT * 2; i += 2 )
			{	size_t x = offset * 2 + i;
				if ( list[ x + 1 ] == targetLow && list[ x ] == targetHigh )
				{	return i / 2;
				}
			}
		}
	}
	return -1;
}

void convert( char target[], int offset, int point, char buffer[ 4 ] )
{	buffer[ 0 ] = '\0';
	if ( target == hiragana_list && ( point + offset ) < ( HIRAGANA_COUNT ) )
	{	buffer[ 0 ] = hiragana_list[ ( point + offset ) * 2 ];
		buffer[ 1 ] = hiragana_list[ ( point + offset ) * 2 + 1 ];
		buffer[ 2 ] = '\0';
	}
	else if ( target == alpha_list && ( point + offset ) < ( 2 * ALPHA_COUNT ) )
	{	buffer[ 0 ] = alpha_list[ point + offset ];
		buffer[ 1 ] = '\0'; 
	}
/*	printf( ":%d-%d", point, target == hiragana_list ); */
	return;
}

int main ( int argc, const char * argv[] )
{
/*	size_t alpha_length = strlen( to_alpha );
    size_t hiragana_length = strlen( hiragana_list );
*/
	char * source = alpha_list;
	char * target = hiragana_list;
	int chint = '\0';
	int offset = 0;
	int i;
	for ( i = 1; i < argc; ++i )
	{
		if ( argv[ i ][ 0 ] == '-' && argv[ i ][ 1 ] == 'o' )
		{	char * stopped = NULL;
			unsigned long offspec = strtoul( argv[ ++i ], &stopped, 10 );
			if ( offspec > HIRAGANA_COUNT )
			{	offspec = 0;
			}
			offset = (int) offspec;
			/* printf( "offset = %d\n", offset ); */
		}
		else if ( ( strcmp( "--to-alpha", argv[ i ] ) == 0 )
			|| ( argv[ i ][ 0 ] == '-' && argv[ i ][ 1 ] == 'a' ) )
		{	source = hiragana_list;
			target = alpha_list;
		}
	}
	prep_search_list( alpha_list );
	prep_search_list( hiragana_list );
/*	puts( alpha_list ); */
/*	puts( hiragana_list ); */
	while ( ( chint = getchar() ) != EOF )
	{	if ( source == alpha_list )
		{	if ( !isalpha( chint ) ) 
			{	putchar( chint );
			}
			else
			{	char ch = tolower( chint );
				int point = search( &ch, source, 0 );
				/* printf( "\npoint was %u\n", point ); */
				if ( point < 0 )
				{	fputs( "H", stdout );
				}
				else
				{	/* putchar( hiragana_list[ ( point + offset ) * 2 ] );
					// putchar( hiragana_list[ ( point + offset ) * 2 + 1 ] );
					*/
					char wch[ 4 ]; 
					/* = { hiragana_list[ ( point + offset ) * 2 ], hiragana_list[ ( point + offset ) * 2 + 1 ], '\0' }; */
					convert( target, offset, point, wch );
					fputs( wch, stdout );
				}
			}
		}
		else
		{	char wch[ 4 ] = {	chint, '\0', '\0', '\0' };
			int point;
			if ( slowsjIsPHighByte( wch ) )
			{
				wch[ 1 ] = chint = getchar();
/*				fputs( ":hb:", stdout ); */
				if ( !slowsjIsP2Byte( wch ) )
				{	ungetc( chint, stdin );
					wch[ 1 ] = '\0';
/*					fputs( ":n2:", stdout );  */
				}
				else if ( ( point = search( wch, source, 0 ) ) >= 0 )
				{	if ( point >= ALPHA_COUNT )
					{	wch[ 0 ] = '?';
						wch[ 1 ] = '\0';
					}
					else
					{	convert( target, ALPHA_COUNT - offset, point, wch );
					}
				}
			}
			fputs( wch, stdout );
			if ( chint == EOF ) 
			{	break;
			}
		}
	}
    return 0;
}
