/* Yet another re-write of the show-the-character-list standard:
// But this one shows the characters embedded in various definition constructs for use in programs.
// Prints various character ranges from the old shift-JIS variable width standard.
// Begun April 2001, Amagasaki, Hyougo, Japan, by Joel Matthew Rees.
//    joel_rees@sannet.ne.jp
//
// The first purpose of this file is to test the contents of sj16bitChars.h.
// Then it turned out to be convenient for generating the revised contents of the same.
//
// Copyright 2001 Joel Matthew Rees.
//   All rights reserved.
//
// Assignment of Stewardship, or Terms of Use: 
//
// The author grants permission to use and/or redistribute the code in this 
// file, in either source or translated form, under the following conditions:
// 1. When redistributing the source code, the copyright notices and terms of 
//    use must be neither removed nor modified. 
// 2. When redistributing in a form not generally read by humans, the 
//    copyright notices and terms of use, with proper indication of elements 
//    covered, must be reproduced in the accompanying documentation and/or 
//    other materials provided with the redistribution. In addition, if the 
//    source includes statements designed to compile a copyright notice 
//    into the output object code, the redistributor is required to take 
//    such steps as necessary to preserve the notice in the translated 
//    object code.
// 3. Modifications must be annotated, with attribution, including the name(s) 
//    of the author(s) and the contributor(s) thereof, the conditions for 
//    distribution of the modification, and full indication of the date(s) 
//    and scope of the modification. Rights to the modification itself 
//    shall necessarily be retained by the author(s) thereof.
// 4. These grants shall not be construed as an assignment or assumption of 
//    liability of any sort or to any degree. Neither shall these grants be 
//    construed as endorsement or represented as such. Any party using this 
//    code in any way does so under the agreement to entirely indemnify the 
//    author and any contributors concerning the code and any use thereof. 
//    Specifically, THIS SOFTWARE IS PROVIDED AT NO COST, AS IT IS, WITHOUT 
//    ANY EXPRESS OR IMPLIED WARRANTY OF ANY SORT, INCLUDING, BUT NOT LIMITED 
//    TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
//    UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR 
//    ANY DAMAGES WHATSOEVER ARISING FROM ITS USE OR MISUSE, EVEN IF ADVISED 
//    OF THE EXISTENCE OF THE POSSIBILITY OF SUCH DAMAGE.
// 5. This code should not be used for any illegal or immoral purpose, 
//    including, but not limited to, the theft of property or services, 
//    deliberate communication of false information, the distribution of drugs 
//    for purposes other than medical, the distribution of pornography, the 
//    provision of illicit sexual services, the maintenance of oppressive 
//    governments or organizations, or the imposture of false religion and 
//    false science. 
//    Any illegal or immoral use incurs natural and legal penalties, which the 
//    author invokes in full force upon the heads of those who so use it.
// 6. Alternative redistribution arrangements:
//    a. If the above conditions are unacceptable, redistribution under the 
//       following commonly used public licenses is expressly permitted:
//       i.   The GNU General Public License (GPL) of the Free Software 
//            Foundation.
//       ii.  The Perl Artistic License, only as a part of Perl.
//       iii. The Apple Public Source License, only as a part of Darwin or 
//            a Macintosh Operating System using Darwin.
//    b. No other alternative redistribution arrangement is permitted.
//       (The original author reserves the right to add to this list.)
//    c. When redistributing this code under an alternative license, the 
//       specific license being invoked shall be noted immediately beneath 
//       the body of the terms of use. The terms of the license so specified 
//       shall apply only to the redistribution of the source so noted. 
// 7. In no case shall the rights of the original author to the original work 
//    be impaired by any distribution or redistribution arrangement.
//
// End of the Assignment of Stewardship, or terms of use.
//
// License invoked: Assignment of Stewardship.
// Notes concerning license:
//    Compiler directives are strongly encouraged as a means of meeting 
//    the attribution requirements in the Assignment of Stewardship.
*/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>


#if CHAR_BIT != 8
#	error "Need to adjust for variant definition of char!"
/* Nothing I can think of to encapsulate this issue until C provides something like 
// typedef unsigned sjisByte: 8;
*/
#endif


#include "sj16bitChars.h"
#include "sjctypenv.h"
#include "port.h"


/* Symbols in the two-byte JIS order:
*/
char * JISSymbols[] =
{	"SP",
	"ToTen",
	"KuTen",
	"Comma",
	"Period",
	"ChuTen",
	"Colon",
	"Semicolon",
	"QuestionMark",
	"ExclamationPoint",
	"DakuTen",
	"HanDakuTen",
	"AccentAcute_Prime",
	"AccentGrave",
	"Umlaut",
	"AccentCircumflex",
	"Overline_Negate",
	"Underline",
	"KatakanaRepeat",
	"KatakanaRepeatVoiced",
	"HiraganaRepeat",
	"HiraganaRepeatVoiced",
	"Ditto",
	"KanjiIbid",
	"KanjiRepeat",
	"Shime",
	"KanjiZero",
	"ChoOn",
	"FullDash",
	"QuarterDash_Hyphen",
	"Slash",
	"BackSlash",
	"WavyDash_Tilde",
	"Parallel_Posts",
	"VerticalLine",
	"ThreePointLeader",
	"TwoPointLeader",
	"LeftSingleQuote",
	"RightSingleQuote_Apostrophe",
	"LeftDoubleQuote",
	"RightDoubleQuote",
	"StartSmallParen",
	"EndSmallParen",
	"StartTurtleParen",
	"EndTurtleParen",
	"StartBracket",
	"EndBracket",
	"StartBrace",
	"EndBrace",
	"StartAngleBracket",
	"EndAngleBracket",
	"StartDblAngleBracket",
	"EndDblAngleBracket",
	"StartKeyBracket",
	"EndKeyBracket",
	"StartDblKeyBracket",
	"EndDblKeyBracket",
	"StartInkedParen",
	"EndInkedParen",
	"Plus",
	"Minus",
	"PlusMinus",
	"Multiply",
	"", /* 7f */
	"Divide", 
	"Equal",
	"NotEqual",
	"LessThan",
	"GreaterThan",
	"LessOrEqual",
	"GreaterOrEqual",
	"Infinity",
	"Therefore",
	"Male",
	"Female",
	"Degree",
	"Minute",
	"Second",
	"Celsius",
	"Yen",
	"Dollar",
	"Cent",
	"Pound",
	"Percent",
	"Number_IGeta",
	"Ampersand",
	"Asterisk",
	"At_UnitPrice",
	"Section",
	"OpenStar",
	"InkedStar",
	"OpenCircle_Maru",
	"InkedCircle",
	"DblCircle",
	"OpenChestnut",
	"InkedChestnut",
	"OpenSquare",
	"InkedSquare",
	"OpenUpTriangle",
	"InkedUpTriangle",
	"OpenDownTriangle",
	"InkedDownTriangle",
	"RiceSheaf",
	"Postal",
	"RightArrow",
	"LeftArrow",
	"UpArrow",
	"DownArrow",
	"Geta",
	"", "", "", "", "", "", "", "", "", "", "", /* ad-b7 */
	"Element",
	"Contains",
	"ProperSubset",
	"ProperSuperset",
	"Subset",
	"Superset",
	"Union",
	"Intersection",
	"", "", "", "", "", "", "", "", /* c0-c7 */
	"Conjunction_And",
	"Disjunction_Or",
	"LogicalNegate",
	"Imply",
	"LogicalEquivalant",
	"ForAll",
	"Exists",
	"", "", "", "", "", "", "", "", "", "", "", /* cf-d9 */
	"Angle",
	"RightAngle",
	"Arc",
	"Delta",
	"UpsideDownTriangleNabura",
	"Equivalent",
	"ApproximateEqual",
	"SignificantlyLess",
	"SignificantlyGreater",
	"Root",
	"Similar",
	"Proportional",
	"Cause",
	"Integral",
	"DoubleIntegral",
	"", "", "", "", "", "", "", /* e9-ef */
	"Angstrom",
	"PerMil",
	"Sharp",
	"Flat",
	"MusicalNote",
	"Dagger",
	"DoubleDagger",
	"Paragraph",
	"", "", "", "", /* f8-fb */
	"CompositionCircle",
	NULL
};


int main( int argc, char * argv[] )
{	int bLo;
	int i;
/* */
	commandLine( &argc, &argv );	/* Set the font, at least. */
	puts( "Two Byte Decimal Digits:" );
	for ( bLo = b16_ZERO[ 1 ]; bLo <= b16_NINE[ 1 ]; ++bLo )
		printf( "0x%02x%02x: %c%c\n", b16_ZERO[ 0 ], bLo, b16_ZERO[ 0 ], bLo );
	putchar( '\n' );
	puts( "Two Byte Hexadecimal Extra Digits:" );
	for ( bLo = b16_A[ 1 ]; bLo <= b16_F[ 1 ]; ++bLo )
		printf( "0x%02x%02x: %c%c\n", b16_A[ 0 ], bLo, b16_A[ 0 ], bLo );
	for ( bLo = b16_a[ 1 ]; bLo <= b16_f[ 1 ]; ++bLo )
		printf( "0x%02x%02x: %c%c\n", b16_a[ 0 ], bLo, b16_a[ 0 ], bLo );
	putchar( '\n' );
	puts( "Two Byte Roman (Latin):" );
	for ( bLo = b16_A[ 1 ]; bLo <= b16_Z[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_A[ 0 ] * 256 + bLo, b16_A[ 0 ], bLo );
	putchar( '\n' );
	for ( bLo = b16_a[ 1 ]; bLo <= b16_z[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_a[ 0 ] * 256 + bLo, b16_a[ 0 ], bLo );
	putchar( '\n' );
	/* I suppose this points out the basic reason why I should be using numerics throughout.
	// The difference between the Roman ` and the Greek  is not readily apparent from the 
	// text editor.
	// Also, the signed char problems keep sneaking up on us and hitting us from behind.
	// (CodeWarrior sometimes does the signed char problem with hex anyway, darn it.)
	*/
	puts( "Two Byte Greek:" );
	for ( bLo = b16_ALPHA[ 1 ]; bLo <= b16_OMEGA[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_ALPHA[ 0 ] * 256 + bLo, b16_ALPHA[ 0 ], bLo );
	putchar( '\n' );
	for ( bLo = b16_alpha[ 1 ]; bLo <= b16_omega[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_alpha[ 0 ] * 256 + bLo, b16_alpha[ 0 ], bLo );
	putchar( '\n' );
	puts( "Two Byte Russian:" );
	for ( bLo = b16_Russian_A[ 1 ]; bLo <= b16_Russian_YA[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_Russian_A[ 0 ] * 256 + bLo, b16_Russian_A[ 0 ], bLo );
	putchar( '\n' );
	for ( bLo = b16_Russian_a[ 1 ]; bLo <= b16_Russian_ya[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_Russian_a[ 0 ] * 256 + bLo, b16_Russian_a[ 0 ], bLo );
	putchar( '\n' );
	/* Now the kana.
	*/
	puts( "Two Byte hiragana:" );
	for ( bLo = b16_hiraganaSub_a[ 1 ]; bLo <= b16_hiragana_ng[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_hiraganaSub_a[ 0 ] * 256 + bLo, b16_hiraganaSub_a[ 0 ], bLo );
	putchar( '\n' );
	puts( "Two Byte katakana:" );
	for ( bLo = b16_katakanaSub_a[ 1 ]; bLo <= b16_katakanaSub_ke[ 1 ]; ++bLo )
		printf( "0x%04x: %c%c\n", b16_katakanaSub_a[ 0 ] * 256 + bLo, b16_katakanaSub_a[ 0 ], bLo );
	putchar( '\n' );
	puts( "JIS various symbols and punctuation:" );
	for ( i = 0; JISSymbols[ i ] != NULL; ++i )
	{	if ( JISSymbols[ i ][ 0 ] != '\0' )
			printf( "#define\tb16_%s\t( (ubyte *) \"\\x%02x\\x%02x\" )\t/* \"%c%c\" */\n",
					JISSymbols[ i ], b16_SP[ 0 ], b16_SP[ 1 ] + i, b16_SP[ 0 ], b16_SP[ 1 ] + i );
		else
			printf( "/* #define\tb16_reserved_%02x%02x\t( (ubyte *) \"\\x%02x\\x%02x\" )\t // \"%c%c\" */\n",
					b16_SP[ 0 ], b16_SP[ 1 ] + i, b16_SP[ 0 ], b16_SP[ 1 ] + i, 
					b16_SP[ 0 ], b16_SP[ 1 ] + i );
	}
	putchar( '\n' );
	return EXIT_SUCCESS;
}
