/* sj16bitChars.h v00.00.00.jmr
// Mnemonic definitions of some 16 bit characters, with casts to unsigned for convenience.
// Written by Joel Matthew Rees, Mukonoso, Amagasaki, Hyougo, Japan, April 2001.
//    joel_rees@sannet.ne.jp
// This would also be fun to generate mechanically, but the Greek and Russian would not.
// I want to use the actual characters, but most of the ones I need display ambiguously.
//
// I had a good thought -- although I want to machine generate these so I can look down 
// the list and say, yes, these all line up, it makes at least as much sense to use the 
// functions I am building with these definitions to machine generate the full lists 
// as one test of the functions. It's a chicken-and-egg business.
//
// Copyright 2001 Joel Matthew Rees.
//   All rights reserved.
//
// Assignment of Stewardship, or Terms of Use: 
//
// The author grants permission to use and/or redistribute the code in this 
// file, in either source or translated form, under the following conditions:
// 1. When redistributing the source code, the copyright notices and terms of 
//    use must be neither removed nor modified. 
// 2. When redistributing in a form not generally read by humans, the 
//    copyright notices and terms of use, with proper indication of elements 
//    covered, must be reproduced in the accompanying documentation and/or 
//    other materials provided with the redistribution. In addition, if the 
//    source includes statements designed to compile a copyright notice 
//    into the output object code, the redistributor is required to take 
//    such steps as necessary to preserve the notice in the translated 
//    object code.
// 3. Modifications must be annotated, with attribution, including the name(s) 
//    of the author(s) and the contributor(s) thereof, the conditions for 
//    distribution of the modification, and full indication of the date(s) 
//    and scope of the modification. Rights to the modification itself 
//    shall necessarily be retained by the author(s) thereof.
// 4. These grants shall not be construed as an assignment or assumption of 
//    liability of any sort or to any degree. Neither shall these grants be 
//    construed as endorsement or represented as such. Any party using this 
//    code in any way does so under the agreement to entirely indemnify the 
//    author and any contributors concerning the code and any use thereof. 
//    Specifically, THIS SOFTWARE IS PROVIDED AT NO COST, AS IT IS, WITHOUT 
//    ANY EXPRESS OR IMPLIED WARRANTY OF ANY SORT, INCLUDING, BUT NOT LIMITED 
//    TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
//    UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR 
//    ANY DAMAGES WHATSOEVER ARISING FROM ITS USE OR MISUSE, EVEN IF ADVISED 
//    OF THE EXISTENCE OF THE POSSIBILITY OF SUCH DAMAGE.
// 5. This code should not be used for any illegal or immoral purpose, 
//    including, but not limited to, the theft of property or services, 
//    deliberate communication of false information, the distribution of drugs 
//    for purposes other than medical, the distribution of pornography, the 
//    provision of illicit sexual services, the maintenance of oppressive 
//    governments or organizations, or the imposture of false religion and 
//    false science. 
//    Any illegal or immoral use incurs natural and legal penalties, which the 
//    author invokes in full force upon the heads of those who so use it.
// 6. Alternative redistribution arrangements:
//    a. If the above conditions are unacceptable, redistribution under the 
//       following commonly used public licenses is expressly permitted:
//       i.   The GNU General Public License (GPL) of the Free Software 
//            Foundation.
//       ii.  The Perl Artistic License, only as a part of Perl.
//       iii. The Apple Public Source License, only as a part of Darwin or 
//            a Macintosh Operating System using Darwin.
//    b. No other alternative redistribution arrangement is permitted.
//       (The original author reserves the right to add to this list.)
//    c. When redistributing this code under an alternative license, the 
//       specific license being invoked shall be noted immediately beneath 
//       the body of the terms of use. The terms of the license so specified 
//       shall apply only to the redistribution of the source so noted. 
// 7. In no case shall the rights of the original author to the original work 
//    be impaired by any distribution or redistribution arrangement.
//
// End of the Assignment of Stewardship, or terms of use.
//
// License invoked: Assignment of Stewardship.
// Notes concerning license:
//    Compiler directives are strongly encouraged as a means of meeting 
//    the attribution requirements in the Assignment of Stewardship.
*/


#ifndef SJ16BITCHARS_H
#define SJ16BITCHARS_H


#include "sjctypenv.h"

/* original, for comparison. */
#define	b16_SP	( (ubyte *) "\x81\x40" )	/* "@" */

#define b16_DakuTen	( (ubyte *) "\x81\x4a" )	/* "J" */
#define b16_HanDakuTen	( (ubyte *) "\x81\x4b" )	/* "K" */
#define b16_ChoOn	( (ubyte *) "\x81\x5b" )	/* "[" */
/* redefine is benign, if same. */

/* Mechanically generated by list: */
#define	b16_SP	( (ubyte *) "\x81\x40" )	/* "@" */
#define	b16_ToTen	( (ubyte *) "\x81\x41" )	/* "A" */
#define	b16_KuTen	( (ubyte *) "\x81\x42" )	/* "B" */
#define	b16_Comma	( (ubyte *) "\x81\x43" )	/* "C" */
#define	b16_Period	( (ubyte *) "\x81\x44" )	/* "D" */
#define	b16_ChuTen	( (ubyte *) "\x81\x45" )	/* "E" */
#define	b16_Colon	( (ubyte *) "\x81\x46" )	/* "F" */
#define	b16_Semicolon	( (ubyte *) "\x81\x47" )	/* "G" */
#define	b16_QuestionMark	( (ubyte *) "\x81\x48" )	/* "H" */
#define	b16_ExclamationPoint	( (ubyte *) "\x81\x49" )	/* "I" */
#define	b16_DakuTen	( (ubyte *) "\x81\x4a" )	/* "J" */
#define	b16_HanDakuTen	( (ubyte *) "\x81\x4b" )	/* "K" */
#define	b16_AccentAcute_Prime	( (ubyte *) "\x81\x4c" )	/* "L" */
#define	b16_AccentGrave	( (ubyte *) "\x81\x4d" )	/* "M" */
#define	b16_Umlaut	( (ubyte *) "\x81\x4e" )	/* "N" */
#define	b16_AccentCircumflex	( (ubyte *) "\x81\x4f" )	/* "O" */
#define	b16_Overline_Negate	( (ubyte *) "\x81\x50" )	/* "P" */
#define	b16_Underline	( (ubyte *) "\x81\x51" )	/* "Q" */
#define	b16_KatakanaRepeat	( (ubyte *) "\x81\x52" )	/* "R" */
#define	b16_KatakanaRepeatVoiced	( (ubyte *) "\x81\x53" )	/* "S" */
#define	b16_HiraganaRepeat	( (ubyte *) "\x81\x54" )	/* "T" */
#define	b16_HiraganaRepeatVoiced	( (ubyte *) "\x81\x55" )	/* "U" */
#define	b16_Ditto	( (ubyte *) "\x81\x56" )	/* "V" */
#define	b16_KanjiIbid	( (ubyte *) "\x81\x57" )	/* "W" */
#define	b16_KanjiRepeat	( (ubyte *) "\x81\x58" )	/* "X" */
#define	b16_Shime	( (ubyte *) "\x81\x59" )	/* "Y" */
#define	b16_KanjiZero	( (ubyte *) "\x81\x5a" )	/* "Z" */
#define	b16_ChoOn	( (ubyte *) "\x81\x5b" )	/* "[" */
#define	b16_FullDash	( (ubyte *) "\x81\x5c" )	/* "\" */
#define	b16_QuarterDash_Hyphen	( (ubyte *) "\x81\x5d" )	/* "]" */
#define	b16_Slash	( (ubyte *) "\x81\x5e" )	/* "^" */
#define	b16_BackSlash	( (ubyte *) "\x81\x5f" )	/* "_" */
#define	b16_WavyDash_Tilde	( (ubyte *) "\x81\x60" )	/* "`" */
#define	b16_Parallel_Posts	( (ubyte *) "\x81\x61" )	/* "a" */
#define	b16_VerticalLine	( (ubyte *) "\x81\x62" )	/* "b" */
#define	b16_ThreePointLeader	( (ubyte *) "\x81\x63" )	/* "c" */
#define	b16_TwoPointLeader	( (ubyte *) "\x81\x64" )	/* "d" */
#define	b16_LeftSingleQuote	( (ubyte *) "\x81\x65" )	/* "e" */
#define	b16_RightSingleQuote_Apostrophe	( (ubyte *) "\x81\x66" )	/* "f" */
#define	b16_LeftDoubleQuote	( (ubyte *) "\x81\x67" )	/* "g" */
#define	b16_RightDoubleQuote	( (ubyte *) "\x81\x68" )	/* "h" */
#define	b16_StartSmallParen	( (ubyte *) "\x81\x69" )	/* "i" */
#define	b16_EndSmallParen	( (ubyte *) "\x81\x6a" )	/* "j" */
#define	b16_StartTurtleParen	( (ubyte *) "\x81\x6b" )	/* "k" */
#define	b16_EndTurtleParen	( (ubyte *) "\x81\x6c" )	/* "l" */
#define	b16_StartBracket	( (ubyte *) "\x81\x6d" )	/* "m" */
#define	b16_EndBracket	( (ubyte *) "\x81\x6e" )	/* "n" */
#define	b16_StartBrace	( (ubyte *) "\x81\x6f" )	/* "o" */
#define	b16_EndBrace	( (ubyte *) "\x81\x70" )	/* "p" */
#define	b16_StartAngleBracket	( (ubyte *) "\x81\x71" )	/* "q" */
#define	b16_EndAngleBracket	( (ubyte *) "\x81\x72" )	/* "r" */
#define	b16_StartDblAngleBracket	( (ubyte *) "\x81\x73" )	/* "s" */
#define	b16_EndDblAngleBracket	( (ubyte *) "\x81\x74" )	/* "t" */
#define	b16_StartKeyBracket	( (ubyte *) "\x81\x75" )	/* "u" */
#define	b16_EndKeyBracket	( (ubyte *) "\x81\x76" )	/* "v" */
#define	b16_StartDblKeyBracket	( (ubyte *) "\x81\x77" )	/* "w" */
#define	b16_EndDblKeyBracket	( (ubyte *) "\x81\x78" )	/* "x" */
#define	b16_StartInkedParen	( (ubyte *) "\x81\x79" )	/* "y" */
#define	b16_EndInkedParen	( (ubyte *) "\x81\x7a" )	/* "z" */
#define	b16_Plus	( (ubyte *) "\x81\x7b" )	/* "{" */
#define	b16_Minus	( (ubyte *) "\x81\x7c" )	/* "|" */
#define	b16_PlusMinus	( (ubyte *) "\x81\x7d" )	/* "}" */
#define	b16_Multiply	( (ubyte *) "\x81\x7e" )	/* "~" */
/* #define	b16_reserved_817f	( (ubyte *) "\x81\x7f" )	 // "" */
#define	b16_Divide	( (ubyte *) "\x81\x80" )	/* "" */
#define	b16_Equal	( (ubyte *) "\x81\x81" )	/* "" */
#define	b16_NotEqual	( (ubyte *) "\x81\x82" )	/* "" */
#define	b16_LessThan	( (ubyte *) "\x81\x83" )	/* "" */
#define	b16_GreaterThan	( (ubyte *) "\x81\x84" )	/* "" */
#define	b16_LessOrEqual	( (ubyte *) "\x81\x85" )	/* "" */
#define	b16_GreaterOrEqual	( (ubyte *) "\x81\x86" )	/* "" */
#define	b16_Infinity	( (ubyte *) "\x81\x87" )	/* "" */
#define	b16_Therefore	( (ubyte *) "\x81\x88" )	/* "" */
#define	b16_Male	( (ubyte *) "\x81\x89" )	/* "" */
#define	b16_Female	( (ubyte *) "\x81\x8a" )	/* "" */
#define	b16_Degree	( (ubyte *) "\x81\x8b" )	/* "" */
#define	b16_Minute	( (ubyte *) "\x81\x8c" )	/* "" */
#define	b16_Second	( (ubyte *) "\x81\x8d" )	/* "" */
#define	b16_Celsius	( (ubyte *) "\x81\x8e" )	/* "" */
#define	b16_Yen	( (ubyte *) "\x81\x8f" )	/* "" */
#define	b16_Dollar	( (ubyte *) "\x81\x90" )	/* "" */
#define	b16_Cent	( (ubyte *) "\x81\x91" )	/* "" */
#define	b16_Pound	( (ubyte *) "\x81\x92" )	/* "" */
#define	b16_Percent	( (ubyte *) "\x81\x93" )	/* "" */
#define	b16_Number_IGeta	( (ubyte *) "\x81\x94" )	/* "" */
#define	b16_Ampersand	( (ubyte *) "\x81\x95" )	/* "" */
#define	b16_Asterisk	( (ubyte *) "\x81\x96" )	/* "" */
#define	b16_At_UnitPrice	( (ubyte *) "\x81\x97" )	/* "" */
#define	b16_Section	( (ubyte *) "\x81\x98" )	/* "" */
#define	b16_OpenStar	( (ubyte *) "\x81\x99" )	/* "" */
#define	b16_InkedStar	( (ubyte *) "\x81\x9a" )	/* "" */
#define	b16_OpenCircle_Maru	( (ubyte *) "\x81\x9b" )	/* "" */
#define	b16_InkedCircle	( (ubyte *) "\x81\x9c" )	/* "" */
#define	b16_DblCircle	( (ubyte *) "\x81\x9d" )	/* "" */
#define	b16_OpenChestnut	( (ubyte *) "\x81\x9e" )	/* "" */
#define	b16_InkedChestnut	( (ubyte *) "\x81\x9f" )	/* "" */
#define	b16_OpenSquare	( (ubyte *) "\x81\xa0" )	/* "" */
#define	b16_InkedSquare	( (ubyte *) "\x81\xa1" )	/* "" */
#define	b16_OpenUpTriangle	( (ubyte *) "\x81\xa2" )	/* "" */
#define	b16_InkedUpTriangle	( (ubyte *) "\x81\xa3" )	/* "" */
#define	b16_OpenDownTriangle	( (ubyte *) "\x81\xa4" )	/* "" */
#define	b16_InkedDownTriangle	( (ubyte *) "\x81\xa5" )	/* "" */
#define	b16_RiceSheaf	( (ubyte *) "\x81\xa6" )	/* "" */
#define	b16_Postal	( (ubyte *) "\x81\xa7" )	/* "" */
#define	b16_RightArrow	( (ubyte *) "\x81\xa8" )	/* "" */
#define	b16_LeftArrow	( (ubyte *) "\x81\xa9" )	/* "" */
#define	b16_UpArrow	( (ubyte *) "\x81\xaa" )	/* "" */
#define	b16_DownArrow	( (ubyte *) "\x81\xab" )	/* "" */
#define	b16_Geta	( (ubyte *) "\x81\xac" )	/* "" */
/* #define	b16_reserved_81ad	( (ubyte *) "\x81\xad" )	 // "" */
/* #define	b16_reserved_81ae	( (ubyte *) "\x81\xae" )	 // "" */
/* #define	b16_reserved_81af	( (ubyte *) "\x81\xaf" )	 // "" */
/* #define	b16_reserved_81b0	( (ubyte *) "\x81\xb0" )	 // "" */
/* #define	b16_reserved_81b1	( (ubyte *) "\x81\xb1" )	 // "" */
/* #define	b16_reserved_81b2	( (ubyte *) "\x81\xb2" )	 // "" */
/* #define	b16_reserved_81b3	( (ubyte *) "\x81\xb3" )	 // "" */
/* #define	b16_reserved_81b4	( (ubyte *) "\x81\xb4" )	 // "" */
/* #define	b16_reserved_81b5	( (ubyte *) "\x81\xb5" )	 // "" */
/* #define	b16_reserved_81b6	( (ubyte *) "\x81\xb6" )	 // "" */
/* #define	b16_reserved_81b7	( (ubyte *) "\x81\xb7" )	 // "" */
#define	b16_Element	( (ubyte *) "\x81\xb8" )	/* "" */
#define	b16_Contains	( (ubyte *) "\x81\xb9" )	/* "" */
#define	b16_ProperSubset	( (ubyte *) "\x81\xba" )	/* "" */
#define	b16_ProperSuperset	( (ubyte *) "\x81\xbb" )	/* "" */
#define	b16_Subset	( (ubyte *) "\x81\xbc" )	/* "" */
#define	b16_Superset	( (ubyte *) "\x81\xbd" )	/* "" */
#define	b16_Union	( (ubyte *) "\x81\xbe" )	/* "" */
#define	b16_Intersection	( (ubyte *) "\x81\xbf" )	/* "" */
/* #define	b16_reserved_81c0	( (ubyte *) "\x81\xc0" )	 // "" */
/* #define	b16_reserved_81c1	( (ubyte *) "\x81\xc1" )	 // "" */
/* #define	b16_reserved_81c2	( (ubyte *) "\x81\xc2" )	 // "" */
/* #define	b16_reserved_81c3	( (ubyte *) "\x81\xc3" )	 // "" */
/* #define	b16_reserved_81c4	( (ubyte *) "\x81\xc4" )	 // "" */
/* #define	b16_reserved_81c5	( (ubyte *) "\x81\xc5" )	 // "" */
/* #define	b16_reserved_81c6	( (ubyte *) "\x81\xc6" )	 // "" */
/* #define	b16_reserved_81c7	( (ubyte *) "\x81\xc7" )	 // "" */
#define	b16_Conjunction_And	( (ubyte *) "\x81\xc8" )	/* "" */
#define	b16_Disjunction_Or	( (ubyte *) "\x81\xc9" )	/* "" */
#define	b16_LogicalNegate	( (ubyte *) "\x81\xca" )	/* "" */
#define	b16_Imply	( (ubyte *) "\x81\xcb" )	/* "" */
#define	b16_LogicalEquivalant	( (ubyte *) "\x81\xcc" )	/* "" */
#define	b16_ForAll	( (ubyte *) "\x81\xcd" )	/* "" */
#define	b16_Exists	( (ubyte *) "\x81\xce" )	/* "" */
/* #define	b16_reserved_81cf	( (ubyte *) "\x81\xcf" )	 // "" */
/* #define	b16_reserved_81d0	( (ubyte *) "\x81\xd0" )	 // "" */
/* #define	b16_reserved_81d1	( (ubyte *) "\x81\xd1" )	 // "" */
/* #define	b16_reserved_81d2	( (ubyte *) "\x81\xd2" )	 // "" */
/* #define	b16_reserved_81d3	( (ubyte *) "\x81\xd3" )	 // "" */
/* #define	b16_reserved_81d4	( (ubyte *) "\x81\xd4" )	 // "" */
/* #define	b16_reserved_81d5	( (ubyte *) "\x81\xd5" )	 // "" */
/* #define	b16_reserved_81d6	( (ubyte *) "\x81\xd6" )	 // "" */
/* #define	b16_reserved_81d7	( (ubyte *) "\x81\xd7" )	 // "" */
/* #define	b16_reserved_81d8	( (ubyte *) "\x81\xd8" )	 // "" */
/* #define	b16_reserved_81d9	( (ubyte *) "\x81\xd9" )	 // "" */
#define	b16_Angle	( (ubyte *) "\x81\xda" )	/* "" */
#define	b16_RightAngle	( (ubyte *) "\x81\xdb" )	/* "" */
#define	b16_Arc	( (ubyte *) "\x81\xdc" )	/* "" */
#define	b16_Delta	( (ubyte *) "\x81\xdd" )	/* "" */
#define	b16_UpsideDownTriangleNabura	( (ubyte *) "\x81\xde" )	/* "" */
#define	b16_Equivalent	( (ubyte *) "\x81\xdf" )	/* "" */
#define	b16_ApproximateEqual	( (ubyte *) "\x81\xe0" )	/* "" */
#define	b16_SignificantlyLess	( (ubyte *) "\x81\xe1" )	/* "" */
#define	b16_SignificantlyGreater	( (ubyte *) "\x81\xe2" )	/* "" */
#define	b16_Root	( (ubyte *) "\x81\xe3" )	/* "" */
#define	b16_Similar	( (ubyte *) "\x81\xe4" )	/* "" */
#define	b16_Proportional	( (ubyte *) "\x81\xe5" )	/* "" */
#define	b16_Cause	( (ubyte *) "\x81\xe6" )	/* "" */
#define	b16_Integral	( (ubyte *) "\x81\xe7" )	/* "" */
#define	b16_DoubleIntegral	( (ubyte *) "\x81\xe8" )	/* "" */
/* #define	b16_reserved_81e9	( (ubyte *) "\x81\xe9" )	 // "" */
/* #define	b16_reserved_81ea	( (ubyte *) "\x81\xea" )	 // "" */
/* #define	b16_reserved_81eb	( (ubyte *) "\x81\xeb" )	 // "" */
/* #define	b16_reserved_81ec	( (ubyte *) "\x81\xec" )	 // "" */
/* #define	b16_reserved_81ed	( (ubyte *) "\x81\xed" )	 // "" */
/* #define	b16_reserved_81ee	( (ubyte *) "\x81\xee" )	 // "" */
/* #define	b16_reserved_81ef	( (ubyte *) "\x81\xef" )	 // "" */
#define	b16_Angstrom	( (ubyte *) "\x81\xf0" )	/* "" */
#define	b16_PerMil	( (ubyte *) "\x81\xf1" )	/* "" */
#define	b16_Sharp	( (ubyte *) "\x81\xf2" )	/* "" */
#define	b16_Flat	( (ubyte *) "\x81\xf3" )	/* "" */
#define	b16_MusicalNote	( (ubyte *) "\x81\xf4" )	/* "" */
#define	b16_Dagger	( (ubyte *) "\x81\xf5" )	/* "" */
#define	b16_DoubleDagger	( (ubyte *) "\x81\xf6" )	/* "" */
#define	b16_Paragraph	( (ubyte *) "\x81\xf7" )	/* "" */
/* #define	b16_reserved_81f8	( (ubyte *) "\x81\xf8" )	 // "" */
/* #define	b16_reserved_81f9	( (ubyte *) "\x81\xf9" )	 // "" */
/* #define	b16_reserved_81fa	( (ubyte *) "\x81\xfa" )	 // "" */
/* #define	b16_reserved_81fb	( (ubyte *) "\x81\xfb" )	 // "" */
#define	b16_CompositionCircle	( (ubyte *) "\x81\xfc" )	/* "" */
/* End Mechanically generated. */

/* Not taking the time to make the lists (now). */

#define b16_LineDraw_1H	( (ubyte *) "\x84\x9f" )	/* "" */
#define b16_LineDraw_1H2V	( (ubyte *) "\x84\xbe" )	/* "" */

#define	b16_ZERO	( (ubyte *) "\x82\x4f" )	/* "O" */
#define	b16_NINE	( (ubyte *) "\x82\x58" )	/* "X" */

#define	b16_A	( (ubyte *) "\x82\x60" )	/* "`" */
#define	b16_F	( (ubyte *) "\x82\x65" )	/* "e" */
#define	b16_Z	( (ubyte *) "\x82\x79" )	/* upper "y" */
#define	b16_a	( (ubyte *) "\x82\x81" )	/* "" */
#define	b16_f	( (ubyte *) "\x82\x86" )	/* "" */
#define	b16_z	( (ubyte *) "\x82\x9a" )	/* lower "" */

#define	b16_ALPHA	( (ubyte *) "\x83\x9f" )	/* "" Greek */
#define	b16_OMEGA	( (ubyte *) "\x83\xb6" )	/* "" */
#define	b16_alpha	( (ubyte *) "\x83\xbf" )	/* "" */
#define	b16_omega	( (ubyte *) "\x83\xd6" )	/* "" */

#define	b16_Russian_A	( (ubyte *) "\x84\x40" )	/* "@" Russian */
#define	b16_Russian_YA	( (ubyte *) "\x84\x60" )	/* upper "`" (last) */
#define	b16_Russian_a	( (ubyte *) "\x84\x70" )	/* "p" */
#define	b16_Russian_ya	( (ubyte *) "\x84\x91" )	/* lower "" (last) */

#define b16_hiraganaSub_a	( (ubyte *) "\x82\x9f" )	/* subscripted "" (first) */
#define b16_hiragana_ng	( (ubyte *) "\x82\xf1" )	/* "" (last) */
#define b16_katakanaSub_a	( (ubyte *) "\x83\x40" )	/* subscripted "@" (first) */
#define b16_katakanaSub_ke	( (ubyte *) "\x83\x96" )	/* subscripted "" (last) */

/* sJIS Kanji: 
// Pronunciation is neither singular, nor unique, 
// so I am naming the boundaries by range and position, with a pronunciation as a note.
// Yes, this is sloppy. But it is sufficient for this step.
// If I could use the characters themselves, that would be clean. 
// (That's a vicious cycle.)
// I could also refer to the ordinal number in some authoritative dictionary,
// as the UNICODE group has done.
// (That's an even better stop-gap, but I don't have a good authoritative dictionary handy.)
// What I want to do is name by spelling (list of position/radical pairs), 
// but there is no standard spelling for Han characters.
// Primarily, I need range boundaries, 
// and a few other exceptional characters which can also be uniquely named by hand.
*/
/* JIS level 1 range boundaries: 
*/
#define b16_kanji1Low_a	( (ubyte *) "\x88\x9f" )	/* "" (first in range 1) */
#define b16_kanji1High_ude	( (ubyte *) "\x98\x72" )	/* "r" (last in range 1) */

/* JIS level 2 range boundaries (note the gap): 
*/
#define b16_kanji2aLow_ichi	( (ubyte *) "\x98\x9f" )	/* "" (first in range 2a) */
#define b16_kanji2aHigh_jou ( (ubyte *) "\x9f\xfc" )	/* "" (last in range 2a) */
#define b16_kanji2bLow_you	( (ubyte *) "\xe0\x40" )	/* "@" (first in range 2b) */
#define b16_kanji2bHigh_hikaru	( (ubyte *) "\xea\xa4" )	/* "" (last in range 2b) */


#endif /* ifndef SJ16BITCHARS_H */

