/* slowsjctype.h v00.00.00.jmr
// Near-ctype functions for shift-JIS characters, slow version.
// Written by Joel Matthew Rees, Amagasaki, Hyogo, Japan, April 2001.
//    joel_rees@sannet.ne.jp
// Shifting strategy for usability in current C environments: 
//		pass char pointers instead of unsigned char.
// Also, adding P to names to emphasize pointer usage.
//
// Copyright 2000, 2001 Joel Matthew Rees.
//   All rights reserved.
//
// Assignment of Stewardship, or Terms of Use: 
//
// The author grants permission to use and/or redistribute the code in this 
// file, in either source or translated form, under the following conditions:
// 1. When redistributing the source code, the copyright notices and terms of 
//    use must be neither removed nor modified. 
// 2. When redistributing in a form not generally read by humans, the 
//    copyright notices and terms of use, with proper indication of elements 
//    covered, must be reproduced in the accompanying documentation and/or 
//    other materials provided with the redistribution. In addition, if the 
//    source includes statements designed to compile a copyright notice 
//    into the output object code, the redistributor is required to take 
//    such steps as necessary to preserve the notice in the translated 
//    object code.
// 3. Modifications must be annotated, with attribution, including the name(s) 
//    of the author(s) and the contributor(s) thereof, the conditions for 
//    distribution of the modification, and full indication of the date(s) 
//    and scope of the modification. Rights to the modification itself 
//    shall necessarily be retained by the author(s) thereof.
// 4. These grants shall not be construed as an assignment or assumption of 
//    liability of any sort or to any degree. Neither shall these grants be 
//    construed as endorsement or represented as such. Any party using this 
//    code in any way does so under the agreement to entirely indemnify the 
//    author and any contributors concerning the code and any use thereof. 
//    Specifically, THIS SOFTWARE IS PROVIDED AT NO COST, AS IT IS, WITHOUT 
//    ANY EXPRESS OR IMPLIED WARRANTY OF ANY SORT, INCLUDING, BUT NOT LIMITED 
//    TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
//    UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR 
//    ANY DAMAGES WHATSOEVER ARISING FROM ITS USE OR MISUSE, EVEN IF ADVISED 
//    OF THE EXISTENCE OF THE POSSIBILITY OF SUCH DAMAGE.
// 5. This code should not be used for any illegal or immoral purpose, 
//    including, but not limited to, the theft of property or services, 
//    deliberate communication of false information, the distribution of drugs 
//    for purposes other than medical, the distribution of pornography, the 
//    provision of illicit sexual services, the maintenance of oppressive 
//    governments or organizations, or the imposture of false religion and 
//    false science. 
//    Any illegal or immoral use incurs natural and legal penalties, which the 
//    author invokes in full force upon the heads of those who so use it.
// 6. Alternative redistribution arrangements:
//    a. If the above conditions are unacceptable, redistribution under the 
//       following commonly used public licenses is expressly permitted:
//       i.   The GNU General Public License (GPL) of the Free Software 
//            Foundation.
//       ii.  The Perl Artistic License, only as a part of Perl.
//       iii. The Apple Public Source License, only as a part of Darwin or 
//            a Macintosh Operating System using Darwin.
//    b. No other alternative redistribution arrangement is permitted.
//       (The original author reserves the right to add to this list.)
//    c. When redistributing this code under an alternative license, the 
//       specific license being invoked shall be noted immediately beneath 
//       the body of the terms of use. The terms of the license so specified 
//       shall apply only to the redistribution of the source so noted. 
// 7. In no case shall the rights of the original author to the original work 
//    be impaired by any distribution or redistribution arrangement.
//
// End of the Assignment of Stewardship, or terms of use.
//
// License invoked: Assignment of Stewardship.
// Notes concerning license:
//    Compiler directives are strongly encouraged as a means of meeting 
//    the attribution requirements in the Assignment of Stewardship.
*/


#ifndef SLOWSJCTYPE_H
#define SLOWSJCTYPE_H


/* #include "sjctypenv.h"	clearing the unwanted dependency (bool) -- JMR2001.05.31 
// This required changing the bool typed functions to int typed functions, noted below.
// This mod by Joel Matthew Rees, released under original terms of use.
*/


/* Test whether pointing to something I know is a single byte character.
// Excluding 0x80, 0xa0, and 0xfd to 0xff because I don't know any better.
// Returns 0 (false) or 1 (true). -- Changed from bool to int JMR2001.05.31
*/
extern int slowsjIsPOneByte( char * chp );

/* Test whether pointing to something in the high byte range.
// Including 0x80 and excluding 0xa0, because I don't know any better.
// Also excluding 0xfd to 0xff for the same reason.
// Returns 0 (false) or 1 (true). -- Changed from bool to int JMR2001.05.31
*/
extern int slowsjIsPHighByte( char * chp );


/* Test whether pointing to something in the low byte range.
// Returns 0 (false) or 1 (true). -- Changed from bool to int JMR2001.05.31
*/
extern int slowsjIsPLowByte( char * chp );


/* We want to be able to pick out the 7 bit only without worrying about sign.
// Returns 0 (false) or 1 (true). -- Changed from bool to int JMR2001.05.31
*/
extern int slowsjIsP7bit( char * chp );

/* Try to determine the byte count by simple ranges.
// Misses the gaps where no characters are defined.
// Returns byte count (2, 1 or 0).
*/
extern int slowsjPGuessCount( char * chp ); 


/* As near as I can tell, all one byte, between 0 and 0x1f, inclusive. 
// Returns byte count (1 or 0). 
*/
extern int slowsjIsPCntrl( char * chp );


/* Adds one two byte version of the space character. 
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPSpace( char * chp );


/* The standard digits 0..9, as specified in ANSI/ISO ctype. 
// Includes both one and two byte digits.
// Does not include numerical kanji.
// Returns byte count (2, 1, or 0). 
*/      
extern int slowsjIsPDigit( char * chp );


/* The standard hexadecimal digits specified in ANSI/ISO ctype. 
// Includes both one and two byte digits. 
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPXDigit( char * chp );


/* All the JIS Roman (Latin) characters. 
// Returns byte count (2, 1, or 0).
*/
extern int slowsjIsPRomanLower( char * chp );
extern int slowsjIsPRomanUpper( char * chp );
extern int slowsjIsPRoman( char * chp );


/* All the JIS Greek characters. 
// Returns byte count (2 or 0).
*/
extern int slowsjIsPGreekLower( char * chp );
extern int slowsjIsPGreekUpper( char * chp );
extern int slowsjIsPGreek( char * chp );


/* All the JIS Russian characters. 
// Returns byte count (2 or 0).
*/
extern int slowsjIsPRussianLower( char * chp );
extern int slowsjIsPRussianUpper( char * chp );
extern int slowsjIsPRussian( char * chp );


/* Lower cased characters, includes 8 bit JIS-Latin, 
// 16 bit JIS-Roman, -Greek, and -Russian characters, but no kanji, of course. 
// Returns byte count (2, 1, or 0 ). 
*/
extern int slowsjIsPLower( char * chp );


/* Upper cased characters, includes 8 bit JIS-Latin, 
// 16 bit JIS-Roman, -Greek, and -Russian characters, but no kanji, of course. 
// Returns byte count (2, 1, or 0 ). 
*/
extern int slowsjIsPUpper( char * chp ); 


/* 8 bit JIS-Latin, 16 bit JIS-Roman, -Greek, and -Russian characters, 
// but no kanji, of course. 
// Returns byte count (2, 1, or 0 ). 
*/
extern int slowsjIsPEurAsianAlpha( char * chp );


/* Accent characters for JIS-Roman, -Greek, and -Russian characters, and hyphen.
// Includes tilde, and 16-bit wavy dash because it looks like tilde.
// Also includes 8-bit caret because it is sometimes used as circumflex,
// and 16-bit overscore because it is sometimes used as a vowel lengthener in romaji.
// The one-byte characters here are usually not considered part of identifiers. 
// Whether the two byte characters should be is left to the user.
// Returns byte count (2, 1, or 0 ). 
*/
int slowsjIsPQuasiEurAsianAlpha( char * chp );


/* Kind of wanted to split out the modified kana with an ismodified(), 
// but not this time around.
*/


/* All the hiragana, including modified. No modifiers. 
// Returns byte count (2 or 0 ).
*/
extern int slowsjIsPHiragana( char * chp );


/* All the katakana, including two byte modified and SJIS one byte. No modifiers. 
// Returns byte count (2, 1, or 0).
*/
extern int slowsjIsPKatakana( char * chp );


/* All the kana, including two byte modified and SJIS one byte. No modifiers. 
// Returns byte count (2, 1, or 0).
*/
extern int slowsjIsPKana( char * chp );

/* The kana word modifiers. 
// These are not kana, but are often used in words.
// A computer language that distinguishes between upper and lower case identifiers
// would also distinguish between katakana and hiragana, 
// and would accept all of these as valid identifier characters 
// and distinguish identifiers with these from the combined and un-abbreviated forms.
// Cho-on (naga-oto?) is one that is really hard to say is not kana,
// but it is sometimes used as a dash, too.
// Returns byte count (2, 1, or 0).
*/
extern int slowsjIsPQuasiKana( char * chp );


/* All the proper kanji characters. 
// Returns byte count (2 or 0). 
// (Some proprietary SJIS have one-byte Kanji.)
*/
extern int slowsjIsPKanji( char * chp );


/* The Kanji word modifiers. 
// These are not Kanji, but are often used in words.
// A computer language that distinguishes between upper and lower case identifiers
// would probably accept all of these as valid identifier characters 
// and distinguish identifiers with these from the un-abbreviated forms.
// Returns byte count (2 or 0).
*/
extern int slowsjIsPQuasiKanji( char * chp );


/* Characters used to form words, as used by non-programmers. 
// Does not include the standard decimal digits, 
// but does include the kanji numbers. 
// Includes a lot of caseless characters, of course.
// Returns byte count (2 or 0). 
*/
extern int slowsjIsPAlpha( char * chp );


/* For completeness.
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPQuasiAlpha( char * chp );


/* Characters used to form words, as used by programmers, thus including digits. 
// Returns byte count (2, 1, or 0).
*/ 
extern int slowsjIsPAlNum( char * chp );


/* Becoming obsessive about completeness? 
// Okay, it was easy to drag the pieces together. So sue me.
// Returns byte count (2, 1, or 0).
*/ 
extern int slowsjIsPAlNumQuasi( char * chp );


/* Line drawing characters.
// Does NOT include the IBM/MS line drawing set.
// Returns byte count (2 or 0). 
*/
extern int slowsjIsPLineDraw( char * chp );


/* All non-word-forming characters. 
// Will later be subdivided for the richer JIS set. Maybe.
// Includes line drawing characters ("not alnum", delimiter).
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPPunct( char * chp );


/* All graphic non-space characters. 
// Plauger's explanation of the C standard says "one print position".
// But it doesn't say anything about the width of that print position.
// I'm going to assume that he means non-zero when not combined.
// Besides, the standard he quotes only says "printing".
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPGraph( char * chp );


/* All graphic characters, including non-control space characters. 
// Returns byte count (2, 1, or 0). 
*/
extern int slowsjIsPPrint( char * chp );


/* Valid two byte characters only. 
// No two-byte control characters, so isprint() should work.
// Returns false (0) or true (1). -- Comment added JMR2001.05.31
*/
#define slowsjIsP2Byte( chp ) ( slowsjIsPPrint( chp ) == 2 )


/* Converts cased word forming characters to lower case, 
// including 8 bit ASCII/JIS-Latin; 16 bit JIS-Roman, -Greek, and -Russian characters, 
// but no kanji/kana. 
// Overwrites the character(s) at the destination pointer, chpout.
// Returns byte count converted  (2, 1, or 0). 
*/
extern int slowsjPToLowerRoman( char * chpin, char * chpout );
extern int slowsjPToLowerGreek( char * chpin, char * chpout );
extern int slowsjPToLowerRussian( char * chpin, char * chpout );
extern int slowsjPToLower( char * chpin, char * chpout );

extern int slowsjPToUpperRoman( char * chpin, char * chpout );
extern int slowsjPToUpperGreek( char * chpin, char * chpout );
extern int slowsjPToUpperRussian( char * chpin, char * chpout );
extern int slowsjPToUpper( char * chpin, char * chpout );

extern int slowsjPToKatakana( char * chpin, char * chpout );
extern int slowsjPToHiragana( char * chpin, char * chpout );

/* Converts cased word forming characters to upper case, 
*/


#endif /* ifndef SLOWSJCTYPE_H */
