/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import rdj.Audio;
import rdj.UI;

public class AudioPlayer
extends Audio {
    public AudioClip audioClip;
    public AudioClip audioClipVoice;
    private AudioInputStream audioInputStreamSounds;
    private AudioInputStream audioInputStreamVoice;
    private Clip clipSounds;
    private Clip clipVoice;

    private boolean isInt(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public synchronized void play(UI ui, String audio, int audio_codec) {
        if (!this.isInt(audio)) {
            Media media;
            switch (audio_codec) {
                case 0: {
                    media = new Media(this.getClass().getResource(audio + ".wav").toExternalForm());
                    break;
                }
                case 1: {
                    media = new Media(this.getClass().getResource(audio + ".ogg").toExternalForm());
                    break;
                }
                case 2: {
                    media = new Media(this.getClass().getResource(audio + ".aiff").toExternalForm());
                    break;
                }
                case 3: {
                    media = new Media(this.getClass().getResource(audio + ".mp3").toExternalForm());
                    break;
                }
                default: {
                    media = new Media(this.getClass().getResource(audio + ".wav").toExternalForm());
                }
            }
            if (media.getSource().contains("/sounds/") && sound_Is_Enabled || media.getSource().contains("/voice/") && voice_Is_Enabled) {
                this.playAudioClip(ui, media, audio_codec);
            }
        }
    }

    public synchronized void playAudioClipFile(UI ui, String fileParam) {
        Thread playAudioClipFileThread = new Thread(() -> {
            File file = new File(fileParam);
            Media media = null;
            try {
                media = new Media(file.toURI().toURL().toString());
            }
            catch (MalformedURLException ex) {
                ui.log("Error: MalformedURLException: " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            this.audioClip = new AudioClip(media.getSource());
            this.audioClip.play();
        });
        playAudioClipFileThread.setName("playAudioClipFileThread");
        playAudioClipFileThread.setDaemon(true);
        playAudioClipFileThread.start();
    }

    public synchronized void playAudioClip(UI ui, Media media, int audio_codec) {
        if (media != null) {
            if (media.getSource().contains("/sounds/")) {
                if (sound_Is_Enabled) {
                    Thread playAudioClipSounds = new Thread(() -> {
                        if (sound_Is_Enabled) {
                            this.audioClip = new AudioClip(media.getSource());
                            this.audioClip.play();
                        }
                    });
                    playAudioClipSounds.setName("playAudioClipSounds");
                    playAudioClipSounds.setDaemon(true);
                    playAudioClipSounds.start();
                }
            } else if (media.getSource().contains("/voice/")) {
                if (voice_Is_Enabled) {
                    if (this.audioClip != null && this.audioClip.isPlaying()) {
                        this.audioClip.stop();
                    }
                    Thread playJavaFXVoiceThread = new Thread(() -> {
                        if (this.audioClipVoice != null && this.audioClipVoice.isPlaying()) {
                            this.audioClipVoice.stop();
                        }
                        this.audioClipVoice = new AudioClip(media.getSource());
                        this.audioClipVoice.play();
                    });
                    playJavaFXVoiceThread.setName("playJavaFXVoiceThread");
                    playJavaFXVoiceThread.setDaemon(true);
                    playJavaFXVoiceThread.start();
                }
            } else {
                ui.log("Alert: " + AudioPlayer.class.getSimpleName() + ".play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
            }
        }
    }

    public synchronized void playJavaX(UI ui, Media media, int audio_codec) {
        if (media != null) {
            if (media.getSource().contains("/sounds/")) {
                if (sound_Is_Enabled) {
                    try {
                        this.audioInputStreamSounds = AudioSystem.getAudioInputStream(new URL(media.getSource()));
                    }
                    catch (UnsupportedAudioFileException ex) {
                        ui.log("Error: UnsupportedAudioFileException " + AudioPlayer.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    catch (IOException ex) {
                        ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    this.clipSounds = null;
                    try {
                        this.clipSounds = AudioSystem.getClip();
                    }
                    catch (LineUnavailableException ex) {
                        ui.log("Error: LineUnavailableException " + AudioPlayer.class.getSimpleName() + ".play(..).AudioSystem.getClip() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    try {
                        this.clipSounds.open(this.audioInputStreamSounds);
                    }
                    catch (LineUnavailableException ex) {
                        this.clipSounds.close();
                        this.clipSounds = null;
                        ui.log("Error: LineUnavailableException " + AudioPlayer.class.getSimpleName() + ".play(..).clipSounds.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    catch (IOException ex) {
                        this.clipSounds.close();
                        this.clipSounds = null;
                        ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).clipSounds.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    if (this.clipSounds != null) {
                        this.clipSounds.start();
                        try {
                            this.audioInputStreamSounds.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).audioInputStreamSounds.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    } else {
                        try {
                            this.audioInputStreamSounds.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).audioInputStreamSounds.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    }
                }
            } else if (media.getSource().contains("/voice/")) {
                if (voice_Is_Enabled) {
                    if (this.clipVoice != null && this.clipVoice.isOpen()) {
                        this.clipVoice.stop();
                        try {
                            this.audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException audioIn.close() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                        }
                    }
                    try {
                        this.audioInputStreamVoice = AudioSystem.getAudioInputStream(new URL(media.getSource()));
                    }
                    catch (UnsupportedAudioFileException ex) {
                        ui.log("Error: UnsupportedAudioFileException play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    catch (IOException ex) {
                        ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..) AudioSystem.getAudioInputStream(" + media.getSource() + " " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    this.clipVoice = null;
                    try {
                        this.clipVoice = AudioSystem.getClip();
                    }
                    catch (LineUnavailableException ex) {
                        ui.log("Error: LineUnavailableException " + AudioPlayer.class.getSimpleName() + ".play(..).AudioSystem.getClip() " + ex.getMessage() + " \r\n", true, true, true, true, false);
                    }
                    try {
                        this.clipVoice.open(this.audioInputStreamVoice);
                    }
                    catch (LineUnavailableException ex) {
                        this.clipVoice.close();
                        this.clipVoice = null;
                        ui.log("Error: LineUnavailableException " + AudioPlayer.class.getSimpleName() + ".play(..).clipVoice.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    catch (IOException ex) {
                        this.clipVoice.close();
                        this.clipVoice = null;
                        ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).clipVoice.open(" + media.getSource() + ") " + ex.getMessage() + " \r\n", true, true, true, false, false);
                    }
                    if (this.clipVoice != null) {
                        this.clipVoice.start();
                        try {
                            this.audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).audioInputStreamVoice.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    } else {
                        try {
                            this.audioInputStreamVoice.close();
                        }
                        catch (IOException ex) {
                            ui.log("Error: IOException " + AudioPlayer.class.getSimpleName() + ".play(..).audioInputStreamVoice.close() " + ex.getMessage() + " \r\n", true, true, true, false, false);
                        }
                    }
                }
            } else {
                ui.log("Alert: " + AudioPlayer.class.getSimpleName() + ".play(" + media.getSource() + ") not recognized!\r\n", true, true, true, true, false);
            }
        }
    }
}

