/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import rdj.UI;

public class Configuration {
    private UI ui;
    public String platform;
    private String fileSeparator;
    private String lineTerminator;
    private Path dataDirPath;
    private Path logDirPath;
    private Path logFilePath;
    private Path errorFilePath;
    private final Calendar currentTimeCalendar;
    private final String timeStampString;
    private final String timeString;
    private final String PRODUCT = "GravitySimulator3D";

    public Configuration(UI ui) {
        this.ui = ui;
        this.platform = System.getProperty("os.name").toLowerCase();
        if (this.platform.indexOf("windows") != -1) {
            this.fileSeparator = "\\";
            this.lineTerminator = "\r\n";
        } else {
            this.fileSeparator = "/";
            this.lineTerminator = "\r\n";
        }
        this.currentTimeCalendar = Calendar.getInstance();
        this.timeStampString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + String.format("%02d", this.currentTimeCalendar.get(5)) + "_" + String.format("%02d", this.currentTimeCalendar.get(11)) + String.format("%02d", this.currentTimeCalendar.get(12)) + String.format("%02d", this.currentTimeCalendar.get(13));
        this.timeString = "" + String.format("%04d", this.currentTimeCalendar.get(1)) + "-" + String.format("%02d", this.currentTimeCalendar.get(2) + 1) + "-" + String.format("%02d", this.currentTimeCalendar.get(5)) + " " + String.format("%02d", this.currentTimeCalendar.get(11)) + ":" + String.format("%02d", this.currentTimeCalendar.get(12)) + ":" + String.format("%02d", this.currentTimeCalendar.get(13));
        this.dataDirPath = Paths.get(System.getProperty("user.home"), ".finalcrypt");
        this.logDirPath = Paths.get(this.dataDirPath.toString(), "log");
        this.logFilePath = Paths.get(this.logDirPath.toString(), "finalcrypt_" + this.timeStampString + ".log");
        this.errorFilePath = Paths.get(this.logDirPath.toString(), "finalcrypt_" + this.timeStampString + ".err");
        boolean missingDirsDetected = false;
        boolean missingCriticalDirsDetected = false;
        if (Files.notExists(this.dataDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.dataDirPath, new FileAttribute[0]);
                this.println("Action:  Config: Creating missing directory: " + this.dataDirPath);
            }
            catch (IOException ex) {
                ui.log("Error: Files.createDirectory(" + this.dataDirPath + ");: " + ex.getMessage(), true, true, true, false, false);
            }
        }
        if (Files.notExists(this.logDirPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.logDirPath, new FileAttribute[0]);
                this.println("Action:  Config: Creating missing directory: " + this.logDirPath);
            }
            catch (IOException ex) {
                ui.log("Error: Files.createDirectory(" + this.dataDirPath + ");: " + ex.getMessage(), true, true, true, false, false);
            }
        }
    }

    public Path getDataDirPath() {
        return this.dataDirPath;
    }

    public Path getLogDirPath() {
        return this.logDirPath;
    }

    public Path getLogFilePath() {
        return this.logFilePath;
    }

    public Path getErrFilePath() {
        return this.errorFilePath;
    }

    public String getTime() {
        return this.timeString;
    }

    private void println(String string) {
        System.out.println(string);
    }
}

