/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import rdj.DeviceController;
import rdj.FCPath;
import rdj.GPT;
import rdj.UI;
import rdj.Validate;

public class DeviceManager
extends Thread {
    private final UI ui;

    public DeviceManager(UI ui) {
        this.ui = ui;
    }

    public void createManualKeyDevice(FCPath keyFCPath, FCPath targetFCPath) {
        if (Validate.isValidFile(this.ui, "", targetFCPath.path, targetFCPath.isKey, true, 1L, false, true, true)) {
            this.ui.log("Creating Key Device: " + targetFCPath.path.toAbsolutePath().toString() + "\r\n", true, true, false, false, false);
            GPT gpt = new GPT(this.ui);
            gpt.create(keyFCPath.size, targetFCPath);
            gpt.write(targetFCPath);
            gpt.createManualKeyPartitions(keyFCPath, targetFCPath);
            gpt.print();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void cloneManualKeyDevice(FCPath keyFCPath, FCPath targetFCPath) {
        if (Validate.isValidFile(this.ui, "", keyFCPath.path, keyFCPath.isKey, true, 1L, false, false, true) && Validate.isValidFile(this.ui, "", targetFCPath.path, targetFCPath.isKey, true, 1L, false, true, true)) {
            this.ui.log("Cloning Key Device: " + keyFCPath.path.toAbsolutePath().toString() + " to " + targetFCPath.path.toAbsolutePath().toString() + "\r\n", true, true, false, false, false);
            GPT gpt = new GPT(this.ui);
            gpt.create(DeviceController.getKeyPartitionSize(this.ui, keyFCPath), targetFCPath);
            gpt.write(targetFCPath);
            gpt.cloneManualKeypartitions(keyFCPath, targetFCPath);
            gpt.print();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void printGPT(FCPath fcPath) {
        if (Validate.isValidFile(this.ui, "", fcPath.path, fcPath.isKey, true, 1L, false, false, true)) {
            GPT gpt = new GPT(this.ui);
            gpt.read(fcPath);
            gpt.print();
        }
    }

    public void deleteGPT(FCPath fcPath) {
        if (Validate.isValidFile(this.ui, "", fcPath.path, fcPath.isKey, true, 1L, false, true, true)) {
            GPT gpt = new GPT(this.ui);
            gpt.write(fcPath);
            gpt.read(fcPath);
            gpt.print();
        }
    }
}

