/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.GPT;
import rdj.MySimpleFCFileVisitor;
import rdj.RNG;
import rdj.Stat;
import rdj.Stats;
import rdj.UI;
import rdj.Validate;

public class FinalCrypt
extends Thread {
    public static boolean verbose = false;
    private boolean symlink = false;
    private boolean txt = false;
    private boolean test = false;
    protected static boolean print_horizontal = false;
    protected static boolean print_vertical = false;
    protected static boolean bin = false;
    protected static boolean dec = false;
    protected static boolean hex = false;
    protected static boolean chr = false;
    private final int BUFFERSIZEDEFAULT = 0x100000;
    private int bufferSize = 0x100000;
    private int readTargetSourceBufferSize = this.bufferSize;
    private int readKeySourceBufferSize = this.bufferSize;
    private int wrteTargetDestinBufferSize = this.bufferSize;
    private final UI ui;
    private TimerTask updateProgressTimerTask;
    private Timer updateProgressTaskTimer;
    private boolean stopPending = false;
    public static boolean pausing = false;
    public boolean processRunning = false;
    private boolean targetSourceEnded;
    public static final String FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V1 = "FinalCrypt - File Encryption Program - Plain Text Authentication Token";
    public static final String FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V2 = "FinalCrypt - File Encryption Program - Plain Text Auth Token Version 2";
    public static final String FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3 = "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003";
    private Calendar startCalendar;
    private Calendar processProgressCalendar;
    private static double filesBytesPerMilliSecond = 0.0;
    private final long UPDATE_PROGRESS_TIMERTASK_PERIOD = 100L;
    public static final String UTF8_UNSUCCEEDED_SYMBOL = "U";
    public static final String UTF8_UNSUCCEEDED_DESC = "Unsucceeded";
    public static final String UTF8_SUCCESSUNKNOWN_SYMBOL = "?";
    public static final String UTF8_SUCCESSUNKNOWN_DESC = "Success Unknown";
    public static final String UTF8_SUCCEEDED_SYMBOL = "S";
    public static final String UTF8_SUCCEEDED_DESC = "Succeeded";
    public static final String UTF8_UNENCRYPTABLE_SYMBOL = "UE";
    public static final String UTF8_UNENCRYPTABLE_DESC = "Unencryptable";
    public static final String UTF8_UNDECRYPTABLE_SYMBOL = "UD";
    public static final String UTF8_UNDECRYPTABLE_DESC = "Undecryptable";
    public static final String UTF8_KEY_DESC = "Key";
    public static final String UTF8_KEY_SYMBOL = "K";
    public static final String UTF8_OLD_TARGET_DESC = "Old Target";
    public static final String UTF8_OLD_TARGET_SYMBOL = "O";
    public static final String UTF8_NEW_TARGET_DESC = "New Target";
    public static final String UTF8_NEW_TARGET_SYMBOL = "N";
    public static final String UTF8_MAC_DESC = "Message Authentication Code (MAC)";
    public static final String UTF8_MAC_SYMBOL = "M";
    public static final String UTF8_ATTRIB_SYMBOL = "A";
    public static final String UTF8_ATTRIB_DESC = "File Attributes";
    public static String UTF8_PROCESS_SYMBOL = "?";
    public static String UTF8_PROCESS_DESC = "Process";
    public static final String UTF8_CREATE_SYMBOL = "+";
    public static final String UTF8_CREATE_DESC = "Create";
    public static final String UTF8_READ_SYMBOL = "R";
    public static final String UTF8_READ_DESC = "Read";
    public static final String UTF8_WRITE_SYMBOL = "W";
    public static final String UTF8_WRITE_DESC = "Write";
    public static final String UTF8_ENCRYPT_SYMBOL = "E";
    public static final String UTF8_ENCRYPT_DESC = "Encrypt";
    public static final String UTF8_DECRYPT_SYMBOL = "D";
    public static final String UTF8_DECRYPT_DESC = "Decrypt";
    public static final String UTF8_XOR_NOMAC_SYMBOL = "X";
    public static final String UTF8_XOR_NOMAC_DESC = "XOR";
    public static final String UTF8_SHRED_SYMBOL = "S";
    public static final String UTF8_SHRED_DESC = "Shred";
    public static final String UTF8_CLONE_SYMBOL = "C";
    public static final String UTF8_CLONE_DESC = "Clone";
    public static final String UTF8_DELETE_SYMBOL = "-";
    public static final String UTF8_DELETE_DESC = "Delete";
    public static final String UTF8_PAUSE_SYMBOL = "PS";
    public static final String UTF8_UNPAUSE_SYMBOL = "UP";
    public static final String UTF8_STOP_SYMBOL = "ST";
    public static final String UTF8_PAUSE_DESC = "Pause";
    public static final String UTF8_UNPAUSE_DESC = "UnPause";
    public static final String UTF8_STOP_DESC = "Stop";
    public static boolean disabledMAC = false;
    public boolean reuseKeys = false;
    private static String pwd = "";
    private static int pwdPos = 0;
    private static byte[] pwdBytes;
    private static int pwdBytesPos;
    public static final String HASH_ALGORITHM_NAME = "SHA-256";
    private static String printVerticalString;
    private static String printHorizontalString;
    public static final double IO_THROUGHPUT_CEILING_DEFAULT = 10.0;
    public static double io_Throughput_Ceiling;
    private static double realtimeMiBPS;
    private long lastBytesProcessed2;
    private long throughputClock = 0L;
    private long lastThroughputClock = 0L;
    private long realtimeBytesProcessed;
    private long totalBytesProcessed;
    public static boolean sync;

    public FinalCrypt(UI ui) {
        this.ui = ui;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean getVerbose() {
        return verbose;
    }

    public boolean getPrint_Horizontal() {
        return print_horizontal;
    }

    public boolean getPrint_Vertical() {
        return print_vertical;
    }

    public boolean getSymlink() {
        return this.symlink;
    }

    public boolean getTXT() {
        return this.txt;
    }

    public boolean getBin() {
        return bin;
    }

    public boolean getDec() {
        return dec;
    }

    public boolean getHex() {
        return hex;
    }

    public boolean getChr() {
        return chr;
    }

    public boolean getTest() {
        return this.test;
    }

    public int getBufferSizeDefault() {
        return 0x100000;
    }

    public void setVerbose(boolean verbose) {
        FinalCrypt.verbose = verbose;
    }

    public void setPrint_Horizontal(boolean print_horizontal) {
        FinalCrypt.print_horizontal = print_horizontal;
    }

    public void setPrint_Vertical(boolean print_vertical) {
        FinalCrypt.print_vertical = print_vertical;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public void setTXT(boolean txt) {
        this.txt = txt;
    }

    public void setBin(boolean bin) {
        FinalCrypt.bin = bin;
    }

    public void setDec(boolean dec) {
        FinalCrypt.dec = dec;
    }

    public void setHex(boolean hex) {
        FinalCrypt.hex = hex;
    }

    public void setChr(boolean chr) {
        FinalCrypt.chr = chr;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public void setBufferSize(int bufferSize) {
        this.readTargetSourceBufferSize = this.bufferSize = bufferSize;
        this.readKeySourceBufferSize = this.bufferSize;
        this.wrteTargetDestinBufferSize = this.bufferSize;
    }

    public static EnumSet<StandardOpenOption> getEnumSet(EnumSet<StandardOpenOption> enumSet) {
        if (sync) {
            enumSet.add(StandardOpenOption.SYNC);
        }
        return enumSet;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void encryptSelection(FCPathList<FCPath> targetSourceFCPathList, FCPathList<FCPath> filteredTargetSourceFCPathList, FCPath keySourceFCPath, boolean encryptMode, String pwdParam, byte[] pwdBytesParam, boolean open) {
        FinalCrypt.io_Throughput_Ceiling = 10.0;
        if (pwdParam.length() > 0) {
            FinalCrypt.pwd = pwdParam;
            FinalCrypt.pwdBytes = pwdBytesParam;
        } else {
            FinalCrypt.pwd = "";
            FinalCrypt.pwdBytes = new byte[0];
        }
        this.startCalendar = Calendar.getInstance(Locale.ROOT);
        allDataStats = new Stats();
        allDataStats.reset();
        wrteKeyStat = new Stat();
        wrteKeyStat.reset();
        readTargetSourceStat = new Stat();
        readTargetSourceStat.reset();
        wrteTargetSourceStat = new Stat();
        wrteTargetSourceStat.reset();
        this.stopPending = false;
        FinalCrypt.pausing = false;
        this.processRunning = true;
        allDataStats.setFilesTotal(filteredTargetSourceFCPathList.encryptableFiles + filteredTargetSourceFCPathList.decryptableFiles);
        allDataStats.setAllDataBytesTotal(filteredTargetSourceFCPathList.encryptableFilesSize + filteredTargetSourceFCPathList.decryptableFilesSize + filteredTargetSourceFCPathList.writeAutoKeyFilesSize);
        modeDesc = "";
        if (this.test) {
            modeDesc = "test ";
        }
        modeDesc = encryptMode ? (!FinalCrypt.disabledMAC ? modeDesc + "encrypting" : modeDesc + "encrypting (legacy)") : (FinalCrypt.disabledMAC == false ? modeDesc + "decrypting" : modeDesc + "decrypting (legacy)");
        this.ui.log(allDataStats.getStartSummary(modeDesc), true, true, true, false, false);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException var13_13) {
            // empty catch block
        }
        this.updateProgressTimerTask = new TimerTask(){
            private long filesBytesTotal;

            @Override
            public void run() {
                long fileBytesProcessed = readTargetSourceStat.getFileBytesProcessed() + wrteTargetSourceStat.getFileBytesProcessed() + wrteKeyStat.getFileBytesProcessed() * 1L;
                double fileBytesTotalPercent = (double)readTargetSourceStat.getFileBytesTotal() / 100.0;
                int fileBytesPercentage = (int)((double)fileBytesProcessed / fileBytesTotalPercent);
                long filesBytesProcessed = allDataStats.getFilesBytesProcessed();
                double filesBytesPercent = (double)allDataStats.getFilesBytesTotal() / 100.0;
                int filesBytesPercentage = (int)((double)filesBytesProcessed / filesBytesPercent);
                FinalCrypt.this.processProgressCalendar = Calendar.getInstance(Locale.ROOT);
                this.filesBytesTotal = allDataStats.getFilesBytesTotal();
                fileBytesProcessed = allDataStats.getFileBytesProcessed();
                filesBytesPerMilliSecond = filesBytesProcessed / (FinalCrypt.this.processProgressCalendar.getTimeInMillis() - FinalCrypt.this.startCalendar.getTimeInMillis());
                FinalCrypt.this.throughputClock = System.nanoTime();
                realtimeMiBPS = (double)FinalCrypt.this.realtimeBytesProcessed * (1.0E9 / (double)(FinalCrypt.this.throughputClock - FinalCrypt.this.lastThroughputClock)) / 1048576.0;
                if (realtimeMiBPS > io_Throughput_Ceiling) {
                    io_Throughput_Ceiling = realtimeMiBPS;
                }
                FinalCrypt.this.lastThroughputClock = FinalCrypt.this.throughputClock;
                FinalCrypt.this.realtimeBytesProcessed = 0L;
                FinalCrypt.this.ui.processProgress(fileBytesPercentage, filesBytesPercentage, this.filesBytesTotal, allDataStats.getFilesBytesProcessed(), realtimeMiBPS);
            }
        };
        this.updateProgressTaskTimer = new Timer();
        this.updateProgressTaskTimer.schedule(this.updateProgressTimerTask, 100L, 100L);
        allDataStats.setAllDataStartNanoTime();
        it = filteredTargetSourceFCPathList.iterator();
        block120: while (it.hasNext()) {
            block245: {
                block246: {
                    block240: {
                        block243: {
                            block244: {
                                block241: {
                                    block242: {
                                        FinalCrypt.pwdPos = 0;
                                        FinalCrypt.pwdBytesPos = 0;
                                        this.totalBytesProcessed = 0L;
                                        srcMessageDigest = null;
                                        try {
                                            srcMessageDigest = MessageDigest.getInstance("SHA-256");
                                        }
                                        catch (NoSuchAlgorithmException ex) {
                                            this.ui.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", false, true, true, true, false);
                                        }
                                        dstMessageDigest = null;
                                        try {
                                            dstMessageDigest = MessageDigest.getInstance("SHA-256");
                                        }
                                        catch (NoSuchAlgorithmException ex) {
                                            this.ui.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", false, true, true, true, false);
                                        }
                                        newTargetSourceFCPath = (FCPath)it.next();
                                        if (!FinalCrypt.disabledMAC && encryptMode) {
                                            newTargetSourceFCPath.macVersion = FCPath.defaultMACVersion;
                                        }
                                        oldTargetSourceFCPath = newTargetSourceFCPath.clone(newTargetSourceFCPath);
                                        targetDestinPath = null;
                                        fileStatusLine = "";
                                        if (this.stopPending) {
                                            this.targetSourceEnded = true;
                                            break;
                                        }
                                        dynamicKeyFCPath = keySourceFCPath.clone(keySourceFCPath);
                                        autoKeyPath = Paths.get(keySourceFCPath.path.toAbsolutePath().toString(), new String[]{newTargetSourceFCPath.path.toAbsolutePath().toString().replace(":", "")});
                                        if ((keySourceFCPath.type == 2 || newTargetSourceFCPath.path.compareTo(keySourceFCPath.path) == 0) && (keySourceFCPath.type != 2 || newTargetSourceFCPath.path.compareTo(autoKeyPath) == 0)) ** GOTO lbl599
                                        bit_extension = ".bit";
                                        lastDotPos = newTargetSourceFCPath.path.getFileName().toString().lastIndexOf(46);
                                        lastPos = newTargetSourceFCPath.path.getFileName().toString().length();
                                        extension = "";
                                        extension = lastDotPos != -1 ? newTargetSourceFCPath.path.getFileName().toString().substring(lastDotPos, lastPos) : "";
                                        if (!FinalCrypt.disabledMAC) {
                                            if (encryptMode) {
                                                FinalCrypt.UTF8_PROCESS_SYMBOL = "E";
                                                targetDestinPath = newTargetSourceFCPath.path.resolveSibling(newTargetSourceFCPath.path.getFileName().toString() + bit_extension);
                                            } else {
                                                FinalCrypt.UTF8_PROCESS_SYMBOL = "D";
                                                targetDestinPath = extension.equals(bit_extension) ? Paths.get(newTargetSourceFCPath.path.toAbsolutePath().toString().substring(0, newTargetSourceFCPath.path.toAbsolutePath().toString().lastIndexOf(46)), new String[0]) : newTargetSourceFCPath.path.resolveSibling(newTargetSourceFCPath.path.getFileName().toString() + bit_extension);
                                            }
                                        } else {
                                            FinalCrypt.UTF8_PROCESS_SYMBOL = "X";
                                            targetDestinPath = extension.equals(bit_extension) != false ? Paths.get(newTargetSourceFCPath.path.toAbsolutePath().toString().substring(0, newTargetSourceFCPath.path.toAbsolutePath().toString().lastIndexOf(46)), new String[0]) : newTargetSourceFCPath.path.resolveSibling(newTargetSourceFCPath.path.getFileName().toString() + bit_extension);
                                        }
                                        if (!Files.exists(newTargetSourceFCPath.path, new LinkOption[0])) {
                                            this.ui.log("Warning: Old Target no longer exists: " + newTargetSourceFCPath.path.toAbsolutePath().toString() + "\r\n", true, true, true, true, false);
                                            continue;
                                        }
                                        if (Files.exists(targetDestinPath, new LinkOption[0])) {
                                            this.ui.log("Warning: New Target exists but shouldn't: " + targetDestinPath.toAbsolutePath().toString() + "\r\n", true, true, true, true, false);
                                            continue;
                                        }
                                        allDataStats.setFileBytesTotal(newTargetSourceFCPath.size + dynamicKeyFCPath.size);
                                        wrteKeyStat.setFileBytesProcessed(0L);
                                        wrteKeyStat.setFileBytesTotal(newTargetSourceFCPath.size + (long)FCPath.MAC_SIZE);
                                        readTargetSourceStat.setFileBytesProcessed(0L);
                                        readTargetSourceStat.setFileBytesTotal(newTargetSourceFCPath.size);
                                        wrteTargetSourceStat.setFileBytesProcessed(0L);
                                        wrteTargetSourceStat.setFileBytesTotal(newTargetSourceFCPath.size);
                                        if (FinalCrypt.print_vertical) {
                                            FinalCrypt.printVerticalString = "\r\n";
                                            FinalCrypt.printVerticalString = FinalCrypt.printVerticalString + "|--------|-------------------|\r\n";
                                            FinalCrypt.printVerticalString = FinalCrypt.printVerticalString + "|        | bin      hx dec c |\r\n";
                                            FinalCrypt.printVerticalString = FinalCrypt.printVerticalString + "|--------|-------------------|\r\n";
                                        }
                                        if (FinalCrypt.print_horizontal) {
                                            FinalCrypt.printHorizontalString = "\r\n";
                                            FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "|-------------------|-------------------|-------------------|\r\n";
                                            FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "|       Input       |         Key       |      Output       |\r\n";
                                            FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "|-------------------|-------------------|-------------------|\r\n";
                                            FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "| bin      hx dec c | bin      hx dec c | bin      hx dec c |\r\n";
                                            FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "|-------------------|-------------------|-------------------|\r\n";
                                        }
                                        if (keySourceFCPath.type == 2) {
                                            this.setBufferSize(0x100000);
                                            if (newTargetSourceFCPath.size + (long)FCPath.MAC_SIZE < (long)this.bufferSize) {
                                                this.setBufferSize((int)(newTargetSourceFCPath.size + (long)FCPath.MAC_SIZE));
                                            }
                                        } else if (keySourceFCPath.size < (long)this.bufferSize) {
                                            this.setBufferSize((int)keySourceFCPath.size);
                                        }
                                        this.ui.log(FinalCrypt.UTF8_PROCESS_SYMBOL + "N" + " \"" + targetDestinPath.toAbsolutePath().toString() + "\" " + Validate.getHumanSize(newTargetSourceFCPath.size, 1, "Bytes") + " ", true, false, false, false, false);
                                        this.ui.log(FinalCrypt.UTF8_PROCESS_SYMBOL + "N" + " \"" + targetDestinPath.toAbsolutePath().toString() + "\" " + Validate.getHumanSize(newTargetSourceFCPath.size, 1, "Bytes") + " ", false, true, true, false, false);
                                        if (this.test) break block240;
                                        if (keySourceFCPath.type != 2 || !keySourceFCPath.isValidKeyDir) break block241;
                                        if (!encryptMode) break block242;
                                        autoKeyPath = Paths.get(keySourceFCPath.path.toAbsolutePath().toString(), new String[]{targetDestinPath.toAbsolutePath().toString().replace(":", "")});
                                        dynamicKeyFCPath = Validate.getFCPath(this.ui, "", autoKeyPath, true, autoKeyPath, FinalCrypt.disabledMAC, true);
                                        if (targetDestinPath.compareTo(dynamicKeyFCPath.path) == 0) {
                                            this.ui.log("Error: Aborting: " + targetDestinPath.toAbsolutePath().toString() + " matches: " + dynamicKeyFCPath.path.toAbsolutePath().toString() + " (is key!)\r\n", true, true, true, true, false);
                                            break;
                                        }
                                        if (newTargetSourceFCPath.path.compareTo(dynamicKeyFCPath.path) == 0) {
                                            this.ui.log("Error: Aborting: " + newTargetSourceFCPath.path.toAbsolutePath().toString() + " matches: " + dynamicKeyFCPath.path.toAbsolutePath().toString() + " (is key!)\r\n", true, true, true, true, false);
                                            break;
                                        }
                                        try {
                                            Files.createDirectories(autoKeyPath.getParent(), new FileAttribute[0]);
                                        }
                                        catch (IOException ex) {
                                            this.ui.log("Error: Files.createDirectories(..): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                            break;
                                        }
                                        if (!(FinalCrypt.disabledMAC == false && this.reuseKeys == false || FinalCrypt.disabledMAC == false && Files.notExists(dynamicKeyFCPath.path, new LinkOption[0]) != false) && (!FinalCrypt.disabledMAC || !Files.notExists(Paths.get(dynamicKeyFCPath.path.toAbsolutePath().toString() + ".bit", new String[0]), new LinkOption[0]))) break block243;
                                        dynamicKeyFCPath.size = FinalCrypt.disabledMAC == false ? newTargetSourceFCPath.size + (long)FCPath.MAC_SIZE : newTargetSourceFCPath.size;
                                        if (dynamicKeyFCPath.size < (long)this.bufferSize) {
                                            this.bufferSize = (int)dynamicKeyFCPath.size;
                                        }
                                        inputEnded = false;
                                        writeKeyFileChannelPosition = 0L;
                                        writeKeyFileChannelTransfered = 0L;
                                        totalTranfered = 0L;
                                        remainder = Long.valueOf(0L);
                                        randomBuffer = ByteBuffer.allocate(this.bufferSize);
                                        randomBuffer.clear();
                                        this.ui.log("+K \"" + targetDestinPath.toAbsolutePath().toString() + "\" ", true, false, false, false, false);
                                        this.ui.log("+K", false, true, true, false, false);
                                        break block244;
                                    }
                                    autoKeyPath = Paths.get(keySourceFCPath.path.toAbsolutePath().toString(), new String[]{newTargetSourceFCPath.path.toAbsolutePath().toString().replace(":", "")});
                                    dynamicKeyFCPath = Validate.getFCPath(this.ui, "", autoKeyPath, true, autoKeyPath, FinalCrypt.disabledMAC, true);
                                    if (targetDestinPath.compareTo(dynamicKeyFCPath.path) == 0) {
                                        this.ui.log("Error: Aborting: " + targetDestinPath.toAbsolutePath().toString() + " matches: " + dynamicKeyFCPath.path.toAbsolutePath().toString() + " (is key!)\r\n", true, true, true, true, false);
                                        break;
                                    }
                                    if (newTargetSourceFCPath.path.compareTo(dynamicKeyFCPath.path) == 0) {
                                        this.ui.log("Error: Aborting: " + newTargetSourceFCPath.path.toAbsolutePath().toString() + " matches: " + dynamicKeyFCPath.path.toAbsolutePath().toString() + " (is key!)\r\n", true, true, true, true, false);
                                        break;
                                    }
                                    break block240;
                                }
                                dynamicKeyFCPath = keySourceFCPath.clone(keySourceFCPath);
                                break block240;
                            }
                            while (totalTranfered < dynamicKeyFCPath.size && !inputEnded) {
                                while (FinalCrypt.pausing) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException var34_48) {}
                                }
                                if (this.stopPending) {
                                    if (keySourceFCPath.type == 2 && keySourceFCPath.isValidKeyDir) {
                                        deleted = false;
                                        try {
                                            deleted = Files.deleteIfExists(dynamicKeyFCPath.path);
                                        }
                                        catch (IOException ex) {
                                            this.ui.log("Error: Files.deleteIfExists(dynamicKeyFCPath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                        }
                                        if (deleted) {
                                            this.ui.log(" ST -KS ", false, true, true, false, false);
                                        } else {
                                            this.ui.log(" ST -KU ", false, true, true, false, false);
                                        }
                                    }
                                    this.targetSourceEnded = true;
                                    this.ui.log("\r\n", true, true, true, false, false);
                                    FinalCrypt.filesBytesPerMilliSecond = 0.0;
                                    break block120;
                                }
                                remainder = Long.valueOf(dynamicKeyFCPath.size - totalTranfered);
                                if (remainder.longValue() >= (long)this.bufferSize) {
                                    randomBuffer = ByteBuffer.allocate(this.bufferSize);
                                    randomBuffer.clear();
                                } else if (remainder.longValue() > 0L && remainder.longValue() < (long)this.bufferSize) {
                                    randomBuffer = ByteBuffer.allocate(remainder.intValue());
                                    randomBuffer.clear();
                                } else {
                                    inputEnded = true;
                                }
                                randomBuffer = RNG.getFCRandomBuffer(this.ui, randomBuffer.capacity(), true, true, FinalCrypt.print_vertical);
                                wrteKeyStat.setFileStartEpoch();
                                try {
                                    writeKeyFileChannel = Files.newByteChannel(dynamicKeyFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE)), new FileAttribute[0]);
                                    ex = null;
                                    try {
                                        writeKeyFileChannel.position(writeKeyFileChannelPosition);
                                        writeKeyFileChannelTransfered = writeKeyFileChannel.write(randomBuffer);
                                        randomBuffer.rewind();
                                        this.realtimeBytesProcessed += writeKeyFileChannelTransfered;
                                        totalTranfered = totalTranfered + writeKeyFileChannelTransfered;
                                        writeKeyFileChannelPosition += writeKeyFileChannelTransfered;
                                        writeKeyFileChannel.close();
                                        wrteKeyStat.setFileEndEpoch();
                                        wrteKeyStat.clock();
                                        wrteKeyStat.addFileBytesProcessed(writeKeyFileChannelTransfered);
                                        allDataStats.addAllDataBytesProcessed("wr key", writeKeyFileChannelTransfered);
                                    }
                                    catch (Throwable var36_55) {
                                        ex = var36_55;
                                        throw var36_55;
                                    }
                                    finally {
                                        if (writeKeyFileChannel != null) {
                                            if (ex != null) {
                                                try {
                                                    writeKeyFileChannel.close();
                                                }
                                                catch (Throwable var36_54) {
                                                    ex.addSuppressed(var36_54);
                                                }
                                            } else {
                                                writeKeyFileChannel.close();
                                            }
                                        }
                                    }
                                }
                                catch (IOException ex) {
                                    this.ui.log("Error: Files.newByteChannel(dynamicKeyFCPath.path: " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                    inputEnded = true;
                                    break;
                                }
                                randomBuffer.clear();
                            }
                            writeKeyFileChannelPosition = 0L;
                            writeKeyFileChannelTransfered = 0L;
                            wrteKeyStat.setFileBytesProcessed(0L);
                            inputEnded = false;
                            this.ui.log("S ", false, true, true, false, false);
                        }
                        if (FinalCrypt.disabledMAC && Files.exists(Paths.get(dynamicKeyFCPath.path.toAbsolutePath().toString() + ".bit", new String[0]), new LinkOption[0])) {
                            dynamicKeyFCPath.path = Paths.get(dynamicKeyFCPath.path.toAbsolutePath().toString() + ".bit", new String[0]);
                        }
                    }
                    readTargetSourceChannelPosition = 0L;
                    writeTargetDestChannelTransfered = 0L;
                    if (FinalCrypt.disabledMAC) break block245;
                    while (FinalCrypt.pausing) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException var30_36) {}
                    }
                    if (!encryptMode) break block246;
                    if (!newTargetSourceFCPath.isDecrypted) break block245;
                    if (newTargetSourceFCPath.isEncryptable) {
                        if (!this.test) {
                            this.ui.log("WM" + FCPath.defaultMACVersion, false, true, true, false, false);
                            targetDestinMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2);
                            targetDestinMACBuffer.clear();
                            try {
                                writeTargetDestinChannel = Files.newByteChannel(targetDestinPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.APPEND)), new FileAttribute[0]);
                                remainder = null;
                                try {
                                    targetDestinMACBuffer = this.createTargetDestinMessageAuthenticationCode(dynamicKeyFCPath.path, FCPath.defaultMACVersion);
                                    writeTargetDestChannelTransfered = writeTargetDestinChannel.write(targetDestinMACBuffer);
                                    targetDestinMACBuffer.flip();
                                    writeTargetDestinChannel.close();
                                    dstMessageDigest.update(targetDestinMACBuffer);
                                }
                                catch (Throwable randomBuffer) {
                                    remainder = randomBuffer;
                                    throw randomBuffer;
                                }
                                finally {
                                    if (writeTargetDestinChannel != null) {
                                        if (remainder != null) {
                                            try {
                                                writeTargetDestinChannel.close();
                                            }
                                            catch (Throwable randomBuffer) {
                                                remainder.addSuppressed(randomBuffer);
                                            }
                                        } else {
                                            writeTargetDestinChannel.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException ex) {
                                this.ui.log("\r\nError: Add Token writeTargetDestinChannel Abort Encrypting: " + targetDestinPath.toString() + " " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                continue;
                            }
                            this.ui.log("S ", false, true, true, false, false);
                        }
                        break block245;
                    } else {
                        this.ui.log("UE \"" + newTargetSourceFCPath.toString() + "\" - Not Encryptable!\r\n", true, true, true, true, false);
                        continue;
                    }
                }
                if (newTargetSourceFCPath.isEncrypted) {
                    if (newTargetSourceFCPath.isDecryptable) {
                        if (!this.test) {
                            this.ui.log("RM" + newTargetSourceFCPath.macVersion, false, true, true, false, false);
                            targetSourceBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2);
                            targetSourceBuffer.clear();
                            try {
                                readTargetSourceChannel = Files.newByteChannel(newTargetSourceFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);
                                remainder = null;
                                try {
                                    readTargetSourceChannel.read(targetSourceBuffer);
                                    targetSourceBuffer.flip();
                                    readTargetSourceChannel.close();
                                    srcMessageDigest.update(targetSourceBuffer);
                                }
                                catch (Throwable randomBuffer) {
                                    remainder = randomBuffer;
                                    throw randomBuffer;
                                }
                                finally {
                                    if (readTargetSourceChannel != null) {
                                        if (remainder != null) {
                                            try {
                                                readTargetSourceChannel.close();
                                            }
                                            catch (Throwable randomBuffer) {
                                                remainder.addSuppressed(randomBuffer);
                                            }
                                        } else {
                                            readTargetSourceChannel.close();
                                        }
                                    }
                                }
                            }
                            catch (IOException ex) {
                                this.ui.log(" Error: IOException: Files.newByteChannel(newTargetSourceFCPath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                continue;
                            }
                            readTargetSourceChannelPosition = "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2;
                            this.ui.log("S ", false, true, true, false, false);
                        }
                    } else {
                        this.ui.log("UD \"" + newTargetSourceFCPath.toString() + "\" - Key Failed : " + keySourceFCPath.toString() + "\r\n", true, true, true, true, false);
                        continue;
                    }
                }
            }
            FinalCrypt.pwdPos = 0;
            FinalCrypt.pwdBytesPos = 0;
            targetSourceBuffer = ByteBuffer.allocate(this.readTargetSourceBufferSize);
            targetSourceBuffer.clear();
            keySourceBuffer = ByteBuffer.allocate(this.readTargetSourceBufferSize);
            keySourceBuffer.clear();
            targetDestinBuffer = ByteBuffer.allocate(this.readTargetSourceBufferSize);
            targetDestinBuffer.clear();
            this.targetSourceEnded = false;
            readTargetSourceChannelTransfered = 0L;
            readKeySourceChannelPosition = 0L;
            readKeySourceChannelPosition = encryptMode != false || encryptMode == false && newTargetSourceFCPath.macVersion >= 3 ? (long)("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2) : 0L;
            readKeySourceChannelTransfered = 0L;
            writeTargetDestChannelPosition = 0L;
            writeTargetDestChannelTransfered = 0L;
            readTargetDestChannelPosition = 0L;
            readTargetDestChannelTransfered = 0L;
            writeTargetSourceChannelPosition = 0L;
            writeTargetSourceChannelTransfered = 0L;
            this.ui.log(FinalCrypt.UTF8_PROCESS_SYMBOL + "N" + " \"" + targetDestinPath.toAbsolutePath().toString() + "\" ", true, false, false, false, false);
            this.ui.log(FinalCrypt.UTF8_PROCESS_SYMBOL + "N", false, true, true, false, false);
            while (true) {
                block247: {
                    if (!this.targetSourceEnded && !this.test) break block247;
                    this.ui.log("S ", false, true, true, false, false);
                    if (!this.test) {
                        this.cloneFileAttributes(newTargetSourceFCPath.path, targetDestinPath, true, "O", "N");
                        if (encryptMode && keySourceFCPath.type == 2 && keySourceFCPath.isValidKeyDir) {
                            this.cloneFileAttributes(newTargetSourceFCPath.path, dynamicKeyFCPath.path, true, "O", "K");
                        }
                    }
                    targetDestinSize = 0L;
                    targetDiffFactor = 1.0;
                    if (!this.test) {
                        this.ui.log("SO \"" + newTargetSourceFCPath.path.toAbsolutePath() + "\" ", true, false, false, false, false);
                        this.ui.log("SO", false, true, true, false, false);
                        if (Validate.isValidFile(this.ui, "", targetDestinPath, false, false, 1L, false, false, true)) {
                            try {
                                targetDestinSize = Files.size(targetDestinPath);
                                targetDiffFactor = newTargetSourceFCPath.size / targetDestinSize;
                            }
                            catch (IOException ex) {
                                this.ui.log("Error: Files.size(targetDestinPath); " + ex.getMessage() + "\r\n", true, true, true, true, false);
                            }
                            break;
                        } else {
                            readTargetSourceChannelPosition = 0L;
                            break;
                        }
                    }
                    ** GOTO lbl560
                }
                while (FinalCrypt.pausing) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var49_65) {}
                }
                if (this.stopPending) {
                    deleted = false;
                    try {
                        deleted = Files.deleteIfExists(targetDestinPath);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: Files.deleteIfExists(targetDestinPath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                    if (deleted) {
                        this.ui.log(" ST -NS ", false, true, true, false, false);
                    } else {
                        this.ui.log(" ST -NU ", false, true, true, false, false);
                    }
                    if (encryptMode && keySourceFCPath.type == 2 && keySourceFCPath.isValidKeyDir && !this.reuseKeys) {
                        deleted = false;
                        try {
                            deleted = Files.deleteIfExists(dynamicKeyFCPath.path);
                        }
                        catch (IOException ex) {
                            this.ui.log("Error: Files.deleteIfExists(dynamicKeyFCPath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                        }
                        if (deleted) {
                            this.ui.log("-KS ", false, true, true, false, false);
                        } else {
                            this.ui.log("-KU ", false, true, true, false, false);
                        }
                    }
                    this.targetSourceEnded = true;
                    this.ui.log("\r\n", true, true, true, false, false);
                    FinalCrypt.filesBytesPerMilliSecond = 0.0;
                    break block120;
                }
                readTargetSourceStat.setFileStartEpoch();
                try {
                    readTargetSourceChannel = Files.newByteChannel(newTargetSourceFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);
                    var50_72 = null;
                    try {
                        readTargetSourceChannel.position(readTargetSourceChannelPosition);
                        readTargetSourceChannelTransfered = readTargetSourceChannel.read(targetSourceBuffer);
                        targetSourceBuffer.flip();
                        readTargetSourceChannelPosition += readTargetSourceChannelTransfered;
                        if (readTargetSourceChannelTransfered == -1L || targetSourceBuffer.limit() < this.readTargetSourceBufferSize) {
                            this.targetSourceEnded = true;
                        }
                        readTargetSourceChannel.close();
                        srcMessageDigest.update(targetSourceBuffer);
                        readTargetSourceStat.setFileEndEpoch();
                        readTargetSourceStat.clock();
                        readTargetSourceStat.addFileBytesProcessed(readTargetSourceChannelTransfered / 2L);
                    }
                    catch (Throwable var51_76) {
                        var50_72 = var51_76;
                        throw var51_76;
                    }
                    finally {
                        if (readTargetSourceChannel != null) {
                            if (var50_72 != null) {
                                try {
                                    readTargetSourceChannel.close();
                                }
                                catch (Throwable var51_75) {
                                    var50_72.addSuppressed(var51_75);
                                }
                            } else {
                                readTargetSourceChannel.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    this.ui.log(" Error: IOException: Files.newByteChannel(newTargetSourceFCPath) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    continue block120;
                }
                if (readTargetSourceChannelTransfered != -1L) {
                    try {
                        readKeySourceChannel = Files.newByteChannel(dynamicKeyFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);
                        var50_72 = null;
                        try {
                            readKeySourceChannel.position(readKeySourceChannelPosition);
                            readKeySourceChannelTransfered = readKeySourceChannel.read(keySourceBuffer);
                            readKeySourceChannelPosition += readKeySourceChannelTransfered;
                            if (readKeySourceChannelTransfered < (long)this.readKeySourceBufferSize) {
                                readKeySourceChannelPosition = 0L;
                                readKeySourceChannel.position(0L);
                                readKeySourceChannelPosition += (readKeySourceChannelTransfered += (long)readKeySourceChannel.read(keySourceBuffer));
                            }
                            keySourceBuffer.flip();
                            readKeySourceChannel.close();
                        }
                        catch (Throwable var51_78) {
                            var50_72 = var51_78;
                            throw var51_78;
                        }
                        finally {
                            if (readKeySourceChannel != null) {
                                if (var50_72 != null) {
                                    try {
                                        readKeySourceChannel.close();
                                    }
                                    catch (Throwable var51_77) {
                                        var50_72.addSuppressed(var51_77);
                                    }
                                } else {
                                    readKeySourceChannel.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: readKeySourceChannel = Files.newByteChannel(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                        continue block120;
                    }
                    try {
                        writeTargetDestinChannel = Files.newByteChannel(targetDestinPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.APPEND)), new FileAttribute[0]);
                        var50_72 = null;
                        try {
                            targetDestinBuffer = FinalCrypt.encryptBuffer(targetSourceBuffer, keySourceBuffer, newTargetSourceFCPath.macVersion, true);
                            writeTargetDestChannelTransfered = writeTargetDestinChannel.write(targetDestinBuffer);
                            targetDestinBuffer.flip();
                            writeTargetDestChannelPosition += writeTargetDestChannelTransfered;
                            this.realtimeBytesProcessed += writeTargetDestChannelTransfered;
                            this.totalBytesProcessed += writeTargetDestChannelTransfered;
                            if (this.txt) {
                                FinalCrypt.logByteBuffer("DB", targetSourceBuffer);
                                FinalCrypt.logByteBuffer("CB", keySourceBuffer);
                                FinalCrypt.logByteBuffer("OB", targetDestinBuffer);
                            }
                            writeTargetDestinChannel.close();
                            dstMessageDigest.update(targetDestinBuffer);
                            allDataStats.addAllDataBytesProcessed("wr dst", writeTargetDestChannelTransfered / 2L);
                        }
                        catch (Throwable var51_80) {
                            var50_72 = var51_80;
                            throw var51_80;
                        }
                        finally {
                            if (writeTargetDestinChannel != null) {
                                if (var50_72 != null) {
                                    try {
                                        writeTargetDestinChannel.close();
                                    }
                                    catch (Throwable var51_79) {
                                        var50_72.addSuppressed(var51_79);
                                    }
                                } else {
                                    writeTargetDestinChannel.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: writeTargetDestinChannel = Files.newByteChannel(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                        continue block120;
                    }
                }
                targetDestinBuffer.clear();
                targetSourceBuffer.clear();
                keySourceBuffer.clear();
            }
            readTargetSourceChannelTransfered = 0L;
            readKeySourceChannelPosition = 0L;
            readKeySourceChannelTransfered = 0L;
            writeTargetDestChannelPosition = 0L;
            targetSourceBuffer = ByteBuffer.allocate(this.readTargetSourceBufferSize);
            targetSourceBuffer.clear();
            keySourceBuffer = ByteBuffer.allocate(this.readKeySourceBufferSize);
            keySourceBuffer.clear();
            targetDestinBuffer = ByteBuffer.allocate(this.wrteTargetDestinBufferSize);
            targetDestinBuffer.clear();
            targetDestinEnded = false;
            while (true) {
                block248: {
                    if (!targetDestinEnded) break block248;
                    this.ui.log("S ", false, true, true, false, false);
                    if (FinalCrypt.verbose) {
                        fileStatusLine = "- Crypt: rd(" + readTargetSourceStat.getFileBytesThroughPut() + ") -> ";
                        fileStatusLine = "wr(" + wrteTargetSourceStat.getFileBytesThroughPut() + ") ";
                    }
lbl560:
                    // 4 sources

                    if (!this.test && (newTargetSourceFCPath.size != 0L && targetDestinSize != 0L && Math.abs(newTargetSourceFCPath.size - targetDestinSize) == (long)("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2) || newTargetSourceFCPath.size == targetDestinSize)) {
                        deleted = false;
                        try {
                            deleted = Files.deleteIfExists(newTargetSourceFCPath.path);
                        }
                        catch (IOException ex) {
                            this.ui.log("Error: Files.deleteIfExists(" + newTargetSourceFCPath.path.toAbsolutePath().toString() + "): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                            continue block120;
                        }
                        if (deleted) {
                            this.ui.log("-OS ", false, true, true, false, false);
                        } else {
                            this.ui.log("- ", false, true, true, false, false);
                        }
                        if (!encryptMode && keySourceFCPath.type == 2 && keySourceFCPath.isValidKeyDir && !this.reuseKeys) {
                            deleted = false;
                            try {
                                deleted = Files.deleteIfExists(dynamicKeyFCPath.path);
                            }
                            catch (IOException ex) {
                                this.ui.log("Error: Files.deleteIfExists(" + dynamicKeyFCPath.path.toAbsolutePath().toString() + "): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                                continue block120;
                            }
                            if (deleted) {
                                this.ui.log("-KS ", false, true, true, false, false);
                            } else {
                                this.ui.log("-KU ", false, true, true, false, false);
                            }
                        }
                    }
                    srcHashBytes = srcMessageDigest.digest();
                    srcHashString = FinalCrypt.getHexString(srcHashBytes, 2);
                    dstHashBytes = dstMessageDigest.digest();
                    dstHashString = FinalCrypt.getHexString(dstHashBytes, 2);
                    fileStatusLine = allDataStats.getAllDataBytesProgressPercentage();
                    if (!this.test) {
                        this.ui.log("SHA-256: \"" + srcHashString + "\"->\"" + dstHashString + "\" " + fileStatusLine + "\r\n", true, true, true, false, false);
                    } else {
                        this.ui.log(fileStatusLine + "\r\n", true, true, true, false, false);
                    }
                    if (FinalCrypt.print_vertical) {
                        this.ui.log(FinalCrypt.printVerticalString + "\r\n", true, true, true, false, false);
                    }
                    if (FinalCrypt.print_horizontal) {
                        FinalCrypt.printHorizontalString = FinalCrypt.printHorizontalString + "|-------------------|-------------------|-------------------|\r\n";
                        this.ui.log(FinalCrypt.printHorizontalString + "\r\n", true, true, true, false, false);
                    }
                    allDataStats.addFilesProcessed(1L);
lbl599:
                    // 2 sources

                    newTargetSourceFCPath = Validate.getFCPath(this.ui, "", targetDestinPath, false, dynamicKeyFCPath.path, FinalCrypt.disabledMAC, FinalCrypt.verbose);
                    if (newTargetSourceFCPath.isEncrypted) {
                        newTargetSourceFCPath.isNewEncrypted = true;
                    } else {
                        newTargetSourceFCPath.isNewDecrypted = true;
                    }
                    targetSourceFCPathList.updateStat(oldTargetSourceFCPath, newTargetSourceFCPath);
                    this.ui.fileProgress();
                    continue block120;
                }
                while (FinalCrypt.pausing) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var54_89) {}
                }
                if (this.stopPending) {
                    deleted = false;
                    try {
                        deleted = Files.deleteIfExists(newTargetSourceFCPath.path);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: Files.deleteIfExists(" + newTargetSourceFCPath.path.toAbsolutePath().toString() + "): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                    if (deleted) {
                        this.ui.log(" ST -OS ", false, true, true, false, false);
                    } else {
                        this.ui.log(" ST -OU ", false, true, true, false, false);
                    }
                    if (!encryptMode && keySourceFCPath.type == 2 && keySourceFCPath.isValidKeyDir && !this.reuseKeys) {
                        deleted = false;
                        try {
                            deleted = Files.deleteIfExists(dynamicKeyFCPath.path);
                        }
                        catch (IOException ex) {
                            this.ui.log("Error: Files.deleteIfExists(dynamicKeyFCPath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
                        }
                        if (deleted) {
                            this.ui.log("-KS ", false, true, true, false, false);
                        } else {
                            this.ui.log("-KU ", false, true, true, false, false);
                        }
                    }
                    this.targetSourceEnded = true;
                    targetDestinEnded = true;
                    srcHashBytes = srcMessageDigest.digest();
                    srcHashString = FinalCrypt.getHexString((byte[])srcHashBytes, 2);
                    dstHashBytes = dstMessageDigest.digest();
                    dstHashString = FinalCrypt.getHexString(dstHashBytes, 2);
                    fileStatusLine = allDataStats.getAllDataBytesProgressPercentage();
                    this.ui.log("SHA-256: \"" + srcHashString + "\"->\"" + dstHashString + "\" " + fileStatusLine + "\r\n", true, true, true, false, false);
                    break block120;
                }
                try {
                    readTargetDestinChannel = Files.newByteChannel(targetDestinPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);
                    srcHashBytes = null;
                    try {
                        readTargetDestinChannel.position(readTargetDestChannelPosition);
                        readTargetDestChannelTransfered = readTargetDestinChannel.read(targetDestinBuffer);
                        targetDestinBuffer.flip();
                        readTargetDestChannelPosition += readTargetDestChannelTransfered;
                        if (readTargetDestChannelTransfered < 1L) {
                            targetDestinEnded = true;
                        }
                        readTargetDestinChannel.close();
                    }
                    catch (Throwable srcHashString) {
                        srcHashBytes = srcHashString;
                        throw srcHashString;
                    }
                    finally {
                        if (readTargetDestinChannel != null) {
                            if (srcHashBytes != null) {
                                try {
                                    readTargetDestinChannel.close();
                                }
                                catch (Throwable srcHashString) {
                                    srcHashBytes.addSuppressed(srcHashString);
                                }
                            } else {
                                readTargetDestinChannel.close();
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    this.ui.log("\r\nError: readTargetDestinChannel = Files.newByteChannel(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    continue block120;
                }
                if (targetDestinBuffer.limit() > 0) {
                    wrteTargetSourceStat.setFileStartEpoch();
                    try {
                        writeTargetSourceChannel = Files.newByteChannel(newTargetSourceFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.WRITE)), new FileAttribute[0]);
                        srcHashBytes = null;
                        try {
                            writeTargetSourceChannel.position(writeTargetSourceChannelPosition);
                            writeTargetSourceChannelTransfered = writeTargetSourceChannel.write(targetDestinBuffer);
                            targetSourceBuffer.flip();
                            writeTargetSourceChannelPosition += writeTargetSourceChannelTransfered;
                            this.realtimeBytesProcessed += writeTargetSourceChannelTransfered;
                            this.totalBytesProcessed += writeTargetSourceChannelTransfered;
                            if (writeTargetSourceChannelTransfered < 1L) {
                                this.targetSourceEnded = true;
                            }
                            writeTargetSourceChannel.close();
                            wrteTargetSourceStat.setFileEndEpoch();
                            wrteTargetSourceStat.clock();
                            wrteTargetSourceStat.addFileBytesProcessed(writeTargetSourceChannelTransfered / 2L);
                            allDataStats.addAllDataBytesProcessed("wr src", writeTargetSourceChannelTransfered / 2L);
                        }
                        catch (Throwable srcHashString) {
                            srcHashBytes = srcHashString;
                            throw srcHashString;
                        }
                        finally {
                            if (writeTargetSourceChannel != null) {
                                if (srcHashBytes != null) {
                                    try {
                                        writeTargetSourceChannel.close();
                                    }
                                    catch (Throwable srcHashString) {
                                        srcHashBytes.addSuppressed(srcHashString);
                                    }
                                } else {
                                    writeTargetSourceChannel.close();
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.ui.log("\r\nError: writeTargetSourceChannel = Files.newByteChannel(..) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                        continue block120;
                    }
                }
                targetDestinBuffer.clear();
                targetSourceBuffer.clear();
                keySourceBuffer.clear();
            }
        }
        FinalCrypt.filesBytesPerMilliSecond = 0.0;
        allDataStats.setAllDataEndNanoTime();
        allDataStats.clock();
        if (this.stopPending) {
            this.ui.log("\r\n", true, false, false, false, false);
            this.stopPending = false;
        }
        this.ui.log(allDataStats.getEndSummary(modeDesc), true, true, true, false, false);
        this.updateProgressTaskTimer.cancel();
        this.updateProgressTaskTimer.purge();
        this.processRunning = false;
        this.ui.processFinished(filteredTargetSourceFCPathList, open);
    }

    public synchronized void cloneFileAttributes(Path sourcePath, Path destPath, boolean cloneModTime, String sourceSymbol, String destSymbol) {
        String statusSymbol = "S";
        this.ui.log("CA" + destSymbol, false, true, true, false, false);
        for (String view : sourcePath.getFileSystem().supportedFileAttributeViews()) {
            if (view.toLowerCase().equals("basic")) {
                try {
                    BasicFileAttributes basicAttributes = null;
                    basicAttributes = Files.readAttributes(sourcePath, BasicFileAttributes.class, new LinkOption[0]);
                    try {
                        Files.setAttribute(destPath, "basic:creationTime", basicAttributes.creationTime(), new LinkOption[0]);
                        if (cloneModTime) {
                            Files.setAttribute(destPath, "basic:lastModifiedTime", basicAttributes.lastModifiedTime(), new LinkOption[0]);
                        }
                        Files.setAttribute(destPath, "basic:lastAccessTime", basicAttributes.lastAccessTime(), new LinkOption[0]);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: Set Basic Attributes: " + ex.getMessage() + "\r\n", false, false, true, true, false);
                        statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
                    }
                }
                catch (IOException ex) {
                    this.ui.log("Error: basicAttributes = Files.readAttributes(..): " + ex.getMessage() + "\r\n", false, false, true, true, false);
                    statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
                }
                continue;
            }
            if (view.toLowerCase().equals("dos")) {
                try {
                    DosFileAttributes msdosAttributes = null;
                    msdosAttributes = Files.readAttributes(sourcePath, DosFileAttributes.class, new LinkOption[0]);
                    try {
                        if (cloneModTime) {
                            Files.setAttribute(destPath, "basic:lastModifiedTime", msdosAttributes.lastModifiedTime(), new LinkOption[0]);
                        }
                        Files.setAttribute(destPath, "dos:hidden", msdosAttributes.isHidden(), new LinkOption[0]);
                        Files.setAttribute(destPath, "dos:system", msdosAttributes.isSystem(), new LinkOption[0]);
                        Files.setAttribute(destPath, "dos:readonly", msdosAttributes.isReadOnly(), new LinkOption[0]);
                        Files.setAttribute(destPath, "dos:archive", msdosAttributes.isArchive(), new LinkOption[0]);
                    }
                    catch (IOException ex) {
                        this.ui.log("Error: Set DOS Attributes: " + ex.getMessage() + "\r\n", false, false, true, true, false);
                        statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
                    }
                }
                catch (IOException ex) {
                    this.ui.log("Error: msdosAttributes = Files.readAttributes(..): " + ex.getMessage() + "\r\n", false, false, true, true, false);
                    statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
                }
                continue;
            }
            if (!view.toLowerCase().equals("posix")) continue;
            PosixFileAttributes posixAttributes = null;
            try {
                posixAttributes = Files.readAttributes(sourcePath, PosixFileAttributes.class, new LinkOption[0]);
                try {
                    Files.setAttribute(destPath, "posix:owner", posixAttributes.owner(), new LinkOption[0]);
                    Files.setAttribute(destPath, "posix:group", posixAttributes.group(), new LinkOption[0]);
                    Files.setPosixFilePermissions(destPath, posixAttributes.permissions());
                    if (!cloneModTime) continue;
                    Files.setLastModifiedTime(destPath, posixAttributes.lastModifiedTime());
                }
                catch (IOException ex) {
                    this.ui.log("Error: Set POSIX Attributes: " + ex.getMessage() + "\r\n", false, false, true, true, false);
                    statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
                }
            }
            catch (IOException ex) {
                this.ui.log("Error: posixAttributes = Files.readAttributes(..): " + ex.getMessage() + "\r\n", false, false, true, true, false);
                statusSymbol = UTF8_SUCCESSUNKNOWN_SYMBOL;
            }
        }
        this.ui.log(statusSymbol + " ", false, true, true, false, false);
    }

    public static synchronized String getHexString(byte[] bytes, int digits) {
        String returnString = "";
        for (byte mybyte : bytes) {
            returnString = returnString + FinalCrypt.getHexString(mybyte, digits);
        }
        return returnString;
    }

    public static synchronized String getHexString(byte value, int digits) {
        return String.format("%0" + Integer.toString(digits) + UTF8_XOR_NOMAC_SYMBOL, value & 0xFF).replaceAll("[^A-Za-z0-9]", "");
    }

    public static ByteBuffer encryptBuffer(ByteBuffer targetSourceBuffer, ByteBuffer keySourceBuffer, int macVersion, boolean printEnabled) {
        ByteBuffer targetDestinBuffer = ByteBuffer.allocate(keySourceBuffer.capacity());
        targetDestinBuffer.clear();
        while (pausing) {
            realtimeMiBPS = 0.0;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (int targetSourceBufferCount = 0; targetSourceBufferCount < targetSourceBuffer.limit(); ++targetSourceBufferCount) {
            byte targetDestinByte;
            byte targetSourceByte = targetSourceBuffer.get(targetSourceBufferCount);
            byte keySourceByte = keySourceBuffer.get(targetSourceBufferCount);
            if (pwd.length() == 0) {
                if (macVersion >= 3) {
                    targetDestinByte = FinalCrypt.encryptByteNoPassV3(targetSourceByte, keySourceByte, macVersion);
                    targetDestinBuffer.put(targetDestinByte);
                } else {
                    targetDestinByte = FinalCrypt.encryptByteNoPass(targetSourceByte, keySourceByte, macVersion);
                    targetDestinBuffer.put(targetDestinByte);
                }
            } else if (macVersion == 1) {
                targetDestinByte = FinalCrypt.encryptBytePassV1(targetSourceByte, keySourceByte, macVersion);
                targetDestinBuffer.put(targetDestinByte);
            } else if (macVersion == 2) {
                targetDestinByte = FinalCrypt.encryptBytePassV2(targetSourceByte, keySourceByte, macVersion);
                targetDestinBuffer.put(targetDestinByte);
            } else {
                targetDestinByte = FinalCrypt.encryptBytePassV3(targetSourceByte, keySourceByte, macVersion);
                targetDestinBuffer.put(targetDestinByte);
            }
            if (!printEnabled) continue;
            if (print_vertical) {
                printVerticalString = printVerticalString + FinalCrypt.getByteString(targetSourceByte, keySourceByte, targetDestinByte, true);
            }
            if (!print_horizontal) continue;
            printHorizontalString = printHorizontalString + FinalCrypt.getByteString(targetSourceByte, keySourceByte, targetDestinByte, false);
        }
        targetDestinBuffer.flip();
        return targetDestinBuffer;
    }

    public static byte encryptByteNoPass(byte targetSourceByte, byte keySourceByte, int macVersion) {
        byte returnByte = 0;
        if (!disabledMAC && keySourceByte == 0) {
            keySourceByte = (byte)(~keySourceByte & 0xFF);
        }
        returnByte = (byte)(targetSourceByte ^ keySourceByte);
        return returnByte;
    }

    public static byte encryptByteNoPassV3(byte targetSourceByte, byte keySourceByte, int macVersion) {
        byte returnByte = 0;
        returnByte = (byte)(targetSourceByte ^ keySourceByte);
        return returnByte;
    }

    public static byte encryptBytePassV1(byte targetSourceByte, byte keySourceByte, int macVersion) {
        byte returnByte = 0;
        if (!disabledMAC && keySourceByte == 0) {
            keySourceByte = (byte)(~keySourceByte & 0xFF);
        }
        byte transitionalByte = (byte)(targetSourceByte ^ keySourceByte);
        returnByte = (byte)(transitionalByte ^ (byte)pwd.charAt(pwdPos));
        if (++pwdPos == pwd.length()) {
            pwdPos = 0;
        }
        return returnByte;
    }

    public static byte encryptBytePassV2(byte targetSourceByte, byte keySourceByte, int macVersion) {
        byte returnByte = 0;
        if (!disabledMAC && keySourceByte == 0) {
            keySourceByte = (byte)(~keySourceByte & 0xFF);
        }
        byte transitionalByte = (byte)(keySourceByte ^ pwdBytes[pwdBytesPos]);
        returnByte = (byte)(targetSourceByte ^ transitionalByte);
        if (++pwdBytesPos == pwdBytes.length) {
            pwdBytesPos = 0;
        }
        return returnByte;
    }

    public static byte encryptBytePassV3(byte targetSourceByte, byte keySourceByte, int macVersion) {
        byte returnByte = 0;
        byte transitionalByte = (byte)(targetSourceByte ^ pwdBytes[pwdBytesPos]);
        returnByte = (byte)(transitionalByte ^ keySourceByte);
        if (++pwdBytesPos == pwdBytes.length) {
            pwdBytesPos = 0;
        }
        return returnByte;
    }

    public static byte encryptByteFastXOR(byte targetSourceByte, byte keySourceByte) {
        int targetDestinIgnoreBits = 0;
        int targetDestinKeyBits = 0;
        int targetDestinMergedBits = 0;
        if (!disabledMAC && keySourceByte == 0) {
            keySourceByte = (byte)(~keySourceByte & 0xFF);
        }
        targetDestinIgnoreBits = targetSourceByte & ~keySourceByte;
        targetDestinKeyBits = ~targetSourceByte & keySourceByte;
        targetDestinMergedBits = targetDestinIgnoreBits + targetDestinKeyBits;
        byte targetDestinEncryptedByte = (byte)(targetDestinMergedBits & 0xFF);
        if (bin) {
            FinalCrypt.logByteBinary(targetSourceByte, keySourceByte, targetDestinEncryptedByte, targetDestinIgnoreBits, targetDestinKeyBits, targetDestinMergedBits);
        }
        if (dec) {
            FinalCrypt.logByteDecimal(targetSourceByte, keySourceByte, targetDestinEncryptedByte, targetDestinIgnoreBits, targetDestinKeyBits, targetDestinMergedBits);
        }
        if (hex) {
            FinalCrypt.logByteHexaDecimal(targetSourceByte, keySourceByte, targetDestinEncryptedByte, targetDestinIgnoreBits, targetDestinKeyBits, targetDestinMergedBits);
        }
        if (chr) {
            FinalCrypt.logByteChar(targetSourceByte, keySourceByte, targetDestinEncryptedByte, targetDestinIgnoreBits, targetDestinKeyBits, targetDestinMergedBits);
        }
        return targetDestinEncryptedByte;
    }

    private ByteBuffer createTargetDestinMessageAuthenticationCode(Path keySourcePath, int macVersion) {
        int x;
        ByteBuffer plainTextMACBuffer = ByteBuffer.allocate(FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length());
        plainTextMACBuffer.clear();
        ByteBuffer keyBitMACBuffer = ByteBuffer.allocate(FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length());
        keyBitMACBuffer.clear();
        ByteBuffer encryptedMACBuffer = ByteBuffer.allocate(FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length());
        encryptedMACBuffer.clear();
        ByteBuffer targetDstMACBuffer = ByteBuffer.allocate(FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length() * 2);
        targetDstMACBuffer.clear();
        long readKeySourceChannelTransfered = 0L;
        plainTextMACBuffer.put(FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.getBytes());
        try (SeekableByteChannel readKeySourceChannel = Files.newByteChannel(keySourcePath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
            readKeySourceChannelTransfered = readKeySourceChannel.read(keyBitMACBuffer);
            keyBitMACBuffer.flip();
            readKeySourceChannel.close();
        }
        catch (IOException ex) {
            this.ui.log("Error: getTargetDestinMAC: readKeySourceChannel " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        encryptedMACBuffer = FinalCrypt.encryptBuffer(plainTextMACBuffer, keyBitMACBuffer, macVersion, false);
        byte[] messageAuthenticationCodeArray = new byte[FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length() * 2];
        for (x = 0; x < plainTextMACBuffer.capacity(); ++x) {
            messageAuthenticationCodeArray[x] = plainTextMACBuffer.array()[x];
        }
        for (x = 0; x < encryptedMACBuffer.capacity(); ++x) {
            messageAuthenticationCodeArray[FINALCRYPT_PLAIN_TEXT_MESSAGE_AUTHENTICATION_CODE_V3.length() + x] = encryptedMACBuffer.array()[x];
        }
        targetDstMACBuffer.put(messageAuthenticationCodeArray);
        targetDstMACBuffer.flip();
        pwdPos = 0;
        return targetDstMACBuffer;
    }

    public void deleteSelection(ArrayList<Path> targetSourcePathList, FCPath keyFCPath, int function, boolean returnpathlist, String pattern, boolean negatePattern) {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        MySimpleFCFileVisitor mySimpleFCFileVisitor = new MySimpleFCFileVisitor(this.ui, verbose, function, this.symlink, false, keyFCPath, new FCPathList<FCPath>(), pattern, negatePattern, disabledMAC);
        for (Path path : targetSourcePathList) {
            try {
                Files.walkFileTree(path, opts, Integer.MAX_VALUE, mySimpleFCFileVisitor);
            }
            catch (IOException e) {
                this.ui.log("Error: IOException: deleteSelection() Files.walkFileTree(" + path.toAbsolutePath().toString() + "): " + e.getMessage() + "\r\n", true, true, true, true, false);
            }
        }
    }

    private static String getBinaryString(Byte myByte) {
        return String.format("%8s", Integer.toBinaryString(myByte & 0xFF)).replace(' ', '0');
    }

    private static String getDecString(Byte myByte) {
        return String.format("%3d", myByte & 0xFF).replace(" ", "0");
    }

    private static String getHexString(Byte myByte, String digits) {
        return String.format("%0" + digits + UTF8_XOR_NOMAC_SYMBOL, myByte & 0xFF);
    }

    private static String getChar(Byte myByte) {
        return String.format("%1s", Character.valueOf((char)(myByte & 0xFF))).replaceAll("\\p{C}", UTF8_SUCCESSUNKNOWN_SYMBOL);
    }

    public boolean getPausing() {
        return pausing;
    }

    public boolean getStopPending() {
        return this.stopPending;
    }

    public void setPausing(boolean val) {
        pausing = val;
        if (pausing) {
            filesBytesPerMilliSecond = 0.0;
            this.ui.log(" PS", false, true, true, false, false);
        } else {
            this.ui.log(" UP ", false, true, true, false, false);
        }
    }

    public void setStopPending(boolean val) {
        this.stopPending = val;
    }

    public void setPwd(String pwdParam) {
        pwd = pwdParam;
    }

    public void setPwdBytes(String pwdBytesParam) {
        if (pwdBytesParam.isEmpty()) {
            pwdBytes = new byte[0];
        } else {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance(HASH_ALGORITHM_NAME);
            }
            catch (NoSuchAlgorithmException ex) {
                this.ui.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", true, true, true, true, false);
            }
            messageDigest.update(pwd.getBytes());
            byte[] hashBytes = messageDigest.digest();
            pwdBytes = GPT.hex2Bytes(FinalCrypt.getHexString(hashBytes, 2));
        }
    }

    public static void resetPwdPos() {
        pwdPos = 0;
    }

    public static void resetPwdBytesPos() {
        pwdBytesPos = 0;
    }

    private static void logByteBuffer(String preFix, ByteBuffer byteBuffer) {
        System.out.println(preFix + "C: ");
        System.out.println(" " + preFix + "Z: " + byteBuffer.limit() + "\r\n");
    }

    private static String getByteString(byte dataByte, byte keyByte, byte outputByte, boolean vertical) {
        String datbin = FinalCrypt.getBinaryString(dataByte);
        String dathex = FinalCrypt.getHexString((Byte)dataByte, "2");
        String datdec = FinalCrypt.getDecString(dataByte);
        String datchr = FinalCrypt.getChar(dataByte);
        String cphbin = FinalCrypt.getBinaryString(keyByte);
        String cphhex = FinalCrypt.getHexString((Byte)keyByte, "2");
        String cphdec = FinalCrypt.getDecString(keyByte);
        String cphchr = FinalCrypt.getChar(keyByte);
        String outbin = FinalCrypt.getBinaryString(outputByte);
        String outhex = FinalCrypt.getHexString((Byte)outputByte, "2");
        String outdec = FinalCrypt.getDecString(outputByte);
        String outchr = FinalCrypt.getChar(outputByte);
        if (vertical) {
            return FinalCrypt.getVirticalByteString(datbin, dathex, datdec, datchr, cphbin, cphhex, cphdec, cphchr, outbin, outhex, outdec, outchr);
        }
        return FinalCrypt.getHorizontalByteString(datbin, dathex, datdec, datchr, cphbin, cphhex, cphdec, cphchr, outbin, outhex, outdec, outchr);
    }

    private static String getVirticalByteString(String datbin, String dathex, String datdec, String datchr, String keybin, String keyhex, String keydec, String keychr, String outbin, String outhex, String outdec, String outchr) {
        String returnString = "";
        returnString = returnString + "| Input  | " + datbin + " " + dathex + " " + datdec + " " + datchr + " |\r\n";
        returnString = returnString + "| Key    | " + keybin + " " + keyhex + " " + keydec + " " + keychr + " |\r\n";
        returnString = returnString + "| Output | " + outbin + " " + outhex + " " + outdec + " " + outchr + " |\r\n";
        returnString = returnString + "|--------|-------------------|\r\n";
        return returnString;
    }

    private static String getHorizontalByteString(String datbin, String dathex, String datdec, String datchr, String keybin, String keyhex, String keydec, String keychr, String outbin, String outhex, String outdec, String outchr) {
        String returnString = "| ";
        returnString = returnString + datbin + " " + dathex + " " + datdec + " " + datchr + " | ";
        returnString = returnString + keybin + " " + keyhex + " " + keydec + " " + keychr + " | ";
        returnString = returnString + outbin + " " + outhex + " " + outdec + " " + outchr + " | \r\n";
        return returnString;
    }

    private static void logByteBinary(byte inputByte, byte keyByte, byte outputByte, int dum, int dnm, int dbm) {
        System.out.println("\r\n");
        System.out.println("Input  = " + FinalCrypt.getBinaryString(inputByte) + "\r\n");
        System.out.println("Key = " + FinalCrypt.getBinaryString(keyByte) + "\r\n");
        System.out.println("Output = " + FinalCrypt.getBinaryString(outputByte) + "\r\n");
        System.out.println("\r\n");
        System.out.println("DUM  = " + FinalCrypt.getBinaryString(inputByte) + " & " + FinalCrypt.getBinaryString(~keyByte) + " = " + FinalCrypt.getBinaryString((byte)dum) + "\r\n");
        System.out.println("DNM  = " + FinalCrypt.getBinaryString(~inputByte) + " & " + FinalCrypt.getBinaryString(keyByte) + " = " + FinalCrypt.getBinaryString((byte)dnm) + "\r\n");
        System.out.println("DBM  = " + FinalCrypt.getBinaryString((byte)dum) + " & " + FinalCrypt.getBinaryString((byte)dnm) + " = " + FinalCrypt.getBinaryString((byte)dbm) + "\r\n");
    }

    private static void logByteDecimal(byte dataByte, byte keyByte, byte outputByte, int dum, int dnm, int dbm) {
        System.out.println("\r\n");
        System.out.println("Input  = " + FinalCrypt.getDecString(dataByte) + "\r\n");
        System.out.println("Key = " + FinalCrypt.getDecString(keyByte) + "\r\n");
        System.out.println("Output = " + FinalCrypt.getDecString(outputByte) + "\r\n");
        System.out.println("\r\n");
        System.out.println("DUM  = " + FinalCrypt.getDecString(dataByte) + " & " + FinalCrypt.getDecString(~keyByte) + " = " + FinalCrypt.getDecString((byte)dum) + "\r\n");
        System.out.println("DNM  = " + FinalCrypt.getDecString(~dataByte) + " & " + FinalCrypt.getDecString(keyByte) + " = " + FinalCrypt.getDecString((byte)dnm) + "\r\n");
        System.out.println("DBM  = " + FinalCrypt.getDecString((byte)dum) + " & " + FinalCrypt.getDecString((byte)dnm) + " = " + FinalCrypt.getDecString((byte)dbm) + "\r\n");
    }

    private static void logByteHexaDecimal(byte dataByte, byte keyByte, byte outputByte, int dum, int dnm, int dbm) {
        System.out.println("\r\n");
        System.out.println("Input  = " + FinalCrypt.getHexString((Byte)dataByte, "2") + "\r\n");
        System.out.println("Key = " + FinalCrypt.getHexString((Byte)keyByte, "2") + "\r\n");
        System.out.println("Output = " + FinalCrypt.getHexString((Byte)outputByte, "2") + "\r\n");
        System.out.println("\r\n");
        System.out.println("DUM  = " + FinalCrypt.getHexString((Byte)dataByte, "2") + " & " + FinalCrypt.getHexString((Byte)(~keyByte), "2") + " = " + FinalCrypt.getHexString((Byte)((byte)dum), "2") + "\r\n");
        System.out.println("DNM  = " + FinalCrypt.getHexString((Byte)(~dataByte), "2") + " & " + FinalCrypt.getHexString((Byte)keyByte, "2") + " = " + FinalCrypt.getHexString((Byte)((byte)dnm), "2") + "\r\n");
        System.out.println("DBM  = " + FinalCrypt.getHexString((Byte)((byte)dum), "2") + " & " + FinalCrypt.getHexString((Byte)((byte)dnm), "2") + " = " + FinalCrypt.getHexString((Byte)((byte)dbm), "2") + "\r\n");
    }

    private static void logByteChar(byte dataByte, byte keyByte, byte outputByte, int dum, int dnm, int dbm) {
        System.out.println("\r\n");
        System.out.println("Input  = " + FinalCrypt.getChar(dataByte) + "\r\n");
        System.out.println("Key = " + FinalCrypt.getChar(keyByte) + "\r\n");
        System.out.println("Output = " + FinalCrypt.getChar(outputByte) + "\r\n");
        System.out.println("\r\n");
        System.out.println("DUM  = " + FinalCrypt.getChar(dataByte) + " & " + FinalCrypt.getChar(~keyByte) + " = " + FinalCrypt.getChar((byte)dum) + "\r\n");
        System.out.println("DNM  = " + FinalCrypt.getChar(~dataByte) + " & " + FinalCrypt.getChar(keyByte) + " = " + FinalCrypt.getChar((byte)dnm) + "\r\n");
        System.out.println("DBM  = " + FinalCrypt.getChar((byte)dum) + " & " + FinalCrypt.getChar((byte)dnm) + " = " + FinalCrypt.getChar((byte)dbm) + "\r\n");
    }

    public ArrayList<Path> getPathList(File[] files) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (File file : files) {
            pathList.add(file.toPath());
        }
        return pathList;
    }

    @Override
    public void run() {
    }

    static {
        pwdBytesPos = 0;
        io_Throughput_Ceiling = 10.0;
        sync = false;
    }
}

