/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.GPT;
import rdj.GPT_Entry;
import rdj.UI;

public class GPT_Entries {
    private final long ABSTRACT_LBA;
    private String DESCSTRING;
    public GPT_Entry[] gpt_entry;
    private UI ui;
    private GPT gpt;
    private long totalSize = 0L;
    private final String HEADERCLASS;

    public GPT_Entries(UI ui, GPT gpt, long abstractLBA, int numOfEntries) {
        this.ui = ui;
        this.gpt = gpt;
        this.gpt_entry = new GPT_Entry[numOfEntries];
        this.ABSTRACT_LBA = abstractLBA;
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            this.gpt_entry[entry] = new GPT_Entry(this.ui, this.gpt, this.ABSTRACT_LBA, entry);
        }
        this.HEADERCLASS = this.ABSTRACT_LBA >= 0L ? "Primary" : "Secondary";
        this.setDesc();
    }

    public void clear() {
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            this.gpt_entry[entry].clear();
        }
        this.setDesc();
    }

    public void read(FCPath keyFCPath) {
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            this.gpt_entry[entry].read(keyFCPath);
        }
        this.setTotalSize();
        this.setDesc();
    }

    public void create(long keySize) {
        if (this.ABSTRACT_LBA >= 0L) {
            this.gpt_entry[0].create(keySize, GPT.getUUID());
            this.gpt_entry[1].create(keySize, GPT.getUUID());
        } else {
            this.gpt_entry[0].create(keySize, this.gpt.gpt_Entries1.getEntry((int)0).uniquePartitionGUIDBytes);
            this.gpt_entry[1].create(keySize, this.gpt.gpt_Entries1.getEntry((int)1).uniquePartitionGUIDBytes);
        }
        this.setTotalSize();
        this.setDesc();
    }

    public void write(FCPath targetFCPath) {
        new DeviceController(this.ui);
        DeviceController.writeLBA(this.getDesc(), this.getBytes(), targetFCPath, this.ABSTRACT_LBA);
    }

    public void createManualKeyPartitions(FCPath keyFCPath, FCPath targetFCPath) {
        this.gpt_entry[0].writeKeyPartitions(keyFCPath, targetFCPath);
    }

    public void cloneManualKeyPartitions(FCPath keyFCPath, FCPath targetFCPath) {
        this.gpt_entry[0].cloneKeyPartition(keyFCPath, targetFCPath);
        this.gpt_entry[1].cloneKeyPartition(keyFCPath, targetFCPath);
        this.ui.processFinished(new FCPathList<FCPath>(), false);
    }

    private int getTotalEntries() {
        return this.gpt_entry.length;
    }

    private int getActiveEntries() {
        int activeEntries = 0;
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            if (this.gpt_entry[entry].startingLBA == 0L) continue;
            ++activeEntries;
        }
        return activeEntries;
    }

    public byte[] getBytes(int off, int length) {
        return GPT.getBytesPart(this.getBytes(), off, length);
    }

    public byte[] getBytes() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            for (byte mybyte : this.gpt_entry[entry].getBytes()) {
                byteList.add(mybyte);
            }
        }
        return GPT.byteListToByteArray(byteList);
    }

    public GPT_Entry getEntry(int entry) {
        return this.gpt_entry[entry];
    }

    public void print() {
        this.ui.log(this.toString(), true, true, true, false, false);
    }

    private void setTotalSize() {
        this.totalSize = 0L;
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            this.totalSize += this.gpt_entry[entry].partSize;
        }
    }

    private void setDesc() {
        this.DESCSTRING = "[ LBA " + this.ABSTRACT_LBA + " - " + this.getActiveEntries() + "/" + this.getTotalEntries() + " " + this.HEADERCLASS + " Entries (" + this.getBytes().length + " Bytes) Partitions: " + GPT.getHumanSize(this.totalSize, 1, "Bytes") + " ]";
    }

    private String getDesc() {
        return this.DESCSTRING;
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "\r\n";
        returnString = returnString + "========================================================================\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + this.DESCSTRING + "\r\n";
        for (int entry = 0; entry < this.gpt_entry.length; ++entry) {
            returnString = returnString + this.gpt_entry[entry].toString();
        }
        return returnString;
    }
}

