/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.GPT;
import rdj.UI;

public class GPT_Entry {
    private final long ABSTRACT_LBA;
    private String DESCSTRING;
    private final long FIRST_LBA = 2048L;
    private final String ENTRYCLASS;
    private final int ENTRYNUMBER;
    private final long LENGTH = 128L;
    private long pos;
    private byte[] partitionTypeGUIDBytes;
    public byte[] uniquePartitionGUIDBytes;
    public long startingLBA;
    private byte[] startingLBABytes;
    public long endingLBA;
    public long keySizeLBA;
    private byte[] endingLBABytes;
    private byte[] attributesBytes;
    private byte[] partitionNameBytes;
    public long partSize = 0L;
    private UI ui;
    private GPT gpt;

    public GPT_Entry(UI ui, GPT gpt, long abstractLBA, int EntryNumber) {
        this.ui = ui;
        this.gpt = gpt;
        this.ABSTRACT_LBA = abstractLBA;
        this.ENTRYNUMBER = EntryNumber;
        this.ENTRYCLASS = this.ABSTRACT_LBA >= 0L ? "Primary" : "Secondary";
        this.clear();
    }

    public void clear() {
        this.partitionTypeGUIDBytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.uniquePartitionGUIDBytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00");
        this.startingLBA = 0L;
        this.startingLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.startingLBA, 8));
        this.endingLBA = 0L;
        this.endingLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.endingLBA, 8));
        this.attributesBytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00");
        this.partitionNameBytes = GPT.getZeroBytes(72);
        this.setDesc();
    }

    public void read(FCPath keyFCPath) {
        this.pos = DeviceController.getLBAOffSet(DeviceController.bytesPerSector, keyFCPath.size, this.ABSTRACT_LBA) + (long)this.ENTRYNUMBER * 128L;
        byte[] bytes = new byte[128];
        new DeviceController(this.ui);
        bytes = DeviceController.readPos(keyFCPath, this.pos, 128L);
        this.partitionTypeGUIDBytes = GPT.getBytesPart(bytes, 0, 16);
        this.uniquePartitionGUIDBytes = GPT.getBytesPart(bytes, 16, 16);
        this.startingLBABytes = GPT.getBytesPart(bytes, 32, 8);
        this.startingLBA = Long.reverseBytes(GPT.bytesToLong(this.startingLBABytes));
        this.endingLBABytes = GPT.getBytesPart(bytes, 40, 8);
        this.endingLBA = Long.reverseBytes(GPT.bytesToLong(this.endingLBABytes));
        this.attributesBytes = GPT.getBytesPart(bytes, 48, 8);
        this.partitionNameBytes = GPT.getBytesPart(bytes, 56, 72);
        this.partSize = (this.endingLBA - this.startingLBA + 1L) * DeviceController.bytesPerSector;
        this.setDesc();
    }

    public void create(long keySize, byte[] uniquePartitionGUIDBytes) {
        this.keySizeLBA = (long)Math.floor((keySize - 1L) / DeviceController.bytesPerSector);
        this.partitionTypeGUIDBytes = GPT.hex2Bytes("AF 3D C6 0F 83 84 72 47 8E 79 3D 69 D8 47 7D E4");
        this.uniquePartitionGUIDBytes = uniquePartitionGUIDBytes;
        this.startingLBA = 2048L + (long)this.ENTRYNUMBER * this.keySizeLBA + (long)this.ENTRYNUMBER;
        this.startingLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.startingLBA, 8));
        this.endingLBA = this.startingLBA + this.keySizeLBA;
        this.endingLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.endingLBA, 8));
        this.attributesBytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00");
        this.partitionNameBytes = GPT.getZeroBytes(72);
        this.partSize = (this.endingLBA - this.startingLBA + 1L) * DeviceController.bytesPerSector;
        this.setDesc();
    }

    public void write(FCPath fcPath) {
        this.pos = DeviceController.getLBAOffSet(DeviceController.bytesPerSector, fcPath.size, this.ABSTRACT_LBA) + (long)this.ENTRYNUMBER * 128L;
        new DeviceController(this.ui);
        DeviceController.writePos(this.getDesc(), this.getBytes(), fcPath, this.pos);
    }

    public void writeKeyPartitions(FCPath keyFCPath, FCPath targetFCPath) {
        new DeviceController(this.ui).createManualKeyPartition(keyFCPath, targetFCPath, this.startingLBA, this.endingLBA);
    }

    public void cloneKeyPartition(FCPath keyFCPath, FCPath targetFCPath) {
        new DeviceController(this.ui).cloneKeyPartition(keyFCPath, targetFCPath, this.startingLBA, this.endingLBA);
    }

    public byte[] getBytes(int off, int length) {
        return GPT.getBytesPart(this.getBytes(), off, length);
    }

    public byte[] getBytes() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        for (byte mybyte : this.partitionTypeGUIDBytes) {
            byteList.add(mybyte);
        }
        for (byte mybyte : this.uniquePartitionGUIDBytes) {
            byteList.add(mybyte);
        }
        for (byte mybyte : this.startingLBABytes) {
            byteList.add(mybyte);
        }
        for (byte mybyte : this.endingLBABytes) {
            byteList.add(mybyte);
        }
        for (byte mybyte : this.attributesBytes) {
            byteList.add(mybyte);
        }
        for (byte mybyte : this.partitionNameBytes) {
            byteList.add(mybyte);
        }
        return GPT.byteListToByteArray(byteList);
    }

    public void print() {
        this.ui.log(this.toString(), true, true, true, false, false);
    }

    private void setDesc() {
        this.DESCSTRING = "[ " + this.ENTRYCLASS + " Entry " + this.ENTRYNUMBER + " Pos " + this.pos + " (" + this.getBytes().length + " Bytes) Partition: " + GPT.getHumanSize(this.partSize, 1, "Bytes") + " ]";
    }

    private String getDesc() {
        return this.DESCSTRING;
    }

    public String toString() {
        String returnString = "";
        if (this.startingLBA + this.endingLBA != 0L) {
            if (this.ENTRYNUMBER != 0) {
                returnString = returnString + "\r\n";
            }
            returnString = returnString + "\r\n";
            returnString = returnString + "------------------------------------------------------------------------\r\n";
            returnString = returnString + "\r\n";
            returnString = returnString + this.DESCSTRING + "\r\n";
            returnString = returnString + "\r\n";
            returnString = returnString + String.format("%-25s", "PartttionTypeGUID");
            returnString = returnString + GPT.getHexAndDecimal(this.partitionTypeGUIDBytes, false) + "\r\n";
            returnString = returnString + String.format("%-25s", "UniquePartitionGUID");
            returnString = returnString + GPT.getHexAndDecimal(this.uniquePartitionGUIDBytes, false) + "\r\n";
            returnString = returnString + String.format("%-25s", "StartingLBA");
            returnString = returnString + GPT.getHexAndDecimal(this.startingLBABytes, true) + "\r\n";
            returnString = returnString + String.format("%-25s", "EndingLBA");
            returnString = returnString + GPT.getHexAndDecimal(this.endingLBABytes, true) + "\r\n";
            returnString = returnString + String.format("%-25s", "Attributes");
            returnString = returnString + GPT.getHexAndDecimal(this.attributesBytes, false) + "\r\n";
            returnString = returnString + String.format("%-25s", "PartitionName");
            returnString = returnString + GPT.getHexAndDecimal(this.partitionNameBytes, false) + "\r\n";
        }
        return returnString;
    }
}

