/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.zip.CRC32;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.GPT;
import rdj.UI;

public class GPT_Header {
    private final long ABSTRACT_LBA;
    private String HEADERCLASS;
    private String DESCSTRING;
    private final long LENGTH = DeviceController.bytesPerSector * 1L;
    private byte[] signatureBytes;
    private byte[] revisionBytes;
    private int headerSize;
    private byte[] headerSizeBytes;
    private byte[] headerCRC32Bytes;
    private byte[] reservedBytes;
    private long myLBA;
    private byte[] myLBABytes;
    private long alternateLBA;
    private byte[] alternateLBABytes;
    private long firstUsableLBA;
    private byte[] firstUsableLBABytes;
    private long lastUsableLBA;
    private byte[] lastUsableLBABytes;
    public byte[] diskGUIDBytes;
    private long partitionEntryLBA;
    private byte[] partitionEntryLBABytes;
    public int numberOfPartitionEntries;
    private byte[] numberOfPartitionEntriesBytes;
    public int sizeOfPartitionEntry;
    private byte[] sizeOfPartitionEntryBytes;
    private byte[] crc32PartitionsBytes;
    private byte[] reservedUEFIBytes;
    private boolean littleEndian = true;
    private UI ui;
    private GPT gpt;

    public GPT_Header(UI ui, GPT gpt, long abstractLBA) {
        this.ui = ui;
        this.gpt = gpt;
        this.ABSTRACT_LBA = abstractLBA;
        this.HEADERCLASS = this.ABSTRACT_LBA >= 0L ? "Primary" : "Secondary";
        this.clear();
    }

    public void clear() {
        this.signatureBytes = GPT.hex2Bytes("00 00 00 00 00 00 00 00");
        this.revisionBytes = GPT.hex2Bytes("00 00 00 00");
        this.headerSize = 0;
        this.headerSizeBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.headerSize, 4));
        this.headerCRC32Bytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedBytes = GPT.hex2Bytes("00 00 00 00");
        this.myLBA = 0L;
        this.myLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.myLBA, 8));
        this.alternateLBA = 0L;
        this.alternateLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.alternateLBA, 8));
        this.firstUsableLBA = 0L;
        this.firstUsableLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.firstUsableLBA, 8));
        this.lastUsableLBA = 0L;
        this.lastUsableLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.lastUsableLBA, 8));
        this.diskGUIDBytes = GPT.getZeroBytes(16);
        this.partitionEntryLBA = 0L;
        this.partitionEntryLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(0L, 8));
        this.numberOfPartitionEntries = 0;
        this.numberOfPartitionEntriesBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.numberOfPartitionEntries, 4));
        this.sizeOfPartitionEntry = 0;
        this.sizeOfPartitionEntryBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.sizeOfPartitionEntry, 4));
        this.crc32PartitionsBytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedUEFIBytes = GPT.getZeroBytes(420);
        this.setDesc();
    }

    public void read(FCPath fcPath) {
        byte[] bytes = new byte[(int)this.LENGTH];
        new DeviceController(this.ui);
        bytes = DeviceController.readLBA(fcPath, this.ABSTRACT_LBA, this.LENGTH);
        this.signatureBytes = GPT.getBytesPart(bytes, 0, 8);
        this.revisionBytes = GPT.getBytesPart(bytes, 8, 4);
        this.headerSizeBytes = GPT.getBytesPart(bytes, 12, 4);
        this.headerSize = Integer.reverseBytes(GPT.bytesToInteger(this.headerSizeBytes));
        this.headerCRC32Bytes = GPT.getBytesPart(bytes, 16, 4);
        this.reservedBytes = GPT.getBytesPart(bytes, 20, 4);
        this.myLBABytes = GPT.getBytesPart(bytes, 24, 8);
        this.myLBA = Long.reverseBytes(GPT.bytesToLong(this.myLBABytes));
        this.alternateLBABytes = GPT.getBytesPart(bytes, 32, 8);
        this.alternateLBA = Long.reverseBytes(GPT.bytesToLong(this.alternateLBABytes));
        this.firstUsableLBABytes = GPT.getBytesPart(bytes, 40, 8);
        this.firstUsableLBA = Long.reverseBytes(GPT.bytesToLong(this.firstUsableLBABytes));
        this.lastUsableLBABytes = GPT.getBytesPart(bytes, 48, 8);
        this.lastUsableLBA = Long.reverseBytes(GPT.bytesToLong(this.lastUsableLBABytes));
        this.diskGUIDBytes = GPT.getBytesPart(bytes, 56, 16);
        this.partitionEntryLBABytes = GPT.getBytesPart(bytes, 72, 8);
        this.partitionEntryLBA = Long.reverseBytes(GPT.bytesToLong(this.partitionEntryLBABytes));
        this.numberOfPartitionEntriesBytes = GPT.getBytesPart(bytes, 80, 4);
        this.numberOfPartitionEntries = Integer.reverseBytes(GPT.bytesToInteger(this.numberOfPartitionEntriesBytes));
        this.sizeOfPartitionEntryBytes = GPT.getBytesPart(bytes, 84, 4);
        this.sizeOfPartitionEntry = Integer.reverseBytes(GPT.bytesToInteger(this.sizeOfPartitionEntryBytes));
        this.crc32PartitionsBytes = GPT.getBytesPart(bytes, 88, 4);
        this.reservedUEFIBytes = GPT.getBytesPart(bytes, 92, 420);
        this.setDesc();
    }

    public void create(FCPath targetFCPath) {
        this.signatureBytes = GPT.hex2Bytes("45 46 49 20 50 41 52 54");
        this.revisionBytes = GPT.hex2Bytes("00 00 01 00");
        this.headerSize = 92;
        this.headerSizeBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.headerSize, 4));
        this.headerCRC32Bytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedBytes = GPT.hex2Bytes("00 00 00 00");
        this.myLBA = this.ABSTRACT_LBA >= 0L ? this.ABSTRACT_LBA : targetFCPath.size / DeviceController.bytesPerSector + this.ABSTRACT_LBA;
        this.myLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.myLBA, 8));
        this.alternateLBA = this.ABSTRACT_LBA >= 0L ? targetFCPath.size / DeviceController.bytesPerSector - this.ABSTRACT_LBA : -this.ABSTRACT_LBA;
        this.alternateLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.alternateLBA, 8));
        this.firstUsableLBA = 34L;
        this.firstUsableLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.firstUsableLBA, 8));
        this.lastUsableLBA = targetFCPath.size / DeviceController.bytesPerSector - 34L;
        this.lastUsableLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.lastUsableLBA, 8));
        this.diskGUIDBytes = this.ABSTRACT_LBA >= 0L ? GPT.getUUID() : this.gpt.gpt_Header1.diskGUIDBytes;
        this.partitionEntryLBA = this.ABSTRACT_LBA >= 0L ? 2L : targetFCPath.size / DeviceController.bytesPerSector - 33L;
        this.partitionEntryLBABytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.partitionEntryLBA, 8));
        this.numberOfPartitionEntries = 128;
        this.numberOfPartitionEntriesBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.numberOfPartitionEntries, 4));
        this.sizeOfPartitionEntry = 128;
        this.sizeOfPartitionEntryBytes = GPT.hex2Bytes(GPT.getHexStringLittleEndian(this.sizeOfPartitionEntry, 4));
        this.crc32PartitionsBytes = GPT.hex2Bytes("00 00 00 00");
        this.reservedUEFIBytes = GPT.getZeroBytes(420);
        this.setDesc();
    }

    public void setCRC32Partitions() {
        this.crc32PartitionsBytes = this.getCRC32("GPT_Header1.crc32PartitionsBytes: ", this.gpt.get_GPT_Entries1().getBytes(), this.littleEndian);
    }

    public void setHeaderCRC32Bytes() {
        this.headerCRC32Bytes = this.getCRC32("GPT_Header1.headerCRC32Bytes:\t    ", this.getBytes(0, this.headerSize), this.littleEndian);
    }

    public void write(FCPath fcPath) {
        new DeviceController(this.ui);
        DeviceController.writeLBA(this.getDesc(), this.getBytes(false), fcPath, this.ABSTRACT_LBA);
    }

    public byte[] getBytes(int off, int length) {
        return GPT.getBytesPart(this.getBytes(false), off, length);
    }

    public byte[] getBytes(boolean headerCRC32SetToZeo) {
        ArrayList<Byte> definitiveByteList = new ArrayList<Byte>();
        for (byte mybyte : this.signatureBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.revisionBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.headerSizeBytes) {
            definitiveByteList.add(mybyte);
        }
        if (headerCRC32SetToZeo) {
            for (byte mybyte : GPT.getZeroBytes(4)) {
                definitiveByteList.add(mybyte);
            }
        } else {
            for (byte mybyte : this.headerCRC32Bytes) {
                definitiveByteList.add(mybyte);
            }
        }
        for (byte mybyte : this.reservedBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.myLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.alternateLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.firstUsableLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.lastUsableLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.diskGUIDBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.partitionEntryLBABytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.numberOfPartitionEntriesBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.sizeOfPartitionEntryBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.crc32PartitionsBytes) {
            definitiveByteList.add(mybyte);
        }
        for (byte mybyte : this.reservedUEFIBytes) {
            definitiveByteList.add(mybyte);
        }
        return GPT.byteListToByteArray(definitiveByteList);
    }

    public void print() {
        this.ui.log(this.toString(), true, true, true, false, false);
    }

    private void setDesc() {
        this.DESCSTRING = "[ LBA " + this.ABSTRACT_LBA + " - " + this.HEADERCLASS + " GPT Header (" + this.getBytes(false).length + " Bytes) Storage: " + GPT.getHumanSize(Math.abs(this.lastUsableLBA - this.firstUsableLBA) * DeviceController.bytesPerSector, 1, "Bytes") + " ]";
    }

    private String getDesc() {
        return this.DESCSTRING;
    }

    public String toString() {
        String returnString = "";
        returnString = returnString + "\r\n";
        returnString = returnString + "========================================================================\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + this.DESCSTRING + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + String.format("%-25s", "Signature");
        returnString = returnString + GPT.getHexAndDecimal(this.signatureBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "Revision");
        returnString = returnString + GPT.getHexAndDecimal(this.revisionBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "HeaderSize");
        returnString = returnString + GPT.getHexAndDecimal(this.headerSizeBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "HeaderCRC32");
        returnString = returnString + GPT.getHexAndDecimal(this.headerCRC32Bytes, false) + " " + GPT.getHexString(this.getCRC32("chk: ", this.getBytes(true), this.littleEndian), 2) + " (now)\r\n";
        returnString = returnString + String.format("%-25s", "Reserved");
        returnString = returnString + GPT.getHexAndDecimal(this.reservedBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "MyLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.myLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "AlternateLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.alternateLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "FirstUsableLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.firstUsableLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "LastUsableLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.lastUsableLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "DiskGUID");
        returnString = returnString + GPT.getHexAndDecimal(this.diskGUIDBytes, false) + "\r\n";
        returnString = returnString + String.format("%-25s", "PartitionEntryLBA");
        returnString = returnString + GPT.getHexAndDecimal(this.partitionEntryLBABytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "NumberOfPartitionEntries");
        returnString = returnString + GPT.getHexAndDecimal(this.numberOfPartitionEntriesBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "SizeOfPartitionEntry");
        returnString = returnString + GPT.getHexAndDecimal(this.sizeOfPartitionEntryBytes, true) + "\r\n";
        returnString = returnString + String.format("%-25s", "CRC32Partitions");
        returnString = returnString + GPT.getHexAndDecimal(this.crc32PartitionsBytes, false) + " " + GPT.getHexString(this.getCRC32("chk: ", this.gpt.get_GPT_Entries1().getBytes(), this.littleEndian), 2) + " (now)\r\n";
        returnString = returnString + String.format("%-25s", "Reserved (UEFI)");
        returnString = returnString + GPT.getHexAndDecimal(this.reservedUEFIBytes, false) + "\r\n";
        return returnString;
    }

    private synchronized byte[] getCRC32(String string, byte[] bytes, boolean littleEndian) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        byte[] bigEndianBytes = new byte[4];
        byte[] littleEndianBytes = new byte[4];
        bigEndianBytes = ByteBuffer.allocate(4).putInt((int)crc.getValue()).array();
        littleEndianBytes = GPT.getReverseBytes(ByteBuffer.allocate(4).putInt((int)crc.getValue()).array());
        if (littleEndian) {
            return littleEndianBytes;
        }
        return bigEndianBytes;
    }
}

