/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import java.util.Arrays;

public class Stat {
    private long fileBytesProcessed = 0L;
    private long fileBytesTotal = 0L;
    private long fileStartEpoch = 0L;
    private long fileEndEpoch = 0L;
    private long nanoSeconds = 0L;

    public long getFileBytesProcessed() {
        return this.fileBytesProcessed;
    }

    public long getFileBytesTotal() {
        return this.fileBytesTotal;
    }

    public long getFileStartEpoch() {
        return this.fileStartEpoch;
    }

    public long getFileEndEpoch() {
        return this.fileEndEpoch;
    }

    public long getMSecCounted() {
        return this.nanoSeconds;
    }

    public void setFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed = fileBytesProcessed;
    }

    public void setFileBytesTotal(long fileBytesTotal) {
        this.fileBytesTotal = fileBytesTotal;
    }

    public void setFileStartEpoch() {
        this.fileStartEpoch = System.nanoTime();
    }

    public void setFileEndEpoch() {
        this.fileEndEpoch = System.nanoTime();
    }

    public void clock() {
        this.nanoSeconds += this.fileEndEpoch - this.fileStartEpoch;
    }

    public void setMSecCounted(long param) {
        this.nanoSeconds = param;
    }

    public void addMSecCounted(long param) {
        this.nanoSeconds += param;
    }

    public void addFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed += fileBytesProcessed;
    }

    public void subFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed -= fileBytesProcessed;
    }

    public void addFileBytesTotal(long fileBytesTotal) {
        this.fileBytesTotal += fileBytesTotal;
    }

    public String getFileBytesThroughPut() {
        String returnString = new String();
        double throughput = (double)this.fileBytesProcessed / ((double)this.nanoSeconds / 1.0E9);
        String throughputString = String.format("%.1f", throughput);
        returnString = Stat.getHumanSize(throughput, 1) + "/s";
        return returnString;
    }

    public String getFileBytesProgressPercentage() {
        String returnString = new String();
        double percentage = (double)this.fileBytesProcessed / ((double)this.fileBytesTotal / 100.0);
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        String throughputString = String.format("%.0f", Math.floor(percentage));
        returnString = " " + throughputString + "%\r\n";
        return returnString;
    }

    public static String getHumanSize(double value, int decimals) {
        long factor;
        int x = 0;
        double newValue = value;
        String returnString = new String("");
        ArrayList<String> magnitude = new ArrayList<String>();
        magnitude.addAll(Arrays.asList("ZiB", "EiB", "PiB", "TiB", "GiB", "MiB", "KiB", "Bytes"));
        for (factor = 70L; factor > 0L; factor -= 10L) {
            if (value / Math.pow(2.0, factor) >= 1.0) {
                newValue = value / Math.pow(2.0, factor);
                returnString = String.format("%.1f", newValue) + " " + (String)magnitude.get(x);
                break;
            }
            ++x;
        }
        if (factor == 0L) {
            newValue = value / Math.pow(2.0, factor);
            returnString = String.format("%." + decimals + "f", newValue) + " " + (String)magnitude.get(x);
        }
        return returnString;
    }

    public static String getDecimal(double value, int decimals) {
        return String.format("%." + decimals + "f", value);
    }

    public void reset() {
        this.fileBytesProcessed = 0L;
        this.fileBytesTotal = 0L;
        this.fileStartEpoch = 0L;
        this.fileEndEpoch = 0L;
        this.nanoSeconds = 0L;
    }
}

