/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Random;
import rdj.Audio;
import rdj.AudioPlayer;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.UI;
import rdj.Version;

public class TypeWriter
implements UI {
    private Version version;
    private UI ui = this;
    private String text = "";
    private String sound = "20";
    private boolean soundstate;
    private int mindelay = 20;
    private boolean minset = false;
    private int maxdelay = 100;
    private boolean maxset = false;
    private Random random = new Random();
    private int seq;
    private int randomDelay;

    public TypeWriter() {
        this.version = new Version(this);
        this.version.checkLocalVersion(this);
    }

    public TypeWriter(String[] args) {
        this();
        if (args.length == 0) {
            this.usage("Error: no parameters", true);
        }
        for (int p = 0; p < args.length; ++p) {
            if (args[p].equals("-h")) {
                this.usage("", false);
                continue;
            }
            if (args[p].equals("-t")) {
                if (p + 1 < args.length) {
                    this.text = TypeWriter.reformat(args[p + 1]);
                    ++p;
                    continue;
                }
                this.usage("Error: param -t \"value\" missing!", true);
                continue;
            }
            if (args[p].equals("-s")) {
                if (p + 1 < args.length) {
                    this.sound = args[p + 1];
                    ++p;
                    continue;
                }
                this.usage("Error: param -s \"value\" missing!", true);
                continue;
            }
            if (args[p].equals("-min")) {
                if (p + 1 < args.length) {
                    if (this.isInt(args[p + 1])) {
                        this.mindelay = Integer.parseInt(args[p + 1]);
                        this.minset = true;
                    } else {
                        this.usage("Error: param -min " + args[p + 1] + " invalid", false);
                    }
                    ++p;
                    continue;
                }
                this.usage("Error: param -min \"value\" missing!", true);
                continue;
            }
            if (args[p].equals("-max")) {
                if (p + 1 < args.length) {
                    if (this.isInt(args[p + 1])) {
                        this.maxdelay = Integer.parseInt(args[p + 1]);
                        this.maxset = true;
                    } else {
                        this.usage("Error: param -max " + args[p + 1] + " invalid", false);
                    }
                    ++p;
                    continue;
                }
                this.usage("Error: param -max \"value\" missing!", true);
                continue;
            }
            this.usage("Error: invalid parameter: " + args[p] + "\r\n", true);
        }
        if (!this.minset && !this.maxset) {
            this.mindelay = 20;
            this.maxdelay = 100;
        } else if (!this.minset && this.maxset) {
            this.mindelay = 1;
        } else if (this.minset && !this.maxset) {
            this.maxdelay = this.mindelay;
        }
        if (this.isInt(this.sound) && Integer.parseInt(this.sound) >= Audio.soundArray.length) {
            this.usage("Error: sound: " + this.sound + " not available\r\n\r\n" + Audio.getSounds() + "", true);
        }
        this.write(this.sound);
    }

    public TypeWriter(String text) {
        this();
        this.text = text;
        this.write(this.sound);
    }

    public TypeWriter(String text, int min_delay_ms) {
        this();
        this.text = text;
        this.mindelay = min_delay_ms;
        this.maxdelay = 0;
        this.write("");
    }

    public TypeWriter(String text, int min_delay_ms, int max_delay_ms) {
        this();
        this.text = text;
        this.mindelay = min_delay_ms;
        this.maxdelay = max_delay_ms;
        this.write("");
    }

    public TypeWriter(String text, int min_delay_ms, int max_delay_ms, String sound) {
        this();
        this.text = text;
        this.mindelay = min_delay_ms;
        this.maxdelay = max_delay_ms;
        this.write(sound);
    }

    private void delay() {
        if (this.mindelay > 0 && this.maxdelay > this.mindelay) {
            this.randomDelay = this.random.nextInt(this.maxdelay + 1 - this.mindelay) + this.mindelay;
            try {
                Thread.sleep(this.randomDelay);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
        } else if (this.mindelay > 0) {
            try {
                Thread.sleep(this.mindelay);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
        } else if (this.maxdelay > this.mindelay) {
            try {
                Thread.sleep(this.mindelay + 1);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private void write(String soundParam) {
        this.soundstate = AudioPlayer.sound_Is_Enabled;
        AudioPlayer.sound_Is_Enabled = true;
        String sound = "/rdj/audio/sounds/typewriter";
        int codec = 2;
        if (soundParam.length() == 0) {
            sound = "/rdj/audio/sounds/typewriter";
            codec = 2;
        } else if (this.isInt(soundParam)) {
            if (!soundParam.equals("-1")) {
                sound = Audio.getSound(Integer.parseInt(soundParam));
                codec = 2;
            } else {
                sound = soundParam;
            }
        } else if (Files.exists(Paths.get(soundParam, new String[0]), new LinkOption[0])) {
            sound = soundParam;
        } else {
            this.usage("Error: soundfile: " + soundParam + " dos not exist!", true);
        }
        AudioPlayer player = new AudioPlayer();
        this.seq = 0;
        while (this.seq < this.text.length()) {
            System.out.print(this.text.charAt(this.seq));
            if (this.text.length() > 0 && this.mindelay + this.maxdelay != 0 && !this.text.subSequence(this.seq, this.seq + 1).equals("\r")) {
                if (sound.startsWith("/rdj/audio/")) {
                    player.play(this, sound, codec);
                } else {
                    player.playAudioClipFile(this, sound);
                }
            }
            if (this.mindelay + this.maxdelay != 0 && !this.text.subSequence(this.seq, this.seq + 1).equals("\r")) {
                this.delay();
            }
            ++this.seq;
        }
        if (this.mindelay + this.maxdelay != 0) {
            this.delay();
        }
        if (player != null && player.audioClip != null) {
            while (player.audioClip.isPlaying()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
        AudioPlayer.sound_Is_Enabled = this.soundstate;
    }

    private boolean isInt(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static String reformat(String text) {
        return text.replace("\\t", "\t").replace("\\b", "\b").replace("\\n", "\n").replace("\\r", "\r").replace("\\f", "\f");
    }

    public static void main(String[] args) {
        new TypeWriter(args);
    }

    protected void usage(String errorMessage, boolean error) {
        if (errorMessage.length() > 0) {
            this.log("\r\n", false, true, false, false, false);
            this.log(errorMessage + "\r\n", false, true, false, false, false);
        }
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("Print to screen like a typewriter\r\n");
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("Usage: java -cp finalcrypt.jar rdj/TypeWriter -t \"text to write\" [-s sound-nr|\"file\"] [-min delay_ms] [-max delay_ms]\r\n", 0, 0);
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("Examples\r\n", 0, 0);
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"type at steady pace\" -min 100;\t\t", 0, 0);
        new TypeWriter(" # type at steady pace\r\n", 100);
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"type at random pace\" -min 20 -max 100;\t", 0, 0);
        new TypeWriter(" # type at random pace\r\n", 20, 100);
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"\" -min 1000;\t\t\t\t\t # just pause 1000 ms", 0, 0);
        new TypeWriter("", 1000);
        new TypeWriter("\r\n", 0);
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"\\n\" -min 1000 ;\t\t\t\t # newline with pause", 0, 0);
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("\r\n", 0, 0);
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"built-in sound\" -s 8 -min 20 -max 100;\t", 0, 0);
        new TypeWriter(" # built-in sound\r\n", 20, 100, "8");
        new TypeWriter("java -cp finalcrypt.jar rdj/TypeWriter -t \"ext sound file\" -s file.wav -min 20 -max 100;", 0, 0);
        new TypeWriter(" # ext sound file\r\n", 20, 100, "2");
        new TypeWriter("\r\n");
        System.exit(error ? 1 : 0);
    }

    @Override
    public void test(String message) {
        this.log(message, true, true, false, false, false);
    }

    @Override
    public synchronized void log(String message, boolean status, boolean log, boolean logfile, boolean errfile, boolean print) {
        if (status || log) {
            if (!status && log) {
                this.log(message, errfile);
            } else if ((!status || log) && status && log) {
                this.log(message, errfile);
            }
        }
        if (logfile) {
            this.logfile(message);
        }
        if (errfile) {
            this.errfile(message);
        }
        if (print) {
            this.print(message, errfile);
        }
    }

    public void status(String message) {
    }

    public void log(String message, boolean err) {
        if (!err) {
            System.out.print(message);
        } else {
            System.err.print(message);
        }
    }

    public void logfile(String message) {
    }

    public void errfile(String message) {
    }

    public void print(String message, boolean err) {
        if (!err) {
            System.out.print(message);
        } else {
            System.err.print(message);
        }
    }

    @Override
    public void processGraph(int value) {
    }

    @Override
    public void processProgress(int filesProgressPercent, int fileProgressPercent, long bytesTotalParam, long bytesProcessedParam, double bytesPerMiliSecondParam) {
    }

    @Override
    public void fileProgress() {
    }

    @Override
    public void processFinished(FCPathList<FCPath> openFCPathList, boolean open) {
    }

    @Override
    public void processStarted() {
    }

    @Override
    public void buildReady(FCPathList<FCPath> fcPathListParam, boolean validBuild) {
    }
}

