/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import rdj.DeviceController;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.FinalCrypt;
import rdj.MySimpleFCFileVisitor;
import rdj.UI;

public class Validate {
    private static Path selectedKeyPath;
    public static long bytesCount;
    private static MySimpleFCFileVisitor mySimpleFCFileVisitor;
    private static final Path HOME_DIR;
    private static final Path WORK_DIR;
    public static Path key_Home_Path;

    public static void validateBuild(UI ui, FCPathList<FCPath> targetFCPathList, FCPath keyFCPath, boolean printgpt, boolean deletegpt) {
    }

    public static synchronized boolean isValidDir(UI ui, Path targetDirPath, boolean symlink, boolean report) {
        boolean validdir = true;
        String conditions = "";
        String exist = "";
        String read = "";
        String write = "";
        String symbolic = "";
        if (!Files.exists(targetDirPath, new LinkOption[0])) {
            validdir = false;
            exist = "[not found] ";
            conditions = conditions + exist;
        }
        if (!Files.isReadable(targetDirPath)) {
            validdir = false;
            read = "[not readable] ";
            conditions = conditions + read;
        }
        if (!Files.isWritable(targetDirPath)) {
            validdir = false;
            write = "[not writable] ";
            conditions = conditions + write;
        }
        if (!symlink && Files.isSymbolicLink(targetDirPath)) {
            validdir = false;
            symbolic = "[symlink]";
            conditions = conditions + symbolic;
        }
        if (!validdir && report) {
            ui.log("Warning: skipping dir: " + targetDirPath.toString() + ": " + conditions + "\r\n", false, false, true, false, false);
        }
        return validdir;
    }

    public static synchronized boolean isValidFile(UI ui, String caller, Path path, boolean isKey, boolean device, long minSize, boolean symlink, boolean writable, boolean report) {
        boolean validfile = true;
        String conditions = "";
        String size = "";
        String exist = "";
        String dir = "";
        String read = "";
        String write = "";
        String symbolic = "";
        String key = "";
        if (!Files.exists(path, new LinkOption[0])) {
            validfile = false;
            exist = "[not found] ";
            conditions = conditions + exist;
        } else {
            if (Files.isDirectory(path, new LinkOption[0])) {
                validfile = false;
                dir = "[is directory] ";
                conditions = conditions + dir;
            }
            long fileSize = 0L;
            if (device) {
                fileSize = 0L;
                fileSize = DeviceController.getDeviceSize(ui, path, isKey);
            } else {
                fileSize = 0L;
                try {
                    fileSize = Files.size(path);
                }
                catch (IOException ex) {
                    ui.log("Error: Validate: IOException: Files.size(" + path.toAbsolutePath().toString() + ") Size: " + fileSize + "<" + minSize + " " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
            }
            if (fileSize < minSize) {
                validfile = false;
                size = path.toAbsolutePath().toString() + " smaller than " + minSize + " byte ";
                conditions = conditions + size;
            }
            if (!Files.isReadable(path)) {
                validfile = false;
                read = "[not readable] ";
                conditions = conditions + read;
            }
            if (!isKey && writable && !Files.isWritable(path)) {
                validfile = false;
                write = "[not writable] ";
                conditions = conditions + write;
            }
            if (!symlink && Files.isSymbolicLink(path)) {
                validfile = false;
                symbolic = "[symlink] ";
                conditions = conditions + symbolic;
            }
        }
        if (!validfile && report) {
            ui.log("Warning: " + path.toAbsolutePath().toString() + ": " + conditions + "\r\n", true, true, false, false, false);
        }
        return validfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized int targetSourceHasMAC(UI ui, Path targetSourcePath) {
        boolean targetSourceHasMAC = false;
        int macVersion = 0;
        ByteBuffer plainTextMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        plainTextMACBuffer.clear();
        ByteBuffer encryptedMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        encryptedMACBuffer.clear();
        long readTargetSourceChannelTransfered = 0L;
        try (SeekableByteChannel readTargetSourceChannel = Files.newByteChannel(targetSourcePath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
            readTargetSourceChannelTransfered = readTargetSourceChannel.read(plainTextMACBuffer);
            plainTextMACBuffer.flip();
            if (readTargetSourceChannelTransfered != (long)plainTextMACBuffer.capacity()) {
                int n = 0;
                return n;
            }
            readTargetSourceChannel.close();
        }
        catch (IOException ex) {
            ui.log("Error: targetSourceHasMAC: readTargetSourceChannel " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        String plainTextMACString = new String(plainTextMACBuffer.array(), StandardCharsets.UTF_8);
        if (plainTextMACString.equals("FinalCrypt - File Encryption Program - Plain Text Authentication Token")) {
            return 1;
        }
        if (plainTextMACString.equals("FinalCrypt - File Encryption Program - Plain Text Auth Token Version 2")) {
            return 2;
        }
        if (!plainTextMACString.equals("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003")) return 0;
        return 3;
    }

    public static synchronized boolean targetHasAuthenticatedMAC(UI ui, Path targetSourcePath, Path keySourcePath, int macVersion) {
        Throwable throwable;
        if (macVersion == 1) {
            FinalCrypt.resetPwdPos();
        } else {
            FinalCrypt.resetPwdBytesPos();
        }
        boolean readTargetSourceChannelError = false;
        boolean keyAuthenticatedTargetSource = false;
        ByteBuffer targetSrcMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length() * 2);
        targetSrcMACBuffer.clear();
        ByteBuffer targetPlainTextMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        targetPlainTextMACBuffer.clear();
        ByteBuffer targetEncryptedMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        targetEncryptedMACBuffer.clear();
        ByteBuffer keySourceBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        keySourceBuffer.clear();
        ByteBuffer keyDecryptedMACBuffer = ByteBuffer.allocate("FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        keyDecryptedMACBuffer.clear();
        long readTargetSourceChannelPosition = 0L;
        long readTargetSourceChannelTransfered = 0L;
        long readKeySourceChannelPosition = 0L;
        long readKeySourceChannelTransfered = 0L;
        try {
            throwable = null;
            try (SeekableByteChannel readTargetSourceChannel = Files.newByteChannel(targetSourcePath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                readTargetSourceChannel.read(targetSrcMACBuffer);
                targetSrcMACBuffer.flip();
                readTargetSourceChannel.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ex) {
            readTargetSourceChannelError = true;
            ui.log("Error: targetHasAuthenticatedMAC: readTargetSourceChannel " + ex.getMessage() + "\r\n", true, true, true, true, false);
        }
        targetPlainTextMACBuffer.put(targetSrcMACBuffer.array(), 0, "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        targetPlainTextMACBuffer.flip();
        targetEncryptedMACBuffer.put(targetSrcMACBuffer.array(), "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length(), "FinalCrypt - One Time Pad File Encryption - Plain Text MAC Version 003".length());
        targetEncryptedMACBuffer.flip();
        if (!readTargetSourceChannelError) {
            if (!Files.isDirectory(keySourcePath, new LinkOption[0])) {
                try {
                    throwable = null;
                    try (SeekableByteChannel readKeySourceChannel = Files.newByteChannel(keySourcePath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                        readKeySourceChannel.read(keySourceBuffer);
                        keySourceBuffer.flip();
                        readKeySourceChannel.close();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ex) {
                    ui.log("Error: targetHasAuthenticatedMAC readKeySourceChannel " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
                keyDecryptedMACBuffer = FinalCrypt.encryptBuffer(targetEncryptedMACBuffer, keySourceBuffer, macVersion, false);
                String keyDecryptedMACBufferString = new String(keyDecryptedMACBuffer.array(), StandardCharsets.UTF_8);
                keyAuthenticatedTargetSource = keyDecryptedMACBufferString.equals(StandardCharsets.UTF_8.decode(targetPlainTextMACBuffer).toString());
            } else {
                Path autoKeyPath = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", ""));
                if (Files.exists(autoKeyPath, LinkOption.NOFOLLOW_LINKS)) {
                    try (SeekableByteChannel readKeySourceChannel = Files.newByteChannel(autoKeyPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                        readKeySourceChannel.read(keySourceBuffer);
                        keySourceBuffer.flip();
                        readKeySourceChannel.close();
                    }
                    catch (IOException ex) {
                        ui.log("Error: targetHasAuthenticatedMAC readKeySourceChannel " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                    keyDecryptedMACBuffer = FinalCrypt.encryptBuffer(targetEncryptedMACBuffer, keySourceBuffer, macVersion, false);
                    String keyDecryptedMACBufferString = new String(keyDecryptedMACBuffer.array(), StandardCharsets.UTF_8);
                    keyAuthenticatedTargetSource = keyDecryptedMACBufferString.equals(StandardCharsets.UTF_8.decode(targetPlainTextMACBuffer).toString());
                } else {
                    keyAuthenticatedTargetSource = false;
                }
            }
        } else {
            keyAuthenticatedTargetSource = false;
        }
        if (macVersion == 1) {
            FinalCrypt.resetPwdPos();
        } else {
            FinalCrypt.resetPwdBytesPos();
        }
        return keyAuthenticatedTargetSource;
    }

    public static synchronized Boolean getTargetReadAutoKeyMatched(UI ui, Path targetSourcePath, long targetSourceSize, Path keySourcePath) {
        Boolean autoKeyMatched = false;
        if (keySourcePath == null) {
            return false;
        }
        if (!Files.isDirectory(keySourcePath, new LinkOption[0])) {
            autoKeyMatched = Files.exists(keySourcePath, LinkOption.NOFOLLOW_LINKS) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        } else {
            Path autoKeyPath1 = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", ""));
            Path autoKeyPath2 = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", "") + ".bit");
            autoKeyMatched = Files.exists(autoKeyPath1, LinkOption.NOFOLLOW_LINKS) ? Boolean.valueOf(true) : (Files.exists(autoKeyPath2, LinkOption.NOFOLLOW_LINKS) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return autoKeyMatched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized long getTargetReadAutoKeySizeMatched(UI ui, Path targetSourcePath, long targetSourceSize, Path keySourcePath) {
        long existingReadAutoKeySize = 0L;
        long readAutoKeySize = 0L;
        if (keySourcePath == null) {
            return 0L;
        }
        if (!Files.isDirectory(keySourcePath, new LinkOption[0])) {
            if (!Files.exists(keySourcePath, LinkOption.NOFOLLOW_LINKS)) return 0L;
            try {
                return Files.size(keySourcePath);
            }
            catch (IOException ex) {
                ui.log("Error: IOException: existingReadAutoKeySize = Files.size(keySourcePath): " + ex.getMessage() + "\r\n", true, true, true, true, false);
            }
            return existingReadAutoKeySize;
        } else {
            Path autoKeyPath1 = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", ""));
            Path autoKeyPath2 = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", "") + ".bit");
            if (Files.exists(autoKeyPath1, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    return Files.size(autoKeyPath1);
                }
                catch (IOException ex) {
                    ui.log("Error: IOException: getTargetKeySizeRequired(..): Files.size() " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
                return existingReadAutoKeySize;
            } else {
                if (!Files.exists(autoKeyPath2, LinkOption.NOFOLLOW_LINKS)) return 0L;
                try {
                    return Files.size(autoKeyPath2);
                }
                catch (IOException ex) {
                    ui.log("Error: IOException: getTargetKeySizeRequired(..): Files.size() " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
            }
        }
        return existingReadAutoKeySize;
    }

    public static synchronized long getTargetWriteAutoKeySizeRequired(UI ui, Path targetSourcePath, long targetSourceSize, Path keySourcePath) {
        long writeAutoKeySize = 0L;
        if (keySourcePath == null) {
            return 0L;
        }
        if (!Files.isDirectory(keySourcePath, new LinkOption[0])) {
            return 0L;
        }
        Path autoKeyPath = Paths.get(keySourcePath.toAbsolutePath().toString(), targetSourcePath.toAbsolutePath().toString().replace(":", "") + ".bit");
        writeAutoKeySize = Files.exists(autoKeyPath, LinkOption.NOFOLLOW_LINKS) ? targetSourceSize + (long)FCPath.MAC_SIZE : targetSourceSize + (long)FCPath.MAC_SIZE;
        return writeAutoKeySize;
    }

    public static void buildSelection(UI ui, ArrayList<Path> pathList, FCPath keyFCPath, FCPathList<FCPath> targetFCPathList, boolean symlink, String pattern, boolean negatePattern, boolean disabledMAC, boolean status) {
        mySimpleFCFileVisitor = new MySimpleFCFileVisitor(ui, false, 1, symlink, true, keyFCPath, targetFCPathList, pattern, negatePattern, disabledMAC);
        for (Path path : pathList) {
            try {
                Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS, FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, mySimpleFCFileVisitor);
            }
            catch (IOException e) {
                ui.log("Error: Validate.buildSelection: Files.walkFileTree(path, EnumSet.of(..) " + e.getMessage() + "\r\n", true, true, true, true, false);
            }
        }
        MySimpleFCFileVisitor.running = false;
        ui.buildReady(targetFCPathList, true);
    }

    public static synchronized String getHumanSize(double value, int decimals, String unit) {
        long factor;
        int x = 0;
        double newValue = value;
        String returnString = new String("");
        ArrayList<String> magnitude = new ArrayList<String>();
        magnitude.addAll(Arrays.asList("Zi" + unit.charAt(0), "Ei" + unit.charAt(0), "Pi" + unit.charAt(0), "Ti" + unit.charAt(0), "Gi" + unit.charAt(0), "Mi" + unit.charAt(0), "Ki" + unit.charAt(0), unit));
        for (factor = 70L; factor > 0L; factor -= 10L) {
            if (value / Math.pow(2.0, factor) >= 1.0) {
                newValue = value / Math.pow(2.0, factor);
                returnString = String.format("%.1f", newValue) + " " + (String)magnitude.get(x);
                break;
            }
            ++x;
        }
        if (factor == 0L) {
            newValue = value / Math.pow(2.0, factor);
            returnString = String.format("%." + decimals + "f", newValue) + " " + (String)magnitude.get(x);
        }
        return returnString;
    }

    public static int getFCPathType(Path path) {
        int returnFCPathType = 0;
        if (path.toAbsolutePath().toString().startsWith("/dev/")) {
            returnFCPathType = path.toAbsolutePath().toString().startsWith("/dev/hd") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) ? 5 : (!path.getFileName().endsWith("hda") ? 4 : 7)) : (path.toAbsolutePath().toString().startsWith("/dev/sd") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) ? 5 : (!path.getFileName().endsWith("sda") ? 4 : 7)) : (path.toAbsolutePath().toString().startsWith("/dev/mmcblk") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) && String.valueOf(path.getFileName().toString().charAt(path.getFileName().toString().length() - 2)).equalsIgnoreCase("p") ? 5 : (!path.getFileName().toString().endsWith("mmcblk0") ? 4 : 4)) : (path.toAbsolutePath().toString().startsWith("/dev/nvme") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) && String.valueOf(path.getFileName().toString().charAt(path.getFileName().toString().length() - 2)).equalsIgnoreCase("p") ? 5 : (!path.getFileName().toString().endsWith("nvme0n1") ? 4 : 7)) : (path.toAbsolutePath().toString().startsWith("/dev/disk") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) && String.valueOf(path.getFileName().toString().charAt(path.getFileName().toString().length() - 2)).equalsIgnoreCase("s") ? 5 : (!path.getFileName().toString().endsWith("disk0") ? 4 : 7)) : (path.toAbsolutePath().toString().startsWith("/dev/ada") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) && String.valueOf(path.getFileName().toString().charAt(path.getFileName().toString().length() - 2)).equalsIgnoreCase("p") ? 5 : (!path.getFileName().toString().endsWith("ada0") ? 4 : 7)) : (path.toAbsolutePath().toString().startsWith("/dev/da") ? (Character.isDigit(path.getFileName().toString().charAt(path.getFileName().toString().length() - 1)) && String.valueOf(path.getFileName().toString().charAt(path.getFileName().toString().length() - 2)).equalsIgnoreCase("p") ? 5 : (!path.getFileName().toString().endsWith("da0") ? 4 : 4)) : 6))))));
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            returnFCPathType = 2;
        } else if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            returnFCPathType = 1;
        } else if (Files.isSymbolicLink(path)) {
            returnFCPathType = 3;
        }
        return returnFCPathType;
    }

    public static synchronized FCPath getFCPath(UI ui, String caller, Path path, boolean isKey, Path keyPath, boolean disabledMAC, boolean report) {
        boolean exist = false;
        int type = 0;
        long size = 0L;
        boolean readable = false;
        boolean writable = false;
        boolean isHidden = false;
        boolean matchKey = false;
        boolean isValid = false;
        boolean isValidPath = false;
        boolean isValidFile = false;
        boolean isValidDevice = false;
        boolean isValidDeviceProtected = false;
        boolean isValidPartition = false;
        boolean isDecrypted = false;
        boolean isEncryptable = false;
        boolean needsWriteAutoKey = false;
        long needsWriteAutoKeySize = 0L;
        boolean matchedReadAutoKey = false;
        long matchedReadAutoKeySize = 0L;
        boolean unmatchedReadAutoKey = false;
        long unmatchedReadAutoKeySize = 0L;
        boolean isNewEncrypted = false;
        boolean isUnEncryptable = false;
        boolean isEncrypted = false;
        int macVersion = 0;
        boolean isDecryptable = false;
        boolean isNewDecrypted = false;
        boolean isUnDecryptable = false;
        boolean isValidKey = false;
        boolean isValidKeyDir = false;
        String errorDesc = "";
        if (Files.exists(path = path.normalize(), LinkOption.NOFOLLOW_LINKS)) {
            exist = true;
            type = Validate.getFCPathType(path);
            if (exist) {
                if (type == 5 || type == 4 || type == 7) {
                    size = DeviceController.getDeviceSize(ui, path, isKey);
                } else if (exist && type == 1) {
                    try {
                        size = Files.size(path);
                    }
                    catch (IOException ex) {
                        ui.log("Error: IOException: Validate.getFCPath: Files.size() " + ex.getMessage() + "\r\n", true, true, true, true, false);
                    }
                }
            }
            readable = Files.isReadable(path);
            writable = Files.isWritable(path);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                try {
                    isHidden = Files.isHidden(path);
                }
                catch (IOException ex) {
                    ui.log("Error: IOException: Validate.getFCPath: Files.isHidden(path) " + ex.getMessage() + "\r\n", true, true, true, true, false);
                }
            }
            if (isKey) {
                if (exist && type == 2 && readable && writable) {
                    isValid = true;
                    isValidPath = true;
                    isValidKeyDir = true;
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                } else {
                    isValid = false;
                    isValidPath = false;
                    isValidKeyDir = false;
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                }
                boolean tmpValid = true;
                if (type != 2) {
                    if (!readable) {
                        tmpValid = false;
                        errorDesc = errorDesc + "Warning: Key File: \"" + path.toAbsolutePath().toString() + "\" not readable!\r\n";
                    }
                    if (!writable) {
                        tmpValid = false;
                        errorDesc = errorDesc + "Warning: Key File: \"" + path.toAbsolutePath().toString() + "\" not writable!\r\n";
                    }
                } else {
                    if (!readable) {
                        tmpValid = false;
                        errorDesc = errorDesc + "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" not readable!\r\n";
                    }
                    if (!writable) {
                        tmpValid = false;
                        errorDesc = errorDesc + "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" not writable!\r\n";
                    }
                }
                if (path.toAbsolutePath().toString().equals(Paths.get("/", new String[0]).toAbsolutePath().toString())) {
                    tmpValid = false;
                    errorDesc = "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" equals Root directory!\r\n";
                }
                if (path.toAbsolutePath().compareTo(HOME_DIR.toAbsolutePath()) == 0) {
                    tmpValid = false;
                    errorDesc = "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" equals Home directory!\r\n";
                }
                if (path.toAbsolutePath().compareTo(WORK_DIR.toAbsolutePath()) == 0) {
                    tmpValid = false;
                    errorDesc = "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" equals Work directory!\r\n";
                }
                if (path.toAbsolutePath().compareTo(key_Home_Path.toAbsolutePath()) == 0) {
                    tmpValid = false;
                    errorDesc = "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" equals Home directory!\r\n";
                }
                if (path.toAbsolutePath().compareTo(Paths.get(HOME_DIR.toAbsolutePath().toString(), "Desktop").toAbsolutePath()) == 0) {
                    tmpValid = false;
                    errorDesc = "Warning: Key Directory: \"" + path.toAbsolutePath().toString() + "\" equals Desktop directory!\r\n";
                }
                if (tmpValid) {
                    isValid = true;
                    isValidPath = true;
                    isValidKeyDir = true;
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                } else {
                    isValid = false;
                    isValidPath = false;
                    isValidKeyDir = false;
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                }
                if (disabledMAC) {
                    if (exist && size >= (long)FCPath.KEY_SIZE_MIN && readable) {
                        isValid = true;
                        isValidKey = true;
                    } else {
                        isValid = false;
                        isUnEncryptable = true;
                        isUnDecryptable = true;
                    }
                } else if (exist && size >= (long)FCPath.KEY_SIZE_MIN && size >= (long)FCPath.MAC_SIZE && readable) {
                    isValid = true;
                    isValidKey = true;
                } else {
                    isValid = false;
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                }
            } else if (exist && size > 0L && readable && writable) {
                isValid = true;
            } else {
                isValid = false;
                isUnEncryptable = true;
                isUnDecryptable = true;
                if (!readable) {
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                }
                if (!writable) {
                    isUnEncryptable = true;
                    isUnDecryptable = true;
                }
            }
            if (isValid && type == 1) {
                isValidFile = true;
            } else {
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
            }
            if (isValid && type == 7 && size >= (long)FCPath.KEY_SIZE_MIN) {
                isValidDeviceProtected = true;
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
            }
            if (isValid && type == 4 && size >= (long)FCPath.KEY_SIZE_MIN) {
                isValidDevice = true;
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
            }
            if (isValid && type == 5 && size >= (long)FCPath.KEY_SIZE_MIN) {
                isValidPartition = true;
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
            }
            if (isValidFile && (isEncrypted = (macVersion = Validate.targetSourceHasMAC(ui, path)) != 0) && size > (long)FCPath.MAC_SIZE) {
                if (keyPath != null) {
                    if (Files.exists(keyPath, LinkOption.NOFOLLOW_LINKS)) {
                        isDecryptable = Validate.targetHasAuthenticatedMAC(ui, path, keyPath, macVersion);
                        if (!isKey) {
                            matchedReadAutoKey = Validate.getTargetReadAutoKeyMatched(ui, path, size, keyPath);
                            matchedReadAutoKeySize = Validate.getTargetReadAutoKeySizeMatched(ui, path, size, keyPath);
                            if (matchedReadAutoKeySize > 0L) {
                                matchedReadAutoKey = true;
                            }
                            boolean bl = unmatchedReadAutoKey = !matchedReadAutoKey;
                            if (unmatchedReadAutoKey) {
                                unmatchedReadAutoKeySize = size + (long)FCPath.MAC_SIZE;
                            }
                        }
                    } else {
                        isDecryptable = false;
                        matchedReadAutoKey = false;
                        unmatchedReadAutoKey = true;
                        unmatchedReadAutoKeySize = size + (long)FCPath.MAC_SIZE;
                    }
                } else {
                    isDecryptable = false;
                    matchedReadAutoKey = false;
                    unmatchedReadAutoKey = true;
                    unmatchedReadAutoKeySize = size + (long)FCPath.MAC_SIZE;
                }
            }
            if (isValidFile && isEncrypted && !isDecryptable) {
                isEncrypted = true;
                isDecryptable = false;
                isDecrypted = false;
                isEncryptable = false;
                isUnEncryptable = true;
                isUnDecryptable = true;
            }
            if (isValidFile && isEncrypted && isDecryptable) {
                isEncrypted = true;
                isDecryptable = true;
                isDecrypted = false;
                isEncryptable = false;
                isUnEncryptable = true;
                isUnDecryptable = false;
                if (!isKey && (matchedReadAutoKeySize = Validate.getTargetReadAutoKeySizeMatched(ui, path, size, keyPath)) > 0L) {
                    matchedReadAutoKey = true;
                }
            }
            if (isValidFile && !isEncrypted) {
                isDecrypted = true;
                isUnEncryptable = false;
                isDecryptable = false;
                isEncryptable = true;
                isUnDecryptable = true;
                if (isEncryptable && !isKey && (needsWriteAutoKeySize = Validate.getTargetWriteAutoKeySizeRequired(ui, path, size, keyPath)) > 0L) {
                    needsWriteAutoKey = true;
                }
                if (!isKey && (matchedReadAutoKeySize = Validate.getTargetReadAutoKeySizeMatched(ui, path, size, keyPath)) > 0L) {
                    matchedReadAutoKey = true;
                }
            }
            if (keyPath != null && path.compareTo(keyPath) == 0) {
                matchKey = true;
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
            }
            if (isKey && exist) {
                isEncryptable = false;
                isUnEncryptable = true;
                isDecryptable = false;
                isUnDecryptable = true;
                if (disabledMAC) {
                    if ((type == 1 || type == 5 || type == 4 || type == 7) && size >= (long)FCPath.KEY_SIZE_MIN && readable) {
                        isValidKey = true;
                    }
                } else if ((type == 1 || type == 5 || type == 4 || type == 7) && size >= (long)FCPath.KEY_SIZE_MIN && size >= (long)FCPath.MAC_SIZE && readable) {
                    isValidKey = true;
                }
            }
        }
        FCPath fcPath = new FCPath(path, exist, type, size, readable, writable, isHidden, matchKey, isValid, isValidFile, isValidDeviceProtected, isValidDevice, isValidPartition, isKey, isValidKey, isValidKeyDir, isDecrypted, isEncryptable, needsWriteAutoKey, needsWriteAutoKeySize, matchedReadAutoKey, matchedReadAutoKeySize, unmatchedReadAutoKey, unmatchedReadAutoKeySize, isNewEncrypted, isUnEncryptable, isEncrypted, macVersion, isDecryptable, isNewDecrypted, isUnDecryptable, errorDesc);
        return fcPath;
    }

    public static synchronized String getFCPathStatus(FCPath fcPath) {
        String returnString = "";
        returnString = returnString + String.format("%-2s%-40s%-3s%-6s%-3s%-17s%-3s%-12s%-3s%-9s%-3s%-6s%-2s\r\n", "|-", "----------------------------------------", "-|-", "------", "-|-", "-----------------", "-|-", "------------", "-|-", "---------", "-|-", "------", "-|");
        returnString = returnString + String.format("%-2s%-40s%-3s%-6s%-3s%-17s%-3s%-12s%-3s%-9s%-3s%-6s%-2s\r\n", "| ", "Path", " | ", "Exist ", " | ", "Type", " | ", "Size", " | ", "Readable ", " | ", "Valid ", " |");
        returnString = returnString + String.format("%-2s%-40s%-3s%-6s%-3s%-17s%-3s%-12s%-3s%-9s%-3s%-6s%-2s\r\n", "|-", "----------------------------------------", "-|-", "------", "-|-", "-----------------", "-|-", "------------", "-|-", "---------", "-|-", "------", "-|");
        returnString = returnString + String.format("%-2s%-40s%-3s%-6s%-3s%-17s%-3s%-12s%-3s%-9s%-3s%-6s%-2s\r\n", "| ", fcPath.path.toAbsolutePath().toString(), " | ", Validate.b(fcPath.exist), " | ", Validate.t(fcPath.type), " | ", Validate.s(fcPath.size), " | ", Validate.b(fcPath.isReadable), " | ", Validate.b(fcPath.isValidKey), " |");
        returnString = returnString + String.format("%-2s%-40s%-3s%-6s%-3s%-17s%-3s%-12s%-3s%-9s%-3s%-6s%-2s\r\n", "|-", "----------------------------------------", "-|-", "------", "-|-", "-----------------", "-|-", "------------", "-|-", "---------", "-|-", "------", "-|");
        return returnString;
    }

    private static String b(boolean b) {
        return Boolean.toString(b);
    }

    private static String t(int t) {
        return FCPath.getTypeString(t);
    }

    private static String s(long s) {
        return Validate.getHumanSize(s, 1, "Bytes");
    }

    static {
        HOME_DIR = Paths.get(System.getProperty("user.home"), new String[0]);
        WORK_DIR = Paths.get(System.getProperty("user.dir"), new String[0]);
        key_Home_Path = HOME_DIR;
    }
}

