/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rdj.Configuration;
import rdj.ConsoleEraser;
import rdj.DeviceManager;
import rdj.FCPath;
import rdj.FCPathList;
import rdj.FinalCrypt;
import rdj.GPT;
import rdj.GUIFX;
import rdj.RNG;
import rdj.Stats;
import rdj.TestListReaderThread;
import rdj.TestListReaderTimeoutThread;
import rdj.TypeWriter;
import rdj.UI;
import rdj.UsageReaderThread;
import rdj.UsageReaderTimeoutThread;
import rdj.Validate;
import rdj.Version;

public class CLUI
implements UI {
    protected FinalCrypt finalCrypt;
    private Version version;
    private UI ui = this;
    private final Configuration configuration;
    private boolean symlink = false;
    private boolean verbose = false;
    private boolean scan = false;
    private boolean dictionary = false;
    private String dictionaryFilePathString = "";
    private boolean encrypt = false;
    private boolean decrypt = false;
    private boolean createManualKeyDev = false;
    private boolean createManualKeyFile = false;
    private boolean clonekeydev = false;
    private boolean key_checksum = false;
    private boolean printgpt = false;
    private boolean deletegpt = false;
    protected FCPathList<FCPath> decryptedList;
    protected FCPathList<FCPath> encryptableList;
    protected FCPathList<FCPath> readAutoKeyList;
    protected FCPathList<FCPath> writeAutoKeyList;
    protected FCPathList<FCPath> missingAutoKeyList;
    protected FCPathList<FCPath> encryptedList;
    protected FCPathList<FCPath> decryptableList;
    protected FCPathList<FCPath> emptyList;
    protected FCPathList<FCPath> symlinkList;
    protected FCPathList<FCPath> unreadableList;
    protected FCPathList<FCPath> unwritableList;
    protected FCPathList<FCPath> hiddenList;
    protected FCPathList<FCPath> newEncryptedList;
    protected FCPathList<FCPath> unencryptableList;
    protected FCPathList<FCPath> newDecryptedList;
    protected FCPathList<FCPath> undecryptableList;
    protected FCPathList<FCPath> invalidFilesList;
    protected FCPathList<FCPath> createManualKeyList;
    protected FCPathList<FCPath> cloneManualKeyList;
    private boolean encryptablesFound = false;
    private boolean decryptablesFound = false;
    private boolean createManualKeyDeviceFound = false;
    private boolean cloneManualKeyDeviceFound = false;
    private FCPathList<FCPath> printGPTTargetList;
    private boolean printGPTDeviceFound;
    private boolean deleteGPTDeviceFound;
    private FCPathList<FCPath> deleteGPTTargetList;
    protected FCPathList<FCPath> targetFCPathList;
    private boolean keySourceChecksumReadEnded = false;
    private int bufferSize;
    private Long totalTranfered;
    private Long filesizeInBytes = 0x6400000L;
    private Path keyPath;
    private boolean encryptModeNeeded;
    protected UsageReaderTimeoutThread usageReaderTimeoutThread;
    protected TestListReaderTimeoutThread testListReaderTimeoutThread;
    protected boolean testListAborted = true;
    private UsageReaderThread usageReaderThread;
    private TestListReaderThread testListReaderThread;
    private String pwd = "";
    private byte[] pwdBytes;
    private boolean pwdPromptNeeded = false;
    private boolean pwdIsSet = false;
    protected boolean test = false;
    protected String testAnswer = "";
    protected FCPath keyFCPath;
    protected FCPath bruteForceFCPathTargetPrint;
    private long bfcounter;
    private long bflines;
    private Stats bruteForceDataStats;

    public CLUI(String[] args) {
        MessageDigest messageDigest;
        Throwable throwable;
        boolean tfset = false;
        boolean tfsetneeded = false;
        boolean kfset = false;
        boolean kfsetneeded = true;
        boolean validInvocation = true;
        boolean negatePattern = false;
        ArrayList<Path> targetPathList = new ArrayList<Path>();
        ArrayList extendedTargetPathList = new ArrayList();
        Object batchFilePath = null;
        Object dictionaryFilePath = null;
        String dictionaryFilePathString = "";
        this.keyFCPath = null;
        Object outputFilePath = null;
        this.configuration = new Configuration(this);
        this.version = new Version(this);
        this.version.checkLocalVersion(this);
        String pattern = "glob:*";
        this.finalCrypt = new FinalCrypt(this);
        this.finalCrypt.start();
        this.finalCrypt.setBufferSize(this.finalCrypt.getBufferSizeDefault());
        this.pwdBytes = new byte[0];
        this.log(Version.getSysEnv(this.getClass().getSimpleName(), this.version, this.configuration), false, false, true, false, false);
        if (args.length == 0) {
            this.log("\r\nWarning: No parameters entered!\r\n", false, true, true, false, false);
            this.usagePrompt(true);
        }
        for (int paramCnt = 0; paramCnt < args.length; ++paramCnt) {
            if (args[paramCnt].equals("-h") || args[paramCnt].equals("--help")) {
                this.usage(false);
                continue;
            }
            if (args[paramCnt].equals("--examples")) {
                this.examples();
                continue;
            }
            if (args[paramCnt].equals("--typewriter")) {
                this.typewriter(args);
                continue;
            }
            if (args[paramCnt].equals("--reuse-keys")) {
                this.finalCrypt.reuseKeys = true;
                continue;
            }
            if (args[paramCnt].equals("--disable-MAC")) {
                FinalCrypt.disabledMAC = true;
                FCPath.KEY_SIZE_MIN = 1;
                this.encryptModeNeeded = true;
                continue;
            }
            if (args[paramCnt].equals("--scan")) {
                this.scan = true;
                continue;
            }
            if (args[paramCnt].equals("--encrypt")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.encrypt = true;
                kfsetneeded = true;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--decrypt")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.decrypt = true;
                kfsetneeded = true;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("-p") || args[paramCnt].equals("--password")) {
                MessageDigest messageDigest2 = null;
                try {
                    messageDigest2 = MessageDigest.getInstance("SHA-256");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", true, true, true, true, false);
                }
                messageDigest2.update(this.pwd.getBytes());
                byte[] byArray = messageDigest2.digest();
                this.pwdBytes = GPT.hex2Bytes(GUIFX.getHexString(byArray, 2));
                this.pwd = args[paramCnt + 1];
                this.pwdIsSet = true;
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-pd") || args[paramCnt].equals("--password-dictionary")) {
                dictionaryFilePathString = args[paramCnt + 1];
                this.dictionary = true;
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-pp") || args[paramCnt].equals("--password-prompt")) {
                this.pwdPromptNeeded = true;
                continue;
            }
            if (args[paramCnt].equals("--create-keydev")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.createManualKeyDev = true;
                kfsetneeded = true;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--create-keyfile")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.createManualKeyFile = true;
                kfsetneeded = false;
                tfsetneeded = false;
                continue;
            }
            if (args[paramCnt].equals("--clone-keydev")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.clonekeydev = true;
                kfsetneeded = true;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--key-chksum")) {
                this.key_checksum = true;
                kfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--no-key-size")) {
                FCPath.KEY_SIZE_MIN = 1;
                continue;
            }
            if (args[paramCnt].equals("--print-gpt")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.printgpt = true;
                kfsetneeded = false;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--delete-gpt")) {
                if (this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt) continue;
                this.deletegpt = true;
                kfsetneeded = false;
                tfsetneeded = true;
                continue;
            }
            if (args[paramCnt].equals("--print")) {
                this.finalCrypt.setPrint_Vertical(true);
                continue;
            }
            if (args[paramCnt].equals("--print-vertical")) {
                this.finalCrypt.setPrint_Vertical(true);
                continue;
            }
            if (args[paramCnt].equals("--print-horizontal")) {
                this.finalCrypt.setPrint_Horizontal(true);
                continue;
            }
            if (args[paramCnt].equals("-v") || args[paramCnt].equals("--verbose")) {
                this.finalCrypt.setVerbose(true);
                this.verbose = true;
                continue;
            }
            if (args[paramCnt].equals("-l") || args[paramCnt].equals("--symlink")) {
                this.finalCrypt.setSymlink(true);
                this.symlink = true;
                continue;
            }
            if (args[paramCnt].equals("--version")) {
                CLUI cLUI = this;
                CLUI cLUI2 = this;
                this.log(cLUI.version.getProductName() + " " + cLUI2.version.getLocalOverallVersionString() + "\r\n", false, true, true, false, false);
                System.exit(0);
                continue;
            }
            if (args[paramCnt].equals("--license")) {
                CLUI cLUI = this;
                this.log(cLUI.version.getProductName() + " " + Version.getLicense() + "\r\n", false, true, true, false, false);
                System.exit(0);
                continue;
            }
            if (args[paramCnt].equals("--check-update")) {
                String[] lines;
                this.version.checkLatestVersion(this);
                for (String line : lines = this.version.getUpdateStatus().split("\r\n")) {
                    this.log(line + "\r\n", false, true, true, false, false);
                }
                System.exit(0);
                continue;
            }
            if (args[paramCnt].equals("--urlencode") && paramCnt == 0) {
                if (args.length == 2) {
                    if (!args[paramCnt + 1].isEmpty()) {
                        try {
                            this.log(URLEncoder.encode(args[paramCnt + 1], StandardCharsets.UTF_8.toString()).replace("+", "%20") + "\r\n", false, true, false, false, false);
                        }
                        catch (UnsupportedEncodingException ex) {
                            this.log("Error: Version.encodeValue URLEncoder.encode(" + args[paramCnt + 1] + ") (URL Encoding?)\r\n", false, true, true, true, false);
                        }
                        System.exit(0);
                        continue;
                    }
                    this.log("Please specify one text parameter: \"example text\"\r\n", false, true, false, false, false);
                    System.exit(1);
                    continue;
                }
                this.log("Please specify one text parameter: \"example text\"\r\n", false, true, false, false, false);
                System.exit(1);
                continue;
            }
            if (args[paramCnt].equals("-s") && !args[paramCnt + 1].isEmpty()) {
                if (this.validateIntegerString(args[paramCnt + 1])) {
                    this.finalCrypt.setBufferSize(Integer.valueOf(args[paramCnt + 1]) * 1024);
                    ++paramCnt;
                    continue;
                }
                this.log("\r\nWarning: Invalid Option Value [-b size]\r\n", false, true, true, false, false);
                this.usagePrompt(true);
                continue;
            }
            if (args[paramCnt].equals("-S") && !args[paramCnt + 1].isEmpty()) {
                if (this.validateIntegerString(args[paramCnt + 1])) {
                    this.filesizeInBytes = Long.valueOf(args[paramCnt + 1]);
                    ++paramCnt;
                    continue;
                }
                this.log("\r\nWarning: Invalid Option Value [-S size]\r\n", false, true, true, false, false);
                this.usagePrompt(true);
                continue;
            }
            if (!(this.scan || this.encrypt || this.decrypt || this.createManualKeyDev || this.clonekeydev || this.printgpt || this.deletegpt || this.createManualKeyFile)) {
                this.log("\r\nWarning: No <--Mode> parameter specified\r\n", false, true, true, false, false);
                this.usagePrompt(true);
                continue;
            }
            if (args[paramCnt].equals("--test") && args[paramCnt + 1].isEmpty()) {
                this.test = true;
                this.finalCrypt.setTest(this.test);
                continue;
            }
            if (args[paramCnt].equals("--test") && !args[paramCnt + 1].isEmpty()) {
                this.test = true;
                this.finalCrypt.setTest(this.test);
                if (!args[paramCnt + 1].toLowerCase().equals("c") && !this.validateIntegerString(args[paramCnt + 1])) continue;
                this.testAnswer = args[paramCnt + 1];
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-w") && !args[paramCnt + 1].isEmpty()) {
                negatePattern = false;
                pattern = "glob:" + args[paramCnt + 1];
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-W") && !args[paramCnt + 1].isEmpty()) {
                negatePattern = true;
                pattern = "glob:" + args[paramCnt + 1];
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-r") && !args[paramCnt + 1].isEmpty()) {
                pattern = "regex:" + args[paramCnt + 1];
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-k")) {
                if (paramCnt + 1 < args.length) {
                    this.keyFCPath = Validate.getFCPath(this.ui, "", Paths.get(args[paramCnt + 1], new String[0]), true, Paths.get(args[paramCnt + 1], new String[0]), FinalCrypt.disabledMAC, true);
                    kfset = true;
                    ++paramCnt;
                    continue;
                }
                this.log("\r\nWarning: Missing key parameter <-k \"keyfile\">\r\n", false, true, true, false, false);
                this.usagePrompt(true);
                continue;
            }
            if (args[paramCnt].equals("-K") && !args[paramCnt + 1].isEmpty()) {
                this.keyPath = Paths.get(args[paramCnt + 1], new String[0]);
                ++paramCnt;
                continue;
            }
            if (args[paramCnt].equals("-t")) {
                if (paramCnt + 1 < args.length) {
                    targetPathList.add(Paths.get(args[paramCnt + 1], new String[0]));
                    tfset = true;
                    ++paramCnt;
                    continue;
                }
                this.log("\r\nWarning: Missing target parameter <[-t \"file/dir\"]>\r\n", false, true, true, false, false);
                this.usagePrompt(true);
                continue;
            }
            if (args[paramCnt].equals("-b") && !args[paramCnt + 1].isEmpty()) {
                tfset = this.addBatchTargetFiles(args[paramCnt + 1], targetPathList);
                ++paramCnt;
                continue;
            }
            this.log("\r\nWarning: Invalid Parameter: " + args[paramCnt] + "\r\n", false, true, true, true, false);
            this.usagePrompt(true);
        }
        if (this.encryptModeNeeded && this.decrypt) {
            this.log("\r\nWarning: MAC Mode Disabled! Use --encrypt if you know what you are doing!!!\r\n", false, true, true, false, false);
            this.usagePrompt(true);
        }
        if (this.encryptModeNeeded && !this.encrypt) {
            this.log("\r\nWarning: Missing valid parameter <--encrypt>\r\n", false, true, true, false, false);
            this.usagePrompt(true);
        }
        if (kfsetneeded && !kfset) {
            this.log("\r\nWarning: Missing valid parameter <-k \"keyfile\">\r\n", false, true, true, false, false);
            this.usagePrompt(true);
        }
        if (tfsetneeded && !tfset) {
            this.log("\r\nWarning: Missing valid parameter <-t \"file/dir\"> or <-b \"batchfile\">\r\n", false, true, true, false, false);
            this.usagePrompt(true);
        }
        if (kfsetneeded && !this.keyFCPath.isValidKey && !this.keyFCPath.isValidKeyDir) {
            String exist = "";
            String size = "";
            String string = "";
            String sym = "";
            String all = "";
            if (!this.keyFCPath.exist) {
                exist = exist + " [key does not exist] ";
            } else {
                if (this.keyFCPath.type == 3) {
                    sym = sym + " [is symlink] ";
                }
                if (!FinalCrypt.disabledMAC) {
                    if (this.keyFCPath.size < (long)FCPath.KEY_SIZE_MIN) {
                        size = size + " [size < " + FCPath.KEY_SIZE_MIN + "] try: \"--no-key-size\" option ";
                    }
                    if (this.keyFCPath.size < (long)FCPath.MAC_SIZE) {
                        size = size + " [size < " + FCPath.MAC_SIZE + "] try: \"--disable-MAC\" option if you know what you are doing !!! ";
                    }
                } else if (this.keyFCPath.size < (long)FCPath.KEY_SIZE_MIN) {
                    size = size + " [size < " + FCPath.KEY_SIZE_MIN + "] try: \"--no-key-size\" option ";
                }
            }
            all = exist + sym + size;
            if (!this.keyFCPath.errorDescription.isEmpty()) {
                this.log("\r\n" + this.keyFCPath.errorDescription + "\r\n", false, true, true, false, false);
            }
            this.log(Validate.getFCPathStatus(this.keyFCPath), false, true, false, false, false);
            this.usagePrompt(true);
        }
        if (tfsetneeded) {
            for (Path targetPath : targetPathList) {
                if (Files.exists(targetPath, new LinkOption[0])) {
                    if (Validate.isValidDir(this, targetPath, this.symlink, this.verbose)) {
                        if (!this.verbose) continue;
                        this.log("Info: Target parameter: " + targetPath + " is a valid dir\r\n", false, true, true, false, false);
                        continue;
                    }
                    if (!Validate.isValidFile(this, "CLUI.CLUI() ", targetPath, false, false, 1L, this.symlink, true, this.verbose) || !this.verbose) continue;
                    this.log("Info: Target parameter: " + targetPath + " is a valid file\r\n", false, true, true, false, false);
                    continue;
                }
                this.log("Warning: Target parameter: -t \"" + targetPath + "\" does not exists\r\n", false, true, true, false, false);
                this.usagePrompt(true);
            }
        }
        if (this.pwdPromptNeeded) {
            ConsoleEraser consoleEraser = new ConsoleEraser();
            System.out.print("Password: ");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            consoleEraser.start();
            try {
                this.pwd = in.readLine();
                this.pwdIsSet = true;
            }
            catch (IOException iOException) {
                this.log("Error: Can't read password! " + iOException.getMessage() + "\r\n", false, true, true, true, false);
                this.usagePrompt(true);
                System.exit(1);
            }
            consoleEraser.halt();
        }
        if (this.pwdIsSet) {
            MessageDigest messageDigest3 = null;
            try {
                messageDigest3 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                this.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", true, true, true, true, false);
            }
            messageDigest3.update(this.pwd.getBytes());
            byte[] hashBytes = messageDigest3.digest();
            this.pwdBytes = GPT.hex2Bytes(GUIFX.getHexString(hashBytes, 2));
            this.finalCrypt.setPwd(this.pwd);
            this.finalCrypt.setPwdBytes(this.pwd);
        }
        if (this.createManualKeyFile) {
            Long factor = 0L;
            this.bufferSize = 0x100000;
            this.totalTranfered = 0L;
            if (Files.exists(this.keyPath, LinkOption.NOFOLLOW_LINKS)) {
                this.log("Warning: file: \"" + this.keyPath.toAbsolutePath().toString() + "\" exists! Aborted!\r\n\r\n", false, true, false, false, false);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException hashBytes) {
                    // empty catch block
                }
                System.exit(1);
            } else {
                this.log("Creating OTP Key File (" + Validate.getHumanSize(this.filesizeInBytes.longValue(), 1, "Bytes") + ")...", false, true, false, false, false);
            }
            if (this.filesizeInBytes < (long)this.bufferSize) {
                this.bufferSize = this.filesizeInBytes.intValue();
            }
            boolean inputEnded = false;
            long l = 0L;
            long writeKeyFileChannelTransfered = 0L;
            this.totalTranfered = 0L;
            Long remainder = 0L;
            ByteBuffer randomBuffer = ByteBuffer.allocate(this.bufferSize);
            randomBuffer.clear();
            while (this.totalTranfered < this.filesizeInBytes && !inputEnded) {
                remainder = this.filesizeInBytes - this.totalTranfered;
                if (remainder >= (long)this.bufferSize) {
                    randomBuffer = ByteBuffer.allocate(this.bufferSize);
                    randomBuffer.clear();
                } else if (remainder > 0L && remainder < (long)this.bufferSize) {
                    randomBuffer = ByteBuffer.allocate(remainder.intValue());
                    randomBuffer.clear();
                } else {
                    inputEnded = true;
                }
                randomBuffer = RNG.getFCRandomBuffer(this.ui, randomBuffer.capacity(), true, true, this.finalCrypt.getPrint_Vertical());
                try {
                    throwable = null;
                    try (SeekableByteChannel writeKeyFileChannel = Files.newByteChannel(this.keyPath, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE)), new FileAttribute[0]);){
                        writeKeyFileChannel.position(l);
                        writeKeyFileChannelTransfered = writeKeyFileChannel.write(randomBuffer);
                        randomBuffer.rewind();
                        this.totalTranfered = this.totalTranfered + writeKeyFileChannelTransfered;
                        l += writeKeyFileChannelTransfered;
                        writeKeyFileChannel.close();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException ex) {
                    this.log("\r\nError: " + ex.getMessage() + "\r\n", false, true, true, true, false);
                    inputEnded = true;
                    break;
                }
                randomBuffer.clear();
            }
            l = 0L;
            writeKeyFileChannelTransfered = 0L;
            inputEnded = false;
            this.log("finished\r\n", false, true, false, false, false);
            System.exit(0);
        }
        if (this.key_checksum) {
            this.log("\r\nKey CheckSum: (SHA-256): \"" + this.keyFCPath.path.toAbsolutePath().toString() + "\"...\r\n", false, true, false, false, false);
            long readKeySourceChannelPosition = 0L;
            long l = 0L;
            int readKeySourceBufferSize = 0x100000;
            ByteBuffer keySourceBuffer = ByteBuffer.allocate(readKeySourceBufferSize);
            keySourceBuffer.clear();
            messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                this.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", false, true, true, true, false);
            }
            int x = 0;
            while (!this.keySourceChecksumReadEnded) {
                try {
                    throwable = null;
                    try (SeekableByteChannel readKeySourceChannel = Files.newByteChannel(this.keyFCPath.path, FinalCrypt.getEnumSet(EnumSet.of(StandardOpenOption.READ)), new FileAttribute[0]);){
                        readKeySourceChannel.position(readKeySourceChannelPosition);
                        l = readKeySourceChannel.read(keySourceBuffer);
                        keySourceBuffer.flip();
                        readKeySourceChannelPosition += l;
                        readKeySourceChannel.close();
                        messageDigest.update(keySourceBuffer);
                        if (l < 0L) {
                            this.keySourceChecksumReadEnded = true;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ex) {
                    this.keySourceChecksumReadEnded = true;
                    this.log("Error: readKeySourceChannel = Files.newByteChannel(..) " + ex.getMessage() + "\r\n", false, true, false, true, false);
                }
                ++x;
                keySourceBuffer.clear();
            }
            byte[] hashBytes = messageDigest.digest();
            String hashString = GUIFX.getHexString(hashBytes, 2);
            this.log("Message Digest:         " + hashString + "\r\n\r\n", false, true, false, false, false);
        }
        this.targetFCPathList = new FCPathList();
        if (!kfsetneeded) {
            this.keyFCPath = Validate.getFCPath(this.ui, "", (Path)targetPathList.get(0), true, (Path)targetPathList.get(0), FinalCrypt.disabledMAC, true);
        }
        if (this.dictionary) {
            Validate.buildSelection(this, targetPathList, this.keyFCPath, this.targetFCPathList, this.symlink, pattern, negatePattern, FinalCrypt.disabledMAC, true);
            if (this.targetFCPathList.validFiles > 0L) {
                FCPath dictFileFCPath = Validate.getFCPath(this.ui, "NA", Paths.get(dictionaryFilePathString, new String[0]), false, Paths.get(dictionaryFilePathString, new String[0]), false, true);
                if (dictFileFCPath.exist && dictFileFCPath.isValidFile && dictFileFCPath.isReadable && dictFileFCPath.size > 0L) {
                    boolean pwdFound;
                    Timer timer;
                    block190: {
                        this.bflines = 0L;
                        try {
                            this.bflines = Files.lines(dictFileFCPath.path).count();
                        }
                        catch (IOException ex) {
                            this.log("Files.lines(" + dictFileFCPath.path.toAbsolutePath().toString() + ").count();" + ex.getMessage(), false, true, true, true, false);
                        }
                        this.bfcounter = 1L;
                        this.bruteForceDataStats = new Stats();
                        this.bruteForceDataStats.reset();
                        this.bruteForceDataStats.setAllDataStartNanoTime();
                        this.bruteForceDataStats.clock();
                        TimerTask printTask = new TimerTask(){

                            @Override
                            public void run() {
                                if (CLUI.this.bruteForceFCPathTargetPrint != null) {
                                    CLUI.this.log("Brute Force testing target: \"" + CLUI.this.bruteForceFCPathTargetPrint.path.toAbsolutePath().toString() + "\" password count: " + CLUI.this.bfcounter + " " + CLUI.this.bfcounter / (CLUI.this.bflines / 100L) + "% \r\n", false, true, false, false, false);
                                }
                            }
                        };
                        timer = new Timer();
                        timer.schedule(printTask, 1000L, 1000L);
                        this.log("\r\nStart Brute Force testing " + this.bflines + " passwords...\r\n\r\n", false, true, true, false, false);
                        this.log("Brute Force testing target: \"" + ((FCPath)this.targetFCPathList.get((int)0)).path.toAbsolutePath().toString() + "\" password count: " + 1 + " " + this.bfcounter / (this.bflines / 100L) + "%\r\n", false, true, false, false, false);
                        pwdFound = false;
                        BufferedReader bufferedReader = null;
                        try {
                            bufferedReader = new BufferedReader(new FileReader(dictFileFCPath.path.toFile()));
                        }
                        catch (FileNotFoundException ex) {
                            this.log("Error: new FileReader(" + dictFileFCPath.path.toAbsolutePath().toString() + ");" + ex.getMessage(), false, true, true, true, false);
                        }
                        try {
                            String pwdString;
                            while (!pwdFound && (pwdString = bufferedReader.readLine()) != null) {
                                this.pwd = pwdString;
                                messageDigest = null;
                                try {
                                    messageDigest = MessageDigest.getInstance("SHA-256");
                                }
                                catch (NoSuchAlgorithmException ex) {
                                    this.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", true, true, true, true, false);
                                }
                                messageDigest.update(this.pwd.getBytes());
                                byte[] hashBytes = messageDigest.digest();
                                this.pwdBytes = GPT.hex2Bytes(GUIFX.getHexString(hashBytes, 2));
                                this.finalCrypt.setPwd(this.pwd);
                                this.finalCrypt.setPwdBytes(this.pwd);
                                this.targetFCPathList = new FCPathList();
                                Validate.buildSelection(this, targetPathList, this.keyFCPath, this.targetFCPathList, this.symlink, pattern, negatePattern, FinalCrypt.disabledMAC, false);
                                Iterator iterator = this.targetFCPathList.iterator();
                                while (iterator.hasNext()) {
                                    FCPath fcPathItem;
                                    this.bruteForceFCPathTargetPrint = fcPathItem = (FCPath)iterator.next();
                                    ++this.bfcounter;
                                    if (!fcPathItem.isDecryptable) continue;
                                    pwdFound = true;
                                    break block190;
                                }
                            }
                        }
                        catch (IOException ex) {
                            this.log("Error: bufferedReader.readLine(" + dictFileFCPath.path + ");" + ex.getMessage(), false, true, true, true, false);
                        }
                    }
                    if (this.bruteForceFCPathTargetPrint != null) {
                        this.log("Brute Force testing target: \"" + this.bruteForceFCPathTargetPrint.path.toAbsolutePath().toString() + "\" password count: " + (this.bfcounter - 1L) + " " + this.bfcounter / (this.bflines / 100L) + "%\r\n", false, true, false, false, false);
                    }
                    if (pwdFound) {
                        this.log("\r\nPassword found: \"" + this.pwd + "\"\r\n", false, true, false, false, false);
                    } else {
                        this.log("\r\nPassword not found\r\n", false, true, false, false, false);
                    }
                    this.bruteForceDataStats.setAllDataEndNanoTime();
                    this.bruteForceDataStats.clock();
                    timer.cancel();
                    timer.purge();
                    this.log("\r\nFinished Brute force testing " + (this.bfcounter - 1L) + " / " + this.bflines + " passwords in " + this.bruteForceDataStats.getElapsedTime(this.bruteForceDataStats.getAllDataEndEpoch() - this.bruteForceDataStats.getAllDataStartEpoch()) + " " + this.bruteForceDataStats.getBruteForceThroughPut(this.bfcounter, this.bruteForceDataStats.getAllDataEndEpoch() - this.bruteForceDataStats.getAllDataStartEpoch()) + "\r\n\r\n", false, true, true, false, false);
                } else {
                    this.log("\r\nWarning: dictionary file: " + dictFileFCPath.path.toAbsolutePath().toString() + " is not a valid file!\r\n\r\n", false, true, true, false, false);
                    this.log(dictFileFCPath.getString() + "\r\n", false, true, true, false, false);
                }
            } else {
                this.log("\r\nWarning: No valid target files found\r\n\r\n", false, true, true, false, false);
                this.log(this.targetFCPathList.getStats() + "\r\n", false, true, true, false, false);
            }
            System.exit(0);
        } else {
            this.log("\r\nScanning files... ", false, true, true, false, false);
            Validate.buildSelection(this, targetPathList, this.keyFCPath, this.targetFCPathList, this.symlink, pattern, negatePattern, FinalCrypt.disabledMAC, false);
            this.log("Finished\r\n\r\n", false, true, true, false, false);
        }
        if (this.scan) {
            if (this.verbose) {
                for (FCPath fcPathItem : this.targetFCPathList) {
                    this.log(fcPathItem.getString() + "\r\n", false, true, true, false, false);
                }
            }
            this.log("=========================================\r\n\r\n", false, true, true, false, false);
            this.log(this.targetFCPathList.getStats() + "\r\n", false, true, true, false, false);
            System.exit(0);
        }
        if (this.keyFCPath != null && this.keyFCPath.isKey && this.keyFCPath.isValidKey || this.keyFCPath != null && this.keyFCPath.type == 2 && this.keyFCPath.isValidKeyDir) {
            this.invalidFilesList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 0);
            this.decryptedList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isDecrypted);
            this.encryptableList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isEncryptable);
            this.encryptablesFound = true;
            this.unencryptableList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isUnEncryptable && fcPath.isDecrypted && fcPath.size > 0L);
            this.encryptedList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isEncrypted);
            this.decryptableList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isDecryptable);
            this.decryptablesFound = true;
            this.undecryptableList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isUnDecryptable && fcPath.isEncrypted && fcPath.size > 0L);
            this.emptyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.size == 0L && fcPath.type == 1);
            this.symlinkList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 3);
            this.unreadableList = CLUI.filter(this.targetFCPathList, fcPath -> !fcPath.isReadable && fcPath.type == 1);
            this.unwritableList = CLUI.filter(this.targetFCPathList, fcPath -> !fcPath.isWritable && fcPath.type == 1);
            this.hiddenList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.isHidden);
            this.readAutoKeyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.matchedReadAutoKey);
            this.writeAutoKeyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.needsWriteAutoKey);
            this.missingAutoKeyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.unmatchedReadAutoKey);
            if (this.keyFCPath.type == 1) {
                if (this.targetFCPathList.validDevices > 0L) {
                    this.createManualKeyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 4);
                    this.createManualKeyDeviceFound = true;
                } else {
                    this.createManualKeyDeviceFound = false;
                }
            } else if (this.keyFCPath.type == 4) {
                if (this.targetFCPathList.validDevices > 0L && this.targetFCPathList.matchingKey == 0L) {
                    FCPath keyFCPath2 = this.keyFCPath;
                    this.cloneManualKeyList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 4 && fcPath.path.compareTo(keyFCPath2.path) != 0);
                    this.cloneManualKeyDeviceFound = true;
                } else {
                    this.cloneManualKeyDeviceFound = false;
                }
            } else {
                this.cloneManualKeyDeviceFound = false;
            }
        } else {
            this.createManualKeyDeviceFound = false;
        }
        if (this.printgpt && (this.targetFCPathList.validDevices > 0L || this.targetFCPathList.validDevicesProtected > 0L)) {
            this.printGPTTargetList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 4 || fcPath.type == 7);
            this.printGPTDeviceFound = true;
        } else {
            this.printGPTDeviceFound = false;
        }
        if (this.deletegpt && this.targetFCPathList.validDevices > 0L) {
            this.deleteGPTTargetList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 4);
            this.deleteGPTDeviceFound = this.deleteGPTTargetList.size() > 0;
        } else if (this.deletegpt && this.targetFCPathList.validDevicesProtected > 0L) {
            this.deleteGPTTargetList = CLUI.filter(this.targetFCPathList, fcPath -> fcPath.type == 7);
            FCPath fcPath2 = (FCPath)this.deleteGPTTargetList.get(0);
            this.log("WARNING: Device: " + fcPath2.path + " is protected!!!\r\n", false, true, true, false, false);
            this.deleteGPTDeviceFound = false;
        } else {
            this.deleteGPTDeviceFound = false;
        }
        if (this.encrypt) {
            if (FinalCrypt.disabledMAC) {
                this.log("\"Warning: MAC Mode Disabled! (files will be encrypted without Message Authentication Code Header)\r\n", true, true, true, false, false);
            }
            if (this.finalCrypt.getTest()) {
                this.testListPrompt();
            }
            if (this.encryptableList.size() > 0 && this.encryptableList.encryptableFiles > 0L) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (CLUI.this.finalCrypt.processRunning) {
                            CLUI.this.finalCrypt.setStopPending(true);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            CLUI.this.log("\r\nEncryption User Interrupted...\r\n", false, true, true, false, false);
                        }
                    }
                });
                this.processStarted();
                this.finalCrypt.encryptSelection(this.targetFCPathList, this.encryptableList, this.keyFCPath, true, this.pwd, this.pwdBytes, false);
            } else {
                this.log("No encryptable targets found:\r\n", false, true, true, false, false);
                this.log(this.getScanResults(false), false, true, true, false, false);
            }
        } else if (this.decrypt) {
            if (FinalCrypt.disabledMAC) {
                this.log("Warning: MAC Mode Disabled! Use --encrypt if you know what you are doing!!!\r\n", true, true, true, false, false);
            } else {
                if (this.finalCrypt.getTest()) {
                    this.testListPrompt();
                }
                if (this.decryptableList.size() > 0 && this.decryptableList.decryptableFiles > 0L) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            if (CLUI.this.finalCrypt.processRunning) {
                                CLUI.this.finalCrypt.setStopPending(true);
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                CLUI.this.log("\r\nDecryption User Interrupted...\r\n", false, true, true, false, false);
                            }
                        }
                    });
                    this.processStarted();
                    this.finalCrypt.encryptSelection(this.targetFCPathList, this.decryptableList, this.keyFCPath, false, this.pwd, this.pwdBytes, false);
                } else {
                    this.log("No decryptable targets found\r\n\r\n", false, true, true, false, false);
                    if (this.targetFCPathList.encryptedFiles > 0L) {
                        this.log("Wrong key / password?\r\n\r\n", false, true, false, false, false);
                    }
                    this.log(this.getScanResults(false), false, true, true, false, false);
                }
            }
        } else if (this.createManualKeyDev) {
            if (this.createManualKeyDeviceFound) {
                this.processStarted();
                DeviceManager deviceManager = new DeviceManager(this.ui);
                deviceManager.start();
                deviceManager.createManualKeyDevice(this.keyFCPath, (FCPath)this.createManualKeyList.get(0));
                this.processFinished(new FCPathList<FCPath>(), false);
            } else {
                this.log("No valid target device found:\r\n", false, true, true, false, false);
                this.log(this.targetFCPathList.getStats(), false, true, false, false, false);
            }
        } else if (this.clonekeydev && this.cloneManualKeyDeviceFound) {
            if (this.cloneManualKeyDeviceFound) {
                this.processStarted();
                DeviceManager deviceManager = new DeviceManager(this.ui);
                deviceManager.start();
                deviceManager.cloneManualKeyDevice(this.keyFCPath, (FCPath)this.cloneManualKeyList.get(0));
                this.processFinished(new FCPathList<FCPath>(), false);
            } else {
                this.log("No valid target device found:\r\n", false, true, true, false, false);
                this.log(this.targetFCPathList.getStats(), false, true, false, false, false);
            }
        } else if (this.printgpt && this.printGPTDeviceFound) {
            if (this.printGPTDeviceFound) {
                DeviceManager deviceManager = new DeviceManager(this.ui);
                deviceManager.start();
                deviceManager.printGPT((FCPath)this.printGPTTargetList.get(0));
            } else {
                this.log("No valid target device found:\r\n", false, true, true, false, false);
                this.log(this.targetFCPathList.getStats(), false, true, false, false, false);
            }
        } else if (this.deletegpt && this.deleteGPTDeviceFound) {
            if (this.deleteGPTDeviceFound) {
                DeviceManager deviceManager = new DeviceManager(this.ui);
                deviceManager.start();
                deviceManager.deleteGPT((FCPath)this.deleteGPTTargetList.get(0));
            } else {
                this.log("No valid target device found:\r\n", false, true, true, false, false);
                this.log(this.targetFCPathList.getStats(), false, true, false, false, false);
            }
        }
    }

    private boolean addBatchTargetFiles(String batchFilePathString, ArrayList<Path> targetFilesPathList) {
        boolean ifset = false;
        if (Validate.isValidFile(this, "CLUI.addBatchTargetFiles", Paths.get(batchFilePathString, new String[0]), false, false, 1L, this.symlink, true, true)) {
            this.log("Adding items from batchfile: " + batchFilePathString + "\r\n", false, true, true, false, false);
            Path batchFilePath = Paths.get(batchFilePathString, new String[0]);
            try {
                for (String targetFilePathString : Files.readAllLines(batchFilePath)) {
                    if (!Validate.isValidFile(this.ui, "CLUI.addBatchTargetFiles", Paths.get(targetFilePathString, new String[0]), false, false, 0L, this.symlink, true, true)) continue;
                    Path targetFilePath = Paths.get(targetFilePathString, new String[0]);
                    targetFilesPathList.add(targetFilePath);
                    ifset = true;
                }
            }
            catch (IOException ex) {
                this.log("Files.readAllLines(" + batchFilePath + ");" + ex.getMessage(), false, true, true, true, false);
            }
            if (!ifset) {
                this.log("Warning: batchfile: " + batchFilePathString + " doesn't contain any valid items!\r\n", false, true, true, false, false);
            }
        } else {
            this.log("Warning: batchfile: " + batchFilePathString + " is not a valid file!\r\n", false, true, true, false, false);
        }
        return ifset;
    }

    public static FCPathList<FCPath> filter(ArrayList<FCPath> fcPathList, Predicate<FCPath> fcPath) {
        FCPathList<FCPath> result = new FCPathList<FCPath>();
        for (FCPath fcPathItem : fcPathList) {
            if (!fcPath.test(fcPathItem)) continue;
            result.add(fcPathItem);
        }
        return result;
    }

    public static Predicate<FCPath> isHidden() {
        return fcPath -> fcPath.isHidden;
    }

    public List<FCPath> filter(Predicate<FCPath> criteria, ArrayList<FCPath> list) {
        return list.stream().filter(criteria).collect(Collectors.toList());
    }

    private boolean validateIntegerString(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void usagePrompt(boolean error) {
        this.usageReaderTimeoutThread = new UsageReaderTimeoutThread(this);
        this.usageReaderTimeoutThread.start();
        this.usageReaderThread = new UsageReaderThread(this);
        this.usageReaderThread.start();
        while (this.usageReaderTimeoutThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log("\r\n\r\n", false, true, false, false, false);
        System.exit(error ? 1 : 0);
    }

    private void testListPrompt() {
        this.testListReaderTimeoutThread = new TestListReaderTimeoutThread(this);
        this.testListReaderTimeoutThread.start();
        this.testListReaderThread = new TestListReaderThread(this);
        this.testListReaderThread.start();
        while (this.testListReaderTimeoutThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log("\r\n\r\n", false, true, false, false, false);
    }

    protected void usage(boolean error) {
        String fileSeparator = FileSystems.getDefault().getSeparator();
        this.log("\r\n", false, true, false, false, false);
        this.log("Usage:      java -cp finalcrypt.jar rdj/CLUI   <Mode>  [options] <Parameters>\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Examples:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --examples                 Print commandline examples\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt --test -k \"key_dir\" -t \"target_dir\" -t \"target_file\" # Test Encrypt (Auto Key Mode)\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt --test -k \"key_dir\" -t \"target_dir\" -t \"target_file\" # Test Decrypt (Auto Key Mode)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -k \"key_dir\" -t \"target_dir\" -t \"target_file\"  # Encrypt (Auto Key Mode)\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -k \"key_dir\" -t \"target_dir\" -t \"target_file\"  # Decrypt (Auto Key Mode)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -k \"key_file\" -t \"target_file\"  # Encrypt (Manual Key Mode not recommended)\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -k \"key_file\" -t \"target_file\"  # Decrypt (Manual Key Mode not recommended)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Mode:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            <--scan>              -k \"key_dir\"       -t \"target\"        Print scan results and quit\r\n", false, true, false, false, false);
        this.log("            <--encrypt>           -k \"key_dir\"       -t \"target\"        Encrypt Targets\r\n", false, true, false, false, false);
        this.log("            <--decrypt>           -k \"key_dir\"       -t \"target\"        Decrypt Targets\r\n", false, true, false, false, false);
        this.log("            <--create-keydev>     -k \"key_file\"      -t \"target\"        Create Key Device (only unix)\r\n", false, true, false, false, false);
        this.log("            <--create-keyfile>    -K \"key_file\"      -S \"Size (bytes)\"  Create OTP Key File\r\n", false, true, false, false, false);
        this.log("            <--clone-keydev>      -k \"source_device\" -t \"target_device\" Clone Key Device (only unix)\r\n", false, true, false, false, false);
        this.log("            <--typewriter>                                              Print to screen like a typewriter\r\n", false, true, false, false, false);
        this.log("            [--print-gpt]         -t \"target_device\"                    Print GUID Partition Table\r\n", false, true, false, false, false);
        this.log("            [--print-gpt]         -t \"target_device\"                    Print GUID Partition Table\r\n", false, true, false, false, false);
        this.log("            [--delete-gpt]        -t \"target_device\"                    Delete GUID Partition Table (DATA LOSS!)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Options:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            [-h] [--help]                                               Print help page\r\n", false, true, false, false, false);
        this.log("            [--password]          -p 'password'                         Optional password parameter http://www.finalcrypt.org/faq.php#t22\r\n", false, true, false, false, false);
        this.log("            [--password-prompt]   -pp                                   Optional password prompt http://www.finalcrypt.org/faq.php#t22\r\n", false, true, false, false, false);
        this.log("            [--key-chksum]        -k \"key_file\"                         Calculate key checksum\r\n", false, true, false, false, false);
        this.log("            [--no-key-size]                                             Allow key-size less than the default minimum of " + FCPath.KEY_SIZE_MIN + " bytes\r\n", false, true, false, false, false);
        this.log("            [-d] [--debug]                                              Enables debugging mode\r\n", false, true, false, false, false);
        this.log("            [-v] [--verbose]                                            Enables verbose mode\r\n", false, true, false, false, false);
        this.log("            [--print]                                                   Print all bytes binary, hexdec,  dec & char vertical   (slow!!!)\r\n", false, true, false, false, false);
        this.log("            [--print-virtical]                                          Print all bytes binary, hexdec,  dec & char vertical   (slow!!!)\r\n", false, true, false, false, false);
        this.log("            [--print-horizontal]                                        Print all bytes binary, hexdec,  dec & char horizontal (slow!!!)\r\n", false, true, false, false, false);
        this.log("            [-l] [--symlink]                                            Include symlinks (can cause double encryption! Not recommended!)\r\n", false, true, false, false, false);
        this.log("            [--reuse-keys]                                              Reuse Keys only works in MAC Mode (experts only, breaks OTP rule)\r\n", false, true, false, false, false);
        this.log("            [--disable-MAC]                                             Non MAC Mode - Please see http://www.finalcrypt.org/faq.php#t25\r\n", false, true, false, false, false);
        CLUI cLUI = this;
        this.log("            [--version]                                                 Print " + cLUI.version.getProductName() + " version\r\n", false, true, false, false, false);
        CLUI cLUI2 = this;
        this.log("            [--license]                                                 Print " + cLUI2.version.getProductName() + " license\r\n", false, true, false, false, false);
        this.log("            [--check-update]                                            Check for online updates\r\n", false, true, false, false, false);
        this.log("            [-s size]                                                   Changes default I/O buffer size (size = KiB) (default 1024 KiB)\r\n", false, true, false, false, false);
        this.log("            [-S size]                                                   OTP Key File Size (size = bytes). See --create-keyfile \r\n", false, true, false, false, false);
        this.log("            [--urlencode]         \"text to encode\"                      Encode plain text to URL safe text\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Test Options:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            [--test]                                                    Test run without executing (also prints statistics at the end)\r\n", false, true, false, false, false);
        this.log("            [--test \"answer\"]                                           Same but then with non interactive answer (c,1-13) included\r\n", false, true, false, false, false);
        this.log("            [-pd] [--password-dictionary]  \"dict_file\"                  Brute force test plain text passwords from dictionary file\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Filtering Options:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            [-w 'wildcard']                                             File wildcard INCLUDE filter. Uses: \"Globbing Patterns Syntax\"\r\n", false, true, false, false, false);
        this.log("            [-W 'wildcard']                                             File wildcard EXCLUDE filter. Uses: \"Globbing Patterns Syntax\"\r\n", false, true, false, false, false);
        this.log("            [-r 'regex']                                                File regular expression filter. Advanced filename filter!\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Parameters:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            <-k \"keydir\">                                               The directory that holds your keys. Keep SECRET!\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            <-t / -b>                                                   Target items to encrypt. Individual (-t) by batch (-b)\r\n", false, true, false, false, false);
        this.log("            <[-t \"file/dir\"]>                                           Target items (files or directories) you want to encrypt (recursive)\r\n", false, true, false, false, false);
        this.log("            <[-b \"batchfile\"]>                                          Batchfile with targetfiles you want to encrypt (only files)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log(Version.getProductName() + " " + this.version.checkLocalVersion(this) + " - Author: " + Version.getAuthor() + " <" + Version.getEmail() + "> - CC BY-NC-ND 4.0: " + Version.getLicenseDescription() + "\r\n\r\n", false, true, false, false, false);
        System.exit(error ? 1 : 0);
    }

    private void examples() {
        this.log("\r\n", false, true, false, false, false);
        this.log("Usage:      java -cp finalcrypt.jar rdj/CLUI   <Mode>  [options] <Parameters>\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Examples:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Test Run Encrypt / Decrypt mydir and myfile auto creating and selecting keys in mykeydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt --test -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt --test -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Same but then with non interactive answer (c,1-13) included\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt --test c -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt --test c -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt mydir and myfile auto creating and selecting keys in mykeydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -k \"mykeydir\" -t \"mydocdir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt files in batchfile\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -k \"mykeydir\" -b \"mybatchfile\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -k \"mykeydir\" -b \"mybatchfile\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt all *.doc files in mydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -w \"*.doc\" -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -w \"*.doc\" -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt all non *.doc files in mydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -W \"*.doc\" -k \"mykeydir\" -t \"mydir\" \r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -W \"*.doc\" -k \"mykeydir\" -t \"mydir\" \r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt all *.doc files in mydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -r '^.*\\.doc$' -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -r '^.*\\.doc$' -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt all non *.bit files in mydir\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -r '(?!.*\\.bit$)^.*$' -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -r '(?!.*\\.bit$)^.*$' -k \"mykeydir\" -t \"mydir\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Brute force password dictionary testing (in case of forgotten passwords):\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --scan --password-dictionary \"dictionary.txt\" -k \"mykeydir\" -t \"myfile\"\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Create OTP Key file:\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            FinalCrypt automatically creates One-Time Pad Key Files. Creating Manual OTP keys is supported but not recommended\r\n\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj.CLUI --create-keyfile -K \"mykeyfile\" -S 268435456 # (256 MiB) echo $((1024**2*256))\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Key Device Examples (Linux):\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Create Key Device with 2 key partitions (e.g. on USB Mem Stick)\r\n", false, true, false, false, false);
        this.log("            # Beware: keyfile gets randomized before writing to Device\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --create-keydev -k mykeyfile -t /dev/sdb\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Print GUID Partition Table\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --print-gpt -t /dev/sdc\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Delete GUID Partition Table\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --delete-gpt -t /dev/sdc\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Clone Key Device (-k sourcekeydevice -t destinationkeydevice)\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --clone-keydev -k /dev/sdc -t /dev/sdd\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            # Encrypt / Decrypt myfile with raw key partition\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --encrypt -k /dev/sdc1 -t myfile\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/CLUI --decrypt -k /dev/sdc1 -t myfile\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("Typewriter Examples (Print to screen like a typewriter):\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            Usage: java -cp finalcrypt.jar rdj/TypeWriter -t \"text to write\" [-s sound-nr|\"file\"] [-min delay_ms] [-max delay_ms]\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/Audio --list # List available sounds\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"type at steady pace\" -min 100\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"type at random pace\" -min 20 -max 100\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"\" -min 1000\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"\\n\" -min 1000\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"built-in sound\" -s 8 -min 20 -max 100\r\n", false, true, false, false, false);
        this.log("            java -cp finalcrypt.jar rdj/TypeWriter -t \"ext sound file\" -s file.wav -min 20 -max 100\r\n", false, true, false, false, false);
        this.log("\r\n", false, true, false, false, false);
        this.log(Version.getProductName() + " " + this.version.checkLocalVersion(this) + " - Author: " + Version.getAuthor() + " <" + Version.getEmail() + "> - CC BY-NC-ND 4.0: " + Version.getLicenseDescription() + "\r\n\r\n", false, true, false, false, false);
        System.exit(0);
    }

    private static String reformat(String text) {
        return text.replace("\\t", "\t").replace("\\b", "\b").replace("\\n", "\n").replace("\\r", "\r").replace("\\f", "\f");
    }

    private void typewriter(String[] args) {
        String[] newargs = new String[args.length - 1];
        for (int x = 1; x < args.length; ++x) {
            newargs[x - 1] = args[x];
        }
        new TypeWriter(newargs);
        System.exit(0);
    }

    @Override
    public void processGraph(int value) {
    }

    @Override
    public void processStarted() {
    }

    @Override
    public void processProgress(int filesProgress, int fileProgress, long bytesTotalParam, long bytesProcessedParam, double bytesPerMiliSecondParam) {
    }

    @Override
    public void processFinished(FCPathList<FCPath> openFCPathList, boolean open) {
    }

    @Override
    public void fileProgress() {
    }

    @Override
    public void buildReady(FCPathList<FCPath> fcPathListParam, boolean validBuild) {
        this.targetFCPathList = fcPathListParam;
    }

    public String getScanResults(boolean interactive) {
        String prefix = "";
        prefix = interactive ? "print" : "scanned";
        String results = "";
        results = results + "\r\n";
        results = results + "\r\n";
        results = results + "Scanning results:\r\n";
        results = results + "\r\n";
        if (interactive) {
            results = results + " C. Continue test\r\n";
        }
        results = results + " 1. " + prefix + " " + this.decryptedList.decryptedFiles + " decrypted files (" + Validate.getHumanSize(this.decryptedList.decryptedFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 2. " + prefix + " " + this.encryptableList.encryptableFiles + " encryptable files (" + Validate.getHumanSize(this.encryptableList.encryptableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 3. " + prefix + " " + this.encryptedList.encryptedFiles + " encrypted files (" + Validate.getHumanSize(this.encryptedList.encryptedFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 4. " + prefix + " " + this.decryptableList.decryptableFiles + " decryptable files (" + Validate.getHumanSize(this.decryptableList.decryptableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 5. " + prefix + " " + this.emptyList.emptyFiles + " empty files \r\n";
        results = results + " 6. " + prefix + " " + this.symlinkList.symlinkFiles + " symlink files \r\n";
        results = results + " 7. " + prefix + " " + this.unreadableList.unreadableFiles + " unreadable files (" + Validate.getHumanSize(this.unreadableList.unreadableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 8. " + prefix + " " + this.unwritableList.unwritableFiles + " unwritable files (" + Validate.getHumanSize(this.unwritableList.unwritableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + " 9. " + prefix + " " + this.hiddenList.hiddenFiles + " hidden files (" + Validate.getHumanSize(this.hiddenList.hiddenFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "10. " + prefix + " " + this.unencryptableList.unEncryptableFiles + " unencryptable (" + Validate.getHumanSize(this.unencryptableList.unEncryptableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "11. " + prefix + " " + this.undecryptableList.unDecryptableFiles + " undecryptable (" + Validate.getHumanSize(this.undecryptableList.unDecryptableFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "12. " + prefix + " " + this.readAutoKeyList.matchedAutoKeyFiles + " key matched files (" + Validate.getHumanSize(this.readAutoKeyList.matchedAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "13. " + prefix + " " + this.writeAutoKeyList.writeAutoKeyFiles + " key write files (" + Validate.getHumanSize(this.writeAutoKeyList.writeAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "14. " + prefix + " " + this.missingAutoKeyList.unmatchedAutoKeyFiles + " key missing files (" + Validate.getHumanSize(this.missingAutoKeyList.unmatchedAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        results = results + "\r\n";
        if (interactive) {
            results = results + "What list would you like to see ? ";
        }
        return results;
    }

    @Override
    public void test(String message) {
        this.log(message, true, true, false, false, false);
    }

    @Override
    public synchronized void log(String message, boolean status, boolean log, boolean logfile, boolean errfile, boolean print) {
        if (status || log) {
            if (!status && log) {
                this.log(message, errfile);
            } else if ((!status || log) && status && log) {
                this.log(message, errfile);
            }
        }
        if (logfile) {
            this.logfile(message);
        }
        if (errfile) {
            this.errfile(message);
        }
        if (print) {
            this.print(message, errfile);
        }
    }

    public void status(String message) {
    }

    public void log(String message, boolean err) {
        if (!err) {
            System.out.print(message);
        } else {
            System.err.print(message);
        }
    }

    public void logfile(String message) {
        try {
            Files.write(this.configuration.getLogFilePath(), message.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            this.log("Files.write(" + this.configuration.getLogFilePath() + ")..));", false, true, true, false, false);
        }
    }

    public void errfile(String message) {
        try {
            Files.write(this.configuration.getErrFilePath(), message.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException ex) {
            this.log("Files.write(" + this.configuration.getErrFilePath() + ")..));", false, true, true, false, false);
        }
    }

    public void print(String message, boolean err) {
        if (!err) {
            System.out.print(message);
        } else {
            System.err.print(message);
        }
    }

    public static void main(String[] args) {
        new CLUI(args);
    }
}

