/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import rdj.FCPath;
import rdj.Validate;

public class FCPathList<E>
extends ArrayList<E> {
    public long total = 0L;
    public long unexisting = 0L;
    public long existing = 0L;
    public long files = 0L;
    public long filesSize = 0L;
    public long directories = 0L;
    public long symlinkFiles = 0L;
    public long devices = 0L;
    public long devicesProtected = 0L;
    public long partitions = 0L;
    public long emptyFiles = 0L;
    public long readableFiles = 0L;
    public long unreadableFiles = 0L;
    public long unreadableFilesSize = 0L;
    public long writableFiles = 0L;
    public long unwritableFiles = 0L;
    public long unwritableFilesSize = 0L;
    public long hiddenFiles = 0L;
    public long hiddenFilesSize = 0L;
    public long matchingKey = 0L;
    public long validPaths = 0L;
    public long validPathsSize = 0L;
    public long validFiles = 0L;
    public long validFilesSize = 0L;
    public long validDevices = 0L;
    public long validDevicesSize = 0L;
    public long validDevicesProtected = 0L;
    public long validDevicesProtectedSize = 0L;
    public long validPartitions = 0L;
    public long validPartitionsSize = 0L;
    public long keyWrite = 0L;
    public long keyWriteSize = 0L;
    public long keyRead = 0L;
    public long keyReadSize = 0L;
    public long keyMissing = 0L;
    public long keyMissingSize = 0L;
    public long decryptedFiles = 0L;
    public long decryptedFilesSize = 0L;
    public long encryptableFiles = 0L;
    public long encryptableFilesSize = 0L;
    public long writeAutoKeyFiles = 0L;
    public long writeAutoKeyFilesSize = 0L;
    public long matchedAutoKeyFiles = 0L;
    public long matchedAutoKeyFilesSize = 0L;
    public long unmatchedAutoKeyFiles = 0L;
    public long unmatchedAutoKeyFilesSize = 0L;
    public long newEncryptedFiles = 0L;
    public long newEncryptedFilesSize = 0L;
    public long encryptRemainingFiles = 0L;
    public long encryptRemainingFilesSize = 0L;
    public long unEncryptableFiles = 0L;
    public long unEncryptableFilesSize = 0L;
    public long encryptedFiles = 0L;
    public long encryptedFilesSize = 0L;
    public long decryptableFiles = 0L;
    public long decryptableFilesSize = 0L;
    public long newDecryptedFiles = 0L;
    public long newDecryptedFilesSize = 0L;
    public long decryptRemainingFiles = 0L;
    public long decryptRemainingFilesSize = 0L;
    public long unDecryptableFiles = 0L;
    public long unDecryptableFilesSize = 0L;

    public FCPathList() {
        this.clear();
        this.clearStats();
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        if (result) {
            this.addStat((FCPath)e);
        }
        return result;
    }

    public void addStat(FCPath fcPath) {
        ++this.total;
        if (fcPath.exist) {
            ++this.existing;
            if (fcPath.matchKey) {
                ++this.matchingKey;
            }
            if (fcPath.type == 4) {
                ++this.devices;
                if (fcPath.isValidDevice) {
                    ++this.validDevices;
                    this.validDevicesSize += fcPath.size;
                }
            } else if (fcPath.type == 7) {
                ++this.devicesProtected;
                if (fcPath.isValidDeviceProtected) {
                    ++this.validDevicesProtected;
                    this.validDevicesProtectedSize += fcPath.size;
                }
            } else if (fcPath.type == 5) {
                ++this.partitions;
                if (fcPath.isValidPartition) {
                    ++this.validPartitions;
                    this.validPartitionsSize += fcPath.size;
                }
            } else if (fcPath.type == 2) {
                ++this.directories;
            } else if (fcPath.type == 0) {
                ++this.unexisting;
            } else if (fcPath.type == 3) {
                ++this.symlinkFiles;
            } else if (fcPath.type == 1) {
                ++this.files;
                if (fcPath.size > 0L) {
                    this.filesSize += fcPath.size;
                } else {
                    ++this.emptyFiles;
                }
                if (fcPath.isReadable) {
                    ++this.readableFiles;
                } else {
                    ++this.unreadableFiles;
                    this.unreadableFilesSize += fcPath.size;
                }
                if (fcPath.isWritable) {
                    ++this.writableFiles;
                } else {
                    ++this.unwritableFiles;
                    this.unwritableFilesSize += fcPath.size;
                }
                if (fcPath.isHidden) {
                    ++this.hiddenFiles;
                    this.hiddenFilesSize += fcPath.size;
                }
                if (fcPath.isValidPath) {
                    ++this.validPaths;
                    this.validPathsSize += fcPath.size;
                }
                if (fcPath.isValidFile) {
                    ++this.validFiles;
                    this.validFilesSize += fcPath.size;
                }
                if (fcPath.isDecrypted) {
                    ++this.decryptedFiles;
                    this.decryptedFilesSize += fcPath.size;
                }
                if (fcPath.isEncryptable) {
                    ++this.encryptableFiles;
                    this.encryptableFilesSize += fcPath.size;
                }
                if (fcPath.needsWriteAutoKey) {
                    ++this.writeAutoKeyFiles;
                    this.writeAutoKeyFilesSize += fcPath.needsWriteAutoKeySize;
                }
                if (fcPath.matchedReadAutoKey) {
                    ++this.matchedAutoKeyFiles;
                    this.matchedAutoKeyFilesSize += fcPath.matchedReadAutoKeySize;
                }
                if (fcPath.unmatchedReadAutoKey) {
                    ++this.unmatchedAutoKeyFiles;
                    this.unmatchedAutoKeyFilesSize += fcPath.unmatchedReadAutoKeySize;
                }
                if (fcPath.isNewEncrypted) {
                    ++this.newEncryptedFiles;
                    this.newEncryptedFilesSize += fcPath.size;
                }
                if (fcPath.size > 0L && fcPath.isDecrypted && fcPath.isUnEncryptable) {
                    ++this.unEncryptableFiles;
                    this.unEncryptableFilesSize += fcPath.size;
                }
                if (fcPath.isEncrypted) {
                    ++this.encryptedFiles;
                    this.encryptedFilesSize += fcPath.size;
                }
                if (fcPath.isDecryptable) {
                    ++this.decryptableFiles;
                    this.decryptableFilesSize += fcPath.size;
                }
                if (fcPath.isNewDecrypted) {
                    ++this.newDecryptedFiles;
                    this.newDecryptedFilesSize += fcPath.size;
                }
                if (fcPath.size > 0L && fcPath.isEncrypted && fcPath.isUnDecryptable) {
                    ++this.unDecryptableFiles;
                    this.unDecryptableFilesSize += fcPath.size;
                }
            }
        } else {
            ++this.unexisting;
        }
    }

    public void updateStat(FCPath oldFCPath, FCPath newFCPath) {
        this.removeStat(oldFCPath);
        this.addStat(newFCPath);
        oldFCPath = newFCPath.clone(newFCPath);
    }

    public void removeStat(FCPath fcPath) {
        --this.total;
        if (fcPath.exist) {
            --this.existing;
            if (fcPath.matchKey) {
                --this.matchingKey;
            }
            if (fcPath.type == 4) {
                --this.devices;
                if (fcPath.isValidDevice) {
                    --this.validDevices;
                    this.validDevicesSize -= fcPath.size;
                }
            } else if (fcPath.type == 7) {
                --this.devicesProtected;
                if (fcPath.isValidDeviceProtected) {
                    --this.validDevicesProtected;
                    this.validDevicesProtectedSize -= fcPath.size;
                }
            } else if (fcPath.type == 5) {
                --this.partitions;
                if (fcPath.isValidPartition) {
                    --this.validPartitions;
                    this.validPartitionsSize -= fcPath.size;
                }
            } else if (fcPath.type == 2) {
                --this.directories;
            } else if (fcPath.type == 0) {
                --this.unexisting;
            } else if (fcPath.type == 3) {
                --this.symlinkFiles;
            } else if (fcPath.type == 1) {
                --this.files;
                if (fcPath.size > 0L) {
                    this.filesSize -= fcPath.size;
                } else {
                    --this.emptyFiles;
                }
                if (fcPath.isReadable) {
                    --this.readableFiles;
                } else {
                    --this.unreadableFiles;
                    this.unreadableFilesSize -= fcPath.size;
                }
                if (fcPath.isWritable) {
                    --this.writableFiles;
                } else {
                    --this.unwritableFiles;
                    this.unwritableFilesSize -= fcPath.size;
                }
                if (fcPath.isHidden) {
                    --this.hiddenFiles;
                    this.hiddenFilesSize -= fcPath.size;
                }
                if (fcPath.isValidPath) {
                    --this.validPaths;
                    this.validPathsSize -= fcPath.size;
                }
                if (fcPath.isValidFile) {
                    --this.validFiles;
                    this.validFilesSize -= fcPath.size;
                }
                if (fcPath.isDecrypted) {
                    --this.decryptedFiles;
                    this.decryptedFilesSize -= fcPath.size;
                }
                if (fcPath.isEncryptable) {
                    --this.encryptableFiles;
                    this.encryptableFilesSize -= fcPath.size;
                }
                if (fcPath.needsWriteAutoKey) {
                    --this.writeAutoKeyFiles;
                    this.writeAutoKeyFilesSize -= fcPath.needsWriteAutoKeySize;
                }
                if (fcPath.matchedReadAutoKey) {
                    --this.matchedAutoKeyFiles;
                    this.matchedAutoKeyFilesSize -= fcPath.matchedReadAutoKeySize;
                }
                if (fcPath.unmatchedReadAutoKey) {
                    --this.unmatchedAutoKeyFiles;
                    this.unmatchedAutoKeyFilesSize -= fcPath.unmatchedReadAutoKeySize;
                }
                if (fcPath.isNewEncrypted) {
                    --this.newEncryptedFiles;
                    this.newEncryptedFilesSize -= fcPath.size;
                }
                if (fcPath.isEncryptable) {
                    --this.encryptRemainingFiles;
                    this.encryptRemainingFilesSize -= fcPath.size;
                }
                if (fcPath.size > 0L && fcPath.isDecrypted && fcPath.isUnEncryptable) {
                    --this.unEncryptableFiles;
                    this.unEncryptableFilesSize -= fcPath.size;
                }
                if (fcPath.isEncrypted) {
                    --this.encryptedFiles;
                    this.encryptedFilesSize -= fcPath.size;
                }
                if (fcPath.isDecryptable) {
                    --this.decryptableFiles;
                    this.decryptableFilesSize -= fcPath.size;
                }
                if (fcPath.isNewDecrypted) {
                    --this.newDecryptedFiles;
                    this.newDecryptedFilesSize -= fcPath.size;
                }
                if (fcPath.isDecryptable) {
                    --this.decryptRemainingFiles;
                    this.decryptRemainingFilesSize -= fcPath.size;
                }
                if (fcPath.size > 0L && fcPath.isEncrypted && fcPath.isUnDecryptable) {
                    --this.unDecryptableFiles;
                    this.unDecryptableFilesSize -= fcPath.size;
                }
            }
        } else {
            --this.unexisting;
        }
    }

    public void updateStats() {
        this.clearStats();
        for (Object e : this) {
            this.addStat((FCPath)e);
        }
    }

    public String getStats() {
        String returnString = "";
        returnString = returnString + "FCPathList Stats:\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Elements\t\t: " + this.size() + "\r\n";
        returnString = returnString + "Paths Total\t\t: " + this.total + "\r\n";
        returnString = returnString + "Paths Unexisting\t: " + this.unexisting + "\r\n";
        returnString = returnString + "Paths Existing\t\t: " + this.existing + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Files\t\t\t: " + this.files + "\r\n";
        returnString = returnString + "Files Total Size\t: " + Validate.getHumanSize(this.filesSize, 1, "Bytes") + "\r\n";
        returnString = returnString + "Symlink Files\t\t: " + this.symlinkFiles + "\r\n";
        returnString = returnString + "Devices\t\t\t: " + this.devices + "\r\n";
        returnString = returnString + "Devices Protected\t: " + this.devicesProtected + "\r\n";
        returnString = returnString + "Partitions\t\t: " + this.partitions + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Empty Files\t\t: " + this.emptyFiles + "\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Readable Files\t\t: " + this.readableFiles + "\r\n";
        returnString = returnString + "Writable Files\t\t: " + this.writableFiles + "\r\n";
        returnString = returnString + "Hidden Files\t\t: " + this.hiddenFiles + "\r\n";
        returnString = returnString + "Valid Paths\t\t: " + this.validPaths + " (" + Validate.getHumanSize(this.validPathsSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Valid Files\t\t: " + this.validFiles + " (" + Validate.getHumanSize(this.validFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Valid Devices\t\t: " + this.validDevices + " (" + Validate.getHumanSize(this.validDevicesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Valid Devices\t\t: " + this.validDevicesProtected + " (" + Validate.getHumanSize(this.validDevicesProtectedSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Valid Partitions\t: " + this.validPartitions + " (" + Validate.getHumanSize(this.validPartitionsSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Unencrypted Files\t: " + this.decryptedFiles + " (" + Validate.getHumanSize(this.decryptedFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Encryptable Files\t: " + this.encryptableFiles + " (" + Validate.getHumanSize(this.encryptableFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Unencryptable Files\t: " + this.unEncryptableFiles + " (" + Validate.getHumanSize(this.unEncryptableFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Encrypted Files \t: " + this.encryptedFiles + " (" + Validate.getHumanSize(this.encryptedFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Decryptable Files\t: " + this.decryptableFiles + " (" + Validate.getHumanSize(this.decryptableFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "UnDecryptable Files\t: " + this.unDecryptableFiles + " (" + Validate.getHumanSize(this.unDecryptableFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "\r\n";
        returnString = returnString + "Create Keys\t\t: " + this.writeAutoKeyFiles + " (" + Validate.getHumanSize(this.writeAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Match Keys\t\t: " + this.matchedAutoKeyFiles + " (" + Validate.getHumanSize(this.matchedAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "Missing Keys\t\t: " + this.unmatchedAutoKeyFiles + " (" + Validate.getHumanSize(this.unmatchedAutoKeyFilesSize, 1, "Bytes") + ")\r\n";
        returnString = returnString + "\r\n";
        return returnString;
    }

    public void clearStats() {
        this.clear();
        this.total = 0L;
        this.unexisting = 0L;
        this.existing = 0L;
        this.files = 0L;
        this.directories = 0L;
        this.symlinkFiles = 0L;
        this.devices = 0L;
        this.devicesProtected = 0L;
        this.partitions = 0L;
        this.filesSize = 0L;
        this.emptyFiles = 0L;
        this.readableFiles = 0L;
        this.writableFiles = 0L;
        this.hiddenFiles = 0L;
        this.matchingKey = 0L;
        this.validPaths = 0L;
        this.validPathsSize = 0L;
        this.validFiles = 0L;
        this.validFilesSize = 0L;
        this.validDevices = 0L;
        this.validDevicesSize = 0L;
        this.validDevicesProtected = 0L;
        this.validDevicesProtectedSize = 0L;
        this.validPartitions = 0L;
        this.validPartitionsSize = 0L;
        this.keyWrite = 0L;
        this.keyWriteSize = 0L;
        this.keyRead = 0L;
        this.keyReadSize = 0L;
        this.keyMissing = 0L;
        this.keyMissingSize = 0L;
        this.decryptedFiles = 0L;
        this.decryptedFilesSize = 0L;
        this.encryptableFiles = 0L;
        this.encryptableFilesSize = 0L;
        this.writeAutoKeyFiles = 0L;
        this.writeAutoKeyFilesSize = 0L;
        this.newEncryptedFiles = 0L;
        this.newEncryptedFilesSize = 0L;
        this.encryptRemainingFiles = 0L;
        this.encryptRemainingFilesSize = 0L;
        this.unEncryptableFiles = 0L;
        this.unEncryptableFilesSize = 0L;
        this.encryptedFiles = 0L;
        this.encryptedFilesSize = 0L;
        this.decryptableFiles = 0L;
        this.decryptableFilesSize = 0L;
        this.newDecryptedFiles = 0L;
        this.newDecryptedFilesSize = 0L;
        this.decryptRemainingFiles = 0L;
        this.decryptRemainingFilesSize = 0L;
        this.unDecryptableFiles = 0L;
        this.unDecryptableFilesSize = 0L;
    }
}

