/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rdj.Language;
import rdj.UI;

public class LanguageList<E>
extends ArrayList<E> {
    private UI ui;
    private String returnString;

    public LanguageList(UI ui) {
        this.ui = ui;
        this.loadLanguages(ui);
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        return result;
    }

    public void loadLanguages(UI ui) {
        String iso639ResourceString = "/rdj/language/iso639.txt";
        InputStream inputStream = this.getClass().getResourceAsStream(iso639ResourceString);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String languageLine = "";
            while ((languageLine = bufferedReader.readLine()) != null) {
                String[] field = languageLine.split("[|]");
                String iso639_2B = field[0];
                String iso639_2T = field[1];
                String iso639_1 = field[2];
                ArrayList<String> languageNameEngList = new ArrayList<String>();
                ArrayList<String> languageNameFreList = new ArrayList<String>();
                for (String langNameEng : field[3].split("[;]")) {
                    languageNameEngList.add(langNameEng);
                }
                for (String langNameFre : field[4].split("[;]")) {
                    languageNameFreList.add(langNameFre);
                }
                boolean installed = false;
                installed = this.getClass().getResource("/rdj/language/translation_" + iso639_2B + ".properties") != null ? true : (this.getClass().getResource("/rdj/language/translation_" + iso639_2T + ".properties") != null ? true : this.getClass().getResource("/rdj/language/translation_" + iso639_1 + ".properties") != null);
                Language language = new Language(iso639_2B, iso639_2T, iso639_1, languageNameEngList, languageNameFreList, installed);
                this.add(language);
            }
        }
        catch (IOException ex) {
            ui.log("Error: bufferedReader.readLine(" + iso639ResourceString + ");" + ex.getMessage(), false, true, true, true, false);
        }
    }

    @Override
    public String toString() {
        this.returnString = "";
        this.forEach((? super E language) -> {
            this.returnString = this.returnString + language.toString();
        });
        return this.returnString;
    }

    public ArrayList<String> getInstalledLanguageNamesList(LanguageList<Language> languageList) {
        ArrayList<String> languageNamesList = new ArrayList<String>();
        for (Language language : languageList) {
            if (!language.installed) continue;
            for (String name : language.languageNameEnglishList) {
                languageNamesList.add(name);
            }
        }
        Collections.sort(languageNamesList, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        });
        return languageNamesList;
    }
}

