/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import rdj.UI;

public class RNG {
    public static ByteBuffer getFCRandomBuffer(UI ui, int size, boolean extraSeed, boolean encrypt, boolean print) {
        if (encrypt) {
            ByteBuffer randomBuffer1 = RNG.getRandomBuffer(ui, size, extraSeed, print);
            ByteBuffer randomBuffer2 = RNG.getRandomBuffer(ui, size, extraSeed, print);
            if (print) {
                ui.log("\r\n", false, true, true, false, false);
            }
            return RNG.encryptBuffer(randomBuffer1, randomBuffer2, false);
        }
        ByteBuffer randomBuffer1 = RNG.getRandomBuffer(ui, size, extraSeed, print);
        if (print) {
            ui.log("\r\n", false, true, true, false, false);
        }
        return randomBuffer1;
    }

    private static ByteBuffer getRandomBuffer(UI ui, int size, boolean extraSeed, boolean print) {
        byte[] randomBytes = new byte[size];
        ByteBuffer randomBuffer = ByteBuffer.allocate(size);
        randomBuffer.clear();
        SecureRandom random = new SecureRandom();
        if (extraSeed) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException ex) {
                ui.log("Error: NoSuchAlgorithmException: MessageDigest.getInstance(\" SHA-256\")\r\n", true, true, true, true, false);
            }
            messageDigest.update(Long.valueOf(System.nanoTime()).byteValue());
            if (print) {
                byte[] hashBytes = messageDigest.digest();
                ui.log("\r\n" + RNG.getHexString(hashBytes, 2), false, true, true, false, false);
            }
            random.setSeed(messageDigest.digest());
        }
        random.nextBytes(randomBytes);
        randomBuffer.put(randomBytes);
        randomBuffer.flip();
        return randomBuffer;
    }

    private static ByteBuffer getRandomBuffer2(UI ui, int size, boolean extraSeed, boolean print) {
        byte[] randomBytes = new byte[size];
        ByteBuffer randomBuffer = ByteBuffer.allocate(size);
        randomBuffer.clear();
        byte rngByte = 0;
        for (int x = 0; x < size; ++x) {
            for (int b = 1; b <= 8; ++b) {
                rngByte = (byte)(rngByte << 1);
                rngByte = (byte)(rngByte + (int)(Math.round(Math.random()) & 1L));
            }
            randomBuffer.put(rngByte);
        }
        randomBuffer.flip();
        return randomBuffer;
    }

    public static ByteBuffer encryptBuffer(ByteBuffer targetSourceBuffer, ByteBuffer keySourceBuffer, boolean printEnabled) {
        ByteBuffer targetDestinBuffer = ByteBuffer.allocate(keySourceBuffer.capacity());
        targetDestinBuffer.clear();
        for (int targetSourceBufferCount = 0; targetSourceBufferCount < targetSourceBuffer.limit(); ++targetSourceBufferCount) {
            byte targetSourceByte = targetSourceBuffer.get(targetSourceBufferCount);
            byte keySourceByte = keySourceBuffer.get(targetSourceBufferCount);
            byte targetDestinByte = RNG.encryptByte(targetSourceByte, keySourceByte);
            targetDestinBuffer.put(targetDestinByte);
        }
        targetDestinBuffer.flip();
        return targetDestinBuffer;
    }

    public static byte encryptByte(byte targetSourceByte, byte keySourceByte) {
        return (byte)(targetSourceByte ^ keySourceByte);
    }

    public static synchronized String getHexString(byte[] bytes, int digits) {
        String returnString = "";
        for (byte mybyte : bytes) {
            returnString = returnString + RNG.getHexString(mybyte, digits);
        }
        return returnString;
    }

    public static synchronized String getHexString(byte value, int digits) {
        return String.format("%0" + Integer.toString(digits) + "X", value & 0xFF).replaceAll("[^A-Za-z0-9]", "");
    }
}

