/*
 * Decompiled with CFR 0.152.
 */
package rdj;

import java.util.ArrayList;
import java.util.Arrays;

public class Stats {
    private long filesProcessed = 0L;
    private long filesTotal = 0L;
    private long fileBytesProcessed = 0L;
    private long fileBytesTotal = 0L;
    private long filesBytesProcessed = 0L;
    private long filesBytesTotal = 0L;
    private long fileStartNanoTime = 0L;
    private long fileEndNanoTime = 0L;
    private long filesStartNanoTime = 0L;
    private long filesEndNanoTime = 0L;
    private long nanoSeconds = 0L;

    public long getFilesProcessed() {
        return this.filesProcessed;
    }

    public long getFilesTotal() {
        return this.filesTotal;
    }

    public long getFileBytesProcessed() {
        return this.fileBytesProcessed;
    }

    public long getFileBytesTotal() {
        return this.fileBytesTotal;
    }

    public long getFilesBytesProcessed() {
        return this.filesBytesProcessed;
    }

    public long getFilesBytesTotal() {
        return this.filesBytesTotal;
    }

    public long getFileStartEpoch() {
        return this.fileStartNanoTime;
    }

    public long getFileEndEpoch() {
        return this.fileEndNanoTime;
    }

    public long getAllDataStartEpoch() {
        return this.filesStartNanoTime;
    }

    public long getAllDataEndEpoch() {
        return this.filesEndNanoTime;
    }

    public void setFilesProcessed(long filesProcessed) {
        this.filesProcessed = filesProcessed;
    }

    public void setFilesTotal(long filesTotal) {
        this.filesTotal = filesTotal;
    }

    public void setFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed = fileBytesProcessed;
    }

    public void setFileBytesTotal(long fileBytesTotal) {
        this.fileBytesTotal = fileBytesTotal;
    }

    public void setAllDataBytesProcessed(long filesBytesProcessed) {
        this.filesBytesProcessed = filesBytesProcessed;
    }

    public void setAllDataBytesTotal(long filesBytesTotal) {
        this.filesBytesTotal = filesBytesTotal;
    }

    public void setFileStartNanoTime() {
        this.fileStartNanoTime = System.nanoTime();
    }

    public void setFileEndNanoTime() {
        this.fileEndNanoTime = System.nanoTime();
    }

    public void setAllDataStartNanoTime() {
        this.filesStartNanoTime = System.nanoTime();
    }

    public void setAllDataEndNanoTime() {
        this.filesEndNanoTime = System.nanoTime();
    }

    public void clock() {
        this.nanoSeconds += this.filesEndNanoTime - this.filesStartNanoTime;
    }

    public void addFilesProcessed(long filesProcessed) {
        this.filesProcessed += filesProcessed;
    }

    public void addFilesTotal(long filesTotal) {
        this.filesTotal += filesTotal;
    }

    public void addFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed += fileBytesProcessed;
    }

    public void subFileBytesProcessed(long fileBytesProcessed) {
        this.fileBytesProcessed -= fileBytesProcessed;
    }

    public void addFileBytesTotal(long fileBytesTotal) {
        this.fileBytesTotal += fileBytesTotal;
    }

    public void addAllDataBytesProcessed(String s, long filesBytesProcessed) {
        this.filesBytesProcessed += filesBytesProcessed;
    }

    public void addAllDataBytesTotal(long filesBytesTotal) {
        this.filesBytesTotal += filesBytesTotal;
    }

    public String getStartSummary(String mode) {
        String fileString = "files";
        fileString = this.filesTotal == 1L ? "file" : "files";
        String returnString = "\r\nStarted " + mode + " " + this.filesTotal + " " + fileString + " totally " + Stats.getHumanSize(this.filesBytesTotal, 1, "Bytes") + "\r\n\r\n";
        return returnString;
    }

    public String getAllDataBytesProgressPercentage() {
        String returnString = new String();
        double percentage = (double)this.filesBytesProcessed / (double)this.filesBytesTotal * 100.0;
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        String throughputString = String.format("%.1f", percentage);
        returnString = throughputString + "%";
        return returnString;
    }

    public String getEndSummary(String mode) {
        String fileString = "files";
        fileString = this.filesTotal == 1L ? "file" : "files";
        String returnString = "\r\nFinished " + mode + " [" + this.filesProcessed + " / " + this.filesTotal + "] " + fileString + " totally [" + Stats.getHumanSize(this.filesBytesProcessed, 1, "Bytes") + " / " + Stats.getHumanSize(this.filesBytesTotal, 1, "Bytes") + "] in " + this.getElapsedTime(this.nanoSeconds) + " " + this.getAllDataBytesThroughPut() + "\r\n\r\n";
        return returnString;
    }

    public String getElapsedTime(long nanosecs) {
        long totalSecs = Double.valueOf((double)nanosecs / 1.0E9).longValue();
        long days = totalSecs / 86400L;
        long hours = totalSecs / 3600L;
        long minutes = totalSecs % 3600L / 60L;
        long seconds = totalSecs % 60L;
        String dayDesc = "";
        String duration = "";
        dayDesc = days == 1L ? "day" : "days";
        duration = days > 0L ? String.format("[%1d %s %02d:%02d:%02d]", days, dayDesc, hours, minutes, seconds) : String.format("[%02d:%02d:%02d]", hours, minutes, seconds);
        return duration;
    }

    public String getAllDataBytesThroughPut() {
        String returnString = new String();
        double throughput = (double)this.filesBytesProcessed / ((double)this.nanoSeconds / 1.0E9);
        String throughputString = String.format("%.1f", throughput);
        returnString = "(average: " + Stats.getHumanSize(throughput, 1, "Bytes") + "/s)\r\n";
        return returnString;
    }

    public String getBruteForceThroughPut(long items, long nanosecs) {
        String returnString = new String();
        double throughput = (double)items / ((double)nanosecs / 1.0E9);
        String throughputString = String.format("%.0f", throughput);
        returnString = "(average: " + throughputString + " passwords/sec)\r\n";
        return returnString;
    }

    public static String getHumanSize(double value, int decimals, String unit) {
        long factor;
        int x = 0;
        double newValue = value;
        String returnString = new String("");
        ArrayList<String> magnitude = new ArrayList<String>();
        magnitude.addAll(Arrays.asList("Zi" + unit.charAt(0), "Ei" + unit.charAt(0), "Pi" + unit.charAt(0), "Ti" + unit.charAt(0), "Gi" + unit.charAt(0), "Mi" + unit.charAt(0), "Ki" + unit.charAt(0), unit));
        for (factor = 70L; factor > 0L; factor -= 10L) {
            if (value / Math.pow(2.0, factor) >= 1.0) {
                newValue = value / Math.pow(2.0, factor);
                returnString = String.format("%.1f", newValue) + " " + (String)magnitude.get(x);
                break;
            }
            ++x;
        }
        if (factor == 0L) {
            newValue = value / Math.pow(2.0, factor);
            returnString = String.format("%." + decimals + "f", newValue) + " " + (String)magnitude.get(x);
        }
        return returnString;
    }

    public static String getDecimal(double value, int decimals) {
        return String.format("%." + decimals + "f", value);
    }

    public void reset() {
        this.filesProcessed = 0L;
        this.filesTotal = 0L;
        this.fileBytesProcessed = 0L;
        this.fileBytesTotal = 0L;
        this.filesBytesProcessed = 0L;
        this.filesBytesTotal = 0L;
        this.fileStartNanoTime = 0L;
        this.fileEndNanoTime = 0L;
        this.filesStartNanoTime = 0L;
        this.filesEndNanoTime = 0L;
        this.nanoSeconds = 0L;
    }
}

