/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class OpenResourceQuickAccessComputer
implements IQuickAccessComputer,
IQuickAccessComputerExtension {
    private static final long TIMEOUT_MS = 200L;

    public QuickAccessElement[] computeElements(String query, IProgressMonitor monitor) {
        SearchPattern searchPattern = new SearchPattern();
        searchPattern.setPattern(query);
        ArrayList res = new ArrayList();
        long startTime = System.currentTimeMillis();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(resourceProxy -> {
                String name;
                if (resourceProxy.isDerived() || !resourceProxy.isAccessible()) {
                    return false;
                }
                if (resourceProxy.getType() == 1 && searchPattern.matches(name = resourceProxy.getName())) {
                    IFile file = (IFile)resourceProxy.requestResource();
                    res.add(new ResourceElement(labelProvider, file));
                }
                return !monitor.isCanceled() && System.currentTimeMillis() - startTime < 200L;
            }, 0);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        labelProvider.dispose();
        return res.toArray(new QuickAccessElement[res.size()]);
    }

    public QuickAccessElement[] computeElements() {
        return new QuickAccessElement[0];
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return false;
    }

    private static class ResourceElement
    extends QuickAccessElement {
        private final WorkbenchLabelProvider fLabelProvider;
        private final IFile fFile;

        private ResourceElement(WorkbenchLabelProvider labelProvider, IFile resource) {
            this.fLabelProvider = labelProvider;
            this.fFile = resource;
        }

        public String getLabel() {
            return this.fLabelProvider.getText((Object)this.fFile);
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromImageDataProvider(zoom -> this.fLabelProvider.getImage((Object)this.fFile).getImageData());
        }

        public String getId() {
            return this.fFile.getFullPath().toString();
        }

        public void execute() {
            try {
                IDE.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), this.fFile);
            }
            catch (PartInitException e) {
                IDEWorkbenchPlugin.log(e.getMessage(), e);
            }
        }
    }
}

