//
//  PPlotView.m
//  PPlotCocoa
//
//  Created by Drew McCormack on Mon Nov 04 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//

#import "PPlotView.h"
#import "CocoaPainter.h"
#import "PPlotInteraction.h"

@implementation PPlotView

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setCocoaPainter:(new CocoaPainter(self))];
    }
    return self;
}

-(void)dealloc {
    if ( mCocoaPainter ) delete mCocoaPainter;
    [super dealloc];
}

-(CocoaPainter *)cocoaPainter {
    return mCocoaPainter;
}

-(void)setCocoaPainter:(CocoaPainter *)painter {
    if ( mCocoaPainter ) delete mCocoaPainter;
    mCocoaPainter = painter;
}

-(void)drawRect:(NSRect)rect {
    if ( mCocoaPainter ) mCocoaPainter->paint();
}

-(PPlot *)pplot {
    return &([self cocoaPainter]->mPPlot);
}

-(BOOL)isFlipped {
    return YES;
}

-(BOOL)canBecomeKeyView {
    return YES;
}

-(BOOL)acceptsFirstResponder {  
    return YES;
}

+(int)extractModifiersFromCocoaEvent:(NSEvent *)cocoaEvent {
    BOOL shiftDown   = ( ([cocoaEvent modifierFlags] & NSShiftKeyMask) != 0 );
    BOOL controlDown = ( ([cocoaEvent modifierFlags] & NSControlKeyMask) != 0 );
    BOOL altDown     = ( ([cocoaEvent modifierFlags] & NSAlternateKeyMask) != 0 );
    int modifierKeys = 0;
    if ( altDown )     modifierKeys = (modifierKeys | PMouseEvent::kAlt);
    if ( controlDown ) modifierKeys = (modifierKeys | PMouseEvent::kControl);
    if ( shiftDown )   modifierKeys = (modifierKeys | PMouseEvent::kShift);
    return modifierKeys;
}

-(PMouseEvent)convertMouseEvent:(NSEvent *)cocoaEvent {
    NSPoint mouseLoc = [self convertPoint:[cocoaEvent locationInWindow] fromView:nil];
    int modifierKeys = [[self class] extractModifiersFromCocoaEvent:cocoaEvent];
    PMouseEvent pplotEvent((int)mouseLoc.x, (int)mouseLoc.y, PMouseEvent::kDown, modifierKeys);
    return pplotEvent;
}

-(void)keyDown:(NSEvent *)theEvent {
    unichar theKey = [[theEvent charactersIgnoringModifiers] characterAtIndex:0];
    int theModifierKeys = [[self class] extractModifiersFromCocoaEvent:theEvent];
    BOOL isRepeat = [theEvent isARepeat];

    PKeyEvent::EKey theKeyCode = PKeyEvent::kNone;
    char theChar = 0;
    switch (theKey) {
    case NSLeftArrowFunctionKey:
        theKeyCode = PKeyEvent::kArrowLeft;
        break;
    case NSUpArrowFunctionKey:
        theKeyCode = PKeyEvent::kArrowUp;
        break;
    case NSDownArrowFunctionKey:
        theKeyCode = PKeyEvent::kArrowDown;
        break;
    case NSDeleteCharacter:
    case NSBackspaceCharacter:
        theKeyCode = PKeyEvent::kDelete;
        break;
    case NSRightArrowFunctionKey:
        theKeyCode = PKeyEvent::kArrowRight;
        break;
    default:
        if ( theKey >= 'a' && theKey <= 'z' ) {
            theKeyCode = PKeyEvent::kChar;
            theChar = (char)theKey;
        }
        break;
    }
    if (theKeyCode != PKeyEvent::kNone) {
        PKeyEvent theEvent (theKeyCode, ( isRepeat ? 1 : 0 ), theModifierKeys, theChar);
        if ( mCocoaPainter->mInteractionContainer.HandleKeyEvent(theEvent) ) [self setNeedsDisplay:YES];
    } 
    else {
        [super keyDown:theEvent];
    }
}

-(void)mouseDown:(NSEvent *)event {
    PMouseEvent theEvent = [self convertMouseEvent:event];
    theEvent.mType = PMouseEvent::kDown;
    if (mCocoaPainter->mInteractionContainer.HandleMouseEvent(theEvent)) [self setNeedsDisplay:YES];
}

-(void)mouseUp:(NSEvent *)event {
    PMouseEvent theEvent = [self convertMouseEvent:event];
    theEvent.mType = PMouseEvent::kUp;
    if (mCocoaPainter->mInteractionContainer.HandleMouseEvent(theEvent)) [self setNeedsDisplay:YES];
}

-(void)mouseDragged:(NSEvent *)event {
    PMouseEvent theEvent = [self convertMouseEvent:event];
    theEvent.mType = PMouseEvent::kMove;
    if (mCocoaPainter->mInteractionContainer.HandleMouseEvent(theEvent)) [self setNeedsDisplay:YES];
}

@end
