%module pplot
 %{
 /* Includes the header in the wrapper code */
 #include "../generic/PPlot.h"
 using namespace std;
 %}
 
 /* Parse the header file to generate wrappers */

 %typemap(in) PlotDataBase * {
     // convert ruby array to PlotData.
     // takes ownership
     PlotData *thePlotData = new PlotData ();

     int size = RARRAY($input)->len;     
     int i;
    /* Get the first element in memory */
    VALUE *ptr = RARRAY($input)->ptr;   
    for (i=0; i < size; i++, ptr++) {
      /* Convert Ruby Object String to char* */
      float theValue = NUM2DBL (*ptr);
      thePlotData->push_back (theValue); 
    }

     $1 = thePlotData;
  }
 %typemap(out) PlotDataBase * {
     // convert PlotData to ruby array
     if (!$1) {
	$result=Qnil;
     }

     const RealPlotData *thePlotData = $1->GetRealPlotData ();

     VALUE arr = rb_ary_new2(thePlotData->size());
     

     for (long theI=0;theI<thePlotData->size ();theI++) {
      float theValue = (*thePlotData)[theI];
      VALUE theBla = rb_float_new (theValue);
      rb_ary_push(arr, theBla);
     }
     $result = arr;

  }
 %include "../generic/PPlot.h"
