/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    inline SwigValueWrapper() : tt(0) { }
    inline ~SwigValueWrapper() { if (tt) delete tt; } 
    inline SwigValueWrapper& operator=(const T& t) { tt = new T(t); return *this; }
    inline operator T&() const { return *tt; }
    inline T *operator&() { return tt; }
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE  klass;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return STR2CSTR(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else
    Data_Get_Struct(obj, void, *ptr);
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (!rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (flags)
	    rb_raise(rb_eTypeError, "wrong argument type (expected %s)", ty->str);
	  else
	    return -1;
	}
        if (*ptr == 0)
	  rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
    } else {
      if ((c = SWIG_MangleStr(obj)) == NULL) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      tc = SWIG_TypeCheck(c, ty);
      if (!tc) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      *ptr = SWIG_TypeCast(tc, *ptr);
    }
  }
  return 0;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

SWIGRUNTIME(VALUE)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = STR2CSTR(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_PlotDataBase swig_types[0] 
#define  SWIGTYPE_p_CalculatedDataBase swig_types[1] 
#define  SWIGTYPE_p_PRect swig_types[2] 
#define  SWIGTYPE_p_LinTrafo swig_types[3] 
#define  SWIGTYPE_p_DataDrawerBase swig_types[4] 
#define  SWIGTYPE_p_StringData swig_types[5] 
#define  SWIGTYPE_p_PainterTester swig_types[6] 
#define  SWIGTYPE_p_bool swig_types[7] 
#define  SWIGTYPE_p_PlotDataPointer swig_types[8] 
#define  SWIGTYPE_p_BarDataDrawer swig_types[9] 
#define  SWIGTYPE_p_LineDataDrawer swig_types[10] 
#define  SWIGTYPE_p_GridInfo swig_types[11] 
#define  SWIGTYPE_p_Trafo swig_types[12] 
#define  SWIGTYPE_p_LogTrafo swig_types[13] 
#define  SWIGTYPE_p_PlotBackground swig_types[14] 
#define  SWIGTYPE_p_NamedTickIterator swig_types[15] 
#define  SWIGTYPE_p_LogTickIterator swig_types[16] 
#define  SWIGTYPE_p_TickIterator swig_types[17] 
#define  SWIGTYPE_p_LinTickIterator swig_types[18] 
#define  SWIGTYPE_p_PMargins swig_types[19] 
#define  SWIGTYPE_p_PCalculator swig_types[20] 
#define  SWIGTYPE_p_string swig_types[21] 
#define  SWIGTYPE_p_LegendData swig_types[22] 
#define  SWIGTYPE_p_RealPlotData swig_types[23] 
#define  SWIGTYPE_p_PlotData swig_types[24] 
#define  SWIGTYPE_p_CalculatedPlotData swig_types[25] 
#define  SWIGTYPE_p_PlotDataContainer swig_types[26] 
#define  SWIGTYPE_p_AxisSetup swig_types[27] 
#define  SWIGTYPE_p_DummyPainter swig_types[28] 
#define  SWIGTYPE_p_Painter swig_types[29] 
#define  SWIGTYPE_p_DummyData swig_types[30] 
#define  SWIGTYPE_p_PCalculator__tList swig_types[31] 
#define  SWIGTYPE_p_PDrawer__tList swig_types[32] 
#define  SWIGTYPE_p_PColor swig_types[33] 
#define  SWIGTYPE_p_float swig_types[34] 
#define  SWIGTYPE_p_vectorTstring_t swig_types[35] 
#define  SWIGTYPE_p_CalculatedData swig_types[36] 
#define  SWIGTYPE_p_PPlot swig_types[37] 
#define  SWIGTYPE_p_PDrawer swig_types[38] 
#define  SWIGTYPE_p_TickInfo swig_types[39] 
static swig_type_info *swig_types[41];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_pplot
#define SWIG_name    "Pplot"

static VALUE mPplot;

 /* Includes the header in the wrapper code */
 #include "../generic/PPlot.h"
 using namespace std;
 

swig_class cCalculatedDataBase;
static void free_CalculatedDataBase(CalculatedDataBase *);

swig_class cPlotDataBase;
static void free_PlotDataBase(PlotDataBase *);

swig_class cPlotDataPointer;
static void free_PlotDataPointer(PlotDataPointer *);

swig_class cPlotData;
static void free_PlotData(PlotData *);

swig_class cCalculatedData;
static void free_CalculatedData(CalculatedData *);

swig_class cCalculatedPlotData;
static void free_CalculatedPlotData(CalculatedPlotData *);

swig_class cDummyData;
static void free_DummyData(DummyData *);

swig_class cStringData;
static void free_StringData(StringData *);

swig_class cPRect;
static void free_PRect(PRect *);

swig_class cPMargins;
static void free_PMargins(PMargins *);

swig_class cPColor;
static void free_PColor(PColor *);

swig_class cLegendData;
static void free_LegendData(LegendData *);

swig_class cPainter;
static void free_Painter(Painter *);

swig_class cDummyPainter;
static void free_DummyPainter(DummyPainter *);

swig_class cDataDrawerBase;
static void free_DataDrawerBase(DataDrawerBase *);

swig_class cLineDataDrawer;
static void free_LineDataDrawer(LineDataDrawer *);

swig_class cBarDataDrawer;
static void free_BarDataDrawer(BarDataDrawer *);

swig_class cPlotDataContainer;
static void free_PlotDataContainer(PlotDataContainer *);

swig_class cGridInfo;
static void free_GridInfo(GridInfo *);

swig_class cTickInfo;
static void free_TickInfo(TickInfo *);

swig_class cAxisSetup;
static void free_AxisSetup(AxisSetup *);

swig_class cTrafo;
static void free_Trafo(Trafo *);

swig_class cLinTrafo;
static void free_LinTrafo(LinTrafo *);

swig_class cLogTrafo;
static void free_LogTrafo(LogTrafo *);

swig_class cTickIterator;
static void free_TickIterator(TickIterator *);

swig_class cLinTickIterator;
static void free_LinTickIterator(LinTickIterator *);

swig_class cLogTickIterator;
static void free_LogTickIterator(LogTickIterator *);

swig_class cNamedTickIterator;
static void free_NamedTickIterator(NamedTickIterator *);

swig_class cPlotBackground;
static void free_PlotBackground(PlotBackground *);

swig_class cPDrawer;
static void free_PDrawer(PDrawer *);

swig_class cPCalculator;
static void free_PCalculator(PCalculator *);

swig_class cPainterTester;
static void free_PainterTester(PainterTester *);

swig_class cPPlot;
static void free_PPlot(PPlot *);
static VALUE
_wrap_CalculatedDataBase_GetValue(int argc, VALUE *argv, VALUE self) {
    CalculatedDataBase *arg1 = (CalculatedDataBase *) 0 ;
    long arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedDataBase, 1);
    arg2 = NUM2LONG(argv[0]);
    result = (float)((CalculatedDataBase const *)arg1)->GetValue(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CalculatedDataBase_GetSize(int argc, VALUE *argv, VALUE self) {
    CalculatedDataBase *arg1 = (CalculatedDataBase *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedDataBase, 1);
    result = (long)((CalculatedDataBase const *)arg1)->GetSize();
    
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_CalculatedDataBase(CalculatedDataBase *arg1) {
    delete arg1;
}
static void
free_PlotDataBase(PlotDataBase *arg1) {
    delete arg1;
}
static VALUE
_wrap_PlotDataBase_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(self)->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(self)->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    result = (RealPlotData *)((PlotDataBase const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static VALUE
_wrap_PlotDataBase_GetCalculatedData(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    CalculatedDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(self)->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(self)->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    result = (CalculatedDataBase *)((PlotDataBase const *)arg1)->GetCalculatedData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CalculatedDataBase,0);
    return vresult;
}


static VALUE
_wrap_PlotDataBase_GetSize(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(self)->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(self)->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    result = (long)((PlotDataBase const *)arg1)->GetSize();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PlotDataBase_GetValue(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    long arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(self)->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(self)->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    arg2 = NUM2LONG(argv[0]);
    result = (float)((PlotDataBase const *)arg1)->GetValue(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_PlotDataBase_CalculateRange(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    float *arg2 = 0 ;
    float *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(self)->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(self)->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_float, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->CalculateRange(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PlotDataPointer_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PlotDataPointer);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PlotDataPointer(int argc, VALUE *argv, VALUE self) {
    PlotDataBase *arg1 = (PlotDataBase *) 0 ;
    PlotDataPointer *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(argv[0])->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(argv[0])->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg1 = thePlotData;
    }
    result = (PlotDataPointer *)new PlotDataPointer((PlotDataBase const *)arg1);
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PlotDataPointer_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    PlotDataPointer *arg1 = (PlotDataPointer *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataPointer, 1);
    result = (RealPlotData *)((PlotDataPointer const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static VALUE
_wrap_PlotDataPointer_GetCalculatedData(int argc, VALUE *argv, VALUE self) {
    PlotDataPointer *arg1 = (PlotDataPointer *) 0 ;
    CalculatedDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataPointer, 1);
    result = (CalculatedDataBase *)((PlotDataPointer const *)arg1)->GetCalculatedData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CalculatedDataBase,0);
    return vresult;
}


static void
free_PlotDataPointer(PlotDataPointer *arg1) {
    delete arg1;
}
static VALUE
_wrap_PlotData_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    PlotData *arg1 = (PlotData *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotData, 1);
    result = (RealPlotData *)((PlotData const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static VALUE
_wrap_PlotData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PlotData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PlotData(int argc, VALUE *argv, VALUE self) {
    PlotData *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PlotData *)new PlotData();
    DATA_PTR(self) = result;
    return self;
}


static void
free_PlotData(PlotData *arg1) {
    delete arg1;
}
static VALUE
_wrap_CalculatedData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CalculatedData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_CalculatedData(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    float arg2 ;
    long arg3 ;
    CalculatedData *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    arg2 = (float) NUM2DBL(argv[1]);
    arg3 = NUM2LONG(argv[2]);
    result = (CalculatedData *)new CalculatedData(arg1,arg2,arg3);
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_CalculatedData_GetValue(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    long arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    arg2 = NUM2LONG(argv[0]);
    result = (float)((CalculatedData const *)arg1)->GetValue(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CalculatedData_GetSize(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    result = (long)((CalculatedData const *)arg1)->GetSize();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_CalculatedData_mMin_set(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mMin = arg2;
    
    return Qnil;
}


static VALUE
_wrap_CalculatedData_mMin_get(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    result = (float) ((arg1)->mMin);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CalculatedData_mDelta_set(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mDelta = arg2;
    
    return Qnil;
}


static VALUE
_wrap_CalculatedData_mDelta_get(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    result = (float) ((arg1)->mDelta);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_CalculatedData_mSize_set(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mSize = arg2;
    
    return Qnil;
}


static VALUE
_wrap_CalculatedData_mSize_get(int argc, VALUE *argv, VALUE self) {
    CalculatedData *arg1 = (CalculatedData *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedData, 1);
    result = (long) ((arg1)->mSize);
    
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_CalculatedData(CalculatedData *arg1) {
    delete arg1;
}
static VALUE
_wrap_CalculatedPlotData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_CalculatedPlotData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_CalculatedPlotData(int argc, VALUE *argv, VALUE self) {
    CalculatedDataBase *arg1 = (CalculatedDataBase *) 0 ;
    CalculatedPlotData *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_CalculatedDataBase, 1);
    result = (CalculatedPlotData *)new CalculatedPlotData(arg1);
    DATA_PTR(self) = result;
    return self;
}


static void
free_CalculatedPlotData(CalculatedPlotData *arg1) {
    delete arg1;
}
static VALUE
_wrap_CalculatedPlotData_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    CalculatedPlotData *arg1 = (CalculatedPlotData *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedPlotData, 1);
    result = (RealPlotData *)((CalculatedPlotData const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static VALUE
_wrap_CalculatedPlotData_GetCalculatedData(int argc, VALUE *argv, VALUE self) {
    CalculatedPlotData *arg1 = (CalculatedPlotData *) 0 ;
    CalculatedDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedPlotData, 1);
    result = (CalculatedDataBase *)((CalculatedPlotData const *)arg1)->GetCalculatedData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CalculatedDataBase,0);
    return vresult;
}


static VALUE
_wrap_CalculatedPlotData_mCalculatedData_set(int argc, VALUE *argv, VALUE self) {
    CalculatedPlotData *arg1 = (CalculatedPlotData *) 0 ;
    CalculatedDataBase *arg2 = (CalculatedDataBase *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedPlotData, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_CalculatedDataBase, 1);
    if (arg1) (arg1)->mCalculatedData = arg2;
    
    return Qnil;
}


static VALUE
_wrap_CalculatedPlotData_mCalculatedData_get(int argc, VALUE *argv, VALUE self) {
    CalculatedPlotData *arg1 = (CalculatedPlotData *) 0 ;
    CalculatedDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_CalculatedPlotData, 1);
    result = (CalculatedDataBase *) ((arg1)->mCalculatedData);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_CalculatedDataBase,0);
    return vresult;
}


static VALUE
_wrap_DummyData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DummyData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_DummyData(int argc, VALUE *argv, VALUE self) {
    long arg1 = (long) 0 ;
    DummyData *result;
    
    if ((argc < 0) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = NUM2LONG(argv[0]);
    }
    result = (DummyData *)new DummyData(arg1);
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_DummyData_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    DummyData *arg1 = (DummyData *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyData, 1);
    result = (RealPlotData *)((DummyData const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static void
free_DummyData(DummyData *arg1) {
    delete arg1;
}
static VALUE
_wrap_StringData_AddItem(int argc, VALUE *argv, VALUE self) {
    StringData *arg1 = (StringData *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_StringData, 1);
    arg2 = STR2CSTR(argv[0]);
    (arg1)->AddItem((char const *)arg2);
    
    return Qnil;
}


static VALUE
_wrap_StringData_GetStringData(int argc, VALUE *argv, VALUE self) {
    StringData *arg1 = (StringData *) 0 ;
    vector<string > *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_StringData, 1);
    result = (vector<string > *)((StringData const *)arg1)->GetStringData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_vectorTstring_t,0);
    return vresult;
}


static VALUE
_wrap_StringData_GetRealPlotData(int argc, VALUE *argv, VALUE self) {
    StringData *arg1 = (StringData *) 0 ;
    RealPlotData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_StringData, 1);
    result = (RealPlotData *)((StringData const *)arg1)->GetRealPlotData();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_RealPlotData,0);
    return vresult;
}


static VALUE
_wrap_StringData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_StringData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_StringData(int argc, VALUE *argv, VALUE self) {
    StringData *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (StringData *)new StringData();
    DATA_PTR(self) = result;
    return self;
}


static void
free_StringData(StringData *arg1) {
    delete arg1;
}
static VALUE
_wrap_SafeLog(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    arg2 = (float) NUM2DBL(argv[1]);
    result = (float)SafeLog(arg1,arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_SafeExp(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    arg2 = (float) NUM2DBL(argv[1]);
    result = (float)SafeExp(arg1,arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_PRect_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PRect);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PRect(int argc, VALUE *argv, VALUE self) {
    PRect *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PRect *)new PRect();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PRect_mX_set(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mX = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PRect_mX_get(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    result = (long) ((arg1)->mX);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PRect_mY_set(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mY = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PRect_mY_get(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    result = (long) ((arg1)->mY);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PRect_mW_set(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mW = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PRect_mW_get(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    result = (long) ((arg1)->mW);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PRect_mH_set(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mH = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PRect_mH_get(int argc, VALUE *argv, VALUE self) {
    PRect *arg1 = (PRect *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PRect, 1);
    result = (long) ((arg1)->mH);
    
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_PRect(PRect *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_PMargins__SWIG_0(int argc, VALUE *argv, VALUE self) {
    PMargins *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PMargins *)new PMargins();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PMargins_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PMargins);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PMargins__SWIG_1(int argc, VALUE *argv, VALUE self) {
    long arg1 ;
    long arg2 ;
    long arg3 ;
    long arg4 ;
    PMargins *result;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2LONG(argv[0]);
    arg2 = NUM2LONG(argv[1]);
    arg3 = NUM2LONG(argv[2]);
    arg4 = NUM2LONG(argv[3]);
    result = (PMargins *)new PMargins(arg1,arg2,arg3,arg4);
    DATA_PTR(self) = result;
    return self;
}


static VALUE _wrap_new_PMargins(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[4];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 4); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_PMargins__SWIG_0(nargs, args, self);
    }
    if (argc == 4) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    {
                        _v = ((TYPE(argv[3]) == T_FIXNUM) || (TYPE(argv[3]) == T_BIGNUM)) ? 1 : 0;
                    }
                    if (_v) {
                        return _wrap_new_PMargins__SWIG_1(nargs, args, self);
                    }
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_PMargins'");
    return Qnil;
}


static VALUE
_wrap_PMargins_mLeft_set(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mLeft = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PMargins_mLeft_get(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    result = (long) ((arg1)->mLeft);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PMargins_mRight_set(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mRight = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PMargins_mRight_get(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    result = (long) ((arg1)->mRight);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PMargins_mTop_set(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mTop = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PMargins_mTop_get(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    result = (long) ((arg1)->mTop);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PMargins_mBottom_set(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    arg2 = NUM2LONG(argv[0]);
    if (arg1) (arg1)->mBottom = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PMargins_mBottom_get(int argc, VALUE *argv, VALUE self) {
    PMargins *arg1 = (PMargins *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PMargins, 1);
    result = (long) ((arg1)->mBottom);
    
    vresult = INT2NUM(result);
    return vresult;
}


static void
free_PMargins(PMargins *arg1) {
    delete arg1;
}
static VALUE
_wrap_new_PColor__SWIG_0(int argc, VALUE *argv, VALUE self) {
    PColor *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PColor *)new PColor();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PColor_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PColor);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PColor__SWIG_1(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    int arg2 ;
    int arg3 ;
    PColor *result;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2INT(argv[0]);
    arg2 = NUM2INT(argv[1]);
    arg3 = NUM2INT(argv[2]);
    result = (PColor *)new PColor(arg1,arg2,arg3);
    DATA_PTR(self) = result;
    return self;
}


static VALUE _wrap_new_PColor(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs;
    for (ii = 0; (ii < argc) && (ii < 3); ii++) {
        argv[ii] = args[ii];
    }
    if (argc == 0) {
        return _wrap_new_PColor__SWIG_0(nargs, args, self);
    }
    if (argc == 3) {
        int _v;
        {
            _v = ((TYPE(argv[0]) == T_FIXNUM) || (TYPE(argv[0]) == T_BIGNUM)) ? 1 : 0;
        }
        if (_v) {
            {
                _v = ((TYPE(argv[1]) == T_FIXNUM) || (TYPE(argv[1]) == T_BIGNUM)) ? 1 : 0;
            }
            if (_v) {
                {
                    _v = ((TYPE(argv[2]) == T_FIXNUM) || (TYPE(argv[2]) == T_BIGNUM)) ? 1 : 0;
                }
                if (_v) {
                    return _wrap_new_PColor__SWIG_1(nargs, args, self);
                }
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'new_PColor'");
    return Qnil;
}


static VALUE
_wrap_PColor_mR_set(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    arg2 = (unsigned char) NUM2INT(argv[0]);
    if (arg1) (arg1)->mR = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PColor_mR_get(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    result = (unsigned char) ((arg1)->mR);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PColor_mG_set(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    arg2 = (unsigned char) NUM2INT(argv[0]);
    if (arg1) (arg1)->mG = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PColor_mG_get(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    result = (unsigned char) ((arg1)->mG);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PColor_mB_set(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    arg2 = (unsigned char) NUM2INT(argv[0]);
    if (arg1) (arg1)->mB = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PColor_mB_get(int argc, VALUE *argv, VALUE self) {
    PColor *arg1 = (PColor *) 0 ;
    unsigned char result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PColor, 1);
    result = (unsigned char) ((arg1)->mB);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static void
free_PColor(PColor *arg1) {
    delete arg1;
}
static VALUE
_wrap_LegendData_mName_set(int argc, VALUE *argv, VALUE self) {
    LegendData *arg1 = (LegendData *) 0 ;
    string arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LegendData, 1);
    {
        string * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_string, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mName = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LegendData_mName_get(int argc, VALUE *argv, VALUE self) {
    LegendData *arg1 = (LegendData *) 0 ;
    string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LegendData, 1);
    result =  ((arg1)->mName);
    
    {
        string * resultptr;
        resultptr = new string((string &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_string, 1);
    }
    return vresult;
}


static VALUE
_wrap_LegendData_mColor_set(int argc, VALUE *argv, VALUE self) {
    LegendData *arg1 = (LegendData *) 0 ;
    PColor *arg2 = (PColor *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LegendData, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PColor, 1);
    if (arg1) (arg1)->mColor = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_LegendData_mColor_get(int argc, VALUE *argv, VALUE self) {
    LegendData *arg1 = (LegendData *) 0 ;
    PColor *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LegendData, 1);
    result = (PColor *)& ((arg1)->mColor);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PColor,0);
    return vresult;
}


static VALUE
_wrap_LegendData_SetDefaultValues(int argc, VALUE *argv, VALUE self) {
    LegendData *arg1 = (LegendData *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LegendData, 1);
    arg2 = NUM2INT(argv[0]);
    (arg1)->SetDefaultValues(arg2);
    
    return Qnil;
}


static VALUE
_wrap_LegendData_GetDefaultColor(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    PColor result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    result = LegendData::GetDefaultColor(arg1);
    
    {
        PColor * resultptr;
        resultptr = new PColor((PColor &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_PColor, 1);
    }
    return vresult;
}


static VALUE
_wrap_LegendData_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LegendData);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LegendData(int argc, VALUE *argv, VALUE self) {
    LegendData *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LegendData *)new LegendData();
    DATA_PTR(self) = result;
    return self;
}


static void
free_LegendData(LegendData *arg1) {
    delete arg1;
}
static VALUE
_wrap_Painter_DrawLine(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    arg5 = (float) NUM2DBL(argv[3]);
    (arg1)->DrawLine(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_Painter_FillRect(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    (arg1)->FillRect(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_Painter_SetClipRect(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    (arg1)->SetClipRect(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_Painter_GetWidth(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    result = (long)((Painter const *)arg1)->GetWidth();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Painter_GetHeight(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    result = (long)((Painter const *)arg1)->GetHeight();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Painter_SetLineColor(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    (arg1)->SetLineColor(arg2,arg3,arg4);
    
    return Qnil;
}


static VALUE
_wrap_Painter_SetFillColor(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    (arg1)->SetFillColor(arg2,arg3,arg4);
    
    return Qnil;
}


static VALUE
_wrap_Painter_CalculateTextDrawSize(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    char *arg2 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = STR2CSTR(argv[0]);
    result = (long)(arg1)->CalculateTextDrawSize((char const *)arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Painter_GetFontHeight(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    result = (long)((Painter const *)arg1)->GetFontHeight();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Painter_DrawText(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    char *arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = STR2CSTR(argv[2]);
    (arg1)->DrawText(arg2,arg3,(char const *)arg4);
    
    return Qnil;
}


static VALUE
_wrap_Painter_DrawRotatedText(int argc, VALUE *argv, VALUE self) {
    Painter *arg1 = (Painter *) 0 ;
    int arg2 ;
    int arg3 ;
    float arg4 ;
    char *arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Painter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    arg5 = STR2CSTR(argv[3]);
    (arg1)->DrawRotatedText(arg2,arg3,arg4,(char const *)arg5);
    
    return Qnil;
}


static void
free_Painter(Painter *arg1) {
    delete arg1;
}
static VALUE
_wrap_DummyPainter_DrawLine(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    arg5 = (float) NUM2DBL(argv[3]);
    (arg1)->DrawLine(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_FillRect(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    (arg1)->FillRect(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_SetClipRect(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    int arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    arg5 = NUM2INT(argv[3]);
    (arg1)->SetClipRect(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_GetWidth(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    result = (long)((DummyPainter const *)arg1)->GetWidth();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DummyPainter_GetHeight(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    result = (long)((DummyPainter const *)arg1)->GetHeight();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DummyPainter_SetLineColor(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    (arg1)->SetLineColor(arg2,arg3,arg4);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_SetFillColor(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    int arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = NUM2INT(argv[2]);
    (arg1)->SetFillColor(arg2,arg3,arg4);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_CalculateTextDrawSize(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    char *arg2 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = STR2CSTR(argv[0]);
    result = (long)(arg1)->CalculateTextDrawSize((char const *)arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DummyPainter_GetFontHeight(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    long result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    result = (long)((DummyPainter const *)arg1)->GetFontHeight();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_DummyPainter_DrawText(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    char *arg4 ;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = STR2CSTR(argv[2]);
    (arg1)->DrawText(arg2,arg3,(char const *)arg4);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_DrawRotatedText(int argc, VALUE *argv, VALUE self) {
    DummyPainter *arg1 = (DummyPainter *) 0 ;
    int arg2 ;
    int arg3 ;
    float arg4 ;
    char *arg5 ;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DummyPainter, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    arg5 = STR2CSTR(argv[3]);
    (arg1)->DrawRotatedText(arg2,arg3,arg4,(char const *)arg5);
    
    return Qnil;
}


static VALUE
_wrap_DummyPainter_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_DummyPainter);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_DummyPainter(int argc, VALUE *argv, VALUE self) {
    DummyPainter *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (DummyPainter *)new DummyPainter();
    DATA_PTR(self) = result;
    return self;
}


static void
free_DummyPainter(DummyPainter *arg1) {
    delete arg1;
}
static void
free_DataDrawerBase(DataDrawerBase *arg1) {
    delete arg1;
}
static VALUE
_wrap_DataDrawerBase_SetXTrafo(int argc, VALUE *argv, VALUE self) {
    DataDrawerBase *arg1 = (DataDrawerBase *) 0 ;
    Trafo *arg2 = (Trafo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DataDrawerBase, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Trafo, 1);
    (arg1)->SetXTrafo(arg2);
    
    return Qnil;
}


static VALUE
_wrap_DataDrawerBase_SetYTrafo(int argc, VALUE *argv, VALUE self) {
    DataDrawerBase *arg1 = (DataDrawerBase *) 0 ;
    Trafo *arg2 = (Trafo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DataDrawerBase, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Trafo, 1);
    (arg1)->SetYTrafo(arg2);
    
    return Qnil;
}


static VALUE
_wrap_DataDrawerBase_SetDrawFast(int argc, VALUE *argv, VALUE self) {
    DataDrawerBase *arg1 = (DataDrawerBase *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DataDrawerBase, 1);
    arg2 = RTEST(argv[0]);
    (arg1)->SetDrawFast(arg2);
    
    return Qnil;
}


static VALUE
_wrap_DataDrawerBase_DrawData(int argc, VALUE *argv, VALUE self) {
    DataDrawerBase *arg1 = (DataDrawerBase *) 0 ;
    PlotDataBase *arg2 = 0 ;
    PlotDataBase *arg3 = 0 ;
    AxisSetup *arg4 = 0 ;
    PRect *arg5 = 0 ;
    Painter *arg6 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DataDrawerBase, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PlotDataBase, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_PlotDataBase, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_AxisSetup, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_PRect, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg6, SWIGTYPE_p_Painter, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((DataDrawerBase const *)arg1)->DrawData((PlotDataBase const &)*arg2,(PlotDataBase const &)*arg3,(AxisSetup const &)*arg4,(PRect const &)*arg5,*arg6);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_DataDrawerBase_Clone(int argc, VALUE *argv, VALUE self) {
    DataDrawerBase *arg1 = (DataDrawerBase *) 0 ;
    DataDrawerBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_DataDrawerBase, 1);
    result = (DataDrawerBase *)((DataDrawerBase const *)arg1)->Clone();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DataDrawerBase,0);
    return vresult;
}


static VALUE
_wrap_LineDataDrawer_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LineDataDrawer);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LineDataDrawer(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LineDataDrawer *)new LineDataDrawer();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_LineDataDrawer_DrawData(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    PlotDataBase *arg2 = 0 ;
    PlotDataBase *arg3 = 0 ;
    AxisSetup *arg4 = 0 ;
    PRect *arg5 = 0 ;
    Painter *arg6 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PlotDataBase, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_PlotDataBase, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_AxisSetup, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_PRect, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg6, SWIGTYPE_p_Painter, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((LineDataDrawer const *)arg1)->DrawData((PlotDataBase const &)*arg2,(PlotDataBase const &)*arg3,(AxisSetup const &)*arg4,(PRect const &)*arg5,*arg6);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LineDataDrawer_Clone(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    DataDrawerBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    result = (DataDrawerBase *)((LineDataDrawer const *)arg1)->Clone();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DataDrawerBase,0);
    return vresult;
}


static VALUE
_wrap_LineDataDrawer_DrawPoint(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    int arg2 ;
    int arg3 ;
    PRect *arg4 = 0 ;
    Painter *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2INT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_PRect, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_Painter, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((LineDataDrawer const *)arg1)->DrawPoint(arg2,arg3,(PRect const &)*arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LineDataDrawer_mDrawLine_set(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mDrawLine = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LineDataDrawer_mDrawLine_get(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    result = (bool) ((arg1)->mDrawLine);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LineDataDrawer_mDrawPoint_set(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mDrawPoint = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LineDataDrawer_mDrawPoint_get(int argc, VALUE *argv, VALUE self) {
    LineDataDrawer *arg1 = (LineDataDrawer *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LineDataDrawer, 1);
    result = (bool) ((arg1)->mDrawPoint);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_LineDataDrawer(LineDataDrawer *arg1) {
    delete arg1;
}
static VALUE
_wrap_BarDataDrawer_DrawData(int argc, VALUE *argv, VALUE self) {
    BarDataDrawer *arg1 = (BarDataDrawer *) 0 ;
    PlotDataBase *arg2 = 0 ;
    PlotDataBase *arg3 = 0 ;
    AxisSetup *arg4 = 0 ;
    PRect *arg5 = 0 ;
    Painter *arg6 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BarDataDrawer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PlotDataBase, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_PlotDataBase, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_AxisSetup, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_PRect, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg6, SWIGTYPE_p_Painter, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((BarDataDrawer const *)arg1)->DrawData((PlotDataBase const &)*arg2,(PlotDataBase const &)*arg3,(AxisSetup const &)*arg4,(PRect const &)*arg5,*arg6);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_BarDataDrawer_Clone(int argc, VALUE *argv, VALUE self) {
    BarDataDrawer *arg1 = (BarDataDrawer *) 0 ;
    DataDrawerBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_BarDataDrawer, 1);
    result = (DataDrawerBase *)((BarDataDrawer const *)arg1)->Clone();
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DataDrawerBase,0);
    return vresult;
}


static VALUE
_wrap_BarDataDrawer_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_BarDataDrawer);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_BarDataDrawer(int argc, VALUE *argv, VALUE self) {
    BarDataDrawer *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (BarDataDrawer *)new BarDataDrawer();
    DATA_PTR(self) = result;
    return self;
}


static void
free_BarDataDrawer(BarDataDrawer *arg1) {
    delete arg1;
}
static VALUE
_wrap_PlotDataContainer_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PlotDataContainer);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PlotDataContainer(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PlotDataContainer *)new PlotDataContainer();
    DATA_PTR(self) = result;
    return self;
}


static void
free_PlotDataContainer(PlotDataContainer *arg1) {
    delete arg1;
}
static VALUE
_wrap_PlotDataContainer_RemoveElement(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    (arg1)->RemoveElement(arg2);
    
    return Qnil;
}


static VALUE
_wrap_PlotDataContainer_ClearData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    (arg1)->ClearData();
    
    return Qnil;
}


static VALUE
_wrap_PlotDataContainer_AddXYPlot(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    PlotDataBase *arg2 = (PlotDataBase *) 0 ;
    PlotDataBase *arg3 = (PlotDataBase *) 0 ;
    LegendData *arg4 = (LegendData *) 0 ;
    DataDrawerBase *arg5 = (DataDrawerBase *) 0 ;
    
    if ((argc < 2) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(argv[0])->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(argv[0])->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg2 = thePlotData;
    }
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(argv[1])->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(argv[1])->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg3 = thePlotData;
    }
    if (argc > 2) {
        SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_LegendData, 1);
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_DataDrawerBase, 1);
    }
    (arg1)->AddXYPlot(arg2,arg3,arg4,arg5);
    
    return Qnil;
}


static VALUE
_wrap_PlotDataContainer_SetXYPlot(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    PlotDataBase *arg3 = (PlotDataBase *) 0 ;
    PlotDataBase *arg4 = (PlotDataBase *) 0 ;
    LegendData *arg5 = (LegendData *) 0 ;
    DataDrawerBase *arg6 = (DataDrawerBase *) 0 ;
    
    if ((argc < 3) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(argv[1])->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(argv[1])->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg3 = thePlotData;
    }
    {
        // convert ruby array to PlotData.
        // takes ownership
        PlotData *thePlotData = new PlotData ();
        
        int size = RARRAY(argv[2])->len;     
        int i;
        /* Get the first element in memory */
        VALUE *ptr = RARRAY(argv[2])->ptr;   
        for (i=0; i < size; i++, ptr++) {
            /* Convert Ruby Object String to char* */
            float theValue = NUM2DBL (*ptr);
            thePlotData->push_back (theValue); 
        }
        
        arg4 = thePlotData;
    }
    if (argc > 3) {
        SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_LegendData, 1);
    }
    if (argc > 4) {
        SWIG_ConvertPtr(argv[4], (void **) &arg6, SWIGTYPE_p_DataDrawerBase, 1);
    }
    (arg1)->SetXYPlot(arg2,arg3,arg4,arg5,arg6);
    
    return Qnil;
}


static VALUE
_wrap_PlotDataContainer_GetPlotCount(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    result = (int)((PlotDataContainer const *)arg1)->GetPlotCount();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetXData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    PlotDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (PlotDataBase *)(arg1)->GetXData(arg2);
    
    {
        // convert PlotData to ruby array
        if (!result) {
            vresult=Qnil;
        }
        
        const RealPlotData *thePlotData = result->GetRealPlotData ();
        
        VALUE arr = rb_ary_new2(thePlotData->size());
        
        
        for (long theI=0;theI<thePlotData->size ();theI++) {
            float theValue = (*thePlotData)[theI];
            VALUE theBla = rb_float_new (theValue);
            rb_ary_push(arr, theBla);
        }
        vresult = arr;
        
    }
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetYData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    PlotDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (PlotDataBase *)(arg1)->GetYData(arg2);
    
    {
        // convert PlotData to ruby array
        if (!result) {
            vresult=Qnil;
        }
        
        const RealPlotData *thePlotData = result->GetRealPlotData ();
        
        VALUE arr = rb_ary_new2(thePlotData->size());
        
        
        for (long theI=0;theI<thePlotData->size ();theI++) {
            float theValue = (*thePlotData)[theI];
            VALUE theBla = rb_float_new (theValue);
            rb_ary_push(arr, theBla);
        }
        vresult = arr;
        
    }
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetLegendData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    LegendData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (LegendData *)(arg1)->GetLegendData(arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_LegendData,0);
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetDataDrawer(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    DataDrawerBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (DataDrawerBase *)(arg1)->GetDataDrawer(arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DataDrawerBase,0);
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetConstXData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    PlotDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (PlotDataBase *)((PlotDataContainer const *)arg1)->GetConstXData(arg2);
    
    {
        // convert PlotData to ruby array
        if (!result) {
            vresult=Qnil;
        }
        
        const RealPlotData *thePlotData = result->GetRealPlotData ();
        
        VALUE arr = rb_ary_new2(thePlotData->size());
        
        
        for (long theI=0;theI<thePlotData->size ();theI++) {
            float theValue = (*thePlotData)[theI];
            VALUE theBla = rb_float_new (theValue);
            rb_ary_push(arr, theBla);
        }
        vresult = arr;
        
    }
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetConstYData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    PlotDataBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (PlotDataBase *)((PlotDataContainer const *)arg1)->GetConstYData(arg2);
    
    {
        // convert PlotData to ruby array
        if (!result) {
            vresult=Qnil;
        }
        
        const RealPlotData *thePlotData = result->GetRealPlotData ();
        
        VALUE arr = rb_ary_new2(thePlotData->size());
        
        
        for (long theI=0;theI<thePlotData->size ();theI++) {
            float theValue = (*thePlotData)[theI];
            VALUE theBla = rb_float_new (theValue);
            rb_ary_push(arr, theBla);
        }
        vresult = arr;
        
    }
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetConstLegendData(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    LegendData *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (LegendData *)((PlotDataContainer const *)arg1)->GetConstLegendData(arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_LegendData,0);
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_GetConstDataDrawer(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    int arg2 ;
    DataDrawerBase *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = NUM2INT(argv[0]);
    result = (DataDrawerBase *)((PlotDataContainer const *)arg1)->GetConstDataDrawer(arg2);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_DataDrawerBase,0);
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_CalculateXRange(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    float *arg2 = 0 ;
    float *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_float, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((PlotDataContainer const *)arg1)->CalculateXRange(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_CalculateYRange(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    float arg2 ;
    float arg3 ;
    float *arg4 = 0 ;
    float *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_float, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_float, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((PlotDataContainer const *)arg1)->CalculateYRange(arg2,arg3,*arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PlotDataContainer_CalculateYRangePlot(int argc, VALUE *argv, VALUE self) {
    PlotDataContainer *arg1 = (PlotDataContainer *) 0 ;
    float arg2 ;
    float arg3 ;
    PlotDataBase *arg4 = 0 ;
    PlotDataBase *arg5 = 0 ;
    float *arg6 = 0 ;
    float *arg7 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotDataContainer, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_PlotDataBase, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_PlotDataBase, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[4], (void **) &arg6, SWIGTYPE_p_float, 1); if (arg6 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[5], (void **) &arg7, SWIGTYPE_p_float, 1); if (arg7 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((PlotDataContainer const *)arg1)->CalculateYRangePlot(arg2,arg3,(PlotDataBase const &)*arg4,(PlotDataBase const &)*arg5,*arg6,*arg7);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_GridInfo_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_GridInfo);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_GridInfo(int argc, VALUE *argv, VALUE self) {
    bool arg1 = (bool) (bool)false ;
    bool arg2 = (bool) (bool)false ;
    GridInfo *result;
    
    if ((argc < 0) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    if (argc > 0) {
        arg1 = RTEST(argv[0]);
    }
    if (argc > 1) {
        arg2 = RTEST(argv[1]);
    }
    result = (GridInfo *)new GridInfo(arg1,arg2);
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_GridInfo_mXGridOn_set(int argc, VALUE *argv, VALUE self) {
    GridInfo *arg1 = (GridInfo *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GridInfo, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mXGridOn = arg2;
    
    return Qnil;
}


static VALUE
_wrap_GridInfo_mXGridOn_get(int argc, VALUE *argv, VALUE self) {
    GridInfo *arg1 = (GridInfo *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GridInfo, 1);
    result = (bool) ((arg1)->mXGridOn);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_GridInfo_mYGridOn_set(int argc, VALUE *argv, VALUE self) {
    GridInfo *arg1 = (GridInfo *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GridInfo, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mYGridOn = arg2;
    
    return Qnil;
}


static VALUE
_wrap_GridInfo_mYGridOn_get(int argc, VALUE *argv, VALUE self) {
    GridInfo *arg1 = (GridInfo *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_GridInfo, 1);
    result = (bool) ((arg1)->mYGridOn);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_GridInfo(GridInfo *arg1) {
    delete arg1;
}
static VALUE
_wrap_TickInfo_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_TickInfo);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_TickInfo(int argc, VALUE *argv, VALUE self) {
    TickInfo *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (TickInfo *)new TickInfo();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_TickInfo_RoundSpan(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    result = (float)TickInfo::RoundSpan(arg1);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TickInfo_MakeFormatString(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    string *arg2 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_string, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    TickInfo::MakeFormatString(arg1,*arg2);
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mAutoTick_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mAutoTick = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mAutoTick_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (bool) ((arg1)->mAutoTick);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickInfo_mAutoTickSize_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mAutoTickSize = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mAutoTickSize_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (bool) ((arg1)->mAutoTickSize);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickInfo_mTickDivision_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->mTickDivision = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mTickDivision_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (int) ((arg1)->mTickDivision);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_TickInfo_mMajorTickSpan_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mMajorTickSpan = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mMajorTickSpan_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (float) ((arg1)->mMajorTickSpan);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_TickInfo_mMajorTickScreenSize_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->mMajorTickScreenSize = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mMajorTickScreenSize_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (int) ((arg1)->mMajorTickScreenSize);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_TickInfo_mMinorTickScreenSize_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->mMinorTickScreenSize = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mMinorTickScreenSize_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result = (int) ((arg1)->mMinorTickScreenSize);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_TickInfo_mFormatString_set(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    string arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    {
        string * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_string, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mFormatString = arg2;
    
    return Qnil;
}


static VALUE
_wrap_TickInfo_mFormatString_get(int argc, VALUE *argv, VALUE self) {
    TickInfo *arg1 = (TickInfo *) 0 ;
    string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickInfo, 1);
    result =  ((arg1)->mFormatString);
    
    {
        string * resultptr;
        resultptr = new string((string &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_string, 1);
    }
    return vresult;
}


static void
free_TickInfo(TickInfo *arg1) {
    delete arg1;
}
static VALUE
_wrap_AxisSetup_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_AxisSetup);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_AxisSetup(int argc, VALUE *argv, VALUE self) {
    AxisSetup *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (AxisSetup *)new AxisSetup();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_AxisSetup_SetMin(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    (arg1)->SetMin(arg2);
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_SetMax(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    (arg1)->SetMax(arg2);
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_SetAutoScale(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    (arg1)->SetAutoScale(arg2);
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_IsAutoScale(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool)((AxisSetup const *)arg1)->IsAutoScale();
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mMin_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mMin = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mMin_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (float) ((arg1)->mMin);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_AxisSetup_mMax_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mMax = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mMax_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (float) ((arg1)->mMax);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_AxisSetup_mAutoScaleMin_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mAutoScaleMin = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mAutoScaleMin_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool) ((arg1)->mAutoScaleMin);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mAutoScaleMax_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mAutoScaleMax = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mAutoScaleMax_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool) ((arg1)->mAutoScaleMax);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mAscending_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mAscending = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mAscending_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool) ((arg1)->mAscending);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mLogScale_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mLogScale = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mLogScale_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool) ((arg1)->mLogScale);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mCrossOrigin_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mCrossOrigin = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mCrossOrigin_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (bool) ((arg1)->mCrossOrigin);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_AxisSetup_mMaxDecades_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mMaxDecades = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mMaxDecades_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (float) ((arg1)->mMaxDecades);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_AxisSetup_mLogBase_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mLogBase = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mLogBase_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (float) ((arg1)->mLogBase);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_AxisSetup_mLabel_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    string arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    {
        string * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_string, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mLabel = arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mLabel_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result =  ((arg1)->mLabel);
    
    {
        string * resultptr;
        resultptr = new string((string &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_string, 1);
    }
    return vresult;
}


static VALUE
_wrap_AxisSetup_mTickInfo_set(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    TickInfo *arg2 = (TickInfo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_TickInfo, 1);
    if (arg1) (arg1)->mTickInfo = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_AxisSetup_mTickInfo_get(int argc, VALUE *argv, VALUE self) {
    AxisSetup *arg1 = (AxisSetup *) 0 ;
    TickInfo *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_AxisSetup, 1);
    result = (TickInfo *)& ((arg1)->mTickInfo);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TickInfo,0);
    return vresult;
}


static void
free_AxisSetup(AxisSetup *arg1) {
    delete arg1;
}
static void
free_Trafo(Trafo *arg1) {
    delete arg1;
}
static VALUE
_wrap_Trafo_Transform(int argc, VALUE *argv, VALUE self) {
    Trafo *arg1 = (Trafo *) 0 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Trafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    result = (float)((Trafo const *)arg1)->Transform(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_Trafo_TransformBack(int argc, VALUE *argv, VALUE self) {
    Trafo *arg1 = (Trafo *) 0 ;
    int arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_Trafo, 1);
    arg2 = NUM2INT(argv[0]);
    result = (float)((Trafo const *)arg1)->TransformBack(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LinTrafo_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LinTrafo);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LinTrafo(int argc, VALUE *argv, VALUE self) {
    LinTrafo *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LinTrafo *)new LinTrafo();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_LinTrafo_Transform(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    result = (float)((LinTrafo const *)arg1)->Transform(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LinTrafo_TransformBack(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    int arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    arg2 = NUM2INT(argv[0]);
    result = (float)((LinTrafo const *)arg1)->TransformBack(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LinTrafo_mOffset_set(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mOffset = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LinTrafo_mOffset_get(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    result = (float) ((arg1)->mOffset);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LinTrafo_mSlope_set(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mSlope = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LinTrafo_mSlope_get(int argc, VALUE *argv, VALUE self) {
    LinTrafo *arg1 = (LinTrafo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTrafo, 1);
    result = (float) ((arg1)->mSlope);
    
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_LinTrafo(LinTrafo *arg1) {
    delete arg1;
}
static VALUE
_wrap_LogTrafo_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LogTrafo);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LogTrafo(int argc, VALUE *argv, VALUE self) {
    LogTrafo *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LogTrafo *)new LogTrafo();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_LogTrafo_Transform(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    result = (float)((LogTrafo const *)arg1)->Transform(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LogTrafo_TransformBack(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    int arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    arg2 = NUM2INT(argv[0]);
    result = (float)((LogTrafo const *)arg1)->TransformBack(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LogTrafo_mOffset_set(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mOffset = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LogTrafo_mOffset_get(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    result = (float) ((arg1)->mOffset);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LogTrafo_mSlope_set(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mSlope = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LogTrafo_mSlope_get(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    result = (float) ((arg1)->mSlope);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LogTrafo_mBase_set(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    if (arg1) (arg1)->mBase = arg2;
    
    return Qnil;
}


static VALUE
_wrap_LogTrafo_mBase_get(int argc, VALUE *argv, VALUE self) {
    LogTrafo *arg1 = (LogTrafo *) 0 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTrafo, 1);
    result = (float) ((arg1)->mBase);
    
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_LogTrafo(LogTrafo *arg1) {
    delete arg1;
}
static void
free_TickIterator(TickIterator *arg1) {
    delete arg1;
}
static VALUE
_wrap_TickIterator_Init(int argc, VALUE *argv, VALUE self) {
    TickIterator *arg1 = (TickIterator *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickIterator, 1);
    result = (bool)(arg1)->Init();
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickIterator_GetNextTick(int argc, VALUE *argv, VALUE self) {
    TickIterator *arg1 = (TickIterator *) 0 ;
    float *arg2 = 0 ;
    bool *arg3 = 0 ;
    string *arg4 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_bool, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_string, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->GetNextTick(*arg2,*arg3,*arg4);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickIterator_InitFromRanges(int argc, VALUE *argv, VALUE self) {
    TickIterator *arg1 = (TickIterator *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    TickInfo *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_TickInfo, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((TickIterator const *)arg1)->InitFromRanges(arg2,arg3,arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickIterator_AdjustRange(int argc, VALUE *argv, VALUE self) {
    TickIterator *arg1 = (TickIterator *) 0 ;
    float *arg2 = 0 ;
    float *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_float, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((TickIterator const *)arg1)->AdjustRange(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_TickIterator_SetAxisSetup(int argc, VALUE *argv, VALUE self) {
    TickIterator *arg1 = (TickIterator *) 0 ;
    AxisSetup *arg2 = (AxisSetup *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_TickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_AxisSetup, 1);
    (arg1)->SetAxisSetup((AxisSetup const *)arg2);
    
    return Qnil;
}


static VALUE
_wrap_LinTickIterator_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LinTickIterator);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LinTickIterator(int argc, VALUE *argv, VALUE self) {
    LinTickIterator *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LinTickIterator *)new LinTickIterator();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_LinTickIterator_Init(int argc, VALUE *argv, VALUE self) {
    LinTickIterator *arg1 = (LinTickIterator *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTickIterator, 1);
    result = (bool)(arg1)->Init();
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LinTickIterator_GetNextTick(int argc, VALUE *argv, VALUE self) {
    LinTickIterator *arg1 = (LinTickIterator *) 0 ;
    float *arg2 = 0 ;
    bool *arg3 = 0 ;
    string *arg4 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_bool, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_string, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->GetNextTick(*arg2,*arg3,*arg4);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LinTickIterator_InitFromRanges(int argc, VALUE *argv, VALUE self) {
    LinTickIterator *arg1 = (LinTickIterator *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    TickInfo *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LinTickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_TickInfo, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((LinTickIterator const *)arg1)->InitFromRanges(arg2,arg3,arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_LinTickIterator(LinTickIterator *arg1) {
    delete arg1;
}
static VALUE
_wrap_LogTickIterator_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_LogTickIterator);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_LogTickIterator(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (LogTickIterator *)new LogTickIterator();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_LogTickIterator_Init(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    result = (bool)(arg1)->Init();
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LogTickIterator_GetNextTick(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    float *arg2 = 0 ;
    bool *arg3 = 0 ;
    string *arg4 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_bool, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_string, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->GetNextTick(*arg2,*arg3,*arg4);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LogTickIterator_InitFromRanges(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    TickInfo *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_TickInfo, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((LogTickIterator const *)arg1)->InitFromRanges(arg2,arg3,arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LogTickIterator_AdjustRange(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    float *arg2 = 0 ;
    float *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_float, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((LogTickIterator const *)arg1)->AdjustRange(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_LogTickIterator_RoundUp(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    result = (float)((LogTickIterator const *)arg1)->RoundUp(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_LogTickIterator_RoundDown(int argc, VALUE *argv, VALUE self) {
    LogTickIterator *arg1 = (LogTickIterator *) 0 ;
    float arg2 ;
    float result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_LogTickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    result = (float)((LogTickIterator const *)arg1)->RoundDown(arg2);
    
    vresult = rb_float_new(result);
    return vresult;
}


static void
free_LogTickIterator(LogTickIterator *arg1) {
    delete arg1;
}
static VALUE
_wrap_NamedTickIterator_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_NamedTickIterator);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_NamedTickIterator(int argc, VALUE *argv, VALUE self) {
    NamedTickIterator *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (NamedTickIterator *)new NamedTickIterator();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_NamedTickIterator_SetStringList(int argc, VALUE *argv, VALUE self) {
    NamedTickIterator *arg1 = (NamedTickIterator *) 0 ;
    vector<string > *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NamedTickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_vectorTstring_t, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->SetStringList((vector<string > const &)*arg2);
    
    return Qnil;
}


static VALUE
_wrap_NamedTickIterator_GetNextTick(int argc, VALUE *argv, VALUE self) {
    NamedTickIterator *arg1 = (NamedTickIterator *) 0 ;
    float *arg2 = 0 ;
    bool *arg3 = 0 ;
    string *arg4 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NamedTickIterator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_float, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_bool, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[2], (void **) &arg4, SWIGTYPE_p_string, 1); if (arg4 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->GetNextTick(*arg2,*arg3,*arg4);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_NamedTickIterator_InitFromRanges(int argc, VALUE *argv, VALUE self) {
    NamedTickIterator *arg1 = (NamedTickIterator *) 0 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    TickInfo *arg5 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_NamedTickIterator, 1);
    arg2 = (float) NUM2DBL(argv[0]);
    arg3 = (float) NUM2DBL(argv[1]);
    arg4 = (float) NUM2DBL(argv[2]);
    SWIG_ConvertPtr(argv[3], (void **) &arg5, SWIGTYPE_p_TickInfo, 1); if (arg5 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((NamedTickIterator const *)arg1)->InitFromRanges(arg2,arg3,arg4,*arg5);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_NamedTickIterator(NamedTickIterator *arg1) {
    delete arg1;
}
static VALUE
_wrap_PlotBackground_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PlotBackground);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PlotBackground(int argc, VALUE *argv, VALUE self) {
    PlotBackground *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PlotBackground *)new PlotBackground();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PlotBackground_mTransparent_set(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    bool arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    arg2 = RTEST(argv[0]);
    if (arg1) (arg1)->mTransparent = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PlotBackground_mTransparent_get(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    result = (bool) ((arg1)->mTransparent);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PlotBackground_mPlotRegionBackColor_set(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    PColor *arg2 = (PColor *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PColor, 1);
    if (arg1) (arg1)->mPlotRegionBackColor = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PlotBackground_mPlotRegionBackColor_get(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    PColor *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    result = (PColor *)& ((arg1)->mPlotRegionBackColor);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PColor,0);
    return vresult;
}


static VALUE
_wrap_PlotBackground_mTitle_set(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    string arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    {
        string * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_string, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mTitle = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PlotBackground_mTitle_get(int argc, VALUE *argv, VALUE self) {
    PlotBackground *arg1 = (PlotBackground *) 0 ;
    string result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PlotBackground, 1);
    result =  ((arg1)->mTitle);
    
    {
        string * resultptr;
        resultptr = new string((string &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_string, 1);
    }
    return vresult;
}


static void
free_PlotBackground(PlotBackground *arg1) {
    delete arg1;
}
static void
free_PDrawer(PDrawer *arg1) {
    delete arg1;
}
static VALUE
_wrap_PDrawer_Prepare(int argc, VALUE *argv, VALUE self) {
    PDrawer *arg1 = (PDrawer *) 0 ;
    Painter *arg2 = 0 ;
    PPlot *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PDrawer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Painter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_PPlot, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->Prepare(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PDrawer_Draw(int argc, VALUE *argv, VALUE self) {
    PDrawer *arg1 = (PDrawer *) 0 ;
    Painter *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PDrawer, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Painter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->Draw(*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static void
free_PCalculator(PCalculator *arg1) {
    delete arg1;
}
static VALUE
_wrap_PCalculator_Calculate(int argc, VALUE *argv, VALUE self) {
    PCalculator *arg1 = (PCalculator *) 0 ;
    Painter *arg2 = 0 ;
    PPlot *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PCalculator, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Painter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_PPlot, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->Calculate(*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PCalculator_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PCalculator);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PCalculator(int argc, VALUE *argv, VALUE self) {
    PCalculator *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PCalculator *)new PCalculator();
    DATA_PTR(self) = result;
    return self;
}


static VALUE
_wrap_PainterTester_Draw(int argc, VALUE *argv, VALUE self) {
    PainterTester *arg1 = (PainterTester *) 0 ;
    Painter *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PainterTester, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Painter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->Draw(*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PainterTester_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PainterTester);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PainterTester(int argc, VALUE *argv, VALUE self) {
    PainterTester *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PainterTester *)new PainterTester();
    DATA_PTR(self) = result;
    return self;
}


static void
free_PainterTester(PainterTester *arg1) {
    delete arg1;
}
static VALUE
_wrap_PPlot_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_PPlot);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_PPlot(int argc, VALUE *argv, VALUE self) {
    PPlot *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (PPlot *)new PPlot();
    DATA_PTR(self) = result;
    return self;
}


static void
free_PPlot(PPlot *arg1) {
    delete arg1;
}
static VALUE
_wrap_PPlot_Draw(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    Painter *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Painter, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->Draw(*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_mPlotDataContainer_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PlotDataContainer *arg2 = (PlotDataContainer *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PlotDataContainer, 1);
    if (arg1) (arg1)->mPlotDataContainer = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mPlotDataContainer_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PlotDataContainer *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (PlotDataContainer *)& ((arg1)->mPlotDataContainer);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PlotDataContainer,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mXAxisSetup_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    AxisSetup *arg2 = (AxisSetup *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_AxisSetup, 1);
    if (arg1) (arg1)->mXAxisSetup = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mXAxisSetup_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    AxisSetup *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (AxisSetup *)& ((arg1)->mXAxisSetup);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_AxisSetup,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mYAxisSetup_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    AxisSetup *arg2 = (AxisSetup *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_AxisSetup, 1);
    if (arg1) (arg1)->mYAxisSetup = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mYAxisSetup_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    AxisSetup *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (AxisSetup *)& ((arg1)->mYAxisSetup);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_AxisSetup,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mGridInfo_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    GridInfo *arg2 = (GridInfo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_GridInfo, 1);
    if (arg1) (arg1)->mGridInfo = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mGridInfo_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    GridInfo *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (GridInfo *)& ((arg1)->mGridInfo);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_GridInfo,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mMargins_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PMargins *arg2 = (PMargins *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PMargins, 1);
    if (arg1) (arg1)->mMargins = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mMargins_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PMargins *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (PMargins *)& ((arg1)->mMargins);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PMargins,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mPlotBackground_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PlotBackground *arg2 = (PlotBackground *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PlotBackground, 1);
    if (arg1) (arg1)->mPlotBackground = *arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mPlotBackground_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PlotBackground *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (PlotBackground *)& ((arg1)->mPlotBackground);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PlotBackground,0);
    return vresult;
}


static VALUE
_wrap_PPlot_SetPPlotDrawer__SWIG_0(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer *arg2 = (PDrawer *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PDrawer, 1);
    (arg1)->SetPPlotDrawer(arg2);
    
    return Qnil;
}


static VALUE
_wrap_PPlot_SetPPlotDrawer__SWIG_1(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer *arg2 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PDrawer, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    (arg1)->SetPPlotDrawer(*arg2);
    
    return Qnil;
}


static VALUE _wrap_PPlot_SetPPlotDrawer(int nargs, VALUE *args, VALUE self) {
    int argc;
    VALUE argv[3];
    int ii;
    
    argc = nargs + 1;
    argv[0] = self;
    for (ii = 1; (ii < argc) && (ii < 2); ii++) {
        argv[ii] = args[ii-1];
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_PPlot, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_PDrawer, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_PPlot_SetPPlotDrawer__SWIG_0(nargs, args, self);
            }
        }
    }
    if (argc == 2) {
        int _v;
        {
            void *ptr;
            _v = (NIL_P(argv[0]) || (TYPE(argv[0]) == T_DATA && SWIG_ConvertPtr(argv[0], &ptr, SWIGTYPE_p_PPlot, 0) != -1)) ? 1 : 0;
        }
        if (_v) {
            {
                void *ptr;
                _v = (NIL_P(argv[1]) || (TYPE(argv[1]) == T_DATA && SWIG_ConvertPtr(argv[1], &ptr, SWIGTYPE_p_PDrawer, 0) != -1)) ? 1 : 0;
            }
            if (_v) {
                return _wrap_PPlot_SetPPlotDrawer__SWIG_1(nargs, args, self);
            }
        }
    }
    
    rb_raise(rb_eArgError, "No matching function for overloaded 'PPlot_SetPPlotDrawer'");
    return Qnil;
}


static VALUE
_wrap_PPlot_mPostCalculatorList_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PCalculator::tList arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    {
        PCalculator::tList * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_PCalculator__tList, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mPostCalculatorList = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mPostCalculatorList_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PCalculator::tList result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result =  ((arg1)->mPostCalculatorList);
    
    {
        PCalculator::tList * resultptr;
        resultptr = new PCalculator::tList((PCalculator::tList &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_PCalculator__tList, 1);
    }
    return vresult;
}


static VALUE
_wrap_PPlot_mPreDrawerList_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer::tList arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    {
        PDrawer::tList * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_PDrawer__tList, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mPreDrawerList = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mPreDrawerList_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer::tList result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result =  ((arg1)->mPreDrawerList);
    
    {
        PDrawer::tList * resultptr;
        resultptr = new PDrawer::tList((PDrawer::tList &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_PDrawer__tList, 1);
    }
    return vresult;
}


static VALUE
_wrap_PPlot_mPostDrawerList_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer::tList arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    {
        PDrawer::tList * ptr;
        SWIG_ConvertPtr(argv[0], (void **) &ptr, SWIGTYPE_p_PDrawer__tList, 1);
        if (ptr) arg2 = *ptr;
    }
    if (arg1) (arg1)->mPostDrawerList = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mPostDrawerList_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PDrawer::tList result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result =  ((arg1)->mPostDrawerList);
    
    {
        PDrawer::tList * resultptr;
        resultptr = new PDrawer::tList((PDrawer::tList &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_PDrawer__tList, 1);
    }
    return vresult;
}


static VALUE
_wrap_PPlot_mXTickIterator_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    TickIterator *arg2 = (TickIterator *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_TickIterator, 1);
    if (arg1) (arg1)->mXTickIterator = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mXTickIterator_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    TickIterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (TickIterator *) ((arg1)->mXTickIterator);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TickIterator,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mYTickIterator_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    TickIterator *arg2 = (TickIterator *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_TickIterator, 1);
    if (arg1) (arg1)->mYTickIterator = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mYTickIterator_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    TickIterator *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (TickIterator *) ((arg1)->mYTickIterator);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_TickIterator,0);
    return vresult;
}


static VALUE
_wrap_PPlot_CalculateXTransformation(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PRect *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PRect, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->CalculateXTransformation((PRect const &)*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_CalculateYTransformation(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PRect *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PRect, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->CalculateYTransformation((PRect const &)*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_DrawXAxis(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PRect *arg2 = 0 ;
    Painter *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PRect, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Painter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((PPlot const *)arg1)->DrawXAxis((PRect const &)*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_DrawYAxis(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PRect *arg2 = 0 ;
    Painter *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PRect, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Painter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)((PPlot const *)arg1)->DrawYAxis((PRect const &)*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_CalculateTickInfo(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    PRect *arg2 = 0 ;
    Painter *arg3 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_PRect, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg3, SWIGTYPE_p_Painter, 1); if (arg3 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)(arg1)->CalculateTickInfo((PRect const &)*arg2,*arg3);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_PPlot_mXTrafo_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    Trafo *arg2 = (Trafo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Trafo, 1);
    if (arg1) (arg1)->mXTrafo = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mXTrafo_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    Trafo *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (Trafo *) ((arg1)->mXTrafo);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Trafo,0);
    return vresult;
}


static VALUE
_wrap_PPlot_mYTrafo_set(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    Trafo *arg2 = (Trafo *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_Trafo, 1);
    if (arg1) (arg1)->mYTrafo = arg2;
    
    return Qnil;
}


static VALUE
_wrap_PPlot_mYTrafo_get(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    Trafo *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    result = (Trafo *) ((arg1)->mYTrafo);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_Trafo,0);
    return vresult;
}


static VALUE
_wrap_PPlot_Round(int argc, VALUE *argv, VALUE self) {
    float arg1 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (float) NUM2DBL(argv[0]);
    result = (int)PPlot::Round(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_MakeExamplePlot(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    PPlot *arg2 = 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    arg1 = NUM2INT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_PPlot, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    result = (bool)MakeExamplePlot(arg1,*arg2);
    
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_MakeExamplePlot1(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot1(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeExamplePlot2(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot2(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeExamplePlot3(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot3(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeExamplePlot4(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot4(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeExamplePlot5(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot5(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeExamplePlot6(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeExamplePlot6(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakePainterTester(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakePainterTester(*arg1);
    
    return Qnil;
}


static VALUE
_wrap_MakeCopy(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = 0 ;
    PPlot *arg2 = 0 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1); if (arg1 == NULL) rb_raise(rb_eTypeError, "null reference");
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_PPlot, 1); if (arg2 == NULL) rb_raise(rb_eTypeError, "null reference");
    MakeCopy((PPlot const &)*arg1,*arg2);
    
    return Qnil;
}


static VALUE
_wrap_SetCurrentPPlot(int argc, VALUE *argv, VALUE self) {
    PPlot *arg1 = (PPlot *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_PPlot, 1);
    SetCurrentPPlot(arg1);
    
    return Qnil;
}


static VALUE
_wrap_GetCurrentPPlot(int argc, VALUE *argv, VALUE self) {
    PPlot *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        PPlot &_result_ref = GetCurrentPPlot();
        result = (PPlot *) &_result_ref;
    }
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_PPlot,0);
    return vresult;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_PlotDataPointerTo_p_PlotDataBase(void *x) {
    return (void *)((PlotDataBase *)  ((PlotDataPointer *) x));
}
static void *_p_PlotDataTo_p_PlotDataBase(void *x) {
    return (void *)((PlotDataBase *)  ((PlotData *) x));
}
static void *_p_CalculatedPlotDataTo_p_PlotDataBase(void *x) {
    return (void *)((PlotDataBase *)  ((CalculatedPlotData *) x));
}
static void *_p_DummyDataTo_p_PlotDataBase(void *x) {
    return (void *)((PlotDataBase *)  ((DummyData *) x));
}
static void *_p_StringDataTo_p_PlotDataBase(void *x) {
    return (void *)((PlotDataBase *)  ((StringData *) x));
}
static void *_p_CalculatedDataTo_p_CalculatedDataBase(void *x) {
    return (void *)((CalculatedDataBase *)  ((CalculatedData *) x));
}
static void *_p_LineDataDrawerTo_p_DataDrawerBase(void *x) {
    return (void *)((DataDrawerBase *)  ((LineDataDrawer *) x));
}
static void *_p_BarDataDrawerTo_p_DataDrawerBase(void *x) {
    return (void *)((DataDrawerBase *)  ((BarDataDrawer *) x));
}
static void *_p_LinTrafoTo_p_Trafo(void *x) {
    return (void *)((Trafo *)  ((LinTrafo *) x));
}
static void *_p_LogTrafoTo_p_Trafo(void *x) {
    return (void *)((Trafo *)  ((LogTrafo *) x));
}
static void *_p_LinTickIteratorTo_p_TickIterator(void *x) {
    return (void *)((TickIterator *)  ((LinTickIterator *) x));
}
static void *_p_LogTickIteratorTo_p_TickIterator(void *x) {
    return (void *)((TickIterator *)  ((LogTickIterator *) x));
}
static void *_p_NamedTickIteratorTo_p_TickIterator(void *x) {
    return (void *)((TickIterator *) (LinTickIterator *) ((NamedTickIterator *) x));
}
static void *_p_NamedTickIteratorTo_p_LinTickIterator(void *x) {
    return (void *)((LinTickIterator *)  ((NamedTickIterator *) x));
}
static void *_p_DummyPainterTo_p_Painter(void *x) {
    return (void *)((Painter *)  ((DummyPainter *) x));
}
static void *_p_PainterTesterTo_p_PDrawer(void *x) {
    return (void *)((PDrawer *)  ((PainterTester *) x));
}
static void *_p_PPlotTo_p_PDrawer(void *x) {
    return (void *)((PDrawer *)  ((PPlot *) x));
}
static swig_type_info _swigt__p_PlotDataBase[] = {{"_p_PlotDataBase", 0, "PlotDataBase *", 0},{"_p_PlotDataPointer", _p_PlotDataPointerTo_p_PlotDataBase},{"_p_PlotData", _p_PlotDataTo_p_PlotDataBase},{"_p_CalculatedPlotData", _p_CalculatedPlotDataTo_p_PlotDataBase},{"_p_PlotDataBase"},{"_p_DummyData", _p_DummyDataTo_p_PlotDataBase},{"_p_StringData", _p_StringDataTo_p_PlotDataBase},{0}};
static swig_type_info _swigt__p_CalculatedDataBase[] = {{"_p_CalculatedDataBase", 0, "CalculatedDataBase *", 0},{"_p_CalculatedData", _p_CalculatedDataTo_p_CalculatedDataBase},{"_p_CalculatedDataBase"},{0}};
static swig_type_info _swigt__p_PRect[] = {{"_p_PRect", 0, "PRect *", 0},{"_p_PRect"},{0}};
static swig_type_info _swigt__p_LinTrafo[] = {{"_p_LinTrafo", 0, "LinTrafo *", 0},{"_p_LinTrafo"},{0}};
static swig_type_info _swigt__p_DataDrawerBase[] = {{"_p_DataDrawerBase", 0, "DataDrawerBase *", 0},{"_p_LineDataDrawer", _p_LineDataDrawerTo_p_DataDrawerBase},{"_p_BarDataDrawer", _p_BarDataDrawerTo_p_DataDrawerBase},{"_p_DataDrawerBase"},{0}};
static swig_type_info _swigt__p_StringData[] = {{"_p_StringData", 0, "StringData *", 0},{"_p_StringData"},{0}};
static swig_type_info _swigt__p_PainterTester[] = {{"_p_PainterTester", 0, "PainterTester *", 0},{"_p_PainterTester"},{0}};
static swig_type_info _swigt__p_bool[] = {{"_p_bool", 0, "bool *", 0},{"_p_bool"},{0}};
static swig_type_info _swigt__p_PlotDataPointer[] = {{"_p_PlotDataPointer", 0, "PlotDataPointer *", 0},{"_p_PlotDataPointer"},{0}};
static swig_type_info _swigt__p_BarDataDrawer[] = {{"_p_BarDataDrawer", 0, "BarDataDrawer *", 0},{"_p_BarDataDrawer"},{0}};
static swig_type_info _swigt__p_LineDataDrawer[] = {{"_p_LineDataDrawer", 0, "LineDataDrawer *", 0},{"_p_LineDataDrawer"},{0}};
static swig_type_info _swigt__p_GridInfo[] = {{"_p_GridInfo", 0, "GridInfo *", 0},{"_p_GridInfo"},{0}};
static swig_type_info _swigt__p_Trafo[] = {{"_p_Trafo", 0, "Trafo *", 0},{"_p_Trafo"},{"_p_LinTrafo", _p_LinTrafoTo_p_Trafo},{"_p_LogTrafo", _p_LogTrafoTo_p_Trafo},{0}};
static swig_type_info _swigt__p_LogTrafo[] = {{"_p_LogTrafo", 0, "LogTrafo *", 0},{"_p_LogTrafo"},{0}};
static swig_type_info _swigt__p_PlotBackground[] = {{"_p_PlotBackground", 0, "PlotBackground *", 0},{"_p_PlotBackground"},{0}};
static swig_type_info _swigt__p_NamedTickIterator[] = {{"_p_NamedTickIterator", 0, "NamedTickIterator *", 0},{"_p_NamedTickIterator"},{0}};
static swig_type_info _swigt__p_LogTickIterator[] = {{"_p_LogTickIterator", 0, "LogTickIterator *", 0},{"_p_LogTickIterator"},{0}};
static swig_type_info _swigt__p_TickIterator[] = {{"_p_TickIterator", 0, "TickIterator *", 0},{"_p_TickIterator"},{"_p_LinTickIterator", _p_LinTickIteratorTo_p_TickIterator},{"_p_NamedTickIterator", _p_NamedTickIteratorTo_p_TickIterator},{"_p_LogTickIterator", _p_LogTickIteratorTo_p_TickIterator},{0}};
static swig_type_info _swigt__p_LinTickIterator[] = {{"_p_LinTickIterator", 0, "LinTickIterator *", 0},{"_p_LinTickIterator"},{"_p_NamedTickIterator", _p_NamedTickIteratorTo_p_LinTickIterator},{0}};
static swig_type_info _swigt__p_PMargins[] = {{"_p_PMargins", 0, "PMargins *", 0},{"_p_PMargins"},{0}};
static swig_type_info _swigt__p_PCalculator[] = {{"_p_PCalculator", 0, "PCalculator *", 0},{"_p_PCalculator"},{0}};
static swig_type_info _swigt__p_string[] = {{"_p_string", 0, "string *", 0},{"_p_string"},{0}};
static swig_type_info _swigt__p_LegendData[] = {{"_p_LegendData", 0, "LegendData *", 0},{"_p_LegendData"},{0}};
static swig_type_info _swigt__p_RealPlotData[] = {{"_p_RealPlotData", 0, "RealPlotData const *", 0},{"_p_RealPlotData"},{0}};
static swig_type_info _swigt__p_PlotData[] = {{"_p_PlotData", 0, "PlotData *", 0},{"_p_PlotData"},{0}};
static swig_type_info _swigt__p_CalculatedPlotData[] = {{"_p_CalculatedPlotData", 0, "CalculatedPlotData *", 0},{"_p_CalculatedPlotData"},{0}};
static swig_type_info _swigt__p_PlotDataContainer[] = {{"_p_PlotDataContainer", 0, "PlotDataContainer *", 0},{"_p_PlotDataContainer"},{0}};
static swig_type_info _swigt__p_AxisSetup[] = {{"_p_AxisSetup", 0, "AxisSetup *", 0},{"_p_AxisSetup"},{0}};
static swig_type_info _swigt__p_DummyPainter[] = {{"_p_DummyPainter", 0, "DummyPainter *", 0},{"_p_DummyPainter"},{0}};
static swig_type_info _swigt__p_Painter[] = {{"_p_Painter", 0, "Painter *", 0},{"_p_Painter"},{"_p_DummyPainter", _p_DummyPainterTo_p_Painter},{0}};
static swig_type_info _swigt__p_DummyData[] = {{"_p_DummyData", 0, "DummyData *", 0},{"_p_DummyData"},{0}};
static swig_type_info _swigt__p_PCalculator__tList[] = {{"_p_PCalculator__tList", 0, "PCalculator::tList *", 0},{"_p_PCalculator__tList"},{0}};
static swig_type_info _swigt__p_PDrawer__tList[] = {{"_p_PDrawer__tList", 0, "PDrawer::tList *", 0},{"_p_PDrawer__tList"},{0}};
static swig_type_info _swigt__p_PColor[] = {{"_p_PColor", 0, "PColor *", 0},{"_p_PColor"},{0}};
static swig_type_info _swigt__p_float[] = {{"_p_float", 0, "float *", 0},{"_p_float"},{0}};
static swig_type_info _swigt__p_vectorTstring_t[] = {{"_p_vectorTstring_t", 0, "vector<string > *", 0},{"_p_vectorTstring_t"},{0}};
static swig_type_info _swigt__p_CalculatedData[] = {{"_p_CalculatedData", 0, "CalculatedData *", 0},{"_p_CalculatedData"},{0}};
static swig_type_info _swigt__p_PPlot[] = {{"_p_PPlot", 0, "PPlot *", 0},{"_p_PPlot"},{0}};
static swig_type_info _swigt__p_PDrawer[] = {{"_p_PDrawer", 0, "PDrawer *", 0},{"_p_PainterTester", _p_PainterTesterTo_p_PDrawer},{"_p_PDrawer"},{"_p_PPlot", _p_PPlotTo_p_PDrawer},{0}};
static swig_type_info _swigt__p_TickInfo[] = {{"_p_TickInfo", 0, "TickInfo *", 0},{"_p_TickInfo"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_PlotDataBase, 
_swigt__p_CalculatedDataBase, 
_swigt__p_PRect, 
_swigt__p_LinTrafo, 
_swigt__p_DataDrawerBase, 
_swigt__p_StringData, 
_swigt__p_PainterTester, 
_swigt__p_bool, 
_swigt__p_PlotDataPointer, 
_swigt__p_BarDataDrawer, 
_swigt__p_LineDataDrawer, 
_swigt__p_GridInfo, 
_swigt__p_Trafo, 
_swigt__p_LogTrafo, 
_swigt__p_PlotBackground, 
_swigt__p_NamedTickIterator, 
_swigt__p_LogTickIterator, 
_swigt__p_TickIterator, 
_swigt__p_LinTickIterator, 
_swigt__p_PMargins, 
_swigt__p_PCalculator, 
_swigt__p_string, 
_swigt__p_LegendData, 
_swigt__p_RealPlotData, 
_swigt__p_PlotData, 
_swigt__p_CalculatedPlotData, 
_swigt__p_PlotDataContainer, 
_swigt__p_AxisSetup, 
_swigt__p_DummyPainter, 
_swigt__p_Painter, 
_swigt__p_DummyData, 
_swigt__p_PCalculator__tList, 
_swigt__p_PDrawer__tList, 
_swigt__p_PColor, 
_swigt__p_float, 
_swigt__p_vectorTstring_t, 
_swigt__p_CalculatedData, 
_swigt__p_PPlot, 
_swigt__p_PDrawer, 
_swigt__p_TickInfo, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_pplot(void) {
    int i;
    
    SWIG_InitRuntime();
    mPplot = rb_define_module("Pplot");
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cCalculatedDataBase.klass = rb_define_class_under(mPplot, "CalculatedDataBase", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_CalculatedDataBase, (void *) &cCalculatedDataBase);
    rb_undef_method(CLASS_OF(cCalculatedDataBase.klass), "new");
    rb_define_method(cCalculatedDataBase.klass, "GetValue", VALUEFUNC(_wrap_CalculatedDataBase_GetValue), -1);
    rb_define_method(cCalculatedDataBase.klass, "GetSize", VALUEFUNC(_wrap_CalculatedDataBase_GetSize), -1);
    cCalculatedDataBase.mark = 0;
    cCalculatedDataBase.destroy = (void (*)(void *)) free_CalculatedDataBase;
    
    cPlotDataBase.klass = rb_define_class_under(mPplot, "PlotDataBase", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PlotDataBase, (void *) &cPlotDataBase);
    rb_undef_method(CLASS_OF(cPlotDataBase.klass), "new");
    rb_define_method(cPlotDataBase.klass, "GetRealPlotData", VALUEFUNC(_wrap_PlotDataBase_GetRealPlotData), -1);
    rb_define_method(cPlotDataBase.klass, "GetCalculatedData", VALUEFUNC(_wrap_PlotDataBase_GetCalculatedData), -1);
    rb_define_method(cPlotDataBase.klass, "GetSize", VALUEFUNC(_wrap_PlotDataBase_GetSize), -1);
    rb_define_method(cPlotDataBase.klass, "GetValue", VALUEFUNC(_wrap_PlotDataBase_GetValue), -1);
    rb_define_method(cPlotDataBase.klass, "CalculateRange", VALUEFUNC(_wrap_PlotDataBase_CalculateRange), -1);
    cPlotDataBase.mark = 0;
    cPlotDataBase.destroy = (void (*)(void *)) free_PlotDataBase;
    
    cPlotDataPointer.klass = rb_define_class_under(mPplot, "PlotDataPointer", ((swig_class *) SWIGTYPE_p_PlotDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_PlotDataPointer, (void *) &cPlotDataPointer);
    rb_define_singleton_method(cPlotDataPointer.klass, "new", VALUEFUNC(_wrap_PlotDataPointer_allocate), -1);
    rb_define_method(cPlotDataPointer.klass, "initialize", VALUEFUNC(_wrap_new_PlotDataPointer), -1);
    rb_define_method(cPlotDataPointer.klass, "GetRealPlotData", VALUEFUNC(_wrap_PlotDataPointer_GetRealPlotData), -1);
    rb_define_method(cPlotDataPointer.klass, "GetCalculatedData", VALUEFUNC(_wrap_PlotDataPointer_GetCalculatedData), -1);
    cPlotDataPointer.mark = 0;
    cPlotDataPointer.destroy = (void (*)(void *)) free_PlotDataPointer;
    
    cPlotData.klass = rb_define_class_under(mPplot, "PlotData", ((swig_class *) SWIGTYPE_p_PlotDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_PlotData, (void *) &cPlotData);
    rb_define_singleton_method(cPlotData.klass, "new", VALUEFUNC(_wrap_PlotData_allocate), -1);
    rb_define_method(cPlotData.klass, "initialize", VALUEFUNC(_wrap_new_PlotData), -1);
    rb_define_method(cPlotData.klass, "GetRealPlotData", VALUEFUNC(_wrap_PlotData_GetRealPlotData), -1);
    cPlotData.mark = 0;
    cPlotData.destroy = (void (*)(void *)) free_PlotData;
    
    cCalculatedData.klass = rb_define_class_under(mPplot, "CalculatedData", ((swig_class *) SWIGTYPE_p_CalculatedDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_CalculatedData, (void *) &cCalculatedData);
    rb_define_singleton_method(cCalculatedData.klass, "new", VALUEFUNC(_wrap_CalculatedData_allocate), -1);
    rb_define_method(cCalculatedData.klass, "initialize", VALUEFUNC(_wrap_new_CalculatedData), -1);
    rb_define_method(cCalculatedData.klass, "GetValue", VALUEFUNC(_wrap_CalculatedData_GetValue), -1);
    rb_define_method(cCalculatedData.klass, "GetSize", VALUEFUNC(_wrap_CalculatedData_GetSize), -1);
    rb_define_method(cCalculatedData.klass, "mMin=", VALUEFUNC(_wrap_CalculatedData_mMin_set), -1);
    rb_define_method(cCalculatedData.klass, "mMin", VALUEFUNC(_wrap_CalculatedData_mMin_get), -1);
    rb_define_method(cCalculatedData.klass, "mDelta=", VALUEFUNC(_wrap_CalculatedData_mDelta_set), -1);
    rb_define_method(cCalculatedData.klass, "mDelta", VALUEFUNC(_wrap_CalculatedData_mDelta_get), -1);
    rb_define_method(cCalculatedData.klass, "mSize=", VALUEFUNC(_wrap_CalculatedData_mSize_set), -1);
    rb_define_method(cCalculatedData.klass, "mSize", VALUEFUNC(_wrap_CalculatedData_mSize_get), -1);
    cCalculatedData.mark = 0;
    cCalculatedData.destroy = (void (*)(void *)) free_CalculatedData;
    
    cCalculatedPlotData.klass = rb_define_class_under(mPplot, "CalculatedPlotData", ((swig_class *) SWIGTYPE_p_PlotDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_CalculatedPlotData, (void *) &cCalculatedPlotData);
    rb_define_singleton_method(cCalculatedPlotData.klass, "new", VALUEFUNC(_wrap_CalculatedPlotData_allocate), -1);
    rb_define_method(cCalculatedPlotData.klass, "initialize", VALUEFUNC(_wrap_new_CalculatedPlotData), -1);
    rb_define_method(cCalculatedPlotData.klass, "GetRealPlotData", VALUEFUNC(_wrap_CalculatedPlotData_GetRealPlotData), -1);
    rb_define_method(cCalculatedPlotData.klass, "GetCalculatedData", VALUEFUNC(_wrap_CalculatedPlotData_GetCalculatedData), -1);
    rb_define_method(cCalculatedPlotData.klass, "mCalculatedData=", VALUEFUNC(_wrap_CalculatedPlotData_mCalculatedData_set), -1);
    rb_define_method(cCalculatedPlotData.klass, "mCalculatedData", VALUEFUNC(_wrap_CalculatedPlotData_mCalculatedData_get), -1);
    cCalculatedPlotData.mark = 0;
    cCalculatedPlotData.destroy = (void (*)(void *)) free_CalculatedPlotData;
    
    cDummyData.klass = rb_define_class_under(mPplot, "DummyData", ((swig_class *) SWIGTYPE_p_PlotDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_DummyData, (void *) &cDummyData);
    rb_define_singleton_method(cDummyData.klass, "new", VALUEFUNC(_wrap_DummyData_allocate), -1);
    rb_define_method(cDummyData.klass, "initialize", VALUEFUNC(_wrap_new_DummyData), -1);
    rb_define_method(cDummyData.klass, "GetRealPlotData", VALUEFUNC(_wrap_DummyData_GetRealPlotData), -1);
    cDummyData.mark = 0;
    cDummyData.destroy = (void (*)(void *)) free_DummyData;
    
    cStringData.klass = rb_define_class_under(mPplot, "StringData", ((swig_class *) SWIGTYPE_p_PlotDataBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_StringData, (void *) &cStringData);
    rb_define_singleton_method(cStringData.klass, "new", VALUEFUNC(_wrap_StringData_allocate), -1);
    rb_define_method(cStringData.klass, "initialize", VALUEFUNC(_wrap_new_StringData), -1);
    rb_define_method(cStringData.klass, "AddItem", VALUEFUNC(_wrap_StringData_AddItem), -1);
    rb_define_method(cStringData.klass, "GetStringData", VALUEFUNC(_wrap_StringData_GetStringData), -1);
    rb_define_method(cStringData.klass, "GetRealPlotData", VALUEFUNC(_wrap_StringData_GetRealPlotData), -1);
    cStringData.mark = 0;
    cStringData.destroy = (void (*)(void *)) free_StringData;
    rb_define_module_function(mPplot, "SafeLog", VALUEFUNC(_wrap_SafeLog), -1);
    rb_define_module_function(mPplot, "SafeExp", VALUEFUNC(_wrap_SafeExp), -1);
    
    cPRect.klass = rb_define_class_under(mPplot, "PRect", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PRect, (void *) &cPRect);
    rb_define_singleton_method(cPRect.klass, "new", VALUEFUNC(_wrap_PRect_allocate), -1);
    rb_define_method(cPRect.klass, "initialize", VALUEFUNC(_wrap_new_PRect), -1);
    rb_define_method(cPRect.klass, "mX=", VALUEFUNC(_wrap_PRect_mX_set), -1);
    rb_define_method(cPRect.klass, "mX", VALUEFUNC(_wrap_PRect_mX_get), -1);
    rb_define_method(cPRect.klass, "mY=", VALUEFUNC(_wrap_PRect_mY_set), -1);
    rb_define_method(cPRect.klass, "mY", VALUEFUNC(_wrap_PRect_mY_get), -1);
    rb_define_method(cPRect.klass, "mW=", VALUEFUNC(_wrap_PRect_mW_set), -1);
    rb_define_method(cPRect.klass, "mW", VALUEFUNC(_wrap_PRect_mW_get), -1);
    rb_define_method(cPRect.klass, "mH=", VALUEFUNC(_wrap_PRect_mH_set), -1);
    rb_define_method(cPRect.klass, "mH", VALUEFUNC(_wrap_PRect_mH_get), -1);
    cPRect.mark = 0;
    cPRect.destroy = (void (*)(void *)) free_PRect;
    
    cPMargins.klass = rb_define_class_under(mPplot, "PMargins", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PMargins, (void *) &cPMargins);
    rb_define_singleton_method(cPMargins.klass, "new", VALUEFUNC(_wrap_PMargins_allocate), -1);
    rb_define_method(cPMargins.klass, "initialize", VALUEFUNC(_wrap_new_PMargins), -1);
    rb_define_method(cPMargins.klass, "mLeft=", VALUEFUNC(_wrap_PMargins_mLeft_set), -1);
    rb_define_method(cPMargins.klass, "mLeft", VALUEFUNC(_wrap_PMargins_mLeft_get), -1);
    rb_define_method(cPMargins.klass, "mRight=", VALUEFUNC(_wrap_PMargins_mRight_set), -1);
    rb_define_method(cPMargins.klass, "mRight", VALUEFUNC(_wrap_PMargins_mRight_get), -1);
    rb_define_method(cPMargins.klass, "mTop=", VALUEFUNC(_wrap_PMargins_mTop_set), -1);
    rb_define_method(cPMargins.klass, "mTop", VALUEFUNC(_wrap_PMargins_mTop_get), -1);
    rb_define_method(cPMargins.klass, "mBottom=", VALUEFUNC(_wrap_PMargins_mBottom_set), -1);
    rb_define_method(cPMargins.klass, "mBottom", VALUEFUNC(_wrap_PMargins_mBottom_get), -1);
    cPMargins.mark = 0;
    cPMargins.destroy = (void (*)(void *)) free_PMargins;
    
    cPColor.klass = rb_define_class_under(mPplot, "PColor", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PColor, (void *) &cPColor);
    rb_define_singleton_method(cPColor.klass, "new", VALUEFUNC(_wrap_PColor_allocate), -1);
    rb_define_method(cPColor.klass, "initialize", VALUEFUNC(_wrap_new_PColor), -1);
    rb_define_method(cPColor.klass, "mR=", VALUEFUNC(_wrap_PColor_mR_set), -1);
    rb_define_method(cPColor.klass, "mR", VALUEFUNC(_wrap_PColor_mR_get), -1);
    rb_define_method(cPColor.klass, "mG=", VALUEFUNC(_wrap_PColor_mG_set), -1);
    rb_define_method(cPColor.klass, "mG", VALUEFUNC(_wrap_PColor_mG_get), -1);
    rb_define_method(cPColor.klass, "mB=", VALUEFUNC(_wrap_PColor_mB_set), -1);
    rb_define_method(cPColor.klass, "mB", VALUEFUNC(_wrap_PColor_mB_get), -1);
    cPColor.mark = 0;
    cPColor.destroy = (void (*)(void *)) free_PColor;
    
    cLegendData.klass = rb_define_class_under(mPplot, "LegendData", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_LegendData, (void *) &cLegendData);
    rb_define_singleton_method(cLegendData.klass, "new", VALUEFUNC(_wrap_LegendData_allocate), -1);
    rb_define_method(cLegendData.klass, "initialize", VALUEFUNC(_wrap_new_LegendData), -1);
    rb_define_method(cLegendData.klass, "mName=", VALUEFUNC(_wrap_LegendData_mName_set), -1);
    rb_define_method(cLegendData.klass, "mName", VALUEFUNC(_wrap_LegendData_mName_get), -1);
    rb_define_method(cLegendData.klass, "mColor=", VALUEFUNC(_wrap_LegendData_mColor_set), -1);
    rb_define_method(cLegendData.klass, "mColor", VALUEFUNC(_wrap_LegendData_mColor_get), -1);
    rb_define_method(cLegendData.klass, "SetDefaultValues", VALUEFUNC(_wrap_LegendData_SetDefaultValues), -1);
    rb_define_singleton_method(cLegendData.klass, "GetDefaultColor", VALUEFUNC(_wrap_LegendData_GetDefaultColor), -1);
    cLegendData.mark = 0;
    cLegendData.destroy = (void (*)(void *)) free_LegendData;
    
    cPainter.klass = rb_define_class_under(mPplot, "Painter", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_Painter, (void *) &cPainter);
    rb_undef_method(CLASS_OF(cPainter.klass), "new");
    rb_define_method(cPainter.klass, "DrawLine", VALUEFUNC(_wrap_Painter_DrawLine), -1);
    rb_define_method(cPainter.klass, "FillRect", VALUEFUNC(_wrap_Painter_FillRect), -1);
    rb_define_method(cPainter.klass, "SetClipRect", VALUEFUNC(_wrap_Painter_SetClipRect), -1);
    rb_define_method(cPainter.klass, "GetWidth", VALUEFUNC(_wrap_Painter_GetWidth), -1);
    rb_define_method(cPainter.klass, "GetHeight", VALUEFUNC(_wrap_Painter_GetHeight), -1);
    rb_define_method(cPainter.klass, "SetLineColor", VALUEFUNC(_wrap_Painter_SetLineColor), -1);
    rb_define_method(cPainter.klass, "SetFillColor", VALUEFUNC(_wrap_Painter_SetFillColor), -1);
    rb_define_method(cPainter.klass, "CalculateTextDrawSize", VALUEFUNC(_wrap_Painter_CalculateTextDrawSize), -1);
    rb_define_method(cPainter.klass, "GetFontHeight", VALUEFUNC(_wrap_Painter_GetFontHeight), -1);
    rb_define_method(cPainter.klass, "DrawText", VALUEFUNC(_wrap_Painter_DrawText), -1);
    rb_define_method(cPainter.klass, "DrawRotatedText", VALUEFUNC(_wrap_Painter_DrawRotatedText), -1);
    cPainter.mark = 0;
    cPainter.destroy = (void (*)(void *)) free_Painter;
    
    cDummyPainter.klass = rb_define_class_under(mPplot, "DummyPainter", ((swig_class *) SWIGTYPE_p_Painter->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_DummyPainter, (void *) &cDummyPainter);
    rb_define_singleton_method(cDummyPainter.klass, "new", VALUEFUNC(_wrap_DummyPainter_allocate), -1);
    rb_define_method(cDummyPainter.klass, "initialize", VALUEFUNC(_wrap_new_DummyPainter), -1);
    rb_define_method(cDummyPainter.klass, "DrawLine", VALUEFUNC(_wrap_DummyPainter_DrawLine), -1);
    rb_define_method(cDummyPainter.klass, "FillRect", VALUEFUNC(_wrap_DummyPainter_FillRect), -1);
    rb_define_method(cDummyPainter.klass, "SetClipRect", VALUEFUNC(_wrap_DummyPainter_SetClipRect), -1);
    rb_define_method(cDummyPainter.klass, "GetWidth", VALUEFUNC(_wrap_DummyPainter_GetWidth), -1);
    rb_define_method(cDummyPainter.klass, "GetHeight", VALUEFUNC(_wrap_DummyPainter_GetHeight), -1);
    rb_define_method(cDummyPainter.klass, "SetLineColor", VALUEFUNC(_wrap_DummyPainter_SetLineColor), -1);
    rb_define_method(cDummyPainter.klass, "SetFillColor", VALUEFUNC(_wrap_DummyPainter_SetFillColor), -1);
    rb_define_method(cDummyPainter.klass, "CalculateTextDrawSize", VALUEFUNC(_wrap_DummyPainter_CalculateTextDrawSize), -1);
    rb_define_method(cDummyPainter.klass, "GetFontHeight", VALUEFUNC(_wrap_DummyPainter_GetFontHeight), -1);
    rb_define_method(cDummyPainter.klass, "DrawText", VALUEFUNC(_wrap_DummyPainter_DrawText), -1);
    rb_define_method(cDummyPainter.klass, "DrawRotatedText", VALUEFUNC(_wrap_DummyPainter_DrawRotatedText), -1);
    cDummyPainter.mark = 0;
    cDummyPainter.destroy = (void (*)(void *)) free_DummyPainter;
    
    cDataDrawerBase.klass = rb_define_class_under(mPplot, "DataDrawerBase", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_DataDrawerBase, (void *) &cDataDrawerBase);
    rb_undef_method(CLASS_OF(cDataDrawerBase.klass), "new");
    rb_define_method(cDataDrawerBase.klass, "SetXTrafo", VALUEFUNC(_wrap_DataDrawerBase_SetXTrafo), -1);
    rb_define_method(cDataDrawerBase.klass, "SetYTrafo", VALUEFUNC(_wrap_DataDrawerBase_SetYTrafo), -1);
    rb_define_method(cDataDrawerBase.klass, "SetDrawFast", VALUEFUNC(_wrap_DataDrawerBase_SetDrawFast), -1);
    rb_define_method(cDataDrawerBase.klass, "DrawData", VALUEFUNC(_wrap_DataDrawerBase_DrawData), -1);
    rb_define_method(cDataDrawerBase.klass, "Clone", VALUEFUNC(_wrap_DataDrawerBase_Clone), -1);
    cDataDrawerBase.mark = 0;
    cDataDrawerBase.destroy = (void (*)(void *)) free_DataDrawerBase;
    
    cLineDataDrawer.klass = rb_define_class_under(mPplot, "LineDataDrawer", ((swig_class *) SWIGTYPE_p_DataDrawerBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_LineDataDrawer, (void *) &cLineDataDrawer);
    rb_define_singleton_method(cLineDataDrawer.klass, "new", VALUEFUNC(_wrap_LineDataDrawer_allocate), -1);
    rb_define_method(cLineDataDrawer.klass, "initialize", VALUEFUNC(_wrap_new_LineDataDrawer), -1);
    rb_define_method(cLineDataDrawer.klass, "DrawData", VALUEFUNC(_wrap_LineDataDrawer_DrawData), -1);
    rb_define_method(cLineDataDrawer.klass, "Clone", VALUEFUNC(_wrap_LineDataDrawer_Clone), -1);
    rb_define_method(cLineDataDrawer.klass, "DrawPoint", VALUEFUNC(_wrap_LineDataDrawer_DrawPoint), -1);
    rb_define_method(cLineDataDrawer.klass, "mDrawLine=", VALUEFUNC(_wrap_LineDataDrawer_mDrawLine_set), -1);
    rb_define_method(cLineDataDrawer.klass, "mDrawLine", VALUEFUNC(_wrap_LineDataDrawer_mDrawLine_get), -1);
    rb_define_method(cLineDataDrawer.klass, "mDrawPoint=", VALUEFUNC(_wrap_LineDataDrawer_mDrawPoint_set), -1);
    rb_define_method(cLineDataDrawer.klass, "mDrawPoint", VALUEFUNC(_wrap_LineDataDrawer_mDrawPoint_get), -1);
    cLineDataDrawer.mark = 0;
    cLineDataDrawer.destroy = (void (*)(void *)) free_LineDataDrawer;
    
    cBarDataDrawer.klass = rb_define_class_under(mPplot, "BarDataDrawer", ((swig_class *) SWIGTYPE_p_DataDrawerBase->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_BarDataDrawer, (void *) &cBarDataDrawer);
    rb_define_singleton_method(cBarDataDrawer.klass, "new", VALUEFUNC(_wrap_BarDataDrawer_allocate), -1);
    rb_define_method(cBarDataDrawer.klass, "initialize", VALUEFUNC(_wrap_new_BarDataDrawer), -1);
    rb_define_method(cBarDataDrawer.klass, "DrawData", VALUEFUNC(_wrap_BarDataDrawer_DrawData), -1);
    rb_define_method(cBarDataDrawer.klass, "Clone", VALUEFUNC(_wrap_BarDataDrawer_Clone), -1);
    cBarDataDrawer.mark = 0;
    cBarDataDrawer.destroy = (void (*)(void *)) free_BarDataDrawer;
    
    cPlotDataContainer.klass = rb_define_class_under(mPplot, "PlotDataContainer", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PlotDataContainer, (void *) &cPlotDataContainer);
    rb_define_singleton_method(cPlotDataContainer.klass, "new", VALUEFUNC(_wrap_PlotDataContainer_allocate), -1);
    rb_define_method(cPlotDataContainer.klass, "initialize", VALUEFUNC(_wrap_new_PlotDataContainer), -1);
    rb_define_method(cPlotDataContainer.klass, "RemoveElement", VALUEFUNC(_wrap_PlotDataContainer_RemoveElement), -1);
    rb_define_method(cPlotDataContainer.klass, "ClearData", VALUEFUNC(_wrap_PlotDataContainer_ClearData), -1);
    rb_define_method(cPlotDataContainer.klass, "AddXYPlot", VALUEFUNC(_wrap_PlotDataContainer_AddXYPlot), -1);
    rb_define_method(cPlotDataContainer.klass, "SetXYPlot", VALUEFUNC(_wrap_PlotDataContainer_SetXYPlot), -1);
    rb_define_method(cPlotDataContainer.klass, "GetPlotCount", VALUEFUNC(_wrap_PlotDataContainer_GetPlotCount), -1);
    rb_define_method(cPlotDataContainer.klass, "GetXData", VALUEFUNC(_wrap_PlotDataContainer_GetXData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetYData", VALUEFUNC(_wrap_PlotDataContainer_GetYData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetLegendData", VALUEFUNC(_wrap_PlotDataContainer_GetLegendData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetDataDrawer", VALUEFUNC(_wrap_PlotDataContainer_GetDataDrawer), -1);
    rb_define_method(cPlotDataContainer.klass, "GetConstXData", VALUEFUNC(_wrap_PlotDataContainer_GetConstXData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetConstYData", VALUEFUNC(_wrap_PlotDataContainer_GetConstYData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetConstLegendData", VALUEFUNC(_wrap_PlotDataContainer_GetConstLegendData), -1);
    rb_define_method(cPlotDataContainer.klass, "GetConstDataDrawer", VALUEFUNC(_wrap_PlotDataContainer_GetConstDataDrawer), -1);
    rb_define_method(cPlotDataContainer.klass, "CalculateXRange", VALUEFUNC(_wrap_PlotDataContainer_CalculateXRange), -1);
    rb_define_method(cPlotDataContainer.klass, "CalculateYRange", VALUEFUNC(_wrap_PlotDataContainer_CalculateYRange), -1);
    rb_define_method(cPlotDataContainer.klass, "CalculateYRangePlot", VALUEFUNC(_wrap_PlotDataContainer_CalculateYRangePlot), -1);
    cPlotDataContainer.mark = 0;
    cPlotDataContainer.destroy = (void (*)(void *)) free_PlotDataContainer;
    
    cGridInfo.klass = rb_define_class_under(mPplot, "GridInfo", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_GridInfo, (void *) &cGridInfo);
    rb_define_singleton_method(cGridInfo.klass, "new", VALUEFUNC(_wrap_GridInfo_allocate), -1);
    rb_define_method(cGridInfo.klass, "initialize", VALUEFUNC(_wrap_new_GridInfo), -1);
    rb_define_method(cGridInfo.klass, "mXGridOn=", VALUEFUNC(_wrap_GridInfo_mXGridOn_set), -1);
    rb_define_method(cGridInfo.klass, "mXGridOn", VALUEFUNC(_wrap_GridInfo_mXGridOn_get), -1);
    rb_define_method(cGridInfo.klass, "mYGridOn=", VALUEFUNC(_wrap_GridInfo_mYGridOn_set), -1);
    rb_define_method(cGridInfo.klass, "mYGridOn", VALUEFUNC(_wrap_GridInfo_mYGridOn_get), -1);
    cGridInfo.mark = 0;
    cGridInfo.destroy = (void (*)(void *)) free_GridInfo;
    
    cTickInfo.klass = rb_define_class_under(mPplot, "TickInfo", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_TickInfo, (void *) &cTickInfo);
    rb_define_singleton_method(cTickInfo.klass, "new", VALUEFUNC(_wrap_TickInfo_allocate), -1);
    rb_define_method(cTickInfo.klass, "initialize", VALUEFUNC(_wrap_new_TickInfo), -1);
    rb_define_singleton_method(cTickInfo.klass, "RoundSpan", VALUEFUNC(_wrap_TickInfo_RoundSpan), -1);
    rb_define_singleton_method(cTickInfo.klass, "MakeFormatString", VALUEFUNC(_wrap_TickInfo_MakeFormatString), -1);
    rb_define_method(cTickInfo.klass, "mAutoTick=", VALUEFUNC(_wrap_TickInfo_mAutoTick_set), -1);
    rb_define_method(cTickInfo.klass, "mAutoTick", VALUEFUNC(_wrap_TickInfo_mAutoTick_get), -1);
    rb_define_method(cTickInfo.klass, "mAutoTickSize=", VALUEFUNC(_wrap_TickInfo_mAutoTickSize_set), -1);
    rb_define_method(cTickInfo.klass, "mAutoTickSize", VALUEFUNC(_wrap_TickInfo_mAutoTickSize_get), -1);
    rb_define_method(cTickInfo.klass, "mTickDivision=", VALUEFUNC(_wrap_TickInfo_mTickDivision_set), -1);
    rb_define_method(cTickInfo.klass, "mTickDivision", VALUEFUNC(_wrap_TickInfo_mTickDivision_get), -1);
    rb_define_method(cTickInfo.klass, "mMajorTickSpan=", VALUEFUNC(_wrap_TickInfo_mMajorTickSpan_set), -1);
    rb_define_method(cTickInfo.klass, "mMajorTickSpan", VALUEFUNC(_wrap_TickInfo_mMajorTickSpan_get), -1);
    rb_define_method(cTickInfo.klass, "mMajorTickScreenSize=", VALUEFUNC(_wrap_TickInfo_mMajorTickScreenSize_set), -1);
    rb_define_method(cTickInfo.klass, "mMajorTickScreenSize", VALUEFUNC(_wrap_TickInfo_mMajorTickScreenSize_get), -1);
    rb_define_method(cTickInfo.klass, "mMinorTickScreenSize=", VALUEFUNC(_wrap_TickInfo_mMinorTickScreenSize_set), -1);
    rb_define_method(cTickInfo.klass, "mMinorTickScreenSize", VALUEFUNC(_wrap_TickInfo_mMinorTickScreenSize_get), -1);
    rb_define_method(cTickInfo.klass, "mFormatString=", VALUEFUNC(_wrap_TickInfo_mFormatString_set), -1);
    rb_define_method(cTickInfo.klass, "mFormatString", VALUEFUNC(_wrap_TickInfo_mFormatString_get), -1);
    cTickInfo.mark = 0;
    cTickInfo.destroy = (void (*)(void *)) free_TickInfo;
    
    cAxisSetup.klass = rb_define_class_under(mPplot, "AxisSetup", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_AxisSetup, (void *) &cAxisSetup);
    rb_define_singleton_method(cAxisSetup.klass, "new", VALUEFUNC(_wrap_AxisSetup_allocate), -1);
    rb_define_method(cAxisSetup.klass, "initialize", VALUEFUNC(_wrap_new_AxisSetup), -1);
    rb_define_method(cAxisSetup.klass, "SetMin", VALUEFUNC(_wrap_AxisSetup_SetMin), -1);
    rb_define_method(cAxisSetup.klass, "SetMax", VALUEFUNC(_wrap_AxisSetup_SetMax), -1);
    rb_define_method(cAxisSetup.klass, "SetAutoScale", VALUEFUNC(_wrap_AxisSetup_SetAutoScale), -1);
    rb_define_method(cAxisSetup.klass, "IsAutoScale", VALUEFUNC(_wrap_AxisSetup_IsAutoScale), -1);
    rb_define_method(cAxisSetup.klass, "mMin=", VALUEFUNC(_wrap_AxisSetup_mMin_set), -1);
    rb_define_method(cAxisSetup.klass, "mMin", VALUEFUNC(_wrap_AxisSetup_mMin_get), -1);
    rb_define_method(cAxisSetup.klass, "mMax=", VALUEFUNC(_wrap_AxisSetup_mMax_set), -1);
    rb_define_method(cAxisSetup.klass, "mMax", VALUEFUNC(_wrap_AxisSetup_mMax_get), -1);
    rb_define_method(cAxisSetup.klass, "mAutoScaleMin=", VALUEFUNC(_wrap_AxisSetup_mAutoScaleMin_set), -1);
    rb_define_method(cAxisSetup.klass, "mAutoScaleMin", VALUEFUNC(_wrap_AxisSetup_mAutoScaleMin_get), -1);
    rb_define_method(cAxisSetup.klass, "mAutoScaleMax=", VALUEFUNC(_wrap_AxisSetup_mAutoScaleMax_set), -1);
    rb_define_method(cAxisSetup.klass, "mAutoScaleMax", VALUEFUNC(_wrap_AxisSetup_mAutoScaleMax_get), -1);
    rb_define_method(cAxisSetup.klass, "mAscending=", VALUEFUNC(_wrap_AxisSetup_mAscending_set), -1);
    rb_define_method(cAxisSetup.klass, "mAscending", VALUEFUNC(_wrap_AxisSetup_mAscending_get), -1);
    rb_define_method(cAxisSetup.klass, "mLogScale=", VALUEFUNC(_wrap_AxisSetup_mLogScale_set), -1);
    rb_define_method(cAxisSetup.klass, "mLogScale", VALUEFUNC(_wrap_AxisSetup_mLogScale_get), -1);
    rb_define_method(cAxisSetup.klass, "mCrossOrigin=", VALUEFUNC(_wrap_AxisSetup_mCrossOrigin_set), -1);
    rb_define_method(cAxisSetup.klass, "mCrossOrigin", VALUEFUNC(_wrap_AxisSetup_mCrossOrigin_get), -1);
    rb_define_method(cAxisSetup.klass, "mMaxDecades=", VALUEFUNC(_wrap_AxisSetup_mMaxDecades_set), -1);
    rb_define_method(cAxisSetup.klass, "mMaxDecades", VALUEFUNC(_wrap_AxisSetup_mMaxDecades_get), -1);
    rb_define_method(cAxisSetup.klass, "mLogBase=", VALUEFUNC(_wrap_AxisSetup_mLogBase_set), -1);
    rb_define_method(cAxisSetup.klass, "mLogBase", VALUEFUNC(_wrap_AxisSetup_mLogBase_get), -1);
    rb_define_method(cAxisSetup.klass, "mLabel=", VALUEFUNC(_wrap_AxisSetup_mLabel_set), -1);
    rb_define_method(cAxisSetup.klass, "mLabel", VALUEFUNC(_wrap_AxisSetup_mLabel_get), -1);
    rb_define_method(cAxisSetup.klass, "mTickInfo=", VALUEFUNC(_wrap_AxisSetup_mTickInfo_set), -1);
    rb_define_method(cAxisSetup.klass, "mTickInfo", VALUEFUNC(_wrap_AxisSetup_mTickInfo_get), -1);
    cAxisSetup.mark = 0;
    cAxisSetup.destroy = (void (*)(void *)) free_AxisSetup;
    
    cTrafo.klass = rb_define_class_under(mPplot, "Trafo", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_Trafo, (void *) &cTrafo);
    rb_undef_method(CLASS_OF(cTrafo.klass), "new");
    rb_define_method(cTrafo.klass, "Transform", VALUEFUNC(_wrap_Trafo_Transform), -1);
    rb_define_method(cTrafo.klass, "TransformBack", VALUEFUNC(_wrap_Trafo_TransformBack), -1);
    cTrafo.mark = 0;
    cTrafo.destroy = (void (*)(void *)) free_Trafo;
    
    cLinTrafo.klass = rb_define_class_under(mPplot, "LinTrafo", ((swig_class *) SWIGTYPE_p_Trafo->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_LinTrafo, (void *) &cLinTrafo);
    rb_define_singleton_method(cLinTrafo.klass, "new", VALUEFUNC(_wrap_LinTrafo_allocate), -1);
    rb_define_method(cLinTrafo.klass, "initialize", VALUEFUNC(_wrap_new_LinTrafo), -1);
    rb_define_method(cLinTrafo.klass, "Transform", VALUEFUNC(_wrap_LinTrafo_Transform), -1);
    rb_define_method(cLinTrafo.klass, "TransformBack", VALUEFUNC(_wrap_LinTrafo_TransformBack), -1);
    rb_define_method(cLinTrafo.klass, "mOffset=", VALUEFUNC(_wrap_LinTrafo_mOffset_set), -1);
    rb_define_method(cLinTrafo.klass, "mOffset", VALUEFUNC(_wrap_LinTrafo_mOffset_get), -1);
    rb_define_method(cLinTrafo.klass, "mSlope=", VALUEFUNC(_wrap_LinTrafo_mSlope_set), -1);
    rb_define_method(cLinTrafo.klass, "mSlope", VALUEFUNC(_wrap_LinTrafo_mSlope_get), -1);
    cLinTrafo.mark = 0;
    cLinTrafo.destroy = (void (*)(void *)) free_LinTrafo;
    
    cLogTrafo.klass = rb_define_class_under(mPplot, "LogTrafo", ((swig_class *) SWIGTYPE_p_Trafo->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_LogTrafo, (void *) &cLogTrafo);
    rb_define_singleton_method(cLogTrafo.klass, "new", VALUEFUNC(_wrap_LogTrafo_allocate), -1);
    rb_define_method(cLogTrafo.klass, "initialize", VALUEFUNC(_wrap_new_LogTrafo), -1);
    rb_define_method(cLogTrafo.klass, "Transform", VALUEFUNC(_wrap_LogTrafo_Transform), -1);
    rb_define_method(cLogTrafo.klass, "TransformBack", VALUEFUNC(_wrap_LogTrafo_TransformBack), -1);
    rb_define_method(cLogTrafo.klass, "mOffset=", VALUEFUNC(_wrap_LogTrafo_mOffset_set), -1);
    rb_define_method(cLogTrafo.klass, "mOffset", VALUEFUNC(_wrap_LogTrafo_mOffset_get), -1);
    rb_define_method(cLogTrafo.klass, "mSlope=", VALUEFUNC(_wrap_LogTrafo_mSlope_set), -1);
    rb_define_method(cLogTrafo.klass, "mSlope", VALUEFUNC(_wrap_LogTrafo_mSlope_get), -1);
    rb_define_method(cLogTrafo.klass, "mBase=", VALUEFUNC(_wrap_LogTrafo_mBase_set), -1);
    rb_define_method(cLogTrafo.klass, "mBase", VALUEFUNC(_wrap_LogTrafo_mBase_get), -1);
    cLogTrafo.mark = 0;
    cLogTrafo.destroy = (void (*)(void *)) free_LogTrafo;
    
    cTickIterator.klass = rb_define_class_under(mPplot, "TickIterator", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_TickIterator, (void *) &cTickIterator);
    rb_undef_method(CLASS_OF(cTickIterator.klass), "new");
    rb_define_method(cTickIterator.klass, "Init", VALUEFUNC(_wrap_TickIterator_Init), -1);
    rb_define_method(cTickIterator.klass, "GetNextTick", VALUEFUNC(_wrap_TickIterator_GetNextTick), -1);
    rb_define_method(cTickIterator.klass, "InitFromRanges", VALUEFUNC(_wrap_TickIterator_InitFromRanges), -1);
    rb_define_method(cTickIterator.klass, "AdjustRange", VALUEFUNC(_wrap_TickIterator_AdjustRange), -1);
    rb_define_method(cTickIterator.klass, "SetAxisSetup", VALUEFUNC(_wrap_TickIterator_SetAxisSetup), -1);
    cTickIterator.mark = 0;
    cTickIterator.destroy = (void (*)(void *)) free_TickIterator;
    
    cLinTickIterator.klass = rb_define_class_under(mPplot, "LinTickIterator", ((swig_class *) SWIGTYPE_p_TickIterator->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_LinTickIterator, (void *) &cLinTickIterator);
    rb_define_singleton_method(cLinTickIterator.klass, "new", VALUEFUNC(_wrap_LinTickIterator_allocate), -1);
    rb_define_method(cLinTickIterator.klass, "initialize", VALUEFUNC(_wrap_new_LinTickIterator), -1);
    rb_define_method(cLinTickIterator.klass, "Init", VALUEFUNC(_wrap_LinTickIterator_Init), -1);
    rb_define_method(cLinTickIterator.klass, "GetNextTick", VALUEFUNC(_wrap_LinTickIterator_GetNextTick), -1);
    rb_define_method(cLinTickIterator.klass, "InitFromRanges", VALUEFUNC(_wrap_LinTickIterator_InitFromRanges), -1);
    cLinTickIterator.mark = 0;
    cLinTickIterator.destroy = (void (*)(void *)) free_LinTickIterator;
    
    cLogTickIterator.klass = rb_define_class_under(mPplot, "LogTickIterator", ((swig_class *) SWIGTYPE_p_TickIterator->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_LogTickIterator, (void *) &cLogTickIterator);
    rb_define_singleton_method(cLogTickIterator.klass, "new", VALUEFUNC(_wrap_LogTickIterator_allocate), -1);
    rb_define_method(cLogTickIterator.klass, "initialize", VALUEFUNC(_wrap_new_LogTickIterator), -1);
    rb_define_method(cLogTickIterator.klass, "Init", VALUEFUNC(_wrap_LogTickIterator_Init), -1);
    rb_define_method(cLogTickIterator.klass, "GetNextTick", VALUEFUNC(_wrap_LogTickIterator_GetNextTick), -1);
    rb_define_method(cLogTickIterator.klass, "InitFromRanges", VALUEFUNC(_wrap_LogTickIterator_InitFromRanges), -1);
    rb_define_method(cLogTickIterator.klass, "AdjustRange", VALUEFUNC(_wrap_LogTickIterator_AdjustRange), -1);
    rb_define_method(cLogTickIterator.klass, "RoundUp", VALUEFUNC(_wrap_LogTickIterator_RoundUp), -1);
    rb_define_method(cLogTickIterator.klass, "RoundDown", VALUEFUNC(_wrap_LogTickIterator_RoundDown), -1);
    cLogTickIterator.mark = 0;
    cLogTickIterator.destroy = (void (*)(void *)) free_LogTickIterator;
    
    cNamedTickIterator.klass = rb_define_class_under(mPplot, "NamedTickIterator", ((swig_class *) SWIGTYPE_p_LinTickIterator->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_NamedTickIterator, (void *) &cNamedTickIterator);
    rb_define_singleton_method(cNamedTickIterator.klass, "new", VALUEFUNC(_wrap_NamedTickIterator_allocate), -1);
    rb_define_method(cNamedTickIterator.klass, "initialize", VALUEFUNC(_wrap_new_NamedTickIterator), -1);
    rb_define_method(cNamedTickIterator.klass, "SetStringList", VALUEFUNC(_wrap_NamedTickIterator_SetStringList), -1);
    rb_define_method(cNamedTickIterator.klass, "GetNextTick", VALUEFUNC(_wrap_NamedTickIterator_GetNextTick), -1);
    rb_define_method(cNamedTickIterator.klass, "InitFromRanges", VALUEFUNC(_wrap_NamedTickIterator_InitFromRanges), -1);
    cNamedTickIterator.mark = 0;
    cNamedTickIterator.destroy = (void (*)(void *)) free_NamedTickIterator;
    
    cPlotBackground.klass = rb_define_class_under(mPplot, "PlotBackground", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PlotBackground, (void *) &cPlotBackground);
    rb_define_singleton_method(cPlotBackground.klass, "new", VALUEFUNC(_wrap_PlotBackground_allocate), -1);
    rb_define_method(cPlotBackground.klass, "initialize", VALUEFUNC(_wrap_new_PlotBackground), -1);
    rb_define_method(cPlotBackground.klass, "mTransparent=", VALUEFUNC(_wrap_PlotBackground_mTransparent_set), -1);
    rb_define_method(cPlotBackground.klass, "mTransparent", VALUEFUNC(_wrap_PlotBackground_mTransparent_get), -1);
    rb_define_method(cPlotBackground.klass, "mPlotRegionBackColor=", VALUEFUNC(_wrap_PlotBackground_mPlotRegionBackColor_set), -1);
    rb_define_method(cPlotBackground.klass, "mPlotRegionBackColor", VALUEFUNC(_wrap_PlotBackground_mPlotRegionBackColor_get), -1);
    rb_define_method(cPlotBackground.klass, "mTitle=", VALUEFUNC(_wrap_PlotBackground_mTitle_set), -1);
    rb_define_method(cPlotBackground.klass, "mTitle", VALUEFUNC(_wrap_PlotBackground_mTitle_get), -1);
    cPlotBackground.mark = 0;
    cPlotBackground.destroy = (void (*)(void *)) free_PlotBackground;
    
    cPDrawer.klass = rb_define_class_under(mPplot, "PDrawer", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PDrawer, (void *) &cPDrawer);
    rb_undef_method(CLASS_OF(cPDrawer.klass), "new");
    rb_define_method(cPDrawer.klass, "Prepare", VALUEFUNC(_wrap_PDrawer_Prepare), -1);
    rb_define_method(cPDrawer.klass, "Draw", VALUEFUNC(_wrap_PDrawer_Draw), -1);
    cPDrawer.mark = 0;
    cPDrawer.destroy = (void (*)(void *)) free_PDrawer;
    
    cPCalculator.klass = rb_define_class_under(mPplot, "PCalculator", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_PCalculator, (void *) &cPCalculator);
    rb_define_singleton_method(cPCalculator.klass, "new", VALUEFUNC(_wrap_PCalculator_allocate), -1);
    rb_define_method(cPCalculator.klass, "initialize", VALUEFUNC(_wrap_new_PCalculator), -1);
    rb_define_method(cPCalculator.klass, "Calculate", VALUEFUNC(_wrap_PCalculator_Calculate), -1);
    cPCalculator.mark = 0;
    cPCalculator.destroy = (void (*)(void *)) free_PCalculator;
    
    cPainterTester.klass = rb_define_class_under(mPplot, "PainterTester", ((swig_class *) SWIGTYPE_p_PDrawer->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_PainterTester, (void *) &cPainterTester);
    rb_define_singleton_method(cPainterTester.klass, "new", VALUEFUNC(_wrap_PainterTester_allocate), -1);
    rb_define_method(cPainterTester.klass, "initialize", VALUEFUNC(_wrap_new_PainterTester), -1);
    rb_define_method(cPainterTester.klass, "Draw", VALUEFUNC(_wrap_PainterTester_Draw), -1);
    cPainterTester.mark = 0;
    cPainterTester.destroy = (void (*)(void *)) free_PainterTester;
    
    cPPlot.klass = rb_define_class_under(mPplot, "PPlot", ((swig_class *) SWIGTYPE_p_PDrawer->clientdata)->klass);
    SWIG_TypeClientData(SWIGTYPE_p_PPlot, (void *) &cPPlot);
    rb_define_singleton_method(cPPlot.klass, "new", VALUEFUNC(_wrap_PPlot_allocate), -1);
    rb_define_method(cPPlot.klass, "initialize", VALUEFUNC(_wrap_new_PPlot), -1);
    rb_define_method(cPPlot.klass, "Draw", VALUEFUNC(_wrap_PPlot_Draw), -1);
    rb_define_method(cPPlot.klass, "mPlotDataContainer=", VALUEFUNC(_wrap_PPlot_mPlotDataContainer_set), -1);
    rb_define_method(cPPlot.klass, "mPlotDataContainer", VALUEFUNC(_wrap_PPlot_mPlotDataContainer_get), -1);
    rb_define_method(cPPlot.klass, "mXAxisSetup=", VALUEFUNC(_wrap_PPlot_mXAxisSetup_set), -1);
    rb_define_method(cPPlot.klass, "mXAxisSetup", VALUEFUNC(_wrap_PPlot_mXAxisSetup_get), -1);
    rb_define_method(cPPlot.klass, "mYAxisSetup=", VALUEFUNC(_wrap_PPlot_mYAxisSetup_set), -1);
    rb_define_method(cPPlot.klass, "mYAxisSetup", VALUEFUNC(_wrap_PPlot_mYAxisSetup_get), -1);
    rb_define_method(cPPlot.klass, "mGridInfo=", VALUEFUNC(_wrap_PPlot_mGridInfo_set), -1);
    rb_define_method(cPPlot.klass, "mGridInfo", VALUEFUNC(_wrap_PPlot_mGridInfo_get), -1);
    rb_define_method(cPPlot.klass, "mMargins=", VALUEFUNC(_wrap_PPlot_mMargins_set), -1);
    rb_define_method(cPPlot.klass, "mMargins", VALUEFUNC(_wrap_PPlot_mMargins_get), -1);
    rb_define_method(cPPlot.klass, "mPlotBackground=", VALUEFUNC(_wrap_PPlot_mPlotBackground_set), -1);
    rb_define_method(cPPlot.klass, "mPlotBackground", VALUEFUNC(_wrap_PPlot_mPlotBackground_get), -1);
    rb_define_method(cPPlot.klass, "SetPPlotDrawer", VALUEFUNC(_wrap_PPlot_SetPPlotDrawer), -1);
    rb_define_method(cPPlot.klass, "mPostCalculatorList=", VALUEFUNC(_wrap_PPlot_mPostCalculatorList_set), -1);
    rb_define_method(cPPlot.klass, "mPostCalculatorList", VALUEFUNC(_wrap_PPlot_mPostCalculatorList_get), -1);
    rb_define_method(cPPlot.klass, "mPreDrawerList=", VALUEFUNC(_wrap_PPlot_mPreDrawerList_set), -1);
    rb_define_method(cPPlot.klass, "mPreDrawerList", VALUEFUNC(_wrap_PPlot_mPreDrawerList_get), -1);
    rb_define_method(cPPlot.klass, "mPostDrawerList=", VALUEFUNC(_wrap_PPlot_mPostDrawerList_set), -1);
    rb_define_method(cPPlot.klass, "mPostDrawerList", VALUEFUNC(_wrap_PPlot_mPostDrawerList_get), -1);
    rb_define_method(cPPlot.klass, "mXTickIterator=", VALUEFUNC(_wrap_PPlot_mXTickIterator_set), -1);
    rb_define_method(cPPlot.klass, "mXTickIterator", VALUEFUNC(_wrap_PPlot_mXTickIterator_get), -1);
    rb_define_method(cPPlot.klass, "mYTickIterator=", VALUEFUNC(_wrap_PPlot_mYTickIterator_set), -1);
    rb_define_method(cPPlot.klass, "mYTickIterator", VALUEFUNC(_wrap_PPlot_mYTickIterator_get), -1);
    rb_define_method(cPPlot.klass, "CalculateXTransformation", VALUEFUNC(_wrap_PPlot_CalculateXTransformation), -1);
    rb_define_method(cPPlot.klass, "CalculateYTransformation", VALUEFUNC(_wrap_PPlot_CalculateYTransformation), -1);
    rb_define_method(cPPlot.klass, "DrawXAxis", VALUEFUNC(_wrap_PPlot_DrawXAxis), -1);
    rb_define_method(cPPlot.klass, "DrawYAxis", VALUEFUNC(_wrap_PPlot_DrawYAxis), -1);
    rb_define_method(cPPlot.klass, "CalculateTickInfo", VALUEFUNC(_wrap_PPlot_CalculateTickInfo), -1);
    rb_define_method(cPPlot.klass, "mXTrafo=", VALUEFUNC(_wrap_PPlot_mXTrafo_set), -1);
    rb_define_method(cPPlot.klass, "mXTrafo", VALUEFUNC(_wrap_PPlot_mXTrafo_get), -1);
    rb_define_method(cPPlot.klass, "mYTrafo=", VALUEFUNC(_wrap_PPlot_mYTrafo_set), -1);
    rb_define_method(cPPlot.klass, "mYTrafo", VALUEFUNC(_wrap_PPlot_mYTrafo_get), -1);
    rb_define_singleton_method(cPPlot.klass, "Round", VALUEFUNC(_wrap_PPlot_Round), -1);
    cPPlot.mark = 0;
    cPPlot.destroy = (void (*)(void *)) free_PPlot;
    rb_define_module_function(mPplot, "MakeExamplePlot", VALUEFUNC(_wrap_MakeExamplePlot), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot1", VALUEFUNC(_wrap_MakeExamplePlot1), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot2", VALUEFUNC(_wrap_MakeExamplePlot2), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot3", VALUEFUNC(_wrap_MakeExamplePlot3), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot4", VALUEFUNC(_wrap_MakeExamplePlot4), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot5", VALUEFUNC(_wrap_MakeExamplePlot5), -1);
    rb_define_module_function(mPplot, "MakeExamplePlot6", VALUEFUNC(_wrap_MakeExamplePlot6), -1);
    rb_define_module_function(mPplot, "MakePainterTester", VALUEFUNC(_wrap_MakePainterTester), -1);
    rb_define_module_function(mPplot, "MakeCopy", VALUEFUNC(_wrap_MakeCopy), -1);
    rb_define_module_function(mPplot, "SetCurrentPPlot", VALUEFUNC(_wrap_SetCurrentPPlot), -1);
    rb_define_module_function(mPplot, "GetCurrentPPlot", VALUEFUNC(_wrap_GetCurrentPPlot), -1);
}

