#ifndef __wxpplot_h__
#define __wxpplot_h__

#include "wx/wx.h"
#include "wx/dcbuffer.h"
#include "PPlot.h"
// you migth try this: #include "../generic/PPlot.h"

// trick avoiding compile problems
class DefaultInteractionContainer;
class InteractionContainer;

class wxPPlot: public wxPanel, public Painter {

    DECLARE_DYNAMIC_CLASS(wxPPlot);

	public:
	wxPPlot (wxWindow *inParent);
	wxPPlot ();  // default contructor to enable dynamic creation
	~wxPPlot ();

	void OnPaint(wxPaintEvent &WXUNUSED(event));
	void OnEraseBackground(wxEraseEvent& event);
	void OnResize(wxSizeEvent& event);

	PPlot mPPlot;
    DefaultInteractionContainer & GetDefaultInteractionContainer () {return *mDefaultInteractionContainer;};
    InteractionContainer & GetInteractionContainer () {return *mInteractionContainer;};
    DefaultInteractionContainer *mDefaultInteractionContainer;
    InteractionContainer *mInteractionContainer;

    void SetPDrawer (PDrawer *inPDrawer) {mPDrawer = inPDrawer;};

protected:
  void OnMouseEvent (wxMouseEvent &event);
  void OnKeyDown (wxKeyEvent &event);

  virtual void DrawLine (float inX1, float inY1, float inX2, float inY2);
  virtual void FillRect (int inX, int inY, int inW, int inH);
  virtual void InvertRect (int inX, int inY, int inW, int inH);
  virtual void SetClipRect (int inX, int inY, int inW, int inH);
  virtual long GetWidth () const;
  virtual long GetHeight () const;
  virtual void SetLineColor (int inR, int inG, int inB);
  virtual void SetFillColor (int inR, int inG, int inB);
  virtual long CalculateTextDrawSize (const char *inString);
  virtual long GetFontHeight () const;
  virtual void DrawText (int inX, int inY, const char *inString);
  virtual void DrawRotatedText (int inX, int inY, float inDegrees, const char *inString);
  virtual void SetStyle (const PStyle &inStyle){};
  wxBufferedPaintDC *mDC;
  wxFont *mFont;
  wxPen *mPen;
  wxBrush *mBrush;

  PDrawer *mPDrawer;
	private:
   DECLARE_EVENT_TABLE()
};

#endif
