/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: trace_config.h 1230 2008-08-08 05:52:17Z ertl-hiro $
 */

/*
 *		g[XOɊւݒ
 *
 *  ̃CN[ht@ĆCtarget_config.htarget_syssvc.h
 *  ݂CN[hD̃t@C璼ڃCN[hĂ͂
 *  ȂD
 */

#ifndef TOPPERS_TRACE_CONFIG_H
#define TOPPERS_TRACE_CONFIG_H

/*
 *  g[XOobt@̃TCY
 */
#ifndef TCNT_TRACE_BUFFER
#define TCNT_TRACE_BUFFER	1024
#endif /* TCNT_TRACE_BUFFER */

/*
 *  g[X̎擾@
 */
#ifndef TRACE_GET_TIM
#define TRACE_GET_TIM()		(current_time)
#endif /* TRACE_GET_TIM */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  g[XÕf[^\
 *
 *  VXeO@\̃Õf[^\Ɠ̂pD
 */
#include <t_syslog.h>
typedef	SYSLOG	TRACE;

/*
 *  g[XOobt@ƂɃANZX邽߂̃|C^
 */
extern TRACE	trace_buffer[];		/* g[XOobt@ */
extern uint_t	trace_count;		/* g[XOobt@̃O̐ */
extern uint_t	trace_head;			/* 擪̃g[XO̊i[ʒu */
extern uint_t	trace_tail;			/* ̃g[XO̊i[ʒu */
extern uint_t	trace_lost;			/* ꂽg[X̐ */

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  g[X[h̒`
 */
#define TRACE_STOP			UINT_C(0x00)	/* g[X~ */
#define TRACE_RINGBUF		UINT_C(0x01)	/* Oobt@[h */
#define TRACE_AUTOSTOP		UINT_C(0x02)	/* ~[h */
#define TRACE_CLEAR			UINT_C(0x04)	/* g[XÕNA */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  g[XO@\̏
 *
 *  g[XO@\D[`Ƃēo^邱Ƃz
 *  肵ĂDɂ莟̓sD
 *
 *  TRACE_STOPF݂̂Ńg[X͊JnȂD
 *  TRACE_RINGBUFFOobt@[hŃg[XJnD
 *  TRACE_AUTOSTOPF~[hŃg[XJnD
 */
extern void	trace_initialize(intptr_t exinf);

/*
 *  g[XO̊Jn
 *
 *  g[XŐL^Jn^~Dɂ莟̓sD
 *
 *  TRACE_STOPFg[X~D
 *  TRACE_RINGBUFFOobt@[hŃg[XJnD
 *  TRACE_AUTOSTOPF~[hŃg[XJnD
 *  TRACE_CLEARFg[XONAD
 */
extern ER	trace_sta_log(MODE mode);

/*
 *  g[XȌ
 */
extern ER	trace_wri_log(TRACE *p_trace);

/*
 *  g[XO̓Ǐo
 */
extern ER	trace_rea_log(TRACE *p_trace);

/* 
 *  g[XÕ_vitrace_dump.cj
 *
 *  g[XO_vDI[`Ƃēo^邱Ƃz
 *  ĂDƂāC_vƂȂ镶o͊֐ւ̃|C^nD
 *  ^[Qbgˑ̒჌xo͂𗘗pꍇɂ́Ctarget_putcn
 *  D
 */
extern void	trace_dump(intptr_t exinf);

/*
 *  g[XOo͂邽߂̃Cu֐
 */
extern void	trace_write_0(uint_t type);
extern void	trace_write_1(uint_t type, intptr_t arg1);
extern void	trace_write_2(uint_t type, intptr_t arg1, intptr_t arg2);
extern void	trace_write_3(uint_t type, intptr_t arg1, intptr_t arg2,
														intptr_t arg3);

/*
 *  g[XOo͂邽߂̃}N
 */

#define trace_0(type) \
				trace_write_0(type)

#define trace_1(type, arg1) \
				trace_write_1(type, (intptr_t)(arg1))

#define trace_2(type, arg1, arg2) \
				trace_write_2(type, (intptr_t)(arg1), (intptr_t)(arg2))

#define trace_3(type, arg1, arg2, arg3) \
				trace_write_3(type, (intptr_t)(arg1), (intptr_t)(arg2), \
						(intptr_t)(arg3))

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  g[XO@̐ݒ
 */
#define LOG_TSKSTAT(p_tcb)		trace_2(LOG_TYPE_TSKSTAT, p_tcb, p_tcb->tstat)

#define LOG_DSP_LEAVE(p_tcb)	trace_1(LOG_TYPE_DSP|LOG_LEAVE, p_tcb)

#define LOG_SYSLOG_WRI_LOG_ENTER(prio, p_syslog) \
								trace_wri_log((TRACE *) p_syslog)

#endif /* TOPPERS_TRACE_CONFIG_H */
