/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2008 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */


#ifndef TOPPERS_M16C62P_H
#define TOPPERS_M16C62P_H

/* vZbTˑ̏` */

/*
 *  SFRAhX`
 */
#define TADR_SFR_PM0     0x0004 /* vZbT[hWX^0 */
#define TADR_SFR_PM1     0x0005 /* vZbT[hWX^1 */
#define TADR_SFR_CM0     0x0006 /* VXeNbN䃌WX^0 */
#define TADR_SFR_CM1     0x0007 /* VXeNbN䃌WX^1 */
#define TADR_SFR_CSR     0x0008 /* `bvZNg䃌WX^ */
#define TADR_SFR_AIER    0x0009 /* AhXv荞݋WX^ */
#define TADR_SFR_PRCR    0x000A /* veNgWX^ */
#define TADR_SFR_DBR     0x000B /* f[^oNWX^ */
#define TADR_SFR_CM2     0x000C /* U~oWX^ */
#define TADR_SFR_WDTS    0x000E /* EHb`hbO^C}X^[gWX^ */
#define TADR_SFR_WDC     0x000F /* EHb`hbO^C}䃌WX^ */
#define TADR_SFR_RMAD0   0x0010 /* AhXv荞݃WX^0 */
#define TADR_SFR_RMAD1   0x0014 /* AhXv荞݃WX^1 */
#define TADR_SFR_VCR1    0x0019 /* doWX^1 (5A6) */
#define TADR_SFR_VCR2    0x001A /* doWX^2 (5A6) */
#define TADR_SFR_CSE     0x001B /* `bvZNgg䃌WX^ */
#define TADR_SFR_PLC0    0x001C /* PLL䃌WX^0 */
#define TADR_SFR_PM2     0x001E /* vZbT[hWX^2 */
#define TADR_SFR_D4INT   0x001F /* dቺo荞݃WX^ */
#define TADR_SFR_SAR0    0x0020 /* DMA0\|X|C^ */
#define TADR_SFR_DAR0    0x0024 /* DMA0fBXeBl|V|C^ */
#define TADR_SFR_TCR0    0x0028 /* DMA0]JE^ */
#define TADR_SFR_DM0CON  0x002C /* DMA0䃌WX^ */
#define TADR_SFR_SAR1    0x0030 /* DMA1\|X|C^ */
#define TADR_SFR_DAR1    0x0034 /* DMA1fBXeBl|V|C^ */
#define TADR_SFR_TCR1    0x0038 /* DMA1]JE^ */
#define TADR_SFR_DM1CON  0x003C /* DMA1䃌WX^ */
#define TADR_SFR_INT3IC  0x0044 /* INT3荞ݐ䃌WX^ */
#define TADR_SFR_TB5IC   0x0045 /* ^C}B5荞ݐ䃌WX^ */
#define TADR_SFR_TB4IC   0x0046 /* ^C}B4荞ݐ䃌WX^ */
#define TADR_SFR_U1BCNIC 0x0046 /* oXՓˌo荞ݐ䃌WX^ */
#define TADR_SFR_TB3IC   0x0047 /* ^C}B3荞ݐ䃌WX^ */
#define TADR_SFR_U0BCNIC 0x0047 /* UART0oXՓˌo荞ݐ䃌WX^ */
#define TADR_SFR_S4IC    0x0048 /* SI/O4荞ݐ䃌WX^ */
#define TADR_SFR_INT5IC  0x0048 /* INT5荞ݐ䃌WX^ */
#define TADR_SFR_S3IC    0x0049 /* SI/O3荞ݐ䃌WX^ */
#define TADR_SFR_INT4IC  0x0049 /* INT4荞ݐ䃌WX^ */
#define TADR_SFR_BCNIC   0x004A /* UART2oXՓˌo荞ݐ䃌WX^ */
#define TADR_SFR_DM0IC   0x004B /* DMA0荞ݐ䃌WX^ */
#define TADR_SFR_DM1IC   0x004C /* DMA1荞ݐ䃌WX^ */
#define TADR_SFR_KUPIC   0x004D /* L|͊荞ݐ䃌WX^ */
#define TADR_SFR_ADIC    0x004E /* A/Dϊ荞ݐ䃌WX^ */
#define TADR_SFR_S2TIC   0x004F /* UART2M荞ݐ䃌WX^ */
#define TADR_SFR_S2RIC   0x0050 /* UART2M荞ݐ䃌WX^ */
#define TADR_SFR_S0TIC   0x0051 /* UART0M荞ݐ䃌WX^ */
#define TADR_SFR_S0RIC   0x0052 /* UART0M荞ݐ䃌WX^ */
#define TADR_SFR_S1TIC   0x0053 /* UART1M荞ݐ䃌WX^ */
#define TADR_SFR_S1RIC   0x0054 /* UART1M荞ݐ䃌WX^ */
#define TADR_SFR_TA0IC   0x0055 /* ^C}A0荞ݐ䃌WX^ */
#define TADR_SFR_TA1IC   0x0056 /* ^C}A1荞ݐ䃌WX^ */
#define TADR_SFR_TA2IC   0x0057 /* ^C}A2荞ݐ䃌WX^ */
#define TADR_SFR_TA3IC   0x0058 /* ^C}A3荞ݐ䃌WX^ */
#define TADR_SFR_TA4IC   0x0059 /* ^C}A4荞ݐ䃌WX^ */
#define TADR_SFR_TB0IC   0x005A /* ^C}B0荞ݐ䃌WX^ */
#define TADR_SFR_TB1IC   0x005B /* ^C}B1荞ݐ䃌WX^ */
#define TADR_SFR_TB2IC   0x005C /* ^C}B2荞ݐ䃌WX^ */
#define TADR_SFR_INT0IC  0x005D /* INT0荞ݐ䃌WX^ */
#define TADR_SFR_INT1IC  0x005E /* INT1荞ݐ䃌WX^ */
#define TADR_SFR_INT2IC  0x005F /* INT2荞ݐ䃌WX^ */
#define TADR_SFR_FIDR    0x01B4 /* tbVʃWX^ */
#define TADR_SFR_FMR1    0x01B5 /* tbV䃌WX^1 */
#define TADR_SFR_FMR0    0x01B7 /* tbV䃌WX^0 */
#define TADR_SFR_RMAD2   0x01B8 /* AhXv荞݃WX^2 */
#define TADR_SFR_AIER2   0x01BB /* AhXv荞݋WX^2 */
#define TADR_SFR_RMAD3   0x01BC /* AhXv荞݃WX^3 */
#define TADR_SFR_PCLKR   0x025E /* ӃNbNIWX^*/
#define TADR_SFR_TBSR    0x0340 /* ^C}B3,4,5JEgJntO */
#define TADR_SFR_TA11    0x0342 /* ^C}A1-1WX^ */
#define TADR_SFR_TA21    0x0344 /* ^C}A2-1WX^ */
#define TADR_SFR_TA41    0x0346 /* ^C}A4-1WX^ */
#define TADR_SFR_INVC0   0x0348 /* OPWM䃌WX^0 */
#define TADR_SFR_INVC1   0x0349 /* OPWM䃌WX^1 */
#define TADR_SFR_IDB0    0x034A /* Oo̓obt@WX^0 */
#define TADR_SFR_IDB1    0x034B /* Oo̓obt@WX^1 */
#define TADR_SFR_DTT     0x034C /* Zh~^C} */
#define TADR_SFR_ICTB2   0x034D /* ^C}B2荞ݔpxݒJE^ */
#define TADR_SFR_TB3     0x0350 /* ^C}B3WX^ */
#define TADR_SFR_TB4     0x0352 /* ^C}B4WX^ */
#define TADR_SFR_TB5     0x0354 /* ^C}B5WX^ */
#define TADR_SFR_TB3MR   0x035B /* ^C}B3[hWX^ */
#define TADR_SFR_TB4MR   0x035C /* ^C}B4[hWX^ */
#define TADR_SFR_TB5MR   0x035D /* ^C}B5[hWX^ */
#define TADR_SFR_IFSR2A  0x035E /* 荞ݗvIWX^2 */
#define TADR_SFR_IFSR    0x035F /* 荞ݗvIWX^ */
#define TADR_SFR_S3TRR   0x0360 /* SI/O3MWX^ */
#define TADR_SFR_S3C     0x0362 /* SI/O3䃌WX^ */
#define TADR_SFR_S3BRG   0x0363 /* SI/O3rbg[gWX^ */
#define TADR_SFR_S4TRR   0x0364 /* SI/O4MWX^ */
#define TADR_SFR_S4C     0x0366 /* SI/O4䃌WX^ */
#define TADR_SFR_S4BRG   0x0367 /* SI/O4rbg[gWX^ */
#define TADR_SFR_U0SMR4  0x036C /* UART0ꃂ[hWX^4 */
#define TADR_SFR_U0SMR3  0x036D /* UART0ꃂ[hWX^3 */
#define TADR_SFR_U0SMR2  0x036E /* UART0ꃂ[hWX^2 */
#define TADR_SFR_U0SMR   0x036F /* UART0ꃂ[hWX^ */
#define TADR_SFR_U1SMR4  0x0370 /* UART1ꃂ[hWX^4 */
#define TADR_SFR_U1SMR3  0x0371 /* UART1ꃂ[hWX^3 */
#define TADR_SFR_U1SMR2  0x0372 /* UART1ꃂ[hWX^2 */
#define TADR_SFR_U1SMR   0x0373 /* UART1ꃂ[hWX^ */
#define TADR_SFR_U2SMR4  0x0374 /* UART2ꃂ[hWX^4 */
#define TADR_SFR_U2SMR3  0x0375 /* UART2ꃂ[hWX^3 */
#define TADR_SFR_U2SMR2  0x0376 /* UART2ꃂ[hWX^2 */
#define TADR_SFR_U2SMR   0x0377 /* UART2ꃂ[hWX^ */
#define TADR_SFR_U2MR    0x0378 /* UART2M[hWX^ */
#define TADR_SFR_U2BRG   0x0379 /* UART2rbg[gWX^ */
#define TADR_SFR_U2TB    0x037A /* UART2Mobt@WX^ */
#define TADR_SFR_U2C0    0x037C /* UART2M䃌WX^0 */
#define TADR_SFR_U2C1    0x037D /* UART2M䃌WX^1 */
#define TADR_SFR_U2RB    0x037E /* UART2Mobt@WX^ */

/*
 *  DMAC
 */ 
#define TADR_SFR_DM0SL   0x03B8 /* DMA0vIWX^ */
#define TADR_SFR_DM1SL   0x03BA /* DMA1vIWX^ */

/*
 *  ^C}
 */
#define TADR_SFR_TABSR   0x0380 /* JEgJntO */
#define TADR_SFR_CPSRF   0x0381 /* vpvXP[ZbgtO */
#define TADR_SFR_ONSF    0x0382 /* VbgJntO */
#define TADR_SFR_TRGSR   0x0383 /* gKIWX^ */
#define TADR_SFR_UDF     0x0384 /* Abv_EtO */
#define TADR_SFR_TA0     0x0386 /* ^C}A0WX^ */
#define TADR_SFR_TA1     0x0388 /* ^C}A1WX^ */
#define TADR_SFR_TA2     0x038A /* ^C}A2WX^ */
#define TADR_SFR_TA3     0x038C /* ^C}A3WX^ */
#define TADR_SFR_TA4     0x038E /* ^C}A4WX^ */
#define TADR_SFR_TB0     0x0390 /* ^C}B0WX^ */
#define TADR_SFR_TB1     0x0392 /* ^C}B1WX^ */
#define TADR_SFR_TB2     0x0394 /* ^C}B2WX^ */
#define TADR_SFR_TA0MR   0x0396 /* ^C}A0|hWX^ */
#define TADR_SFR_TA1MR   0x0397 /* ^C}A1|hWX^ */
#define TADR_SFR_TA2MR   0x0398 /* ^C}A2|hWX^ */
#define TADR_SFR_TA3MR   0x0399 /* ^C}A3|hWX^ */
#define TADR_SFR_TA4MR   0x039A /* ^C}A4|hWX^ */
#define TADR_SFR_TB0MR   0x039B /* ^C}B0|hWX^ */
#define TADR_SFR_TB1MR   0x039C /* ^C}B1|hWX^ */
#define TADR_SFR_TB2MR   0x039D /* ^C}B2|hWX^ */
#define TADR_SFR_TB2SC   0x039E /* ^C}B2ꃂ|hWX^ */

/*
 *  CRCZ
 */
#define TADR_SFR_CRCD    0x03BC /* CRCf[^WX^ */
#define TADR_SFR_CRCIN   0x03BE /* CRCCvbgWX^ */

/*
 *  VAC^tF[X
 */
#define TADR_SFR_UART0_BASE    0x03A0 /* UART0M|hWX^ */
#define TADR_SFR_UART1_BASE    0x03A8 /* UART1M|hWX^ */
#define TADR_SFR_UART2_BASE    0x0378 /* UART2M|hWX^ */

#define TADR_SFR_UMR_OFFSET         0 /* M|hWX^ */
#define TADR_SFR_UBRG_OFFSET        1 /* rbg[gWX^ */
#define TADR_SFR_UTB_OFFSET         2 /* Mobt@WX^ */
#define TADR_SFR_UC0_OFFSET         4 /* M䃌WX^O*/
#define TADR_SFR_UC1_OFFSET         5 /* M䃌WX^P */
#define TADR_SFR_URB_OFFSET         6 /* Mobt@WX^ */
#define TADR_SFR_UCON          0x03B0 /* UARTM䃌WX^Q */

/*
 *  A-D/D-ARo[^
 */
#define TADR_SFR_AD0     0x03C0 /* A/DWX^0 */
#define TADR_SFR_AD1     0x03C2 /* A/DWX^1 */
#define TADR_SFR_AD2     0x03C4 /* A/DWX^2 */
#define TADR_SFR_AD3     0x03C6 /* A/DWX^3 */
#define TADR_SFR_AD4     0x03C8 /* A/DWX^4 */
#define TADR_SFR_AD5     0x03CA /* A/DWX^5 */
#define TADR_SFR_AD6     0x03CC /* A/DWX^6 */
#define TADR_SFR_AD7     0x03CE /* A/DWX^7 */
#define TADR_SFR_ADCON2  0x03D4 /* A/D䃌WX^2 */
#define TADR_SFR_ADCON0  0x03D6 /* A/D䃌WX^0 */
#define TADR_SFR_ADCON1  0x03D7 /* A/D䃌WX^1 */
#define TADR_SFR_DA0     0x03D8 /* D/AWX^0 */
#define TADR_SFR_DA1     0x03DA /* D/AWX^1 */
#define TADR_SFR_DACON   0x03DC /* D/A䃌WX^*/

/*
 *  vO}uo̓|[g
 */

#define TADR_SFR_PC14    0x03DE /* |[gP14䃌WX^ */
#define TADR_SFR_PUR3    0x03DF /* vAbv䃌WX^3 */
#define TADR_SFR_P0      0x03E0 /* |[gP0WX^ */
#define TADR_SFR_P1      0x03E1 /* |[gP1WX^ */
#define TADR_SFR_PD0     0x03E2 /* |[gP0WX^ */
#define TADR_SFR_PD1     0x03E3 /* |[gP1WX^ */
#define TADR_SFR_P2      0x03E4 /* |[gP2WX^ */
#define TADR_SFR_P3      0x03E5 /* |[gP3WX^ */
#define TADR_SFR_PD2     0x03E6 /* |[gP2WX^ */
#define TADR_SFR_PD3     0x03E7 /* |[gP3WX^ */
#define TADR_SFR_P4      0x03E8 /* |[gP4WX^ */
#define TADR_SFR_P5      0x03E9 /* |[gP5WX^ */
#define TADR_SFR_PD4     0x03EA /* |[gP4WX^ */
#define TADR_SFR_PD5     0x03EB /* |[gP5WX^ */
#define TADR_SFR_P6      0x03EC /* |[gP6WX^ */
#define TADR_SFR_P7      0x03ED /* |[gP7WX^ */
#define TADR_SFR_PD6     0x03EE /* |[gP6WX^ */
#define TADR_SFR_PD7     0x03EF /* |[gP7WX^ */
#define TADR_SFR_P8      0x03F0 /* |[gP8WX^ */
#define TADR_SFR_P9      0x03F1 /* |[gP9WX^ */
#define TADR_SFR_PD8     0x03F2 /* |[gP8WX^ */
#define TADR_SFR_PD9     0x03F3 /* |[gP9WX^ */
#define TADR_SFR_P10     0x03F4 /* |[gP10WX^ */
#define TADR_SFR_P11     0x03F5 /* |[gP11WX^ */
#define TADR_SFR_PD10    0x03F6 /* |[gP10WX^ */
#define TADR_SFR_PD11    0x03F7 /* |[gP11WX^ */
#define TADR_SFR_P12     0x03F8 /* |[gP12WX^ */
#define TADR_SFR_P13     0x03F9 /* |[gP13WX^ */
#define TADR_SFR_PD12    0x03FA /* |[gP12WX^ */
#define TADR_SFR_PD13    0x03FB /* |[gP13WX^ */
#define TADR_SFR_PUR0    0x03FC /* vAbv䃌WX^0 */
#define TADR_SFR_PUR1    0x03FD /* vAbv䃌WX^1 */
#define TADR_SFR_PUR2    0x03FE /* vAbv䃌WX^2 */
#define TADR_SFR_PCR     0x03FF /* |[g䃌WX^ */

/*
 *  CPUOnhԍ̒`
 */

#define INT_UNDEF_INSTRUNCTION	0		/* ` */
#define INT_OVERFLOW			1		/* I[o[t[ */
#define INT_BRK_INSTRUCTION		2		/* BRK */
#define INT_ADDRESS_MATCH		3		/* AhXv */
#define INT_WDT					5		/* EHb`hbO^C} */
#define INT_XIN_STOP			5		/* U~o */
#define INT_LOW_VOLT_DETECT		5		/* dቺo */
#define INT_NMI					7		/* NMI */
#define INT_RESET				8		/* Zbg */

/*
 *  ݃nhԍ̒`
 */
#define	TINHNO_BRK      0		/* BRK */
#define TINHNO_INT3     4		/* INT3 */
#define TINHNO_TB5      5		/* ^C}B5 */
#define TINHNO_TB4      6		/* ^C}B4 */
#define TINHNO_TB3      7		/* ^C}B3 */
#define TINHNO_SIO4     8		/* SIO4 */
#define TINHNO_INT5     8		/* INT5 */
#define TINHNO_SIO3     9		/* SIO3 */
#define TINHNO_INT4     9		/* INT4 */
#define TINHNO_BCN     10		/* UARToXՓˌo */
#define TINHNO_DMA0    11		/* DMA0 */
#define TINHNO_DMA1    12		/* DMA1 */
#define TINHNO_KEY     13		/* L[͊ */
#define TINHNO_AD      14		/* A/D */
#define TINHNO_S2TNACK 15		/* UART2M,NACK */
#define TINHNO_S2RACK  16		/* UART2M,ACK */
#define TINHNO_S0TNACK 17		/* UART0M,NACK */
#define TINHNO_S0RACK  18		/* UART0M,ACK */
#define TINHNO_S1TNACK 19		/* UART1M,NACK */
#define TINHNO_S1RACK  20		/* UART1M,ACK */
#define TINHNO_TA0     21		/* ^C}A0 */
#define TINHNO_TA1     22		/* ^C}A1 */
#define TINHNO_TA2     23		/* ^C}A2 */
#define TINHNO_TA3     24		/* ^C}A3 */
#define TINHNO_TA4     25		/* ^C}A4 */
#define TINHNO_TB0     26		/* ^C}B0 */
#define TINHNO_TB1     27		/* ^C}B1 */
#define TINHNO_TB2     28		/* ^C}B2 */
#define TINHNO_INT0    29		/* INT0 */
#define TINHNO_INT1    30		/* INT1 */
#define TINHNO_INT2    31		/* INT2 */

/*
 *  ݔԍ̒`
 */
#define	TINTNO_BRK      0		/* BRK */
#define TINTNO_INT3     4		/* INT3 */
#define TINTNO_TB5      5		/* ^C}B5 */
#define TINTNO_TB4      6		/* ^C}B4 */
#define TINTNO_TB3      7		/* ^C}B3 */
#define TINTNO_SIO4     8		/* SIO4 */
#define TINTNO_INT5     8		/* INT5 */
#define TINTNO_SIO3     9		/* SIO3 */
#define TINTNO_INT4     9		/* INT4 */
#define TINTNO_BCN     10		/* UARToXՓˌo */
#define TINTNO_DMA0    11		/* DMA0 */
#define TINTNO_DMA1    12		/* DMA1 */
#define TINTNO_KEY     13		/* L[͊ */
#define TINTNO_AD      14		/* A/D */
#define TINTNO_S2TNACK 15		/* UART2M,NACK */
#define TINTNO_S2RACK  16		/* UART2M,ACK */
#define TINTNO_S0TNACK 17		/* UART0M,NACK */
#define TINTNO_S0RACK  18		/* UART0M,ACK */
#define TINTNO_S1TNACK 19		/* UART1M,NACK */
#define TINTNO_S1RACK  20		/* UART1M,ACK */
#define TINTNO_TA0     21		/* ^C}A0 */
#define TINTNO_TA1     22		/* ^C}A1 */
#define TINTNO_TA2     23		/* ^C}A2 */
#define TINTNO_TA3     24		/* ^C}A3 */
#define TINTNO_TA4     25		/* ^C}A4 */
#define TINTNO_TB0     26		/* ^C}B0 */
#define TINTNO_TB1     27		/* ^C}B1 */
#define TINTNO_TB2     28		/* ^C}B2 */
#define TINTNO_INT0    29		/* INT0 */
#define TINTNO_INT1    30		/* INT1 */
#define TINTNO_INT2    31		/* INT2 */



/*
 *  ^C}A
 *
 *  pdicm16c/m16c_ta.cŎgpD
 */

/*
 *  ^C}Ǎ
 */
#define TNUM_M16C_TA		(5)

/*
 *  pdicp̒`lɃl[
 */
#define TABSR_ADDR		TADR_SFR_TABSR
#define UDF_ADDR		TADR_SFR_UDF
#define ONSF_ADDR		TADR_SFR_ONSF
#define TAGSR_ADDR		TADR_SFR_TRGSR

#define INT_TA0			TINHNO_TA0
#define INT_TA1			TINHNO_TA1
#define INT_TA2			TINHNO_TA2
#define INT_TA3			TINHNO_TA3

/*
 *  e`l̃WX^yѐݒrbg
 */
#define TA0_ADDR			(TADR_SFR_TA0)
#define TA0MR_ADDR			(TADR_SFR_TA0MR)
#define TA0_START_BIT		(0x01U << 0U)
#define TA0_ONESHOT_BIT		(0x01U << 0U)
#define TA0_UDSEL_BIT		(0x01U << 0U)
#define TA0_TRIGSEL_OFFSET	(6U)

#define TA1_ADDR			(TADR_SFR_TA1)
#define TA1MR_ADDR			(TADR_SFR_TA1MR)
#define TA1_START_BIT		(0x01U << 1U)
#define TA1_ONESHOT_BIT		(0x01U << 1U)
#define TA1_UDSEL_BIT		(0x01U << 1U)
#define TA1_TRIGSEL_OFFSET	(0U)

#define TA2_ADDR			(TADR_SFR_TA2)
#define TA2MR_ADDR			(TADR_SFR_TA2MR)
#define TA2_START_BIT		(0x01U << 2U)
#define TA2_ONESHOT_BIT		(0x01U << 2U)
#define TA2_UDSEL_BIT		(0x01U << 2U)
#define TA2_TRIGSEL_OFFSET	(2U)

#define TA3_ADDR			(TADR_SFR_TA3)
#define TA3MR_ADDR			(TADR_SFR_TA3MR)
#define TA3_START_BIT		(0x01U << 3U)
#define TA3_ONESHOT_BIT		(0x01U << 3U)
#define TA3_UDSEL_BIT		(0x01U << 3U)
#define TA3_TRIGSEL_OFFSET	(4U)

#define TA4_ADDR			(TADR_SFR_TA4)
#define TA4MR_ADDR			(TADR_SFR_TA4MR)
#define TA4_START_BIT		(0x01U << 4U)
#define TA4_ONESHOT_BIT		(0x01U << 4U)
#define TA4_UDSEL_BIT		(0x01U << 4U)
#define TA4_TRIGSEL_OFFSET	(6U)

/*
 *  UART֘A̒`
 *
 *  pdicm16c/m16c_uart.cŎgpD
 */

/*
 *  VAI/Ǒ
 */
#define TNUM_SIOP			(3)

/*
 *  e|[g̃WX^yѐݒrbg
 */
#define UART0_UC0_ADDR		(TADR_SFR_UART0_BASE+TADR_SFR_UC0_OFFSET)
#define UART0_UC1_ADDR		(TADR_SFR_UART0_BASE+TADR_SFR_UC1_OFFSET)
#define UART0_MODE_ADDR		(TADR_SFR_UART0_BASE+TADR_SFR_UMR_OFFSET)
#define UART0_BAUD_ADDR		(TADR_SFR_UART0_BASE+TADR_SFR_UBRG_OFFSET)
#define UART0_TXBUF_ADDR	(TADR_SFR_UART0_BASE+TADR_SFR_UTB_OFFSET)
#define UART0_RXBUF_ADDR	(TADR_SFR_UART0_BASE+TADR_SFR_URB_OFFSET)
#define UART0_TXINTNO		(TINHNO_S0TNACK)
#define UART0_RXINTNO		(TINHNO_S0TNACK)

#define UART1_UC0_ADDR		(TADR_SFR_UART1_BASE+TADR_SFR_UC0_OFFSET)
#define UART1_UC1_ADDR		(TADR_SFR_UART1_BASE+TADR_SFR_UC1_OFFSET)
#define UART1_MODE_ADDR		(TADR_SFR_UART1_BASE+TADR_SFR_UMR_OFFSET)
#define UART1_BAUD_ADDR		(TADR_SFR_UART1_BASE+TADR_SFR_UBRG_OFFSET)
#define UART1_TXBUF_ADDR	(TADR_SFR_UART1_BASE+TADR_SFR_UTB_OFFSET)
#define UART1_RXBUF_ADDR	(TADR_SFR_UART1_BASE+TADR_SFR_URB_OFFSET)
#define UART1_TXINTNO		(TINHNO_S1TNACK)
#define UART1_RXINTNO		(TINHNO_S1RACK)

#define UART2_UC0_ADDR		(TADR_SFR_UART2_BASE+TADR_SFR_UC0_OFFSET)
#define UART2_UC1_ADDR		(TADR_SFR_UART2_BASE+TADR_SFR_UC1_OFFSET)
#define UART2_MODE_ADDR		(TADR_SFR_UART2_BASE+TADR_SFR_UMR_OFFSET)
#define UART2_BAUD_ADDR		(TADR_SFR_UART2_BASE+TADR_SFR_UBRG_OFFSET)
#define UART2_TXBUF_ADDR	(TADR_SFR_UART2_BASE+TADR_SFR_UTB_OFFSET)
#define UART2_RXBUF_ADDR	(TADR_SFR_UART2_BASE+TADR_SFR_URB_OFFSET)
#define UART2_TXINTNO		(TINHNO_S2TNACK)
#define UART2_RXINTNO		(TINHNO_S2RACK)


#endif	/* TOPPERS_M16C62P_H */
