/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: prc_support.S 759 2008-03-07 23:01:20Z hiro $
 */

/*
 *		vZbTˑW[ AZuꕔiM68040pj
 */

#define	TOPPERS_MACRO_ONLY
#define UINT_C(val)			(val)		/* uint_t^̒萔}N */
#define ULONG_C(val)		(val)		/* ulong_t^̒萔}N */
#define CAST(type, val)		(val)		/* ^LXgs}N */
#include "kernel_impl.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 */
	.text
	.globl dispatch
dispatch:
	/*
	 *  ̃[`́C^XNReLXgECPUbNԁEfBXpb`
	 *  ԁEif́jݗDx}XNSԂŌĂяo
	 *  D
	 */
	movem.l %d2-%d7/%a2-%a6, -(%sp)		/* WX^ۑ */
	move.l p_runtsk, %a0				/* p_runtskA0 */
	move.l %sp, TCB_msp(%a0)			/* ^XNX^bNۑ */
	move.l #dispatch_r, TCB_pc(%a0)		/* sĊJԒnۑ */
	jbra dispatcher

dispatch_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6		/* WX^𕜋A */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq dispatch_r_1					/* enatexfalseȂ烊^[ */
	tst.l TCB_texptn(%a0)				/* texptn0łȂ             */
	jbne call_texrtn					/*  ^XNO[`̌ďo */
dispatch_r_1:
	rts

/*
 *  fBXpb`̓Jniprc_support.Sj
 */
	.globl start_dispatch
start_dispatch:
	/*
	 *  ̃[`́CJ[lNɁCׂĂ݂̊֎~
	 * i݃bNԂƓjŌĂяoD܂C݃[hi
	 *  ^XNReLXgƓjŌĂяo邱Ƃz肵ĂD
	 *
	 *  prc_initializeŁClock_flagtrueɁCsaved_iipmIIPM_ENAALL
	 *  Ă邽߁CJ[lǗO݂̊邱ƂŁC
	 *  CPUbNԁEif́jݗDx}XNSԂɂȂD
	 *  ܂Ctask_initializedisdspfalseɏĂ邽߁CfB
	 *  Xpb`ԂɂȂĂD
	 */
#if TIPM_LOCK == -7
	or.w #0x1000, %sr					/* }X^[h */
#else /* TIPM_LOCK == -7 */
	move.w %sr, %d0						/* }X^[hE                */
	and.w #~0x0700, %d0					/*  J[lǗO݂̊ */
	or.w #(0x1000 | IIPM_LOCK), %d0
	move.w %d0, %sr
#endif /* TIPM_LOCK == -7 */
	jbra dispatcher_0

/*
 *  ݂̃ReLXĝĂăfBXpb`
 */
	.globl exit_and_dispatch
exit_and_dispatch:
	/* fBXpb`{́idispatcherj */

/*
 *  fBXpb`{
 */
dispatcher:
	/*
	 *  ̃[`́C^XNReLXgECPUbNԁEfBXpb`
	 *  ԁEif́jݗDx}XNSԂŌĂяo
	 *  D
	 *
	 *  Ȃ킿C}X^[hElock_flagtrueEdisdspfalseEdspflg
	 *  trueEsaved_iipmIIPM_ENAALLƂȂĂDsĊJԒnւ
	 *  ̏Ԃ̂܂ܕ򂷂D
	 */
#ifdef LOG_DSP_ENTER
	move.l p_runtsk, %d0				/* p_runtskp[^ */
	move.l %d0, -(%sp)
	jsr log_dsp_enter
	addq.l #4, %sp
#endif /* LOG_DSP_ENTER */
dispatcher_0:
	move.l p_schedtsk, %a0				/* p_schedtskp_runtsk */
	move.l %a0, p_runtsk
	jbeq dispatcher_1					/* p_runtskNULLȂdispatcher_1 */
	move.l TCB_msp(%a0), %sp			/* ^XNX^bN𕜋A */
#ifdef LOG_DSP_LEAVE
	move.l %a0, -(%sp)					/* p_runtskp[^ */
	jsr log_dsp_leave
	addq.l #4, %sp
	move.l p_runtsk, %a0
#endif /* LOG_DSP_LEAVE */
	move.l TCB_pc(%a0), %a1				/* sĊJԒn֕ */
	jmp (%a1)
dispatcher_1:
	/*
	 *  CPUbNԂ鏀D
	 */
	move.w %sr, %d0						/* SRD0ɕۑ */
	clr.l lock_flag						/* CPUbNԂ */
dispatcher_2:
	/*
	 *  ݂C݃[hɐ؂芷āC݂҂D
	 *
	 *  Ŋ݃[hɐ؂芷̂́CŔ銄ݏ
	 *  ǂ̃X^bNgƂ̉ƁC݃nhł̃^
	 *  XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  vZbTݑ҂Ɉڍs鏈ƁC݋Ƃ́Cs
	 *  ɍsȂKviM68040łstop߂ŗsȂ̂Ŗ
	 *  jDsɍsȂȂꍇC݂Ɋ
	 *  ݂C̒Ń^XNs\ԂɂȂƁCsׂ^X
	 *  Nɂ炸vZbTݑ҂ɂȂĂ܂D
	 *
	 *  ݑ҂̊Ԃ́Cp_runtskNULLi0jɐݒ肵Ȃ΂Ȃ
	 *  D̂悤ɐݒ肵ȂƁC݃nhiget_tidĂяo
	 *  ۂ̓삪dlɍvȂȂD
	 */
	stop #0x2000						/* ݑ҂ */
	move.w %d0, %sr						/* ̏Ԃɖ߂ */
	tst.l reqflg						/* reqflgfalseȂdispatcher_2 */
	jbeq dispatcher_2
	clr.l reqflg						/* reqflgfalse */
	/*
	 *  CPUbNԂɖ߂Dݑ҂̊ԂɎs݃nhɂ
	 *  Csaved_iipm\邽߁C̒lɖ߂K
	 *  vDdispatchers鎞́Csaved_iipmIIPM_ENAALL
	 *  ƂȂĂ邽߁Cłsaved_iipmIIPM_ENAALLi0jɖ߂
	 *  ΂悢D
	 */
	clr.w saved_iipm					/* saved_iipm0ɂ */
	move.l #true, lock_flag				/* CPUbNԂ */
	jbra dispatcher_0

/*
 *  J[l̏Ǐďo
 *
 *  M68040ł́C[h؊ɂX^bN؂芷邽߁CIȃX
 *  ^bN؊͕KvȂDŏ犄݃[hłꍇC
 *  ł悢D
 */
	.globl call_exit_kernel
call_exit_kernel:
	and.w #~0x1000, %sr					/* ݃[h */
	jmp exit_kernel						/* J[l̏IĂ */
	
/*
 *  ^XNJn
 */
	.text
	.globl start_r
start_r:
	clr.l lock_flag						/* CPUbNԂ */
	and.w #~0x0700, %sr
	move.l TCB_p_tinib(%a0), %a1		/* p_runtsk->p_tinibA1 */
	move.l TINIB_exinf(%a1), -(%sp)		/* exinfX^bNɐς */
	move.l #ext_tsk, -(%sp)				/* ext_tskX^bNɐς */
	move.l TINIB_task(%a1), %a0			/* ^XN̋NԒnA0 */
	jmp (%a0)

/*
 *  ݃nho
 *
 *  ret_int́C݃nh߂Ɏs郋[`ŁC
 *  INTHDR_ENTRY}NœWJ銄݃nh̓ŁC݃n
 *  h̖߂Ԓnɐݒ肳D
 */
	.text
	.globl ret_int
ret_int:
	btst.b #4, 16(%sp)					/* ߂悪݃[hȂ */
	jbne ret_int_1						/*           Ƀ^[ */
	/*
	 *  J[lǗ݂̊֎~D̎_ł́CCPUbNԂ
	 *  ͂ȂȂilock_flagsaved_iipm͍XVȂjD
	 *
	 *  reqflg`FbNOɊ݂֎~̂́Creqflg`FbN
	 *  Ɋ݃nhNC̒ŃfBXpb`v
	 *  ꂽꍇɁCɃfBXpb`ȂƂ肪邽
	 *  łD
	 */
#if TIPM_LOCK == -7
	or.w #0x0700, %sr					/* ׂĂ݂̊֎~ */
#else /* TIPM_LOCK == -7 */
	/*
	 *  ̃[`̓J[lǗ݂̊N邽߁Cł́C
	 *  ݗDx}XNTIPM_LOCKႢƑzłD
	 */
	move.w %sr, %d0						/* J[lǗ݂̊֎~ */
	and.w #~0x0700, %d0
	or.w #IIPM_LOCK, %d0
	move.w %d0, %sr
#endif /* TIPM_LOCK == -7 */
	tst.l reqflg						/* reqflgtruełret_int_2 */
	jbne ret_int_2
ret_int_1:
	/*
	 *  ݏ̃^[ɂCCPUbNԂɈڍs悤
	 *  DݗDx}XŃCRTE߂ɂ茳̒lɖ߂邽߁C
	 *  lock_flagfalseɂĂ΂悢ilock_flagfalseɂ̂́C
	 *  CPUbNԂ̂܂܊݃nh߂̑΍jD
	 */
	clr.l lock_flag						/* CPUbN̏ */
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* XNb`WX^𕜋A */
	rte

ret_int_2:
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* XNb`WX^𕜋A */
	addq.l #8, %sp						/* X[AEFCt[̂Ă */
	or.w #0x1000, %sr					/* }X^[hɁiX^bN؊j*/
	movem.l %d0-%d1/%a0-%a1, -(%sp)		/* XNb`WX^ۑ */
ret_int_3:
	/*
	 *  ւ́CCPUOnh̏o򂵂ĂD
	 *
	 *  ł́C߂悪^XNłCX^bŃCOX^bNt[
	 *  ̏ɃXNb`WX^݂̂ۑꂽԂɂȂĂD
	 *  CvZbT́C}X^[hEJ[lǗ݂̊֎~
	 *  ԂƂȂĂD
	 */
	clr.l reqflg						/* reqflgfalse */
	/*
	 *  CPUbNԂɈڍsDJ[lǗ݂̊͂łɋ֎~
	 *  ̂ŁClock_flagsaved_iipmXVDsaved_iipḿC߂
	 *  ̊ݗDx}XNi̓\jɐݒ肷D
	 *
	 *  ̎_CPUbNԂƂ̂́Cdispatcher֕򂷂鎞ƁC
	 *  call_texrtnĂяoɁCCPUbNԂɂȂĂKv
	 *  ߂łD
	 */
	move.w 16(%sp), %d0					/* ߂SRD0 */
	and.w #0x0700, %d0					/* IPMosaved_iipm */
	move.w %d0, saved_iipm
	move.l #true, lock_flag				/* lock_flagtrue */
	/*
	 *  dspflgfalsełꍇƁCp_runtskp_schedtskꍇɂ́C
	 *  fBXpb`sȂD̃`FbNKvȂ̂́C^XNO
	 *  [`̌ďoKvȏꍇɁCfBXpb`KvȂĂC
	 *  reqflgtrueɂ邽߂łD
	 */
	move.l p_runtsk, %a0				/* p_runtskA0 */
	tst.l dspflg						/* dspflgfalseȂret_int_4 */
	jbeq ret_int_4
	cmp.l p_schedtsk, %a0				/* p_runtskp_schedtskȂ */
	jbeq ret_int_4						/*                    ret_int_4 */
	movem.l %d2-%d7/%a2-%a6, -(%sp)		/* c̃WX^ۑ */
	move.l %sp, TCB_msp(%a0)			/* ^XNX^bNۑ */
	move.l #ret_int_r, TCB_pc(%a0)		/* sĊJԒnۑ */
	jbra dispatcher

ret_int_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6		/* WX^𕜋A */
ret_int_4:
	/*
	 *  enatextrueŁCtexptn0łȂ΁C^XNO[`
	 *  ĂяoD
	 */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq ret_int_5						/* enatexfalseȂret_int_5 */
	tst.l TCB_texptn(%a0)				/* texptn0Ȃret_int_5 */
	jbeq ret_int_5
	jsr call_texrtn						/* ^XNO[`̌ďo */
ret_int_5:
	/*
	 *  ݏ̃^[ɂCCPUbNԂɈڍs
	 *  DݗDx}XŃCRTE߂ɂ茳̒lɖ߂邽
	 *  ߁Clock_flagfalseɂĂ΂悢D
	 */
	clr.l lock_flag						/* CPUbN̏ */
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* XNb`WX^𕜋A */
	rte

/*
 *  CPUOnho
 *
 *  ret_exćCCPUOnh߂Ɏs郋[`ŁC
 *  EXCHDR_ENTRY}NœWJCPUOnh̓ŁCCPUOn
 *  h̖߂Ԓnɐݒ肳D
 */
	.text
	.globl ret_exc
ret_exc:
	addq.l #4, %sp						/* X^bN̈̂Ă */
	move.l (%sp)+, %d0					/* lock_flagɖ߂ */
	move.l %d0, lock_flag
	move.l (%sp)+, %d0					/* SRD0 */
	and.w #0x1000, %d0					/* ݃[hȂ */
	jbeq ret_exc_2						/*       Ƀ^[ */
	/*
	 *  J[lǗ݂̊֎~C}X^[hɖ߂D̎_ł́C
	 *  CPUbNԂɂ͂ȂȂilock_flagsaved_iipm͍XVȂjD
	 *
	 *  reqflg`FbNOɊ݂֎~̂́Creqflg`FbN
	 *  Ɋ݃nhNC̒ŃfBXpb`v
	 *  ꂽꍇɁCɃfBXpb`ȂƂ肪邽
	 *  łD
	 */
#if TIPM_LOCK == -7
	or.w #0x1700, %sr					/* }X^[hES݋֎~ */
#else /* TIPM_LOCK == -7 */
	/*
	 *  CPUO͔Cӂ̏ԂŔ邽߁Cł́CIPMTIPM_LOCK
	 *  ႢƑz肷邱ƂłȂD
	 */
	move.w %sr, %d0						/* ݂IPMi\jo */
	and.w #0x0700, %d0
	cmp.w #LOCK_IIPM, %d0				/* ݂IPMTIPM_LOCKƓ   */
	jbge ret_exc_1						/*    荂Ȃret_exc_1 */
	move.w %sr, %d0						/* J[lǗ݂̊֎~ */
	and.w #~0x0700, %d0
	or.w #LOCK_IIPM, %d0
	move.w %d0, %sr
ret_exc_1:
	or.w #0x1000, %sr					/* }X^[h */
#endif /* TIPM_LOCK == -7 */
	/*
	 *  CPUbNԂCPUOꍇCreqflgtrueɂȂ邱Ƃ
	 *  Ȃ̂ŁCCPUbNԂ̏ꍇret_int_3ւ͕򂵂ȂD
	 */
	tst.l reqflg						/* reqflgtruełret_int_3 */
	jbne ret_int_3
ret_exc_2:
	movem.l (%sp)+, %d0-%d1/%a0-%a1		/* XNb`WX^𕜋A */
	rte

/*
 *  ԑ҂i{SIL̃^[Qbgˑj
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subi.l #SIL_DLY_TIM1, %d0			/* D0SIL_DLY_TIM1 */
	jbhi _sil_dly_nse_1					/* ʂ0ȉȂ烊^[ */
	rts
_sil_dly_nse_1:
	subi.l #SIL_DLY_TIM2, %d0			/* D0SIL_DLY_TIM2 */
	jbhi _sil_dly_nse_1					/* ʂ0傫΃[v */
	rts
